/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ussdgateway;

import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.datacoding.CBSDataCodingGroup;
import org.mobicents.protocols.ss7.map.api.datacoding.CBSDataCodingScheme;
import org.mobicents.protocols.ss7.map.api.datacoding.CBSNationalLanguage;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageExtensionContainer;
import org.mobicents.protocols.ss7.map.api.primitives.USSDString;
import org.mobicents.protocols.ss7.map.api.smstpdu.CharacterSet;
import org.mobicents.protocols.ss7.map.datacoding.CBSDataCodingSchemeImpl;
import org.mobicents.ussdgateway.AnyExt;
import org.mobicents.ussdgateway.SipUssdErrorCode;

public class SipUssdMessage
implements XMLSerializable {
    public static final String USSD_DATA = "ussd-data";
    public static final String LANGUAGE = "language";
    public static final String USSD_STRING = "ussd-string";
    public static final String ERROR_CODE = "error-code";
    public static final String ANY_EXT = "anyExt";
    private String language;
    private String ussdString;
    private int errorCode;
    private AnyExt anyExt;
    protected static final XMLFormat<SipUssdMessage> SIP_USSD_MESSAGE_XML = new XMLFormat<SipUssdMessage>(SipUssdMessage.class){

        public void read(XMLFormat.InputElement xml, SipUssdMessage ussdMessage) throws XMLStreamException {
            ussdMessage.language = (String)xml.get(SipUssdMessage.LANGUAGE, String.class);
            ussdMessage.ussdString = (String)xml.get(SipUssdMessage.USSD_STRING, String.class);
            Integer valI = (Integer)xml.get(SipUssdMessage.ERROR_CODE, Integer.class);
            if (valI != null) {
                ussdMessage.errorCode = valI;
            }
            ussdMessage.anyExt = (AnyExt)xml.get(SipUssdMessage.ANY_EXT, AnyExt.class);
        }

        public void write(SipUssdMessage ussdMessage, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (ussdMessage.language != null) {
                xml.add((Object)ussdMessage.language, SipUssdMessage.LANGUAGE, String.class);
            }
            if (ussdMessage.ussdString != null) {
                xml.add((Object)ussdMessage.ussdString, SipUssdMessage.USSD_STRING, String.class);
            }
            if (ussdMessage.errorCode != 0) {
                xml.add((Object)ussdMessage.errorCode, SipUssdMessage.ERROR_CODE, Integer.class);
            }
            if (ussdMessage.anyExt != null) {
                xml.add((Object)ussdMessage.anyExt, SipUssdMessage.ANY_EXT, AnyExt.class);
            }
        }
    };

    public SipUssdMessage() {
    }

    public SipUssdMessage(String ussdString, String language) {
        this.ussdString = ussdString;
        this.language = language;
    }

    public SipUssdMessage(int errorCode) {
        this.errorCode = errorCode;
    }

    public SipUssdMessage(CBSDataCodingScheme dataCodingScheme, USSDString sourceUSSDString) throws MAPException {
        this.ussdString = sourceUSSDString.getString(null);
        if (dataCodingScheme.getNationalLanguageShiftTable() == null || dataCodingScheme.getNationalLanguageShiftTable() == CBSNationalLanguage.LanguageUnspecified) {
            if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM7) {
                this.language = "en";
            }
        } else {
            switch (dataCodingScheme.getNationalLanguageShiftTable()) {
                case German: {
                    this.language = "de";
                    break;
                }
                case English: {
                    this.language = "en";
                    break;
                }
                case Italian: {
                    this.language = "it";
                    break;
                }
                case French: {
                    this.language = "fr";
                    break;
                }
                case Spanish: {
                    this.language = "es";
                    break;
                }
                case Dutch: {
                    this.language = "nl";
                    break;
                }
                case Swedish: {
                    this.language = "sv";
                    break;
                }
                case Danish: {
                    this.language = "da";
                    break;
                }
                case Portuguese: {
                    this.language = "pt";
                    break;
                }
                case Finnish: {
                    this.language = "fi";
                    break;
                }
                case Norwegian: {
                    this.language = "nb";
                    break;
                }
                case Greek: {
                    this.language = "el";
                    break;
                }
                case Turkish: {
                    this.language = "tr";
                    break;
                }
                case Hungarian: {
                    this.language = "hu";
                    break;
                }
                case Polish: {
                    this.language = "pl";
                    break;
                }
                case Czech: {
                    this.language = "cs";
                    break;
                }
                case Hebrew: {
                    this.language = "he";
                    break;
                }
                case Arabic: {
                    this.language = "ar";
                    break;
                }
                case Russian: {
                    this.language = "ru";
                    break;
                }
                case Icelandic: {
                    this.language = "is";
                }
            }
        }
    }

    public SipUssdMessage(SipUssdErrorCode sipUssdErrorCode) {
        if (sipUssdErrorCode != null) {
            this.errorCode = sipUssdErrorCode.getCode();
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public String getUssdString() {
        return this.ussdString;
    }

    public int getErrorCodeNumeric() {
        return this.errorCode;
    }

    public SipUssdErrorCode getErrorCode() {
        return SipUssdErrorCode.getSipUssdErrorCode(this.errorCode);
    }

    public AnyExt getAnyExt() {
        return this.anyExt;
    }

    public void setAnyExt(AnyExt anyExt) {
        this.anyExt = anyExt;
    }

    public boolean isSuccessMessage() {
        return this.errorCode == 0 && this.ussdString != null;
    }

    public boolean isErrorMessage() {
        return !this.isSuccessMessage();
    }

    public static CBSDataCodingScheme getCBSDataCodingSchemeForLanguage(String language) {
        CBSDataCodingSchemeImpl res = null;
        res = language == null ? new CBSDataCodingSchemeImpl(CBSDataCodingGroup.GeneralGsm7, CharacterSet.GSM7, null, null, false) : (language.equals("en") || language.equals("de") ? new CBSDataCodingSchemeImpl(CBSDataCodingGroup.GeneralGsm7, CharacterSet.GSM7, null, null, false) : new CBSDataCodingSchemeImpl(CBSDataCodingGroup.GeneralDataCodingIndication, CharacterSet.UCS2, null, null, false));
        return res;
    }

    public CBSDataCodingScheme getCBSDataCodingScheme() {
        if (!this.isSuccessMessage()) {
            return null;
        }
        return SipUssdMessage.getCBSDataCodingSchemeForLanguage(this.language);
    }

    public USSDString getUSSDString(MAPProvider mapProvider) throws MAPException {
        if (!this.isSuccessMessage()) {
            return null;
        }
        USSDString res = mapProvider.getMAPParameterFactory().createUSSDString(this.ussdString, this.getCBSDataCodingScheme(), null);
        return res;
    }

    public MAPErrorMessage getMAPErrorMessage(MAPProvider mapProvider) {
        MAPErrorMessageExtensionContainer res;
        if (this.isSuccessMessage()) {
            return null;
        }
        switch (this.getErrorCode()) {
            case languageAlphabitNotSupported: {
                res = mapProvider.getMAPErrorMessageFactory().createMAPErrorMessageExtensionContainer(Long.valueOf(71L), null);
                break;
            }
            case unexpectedDataValue: {
                res = mapProvider.getMAPErrorMessageFactory().createMAPErrorMessageExtensionContainer(Long.valueOf(36L), null);
                break;
            }
            default: {
                res = mapProvider.getMAPErrorMessageFactory().createMAPErrorMessageSystemFailure(2L, null, null, null);
            }
        }
        return res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SipUssdMessage [");
        if (this.ussdString != null) {
            sb.append("ussdString=");
            sb.append(this.ussdString);
            sb.append(",");
        }
        if (this.language != null) {
            sb.append("language=");
            sb.append(this.language);
            sb.append(",");
        }
        if (this.errorCode != 0) {
            sb.append("errorCode=");
            SipUssdErrorCode ec = SipUssdErrorCode.getSipUssdErrorCode(this.errorCode);
            if (ec != null) {
                sb.append((Object)ec);
            } else {
                sb.append(this.errorCode);
            }
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

