
package org.modeldriven.fuml.repository.model;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fUML.Syntax.Classes.Kernel.Association;
import fUML.Syntax.Classes.Kernel.Class_;
import fUML.Syntax.Classes.Kernel.Generalization;
import fUML.Syntax.Classes.Kernel.Classifier;
import fUML.Syntax.Classes.Kernel.LiteralInteger;
import fUML.Syntax.Classes.Kernel.LiteralUnlimitedNatural;
import fUML.Syntax.Classes.Kernel.PrimitiveType;
import UMLPrimitiveTypes.UnlimitedNatural;
import fUML.Syntax.Classes.Kernel.ValueSpecification;
import fUML.Syntax.Classes.Kernel.Enumeration;
import fUML.Syntax.Classes.Kernel.EnumerationLiteral;
import fUML.Syntax.Classes.Kernel.Package;
import fUML.Syntax.Classes.Kernel.Property;

import org.modeldriven.fuml.repository.RepositoryArtifact;
import org.modeldriven.fuml.repository.RepositoryMapping;
import org.modeldriven.fuml.repository.Repository;

import org.modeldriven.fuml.repository.config.Artifact;

// this needs to read the artifact namespace info from the content
public class SuperstructureAssembler extends ModelAssembler 
    implements RepositoryArtifact
{

    private static Log log = LogFactory.getLog(SuperstructureAssembler.class);
    private ModelFactory factory;

    public SuperstructureAssembler(Artifact artifact, RepositoryMapping mapping, Repository model) {
        super(artifact, mapping, model);
        this.factory = new ModelFactory(mapping, model);
        construct();
    }

    private void construct() {
        log.info("initializing...");
        constructPackages();
        constructPrimitiveTypes();
        constructEnumerations();
        constructClasses();
        constructProperties();
        constructGeneralizations();
        constructAssociations();
    } 

    public String getURN() {
        return this.artifact.getUrn();
    }
    
    public String getNamespaceURI() {
        return this.artifact.getNamespaceURI();
    }
    
    private void constructPackages()
    {
        Package pkg = null;
         
                     
        // Actions            
    	pkg  = factory.createPackage("Actions", "Actions", "Actions", this); // root package
    	mapping.mapPackage(pkg, null, this); 
                
                     
        // Actions.CompleteActions                                                    
    	pkg  = factory.createPackage("CompleteActions", "Actions.CompleteActions", "Actions-CompleteActions", pkg, this);
    	mapping.mapPackage(pkg, "Actions", this); 
                        
        mapping.mapPackageMerge(pkg, "Actions-IntermediateActions");
                        
        mapping.mapPackageMerge(pkg, "Actions-StructuredActions");
                
                     
        // Actions.IntermediateActions                                                    
    	pkg  = factory.createPackage("IntermediateActions", "Actions.IntermediateActions", "Actions-IntermediateActions", pkg, this);
    	mapping.mapPackage(pkg, "Actions", this); 
                        
        mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
                
                     
        // Actions.BasicActions                                                    
    	pkg  = factory.createPackage("BasicActions", "Actions.BasicActions", "Actions-BasicActions", pkg, this);
    	mapping.mapPackage(pkg, "Actions", this); 
                
                     
        // Actions.StructuredActions                                                    
    	pkg  = factory.createPackage("StructuredActions", "Actions.StructuredActions", "Actions-StructuredActions", pkg, this);
    	mapping.mapPackage(pkg, "Actions", this); 
                
                     
        // Activities            
    	pkg  = factory.createPackage("Activities", "Activities", "Activities", this); // root package
    	mapping.mapPackage(pkg, null, this); 
                
                     
        // Activities.BasicActivities                                                    
    	pkg  = factory.createPackage("BasicActivities", "Activities.BasicActivities", "Activities-BasicActivities", pkg, this);
    	mapping.mapPackage(pkg, "Activities", this); 
                        
        mapping.mapPackageMerge(pkg, "Activities-FundamentalActivities");
                        
        mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
                
                     
        // Activities.IntermediateActivities                                                    
    	pkg  = factory.createPackage("IntermediateActivities", "Activities.IntermediateActivities", "Activities-IntermediateActivities", pkg, this);
    	mapping.mapPackage(pkg, "Activities", this); 
                        
        mapping.mapPackageMerge(pkg, "Activities-BasicActivities");
                
                     
        // Activities.CompleteActivities                                                    
    	pkg  = factory.createPackage("CompleteActivities", "Activities.CompleteActivities", "Activities-CompleteActivities", pkg, this);
    	mapping.mapPackage(pkg, "Activities", this); 
                        
        mapping.mapPackageMerge(pkg, "Activities-IntermediateActivities");
                
                     
        // Activities.StructuredActivities                                                    
    	pkg  = factory.createPackage("StructuredActivities", "Activities.StructuredActivities", "Activities-StructuredActivities", pkg, this);
    	mapping.mapPackage(pkg, "Activities", this); 
                        
        mapping.mapPackageMerge(pkg, "Activities-FundamentalActivities");
                
                     
        // Activities.ExtraStructuredActivities                                                    
    	pkg  = factory.createPackage("ExtraStructuredActivities", "Activities.ExtraStructuredActivities", "Activities-ExtraStructuredActivities", pkg, this);
    	mapping.mapPackage(pkg, "Activities", this); 
                        
        mapping.mapPackageMerge(pkg, "Activities-StructuredActivities");
                
                     
        // Activities.CompleteStructuredActivities                                                    
    	pkg  = factory.createPackage("CompleteStructuredActivities", "Activities.CompleteStructuredActivities", "Activities-CompleteStructuredActivities", pkg, this);
    	mapping.mapPackage(pkg, "Activities", this); 
                        
        mapping.mapPackageMerge(pkg, "Activities-StructuredActivities");
                        
        mapping.mapPackageMerge(pkg, "Activities-BasicActivities");
                
                     
        // Activities.FundamentalActivities                                                    
    	pkg  = factory.createPackage("FundamentalActivities", "Activities.FundamentalActivities", "Activities-FundamentalActivities", pkg, this);
    	mapping.mapPackage(pkg, "Activities", this); 
                        
        mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
                        
        mapping.mapPackageMerge(pkg, "Actions-BasicActions");
                
                     
        // AuxiliaryConstructs            
    	pkg  = factory.createPackage("AuxiliaryConstructs", "AuxiliaryConstructs", "AuxiliaryConstructs", this); // root package
    	mapping.mapPackage(pkg, null, this); 
                
                     
        // AuxiliaryConstructs.Profiles                                                    
    	pkg  = factory.createPackage("Profiles", "AuxiliaryConstructs.Profiles", "AuxiliaryConstructs-Profiles", pkg, this);
    	mapping.mapPackage(pkg, "AuxiliaryConstructs", this); 
                                                                
        mapping.mapPackageMerge(pkg, "Infrastructure.uml#Profiles");
                
                     
        // AuxiliaryConstructs.InformationFlows                                                    
    	pkg  = factory.createPackage("InformationFlows", "AuxiliaryConstructs.InformationFlows", "AuxiliaryConstructs-InformationFlows", pkg, this);
    	mapping.mapPackage(pkg, "AuxiliaryConstructs", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Kernel");
                
                     
        // AuxiliaryConstructs.Models                                                    
    	pkg  = factory.createPackage("Models", "AuxiliaryConstructs.Models", "AuxiliaryConstructs-Models", pkg, this);
    	mapping.mapPackage(pkg, "AuxiliaryConstructs", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Kernel");
                
                     
        // AuxiliaryConstructs.Templates                                                    
    	pkg  = factory.createPackage("Templates", "AuxiliaryConstructs.Templates", "AuxiliaryConstructs-Templates", pkg, this);
    	mapping.mapPackage(pkg, "AuxiliaryConstructs", this); 
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-InternalStructures");
                
                     
        // Classes            
    	pkg  = factory.createPackage("Classes", "Classes", "Classes", this); // root package
    	mapping.mapPackage(pkg, null, this); 
                
                     
        // Classes.Kernel                                                    
    	pkg  = factory.createPackage("Kernel", "Classes.Kernel", "Classes-Kernel", pkg, this);
    	mapping.mapPackage(pkg, "Classes", this); 
                                                                
        mapping.mapPackageMerge(pkg, "Infrastructure.uml#Core-Constructs");
                                                                
        mapping.mapPackageMerge(pkg, "Infrastructure.uml#Core-PrimitiveTypes");
                
                     
        // Classes.Interfaces                                                    
    	pkg  = factory.createPackage("Interfaces", "Classes.Interfaces", "Classes-Interfaces", pkg, this);
    	mapping.mapPackage(pkg, "Classes", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Dependencies");
                        
        mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
                
                     
        // Classes.Dependencies                                                    
    	pkg  = factory.createPackage("Dependencies", "Classes.Dependencies", "Classes-Dependencies", pkg, this);
    	mapping.mapPackage(pkg, "Classes", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Kernel");
                
                     
        // Classes.PowerTypes                                                    
    	pkg  = factory.createPackage("PowerTypes", "Classes.PowerTypes", "Classes-PowerTypes", pkg, this);
    	mapping.mapPackage(pkg, "Classes", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Kernel");
                
                     
        // Classes.AssociationClasses                                                    
    	pkg  = factory.createPackage("AssociationClasses", "Classes.AssociationClasses", "Classes-AssociationClasses", pkg, this);
    	mapping.mapPackage(pkg, "Classes", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Kernel");
                
                     
        // CommonBehaviors            
    	pkg  = factory.createPackage("CommonBehaviors", "CommonBehaviors", "CommonBehaviors", this); // root package
    	mapping.mapPackage(pkg, null, this); 
                
                     
        // CommonBehaviors.Communications                                                    
    	pkg  = factory.createPackage("Communications", "CommonBehaviors.Communications", "CommonBehaviors-Communications", pkg, this);
    	mapping.mapPackage(pkg, "CommonBehaviors", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Interfaces");
                
                     
        // CommonBehaviors.BasicBehaviors                                                    
    	pkg  = factory.createPackage("BasicBehaviors", "CommonBehaviors.BasicBehaviors", "CommonBehaviors-BasicBehaviors", pkg, this);
    	mapping.mapPackage(pkg, "CommonBehaviors", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Kernel");
                
                     
        // CommonBehaviors.SimpleTime                                                    
    	pkg  = factory.createPackage("SimpleTime", "CommonBehaviors.SimpleTime", "CommonBehaviors-SimpleTime", pkg, this);
    	mapping.mapPackage(pkg, "CommonBehaviors", this); 
                        
        mapping.mapPackageMerge(pkg, "Actions-IntermediateActions");
                
                     
        // Components            
    	pkg  = factory.createPackage("Components", "Components", "Components", this); // root package
    	mapping.mapPackage(pkg, null, this); 
                
                     
        // Components.PackagingComponents                                                    
    	pkg  = factory.createPackage("PackagingComponents", "Components.PackagingComponents", "Components-PackagingComponents", pkg, this);
    	mapping.mapPackage(pkg, "Components", this); 
                        
        mapping.mapPackageMerge(pkg, "Components-BasicComponents");
                
                     
        // Components.BasicComponents                                                    
    	pkg  = factory.createPackage("BasicComponents", "Components.BasicComponents", "Components-BasicComponents", pkg, this);
    	mapping.mapPackage(pkg, "Components", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Dependencies");
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-StructuredClasses");
                
                     
        // CompositeStructures            
    	pkg  = factory.createPackage("CompositeStructures", "CompositeStructures", "CompositeStructures", this); // root package
    	mapping.mapPackage(pkg, null, this); 
                
                     
        // CompositeStructures.StructuredClasses                                                    
    	pkg  = factory.createPackage("StructuredClasses", "CompositeStructures.StructuredClasses", "CompositeStructures-StructuredClasses", pkg, this);
    	mapping.mapPackage(pkg, "CompositeStructures", this); 
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-Ports");
                
                     
        // CompositeStructures.Collaborations                                                    
    	pkg  = factory.createPackage("Collaborations", "CompositeStructures.Collaborations", "CompositeStructures-Collaborations", pkg, this);
    	mapping.mapPackage(pkg, "CompositeStructures", this); 
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-InternalStructures");
                
                     
        // CompositeStructures.Ports                                                    
    	pkg  = factory.createPackage("Ports", "CompositeStructures.Ports", "CompositeStructures-Ports", pkg, this);
    	mapping.mapPackage(pkg, "CompositeStructures", this); 
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-InternalStructures");
                        
        mapping.mapPackageMerge(pkg, "CommonBehaviors-Communications");
                
                     
        // CompositeStructures.InvocationActions                                                    
    	pkg  = factory.createPackage("InvocationActions", "CompositeStructures.InvocationActions", "CompositeStructures-InvocationActions", pkg, this);
    	mapping.mapPackage(pkg, "CompositeStructures", this); 
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-Ports");
                        
        mapping.mapPackageMerge(pkg, "Actions-BasicActions");
                
                     
        // CompositeStructures.InternalStructures                                                    
    	pkg  = factory.createPackage("InternalStructures", "CompositeStructures.InternalStructures", "CompositeStructures-InternalStructures", pkg, this);
    	mapping.mapPackage(pkg, "CompositeStructures", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Interfaces");
                
                     
        // CompositeStructures.StructuredActivities                                                    
    	pkg  = factory.createPackage("StructuredActivities", "CompositeStructures.StructuredActivities", "CompositeStructures-StructuredActivities", pkg, this);
    	mapping.mapPackage(pkg, "CompositeStructures", this); 
                        
        mapping.mapPackageMerge(pkg, "Activities-StructuredActivities");
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-InternalStructures");
                
                     
        // Deployments            
    	pkg  = factory.createPackage("Deployments", "Deployments", "Deployments", this); // root package
    	mapping.mapPackage(pkg, null, this); 
                
                     
        // Deployments.ComponentDeployments                                                    
    	pkg  = factory.createPackage("ComponentDeployments", "Deployments.ComponentDeployments", "Deployments-ComponentDeployments", pkg, this);
    	mapping.mapPackage(pkg, "Deployments", this); 
                        
        mapping.mapPackageMerge(pkg, "Deployments-Nodes");
                
                     
        // Deployments.Nodes                                                    
    	pkg  = factory.createPackage("Nodes", "Deployments.Nodes", "Deployments-Nodes", pkg, this);
    	mapping.mapPackage(pkg, "Deployments", this); 
                        
        mapping.mapPackageMerge(pkg, "Deployments-Artifacts");
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-StructuredClasses");
                
                     
        // Deployments.Artifacts                                                    
    	pkg  = factory.createPackage("Artifacts", "Deployments.Artifacts", "Deployments-Artifacts", pkg, this);
    	mapping.mapPackage(pkg, "Deployments", this); 
                
                     
        // Interactions            
    	pkg  = factory.createPackage("Interactions", "Interactions", "Interactions", this); // root package
    	mapping.mapPackage(pkg, null, this); 
                
                     
        // Interactions.BasicInteractions                                                    
    	pkg  = factory.createPackage("BasicInteractions", "Interactions.BasicInteractions", "Interactions-BasicInteractions", pkg, this);
    	mapping.mapPackage(pkg, "Interactions", this); 
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-InternalStructures");
                        
        mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
                
                     
        // Interactions.Fragments                                                    
    	pkg  = factory.createPackage("Fragments", "Interactions.Fragments", "Interactions-Fragments", pkg, this);
    	mapping.mapPackage(pkg, "Interactions", this); 
                        
        mapping.mapPackageMerge(pkg, "Interactions-BasicInteractions");
                
                     
        // StateMachines            
    	pkg  = factory.createPackage("StateMachines", "StateMachines", "StateMachines", this); // root package
    	mapping.mapPackage(pkg, null, this); 
                
                     
        // StateMachines.BehaviorStateMachines                                                    
    	pkg  = factory.createPackage("BehaviorStateMachines", "StateMachines.BehaviorStateMachines", "StateMachines-BehaviorStateMachines", pkg, this);
    	mapping.mapPackage(pkg, "StateMachines", this); 
                        
        mapping.mapPackageMerge(pkg, "CommonBehaviors-Communications");
                
                     
        // StateMachines.ProtocolStateMachines                                                    
    	pkg  = factory.createPackage("ProtocolStateMachines", "StateMachines.ProtocolStateMachines", "StateMachines-ProtocolStateMachines", pkg, this);
    	mapping.mapPackage(pkg, "StateMachines", this); 
                        
        mapping.mapPackageMerge(pkg, "StateMachines-BehaviorStateMachines");
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-Ports");
                        
        mapping.mapPackageMerge(pkg, "Classes-Interfaces");
                
                     
        // UseCases            
    	pkg  = factory.createPackage("UseCases", "UseCases", "UseCases", this); // root package
    	mapping.mapPackage(pkg, null, this); 
                        
        mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
            
    }   

    private void constructPrimitiveTypes()
    {
        PrimitiveType type = null;
    
    }   
       
    private void constructClasses()
    {
        Package pkg = null;
        String packageId = null;
        Class_ clss = null;
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.ReadExtentAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("ReadExtentAction", "Actions-CompleteActions-ReadExtentAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.ReclassifyObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("ReclassifyObjectAction", "Actions-CompleteActions-ReclassifyObjectAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.ReadIsClassifiedObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("ReadIsClassifiedObjectAction", "Actions-CompleteActions-ReadIsClassifiedObjectAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.StartClassifierBehaviorAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("StartClassifierBehaviorAction", "Actions-CompleteActions-StartClassifierBehaviorAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.QualifierValue 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("QualifierValue", "Actions-CompleteActions-QualifierValue", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.LinkEndData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("LinkEndData", "Actions-CompleteActions-LinkEndData", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.ReadLinkObjectEndAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("ReadLinkObjectEndAction", "Actions-CompleteActions-ReadLinkObjectEndAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.ReadLinkObjectEndQualifierAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("ReadLinkObjectEndQualifierAction", "Actions-CompleteActions-ReadLinkObjectEndQualifierAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.CreateLinkObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("CreateLinkObjectAction", "Actions-CompleteActions-CreateLinkObjectAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.AcceptEventAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("AcceptEventAction", "Actions-CompleteActions-AcceptEventAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.AcceptCallAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("AcceptCallAction", "Actions-CompleteActions-AcceptCallAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.ReplyAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("ReplyAction", "Actions-CompleteActions-ReplyAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.UnmarshallAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("UnmarshallAction", "Actions-CompleteActions-UnmarshallAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.ReduceAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("ReduceAction", "Actions-CompleteActions-ReduceAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.StartObjectBehaviorAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("StartObjectBehaviorAction", "Actions-CompleteActions-StartObjectBehaviorAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.CreateObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("CreateObjectAction", "Actions-IntermediateActions-CreateObjectAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.DestroyObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("DestroyObjectAction", "Actions-IntermediateActions-DestroyObjectAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.TestIdentityAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("TestIdentityAction", "Actions-IntermediateActions-TestIdentityAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.ReadSelfAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("ReadSelfAction", "Actions-IntermediateActions-ReadSelfAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.StructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("StructuralFeatureAction", "Actions-IntermediateActions-StructuralFeatureAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.ReadStructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("ReadStructuralFeatureAction", "Actions-IntermediateActions-ReadStructuralFeatureAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.WriteStructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("WriteStructuralFeatureAction", "Actions-IntermediateActions-WriteStructuralFeatureAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.ClearStructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("ClearStructuralFeatureAction", "Actions-IntermediateActions-ClearStructuralFeatureAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.RemoveStructuralFeatureValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("RemoveStructuralFeatureValueAction", "Actions-IntermediateActions-RemoveStructuralFeatureValueAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.AddStructuralFeatureValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("AddStructuralFeatureValueAction", "Actions-IntermediateActions-AddStructuralFeatureValueAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.LinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("LinkAction", "Actions-IntermediateActions-LinkAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.LinkEndData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("LinkEndData", "Actions-IntermediateActions-LinkEndData", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.ReadLinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("ReadLinkAction", "Actions-IntermediateActions-ReadLinkAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.LinkEndCreationData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("LinkEndCreationData", "Actions-IntermediateActions-LinkEndCreationData", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.CreateLinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("CreateLinkAction", "Actions-IntermediateActions-CreateLinkAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.DestroyLinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("DestroyLinkAction", "Actions-IntermediateActions-DestroyLinkAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.WriteLinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("WriteLinkAction", "Actions-IntermediateActions-WriteLinkAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.ClearAssociationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("ClearAssociationAction", "Actions-IntermediateActions-ClearAssociationAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.BroadcastSignalAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("BroadcastSignalAction", "Actions-IntermediateActions-BroadcastSignalAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.SendObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("SendObjectAction", "Actions-IntermediateActions-SendObjectAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.LinkEndDestructionData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("LinkEndDestructionData", "Actions-IntermediateActions-LinkEndDestructionData", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.ValueSpecificationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("ValueSpecificationAction", "Actions-IntermediateActions-ValueSpecificationAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.OpaqueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("OpaqueAction", "Actions-BasicActions-OpaqueAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.Pin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("Pin", "Actions-BasicActions-Pin", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.ValuePin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("ValuePin", "Actions-BasicActions-ValuePin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.OutputPin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("OutputPin", "Actions-BasicActions-OutputPin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.InputPin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("InputPin", "Actions-BasicActions-InputPin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.InvocationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("InvocationAction", "Actions-BasicActions-InvocationAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.CallAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("CallAction", "Actions-BasicActions-CallAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.SendSignalAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("SendSignalAction", "Actions-BasicActions-SendSignalAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.CallOperationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("CallOperationAction", "Actions-BasicActions-CallOperationAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.CallBehaviorAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("CallBehaviorAction", "Actions-BasicActions-CallBehaviorAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.Action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("Action", "Actions-BasicActions-Action", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.MultiplicityElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("MultiplicityElement", "Actions-BasicActions-MultiplicityElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // Actions.StructuredActions.VariableAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("VariableAction", "Actions-StructuredActions-VariableAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // Actions.StructuredActions.ReadVariableAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("ReadVariableAction", "Actions-StructuredActions-ReadVariableAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // Actions.StructuredActions.WriteVariableAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("WriteVariableAction", "Actions-StructuredActions-WriteVariableAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // Actions.StructuredActions.ClearVariableAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("ClearVariableAction", "Actions-StructuredActions-ClearVariableAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // Actions.StructuredActions.AddVariableValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("AddVariableValueAction", "Actions-StructuredActions-AddVariableValueAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // Actions.StructuredActions.RemoveVariableValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("RemoveVariableValueAction", "Actions-StructuredActions-RemoveVariableValueAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // Actions.StructuredActions.RaiseExceptionAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("RaiseExceptionAction", "Actions-StructuredActions-RaiseExceptionAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // Actions.StructuredActions.ActionInputPin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("ActionInputPin", "Actions-StructuredActions-ActionInputPin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.ObjectNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ObjectNode", "Activities-BasicActivities-ObjectNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.ControlNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ControlNode", "Activities-BasicActivities-ControlNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.ActivityEdge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ActivityEdge", "Activities-BasicActivities-ActivityEdge", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.ControlFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ControlFlow", "Activities-BasicActivities-ControlFlow", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.ObjectFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ObjectFlow", "Activities-BasicActivities-ObjectFlow", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.InitialNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("InitialNode", "Activities-BasicActivities-InitialNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.ActivityFinalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ActivityFinalNode", "Activities-BasicActivities-ActivityFinalNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.ActivityGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ActivityGroup", "Activities-BasicActivities-ActivityGroup", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.ActivityParameterNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ActivityParameterNode", "Activities-BasicActivities-ActivityParameterNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.ActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ActivityNode", "Activities-BasicActivities-ActivityNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.Pin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("Pin", "Activities-BasicActivities-Pin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.Activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("Activity", "Activities-BasicActivities-Activity", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.ValuePin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ValuePin", "Activities-BasicActivities-ValuePin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.ForkNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("ForkNode", "Activities-IntermediateActivities-ForkNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.FlowFinalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("FlowFinalNode", "Activities-IntermediateActivities-FlowFinalNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.CentralBufferNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("CentralBufferNode", "Activities-IntermediateActivities-CentralBufferNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.ActivityPartition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("ActivityPartition", "Activities-IntermediateActivities-ActivityPartition", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.ActivityEdge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("ActivityEdge", "Activities-IntermediateActivities-ActivityEdge", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.ActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("ActivityNode", "Activities-IntermediateActivities-ActivityNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.MergeNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("MergeNode", "Activities-IntermediateActivities-MergeNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.DecisionNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("DecisionNode", "Activities-IntermediateActivities-DecisionNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.FinalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("FinalNode", "Activities-IntermediateActivities-FinalNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.ActivityFinalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("ActivityFinalNode", "Activities-IntermediateActivities-ActivityFinalNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.JoinNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("JoinNode", "Activities-IntermediateActivities-JoinNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.ActivityGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("ActivityGroup", "Activities-IntermediateActivities-ActivityGroup", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.Activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("Activity", "Activities-IntermediateActivities-Activity", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.JoinNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("JoinNode", "Activities-CompleteActivities-JoinNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.DataStoreNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("DataStoreNode", "Activities-CompleteActivities-DataStoreNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.ObjectFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("ObjectFlow", "Activities-CompleteActivities-ObjectFlow", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.ActivityEdge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("ActivityEdge", "Activities-CompleteActivities-ActivityEdge", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.ObjectNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("ObjectNode", "Activities-CompleteActivities-ObjectNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.ParameterSet 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("ParameterSet", "Activities-CompleteActivities-ParameterSet", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.Activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("Activity", "Activities-CompleteActivities-Activity", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.Parameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("Parameter", "Activities-CompleteActivities-Parameter", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.Action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("Action", "Activities-CompleteActivities-Action", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.InterruptibleActivityRegion 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("InterruptibleActivityRegion", "Activities-CompleteActivities-InterruptibleActivityRegion", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.ActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("ActivityNode", "Activities-CompleteActivities-ActivityNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.BehavioralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("BehavioralFeature", "Activities-CompleteActivities-BehavioralFeature", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.Behavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("Behavior", "Activities-CompleteActivities-Behavior", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.Pin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("Pin", "Activities-CompleteActivities-Pin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.ActivityGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("ActivityGroup", "Activities-CompleteActivities-ActivityGroup", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.Variable 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("Variable", "Activities-StructuredActivities-Variable", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.StructuredActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("StructuredActivityNode", "Activities-StructuredActivities-StructuredActivityNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.ConditionalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("ConditionalNode", "Activities-StructuredActivities-ConditionalNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.LoopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("LoopNode", "Activities-StructuredActivities-LoopNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.Clause 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("Clause", "Activities-StructuredActivities-Clause", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.Activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("Activity", "Activities-StructuredActivities-Activity", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.ActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("ActivityNode", "Activities-StructuredActivities-ActivityNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.ExecutableNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("ExecutableNode", "Activities-StructuredActivities-ExecutableNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.SequenceNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("SequenceNode", "Activities-StructuredActivities-SequenceNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.Action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("Action", "Activities-StructuredActivities-Action", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.ActivityGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("ActivityGroup", "Activities-StructuredActivities-ActivityGroup", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.InputPin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("InputPin", "Activities-StructuredActivities-InputPin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.OutputPin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("OutputPin", "Activities-StructuredActivities-OutputPin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // Activities.ExtraStructuredActivities.ExpansionNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.ExtraStructuredActivities").getDelegate();       
    	clss  = factory.createClass("ExpansionNode", "Activities-ExtraStructuredActivities-ExpansionNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.ExtraStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // Activities.ExtraStructuredActivities.ExpansionRegion 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.ExtraStructuredActivities").getDelegate();       
    	clss  = factory.createClass("ExpansionRegion", "Activities-ExtraStructuredActivities-ExpansionRegion", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.ExtraStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // Activities.ExtraStructuredActivities.ExecutableNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.ExtraStructuredActivities").getDelegate();       
    	clss  = factory.createClass("ExecutableNode", "Activities-ExtraStructuredActivities-ExecutableNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.ExtraStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // Activities.ExtraStructuredActivities.ExceptionHandler 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.ExtraStructuredActivities").getDelegate();       
    	clss  = factory.createClass("ExceptionHandler", "Activities-ExtraStructuredActivities-ExceptionHandler", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.ExtraStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // Activities.CompleteStructuredActivities.ConditionalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteStructuredActivities").getDelegate();       
    	clss  = factory.createClass("ConditionalNode", "Activities-CompleteStructuredActivities-ConditionalNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.CompleteStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // Activities.CompleteStructuredActivities.StructuredActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteStructuredActivities").getDelegate();       
    	clss  = factory.createClass("StructuredActivityNode", "Activities-CompleteStructuredActivities-StructuredActivityNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.CompleteStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // Activities.CompleteStructuredActivities.LoopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteStructuredActivities").getDelegate();       
    	clss  = factory.createClass("LoopNode", "Activities-CompleteStructuredActivities-LoopNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.CompleteStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // Activities.CompleteStructuredActivities.Clause 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteStructuredActivities").getDelegate();       
    	clss  = factory.createClass("Clause", "Activities-CompleteStructuredActivities-Clause", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.CompleteStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // Activities.CompleteStructuredActivities.ActivityEdge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteStructuredActivities").getDelegate();       
    	clss  = factory.createClass("ActivityEdge", "Activities-CompleteStructuredActivities-ActivityEdge", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.CompleteStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // Activities.CompleteStructuredActivities.ActivityGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.CompleteStructuredActivities").getDelegate();       
    	clss  = factory.createClass("ActivityGroup", "Activities-CompleteStructuredActivities-ActivityGroup", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.CompleteStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // Activities.FundamentalActivities.Activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.FundamentalActivities").getDelegate();       
    	clss  = factory.createClass("Activity", "Activities-FundamentalActivities-Activity", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Activities.FundamentalActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // Activities.FundamentalActivities.ActivityGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.FundamentalActivities").getDelegate();       
    	clss  = factory.createClass("ActivityGroup", "Activities-FundamentalActivities-ActivityGroup", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.FundamentalActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // Activities.FundamentalActivities.Action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.FundamentalActivities").getDelegate();       
    	clss  = factory.createClass("Action", "Activities-FundamentalActivities-Action", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.FundamentalActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // Activities.FundamentalActivities.ActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Activities.FundamentalActivities").getDelegate();       
    	clss  = factory.createClass("ActivityNode", "Activities-FundamentalActivities-ActivityNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Activities.FundamentalActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Profiles";   
                      
        // AuxiliaryConstructs.Profiles.ExtensionEnd 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Profiles").getDelegate();       
    	clss  = factory.createClass("ExtensionEnd", "AuxiliaryConstructs-Profiles-ExtensionEnd", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Profiles", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // AuxiliaryConstructs.InformationFlows.InformationItem 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.InformationFlows").getDelegate();       
    	clss  = factory.createClass("InformationItem", "AuxiliaryConstructs-InformationFlows-InformationItem", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.InformationFlows", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // AuxiliaryConstructs.InformationFlows.InformationFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.InformationFlows").getDelegate();       
    	clss  = factory.createClass("InformationFlow", "AuxiliaryConstructs-InformationFlows-InformationFlow", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.InformationFlows", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Models";   
                      
        // AuxiliaryConstructs.Models.Model 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Models").getDelegate();       
    	clss  = factory.createClass("Model", "AuxiliaryConstructs-Models-Model", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Models", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.TemplateSignature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("TemplateSignature", "AuxiliaryConstructs-Templates-TemplateSignature", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.NamedElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("NamedElement", "AuxiliaryConstructs-Templates-NamedElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.TemplateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("TemplateParameter", "AuxiliaryConstructs-Templates-TemplateParameter", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.StringExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("StringExpression", "AuxiliaryConstructs-Templates-StringExpression", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.TemplateBinding 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("TemplateBinding", "AuxiliaryConstructs-Templates-TemplateBinding", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.TemplateParameterSubstitution 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("TemplateParameterSubstitution", "AuxiliaryConstructs-Templates-TemplateParameterSubstitution", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.TemplateableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("TemplateableElement", "AuxiliaryConstructs-Templates-TemplateableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.ParameterableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("ParameterableElement", "AuxiliaryConstructs-Templates-ParameterableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.Property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("Property", "AuxiliaryConstructs-Templates-Property", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.ValueSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("ValueSpecification", "AuxiliaryConstructs-Templates-ValueSpecification", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.Operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("Operation", "AuxiliaryConstructs-Templates-Operation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.OperationTemplateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("OperationTemplateParameter", "AuxiliaryConstructs-Templates-OperationTemplateParameter", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.PackageableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("PackageableElement", "AuxiliaryConstructs-Templates-PackageableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.Classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("Classifier", "AuxiliaryConstructs-Templates-Classifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.ClassifierTemplateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("ClassifierTemplateParameter", "AuxiliaryConstructs-Templates-ClassifierTemplateParameter", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.RedefinableTemplateSignature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("RedefinableTemplateSignature", "AuxiliaryConstructs-Templates-RedefinableTemplateSignature", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.ConnectableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("ConnectableElement", "AuxiliaryConstructs-Templates-ConnectableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.ConnectableElementTemplateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("ConnectableElementTemplateParameter", "AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.Package 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("Package", "AuxiliaryConstructs-Templates-Package", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Element 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Element", "Classes-Kernel-Element", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Comment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Comment", "Classes-Kernel-Comment", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.DirectedRelationship 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("DirectedRelationship", "Classes-Kernel-DirectedRelationship", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.NamedElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("NamedElement", "Classes-Kernel-NamedElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.PackageableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("PackageableElement", "Classes-Kernel-PackageableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.OpaqueExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("OpaqueExpression", "Classes-Kernel-OpaqueExpression", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.LiteralSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("LiteralSpecification", "Classes-Kernel-LiteralSpecification", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.LiteralInteger 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("LiteralInteger", "Classes-Kernel-LiteralInteger", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.LiteralString 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("LiteralString", "Classes-Kernel-LiteralString", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.LiteralBoolean 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("LiteralBoolean", "Classes-Kernel-LiteralBoolean", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.LiteralNull 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("LiteralNull", "Classes-Kernel-LiteralNull", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Constraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Constraint", "Classes-Kernel-Constraint", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.ElementImport 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("ElementImport", "Classes-Kernel-ElementImport", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.MultiplicityElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("MultiplicityElement", "Classes-Kernel-MultiplicityElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.TypedElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("TypedElement", "Classes-Kernel-TypedElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Classifier", "Classes-Kernel-Classifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Feature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Feature", "Classes-Kernel-Feature", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.RedefinableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("RedefinableElement", "Classes-Kernel-RedefinableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Generalization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Generalization", "Classes-Kernel-Generalization", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.BehavioralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("BehavioralFeature", "Classes-Kernel-BehavioralFeature", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Parameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Parameter", "Classes-Kernel-Parameter", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.StructuralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("StructuralFeature", "Classes-Kernel-StructuralFeature", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.InstanceSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("InstanceSpecification", "Classes-Kernel-InstanceSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Slot 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Slot", "Classes-Kernel-Slot", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Package 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Package", "Classes-Kernel-Package", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.PackageImport 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("PackageImport", "Classes-Kernel-PackageImport", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Class", "Classes-Kernel-Class", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Property", "Classes-Kernel-Property", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Operation", "Classes-Kernel-Operation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.DataType 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("DataType", "Classes-Kernel-DataType", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Enumeration 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Enumeration", "Classes-Kernel-Enumeration", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.EnumerationLiteral 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("EnumerationLiteral", "Classes-Kernel-EnumerationLiteral", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.PrimitiveType 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("PrimitiveType", "Classes-Kernel-PrimitiveType", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Association 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Association", "Classes-Kernel-Association", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Namespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Namespace", "Classes-Kernel-Namespace", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.ValueSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("ValueSpecification", "Classes-Kernel-ValueSpecification", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Relationship 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Relationship", "Classes-Kernel-Relationship", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.PackageMerge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("PackageMerge", "Classes-Kernel-PackageMerge", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.InstanceValue 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("InstanceValue", "Classes-Kernel-InstanceValue", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.LiteralUnlimitedNatural 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("LiteralUnlimitedNatural", "Classes-Kernel-LiteralUnlimitedNatural", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Type 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Type", "Classes-Kernel-Type", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.Expression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Expression", "Classes-Kernel-Expression", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // Classes.Interfaces.Interface 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Interfaces").getDelegate();       
    	clss  = factory.createClass("Interface", "Classes-Interfaces-Interface", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Interfaces", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // Classes.Interfaces.InterfaceRealization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Interfaces").getDelegate();       
    	clss  = factory.createClass("InterfaceRealization", "Classes-Interfaces-InterfaceRealization", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Interfaces", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // Classes.Interfaces.BehavioredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Interfaces").getDelegate();       
    	clss  = factory.createClass("BehavioredClassifier", "Classes-Interfaces-BehavioredClassifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Interfaces", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // Classes.Interfaces.Operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Interfaces").getDelegate();       
    	clss  = factory.createClass("Operation", "Classes-Interfaces-Operation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Interfaces", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // Classes.Dependencies.Usage 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("Usage", "Classes-Dependencies-Usage", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // Classes.Dependencies.Abstraction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("Abstraction", "Classes-Dependencies-Abstraction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // Classes.Dependencies.Dependency 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("Dependency", "Classes-Dependencies-Dependency", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // Classes.Dependencies.Realization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("Realization", "Classes-Dependencies-Realization", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // Classes.Dependencies.Substitution 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("Substitution", "Classes-Dependencies-Substitution", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // Classes.Dependencies.Classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("Classifier", "Classes-Dependencies-Classifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // Classes.Dependencies.NamedElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("NamedElement", "Classes-Dependencies-NamedElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // Classes.Dependencies.PackageableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("PackageableElement", "Classes-Dependencies-PackageableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // Classes.Dependencies.Namespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("Namespace", "Classes-Dependencies-Namespace", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-PowerTypes";   
                      
        // Classes.PowerTypes.GeneralizationSet 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.PowerTypes").getDelegate();       
    	clss  = factory.createClass("GeneralizationSet", "Classes-PowerTypes-GeneralizationSet", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.PowerTypes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-PowerTypes";   
                      
        // Classes.PowerTypes.Classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.PowerTypes").getDelegate();       
    	clss  = factory.createClass("Classifier", "Classes-PowerTypes-Classifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Classes.PowerTypes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-PowerTypes";   
                      
        // Classes.PowerTypes.Generalization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.PowerTypes").getDelegate();       
    	clss  = factory.createClass("Generalization", "Classes-PowerTypes-Generalization", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.PowerTypes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-AssociationClasses";   
                      
        // Classes.AssociationClasses.AssociationClass 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.AssociationClasses").getDelegate();       
    	clss  = factory.createClass("AssociationClass", "Classes-AssociationClasses-AssociationClass", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.AssociationClasses", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-AssociationClasses";   
                      
        // Classes.AssociationClasses.Property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Classes.AssociationClasses").getDelegate();       
    	clss  = factory.createClass("Property", "Classes-AssociationClasses-Property", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Classes.AssociationClasses", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.BehavioralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("BehavioralFeature", "CommonBehaviors-Communications-BehavioralFeature", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.CallEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("CallEvent", "CommonBehaviors-Communications-CallEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.ChangeEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("ChangeEvent", "CommonBehaviors-Communications-ChangeEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.Class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("Class", "CommonBehaviors-Communications-Class", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.Trigger 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("Trigger", "CommonBehaviors-Communications-Trigger", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.Interface 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("Interface", "CommonBehaviors-Communications-Interface", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.Reception 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("Reception", "CommonBehaviors-Communications-Reception", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.Signal 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("Signal", "CommonBehaviors-Communications-Signal", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.SignalEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("SignalEvent", "CommonBehaviors-Communications-SignalEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.TimeEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("TimeEvent", "CommonBehaviors-Communications-TimeEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.MessageEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("MessageEvent", "CommonBehaviors-Communications-MessageEvent", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.AnyReceiveEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("AnyReceiveEvent", "CommonBehaviors-Communications-AnyReceiveEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.BehavioredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("BehavioredClassifier", "CommonBehaviors-Communications-BehavioredClassifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.Event 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("Event", "CommonBehaviors-Communications-Event", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.Operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("Operation", "CommonBehaviors-Communications-Operation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.Behavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.BasicBehaviors").getDelegate();       
    	clss  = factory.createClass("Behavior", "CommonBehaviors-BasicBehaviors-Behavior", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "CommonBehaviors.BasicBehaviors", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.BehavioredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.BasicBehaviors").getDelegate();       
    	clss  = factory.createClass("BehavioredClassifier", "CommonBehaviors-BasicBehaviors-BehavioredClassifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "CommonBehaviors.BasicBehaviors", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.OpaqueExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.BasicBehaviors").getDelegate();       
    	clss  = factory.createClass("OpaqueExpression", "CommonBehaviors-BasicBehaviors-OpaqueExpression", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.BasicBehaviors", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.BehavioralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.BasicBehaviors").getDelegate();       
    	clss  = factory.createClass("BehavioralFeature", "CommonBehaviors-BasicBehaviors-BehavioralFeature", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "CommonBehaviors.BasicBehaviors", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.OpaqueBehavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.BasicBehaviors").getDelegate();       
    	clss  = factory.createClass("OpaqueBehavior", "CommonBehaviors-BasicBehaviors-OpaqueBehavior", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.BasicBehaviors", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.FunctionBehavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.BasicBehaviors").getDelegate();       
    	clss  = factory.createClass("FunctionBehavior", "CommonBehaviors-BasicBehaviors-FunctionBehavior", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.BasicBehaviors", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.TimeExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("TimeExpression", "CommonBehaviors-SimpleTime-TimeExpression", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.Duration 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("Duration", "CommonBehaviors-SimpleTime-Duration", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.DurationInterval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("DurationInterval", "CommonBehaviors-SimpleTime-DurationInterval", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.TimeConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("TimeConstraint", "CommonBehaviors-SimpleTime-TimeConstraint", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.TimeInterval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("TimeInterval", "CommonBehaviors-SimpleTime-TimeInterval", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.DurationConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("DurationConstraint", "CommonBehaviors-SimpleTime-DurationConstraint", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.IntervalConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("IntervalConstraint", "CommonBehaviors-SimpleTime-IntervalConstraint", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.Interval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("Interval", "CommonBehaviors-SimpleTime-Interval", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.TimeEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("TimeEvent", "CommonBehaviors-SimpleTime-TimeEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.Observation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("Observation", "CommonBehaviors-SimpleTime-Observation", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.TimeObservation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("TimeObservation", "CommonBehaviors-SimpleTime-TimeObservation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.DurationObservation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("DurationObservation", "CommonBehaviors-SimpleTime-DurationObservation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-PackagingComponents";   
                      
        // Components.PackagingComponents.Component 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Components.PackagingComponents").getDelegate();       
    	clss  = factory.createClass("Component", "Components-PackagingComponents-Component", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Components.PackagingComponents", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // Components.BasicComponents.Component 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Components.BasicComponents").getDelegate();       
    	clss  = factory.createClass("Component", "Components-BasicComponents-Component", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Components.BasicComponents", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // Components.BasicComponents.ComponentRealization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Components.BasicComponents").getDelegate();       
    	clss  = factory.createClass("ComponentRealization", "Components-BasicComponents-ComponentRealization", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Components.BasicComponents", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // Components.BasicComponents.Connector 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Components.BasicComponents").getDelegate();       
    	clss  = factory.createClass("Connector", "Components-BasicComponents-Connector", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Components.BasicComponents", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-StructuredClasses";   
                      
        // CompositeStructures.StructuredClasses.Class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.StructuredClasses").getDelegate();       
    	clss  = factory.createClass("Class", "CompositeStructures-StructuredClasses-Class", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CompositeStructures.StructuredClasses", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // CompositeStructures.Collaborations.CollaborationUse 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.Collaborations").getDelegate();       
    	clss  = factory.createClass("CollaborationUse", "CompositeStructures-Collaborations-CollaborationUse", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CompositeStructures.Collaborations", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // CompositeStructures.Collaborations.Collaboration 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.Collaborations").getDelegate();       
    	clss  = factory.createClass("Collaboration", "CompositeStructures-Collaborations-Collaboration", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CompositeStructures.Collaborations", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // CompositeStructures.Collaborations.Classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.Collaborations").getDelegate();       
    	clss  = factory.createClass("Classifier", "CompositeStructures-Collaborations-Classifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "CompositeStructures.Collaborations", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // CompositeStructures.Collaborations.Parameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.Collaborations").getDelegate();       
    	clss  = factory.createClass("Parameter", "CompositeStructures-Collaborations-Parameter", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CompositeStructures.Collaborations", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";   
                      
        // CompositeStructures.Ports.Port 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.Ports").getDelegate();       
    	clss  = factory.createClass("Port", "CompositeStructures-Ports-Port", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CompositeStructures.Ports", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";   
                      
        // CompositeStructures.Ports.EncapsulatedClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.Ports").getDelegate();       
    	clss  = factory.createClass("EncapsulatedClassifier", "CompositeStructures-Ports-EncapsulatedClassifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "CompositeStructures.Ports", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";   
                      
        // CompositeStructures.Ports.ConnectorEnd 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.Ports").getDelegate();       
    	clss  = factory.createClass("ConnectorEnd", "CompositeStructures-Ports-ConnectorEnd", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CompositeStructures.Ports", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InvocationActions";   
                      
        // CompositeStructures.InvocationActions.InvocationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.InvocationActions").getDelegate();       
    	clss  = factory.createClass("InvocationAction", "CompositeStructures-InvocationActions-InvocationAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "CompositeStructures.InvocationActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InvocationActions";   
                      
        // CompositeStructures.InvocationActions.Trigger 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.InvocationActions").getDelegate();       
    	clss  = factory.createClass("Trigger", "CompositeStructures-InvocationActions-Trigger", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "CompositeStructures.InvocationActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.ConnectorEnd 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.InternalStructures").getDelegate();       
    	clss  = factory.createClass("ConnectorEnd", "CompositeStructures-InternalStructures-ConnectorEnd", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CompositeStructures.InternalStructures", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.Connector 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.InternalStructures").getDelegate();       
    	clss  = factory.createClass("Connector", "CompositeStructures-InternalStructures-Connector", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CompositeStructures.InternalStructures", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.Property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.InternalStructures").getDelegate();       
    	clss  = factory.createClass("Property", "CompositeStructures-InternalStructures-Property", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CompositeStructures.InternalStructures", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.StructuredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.InternalStructures").getDelegate();       
    	clss  = factory.createClass("StructuredClassifier", "CompositeStructures-InternalStructures-StructuredClassifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "CompositeStructures.InternalStructures", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.ConnectableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.InternalStructures").getDelegate();       
    	clss  = factory.createClass("ConnectableElement", "CompositeStructures-InternalStructures-ConnectableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "CompositeStructures.InternalStructures", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.Classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.InternalStructures").getDelegate();       
    	clss  = factory.createClass("Classifier", "CompositeStructures-InternalStructures-Classifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "CompositeStructures.InternalStructures", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-StructuredActivities";   
                      
        // CompositeStructures.StructuredActivities.Variable 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("CompositeStructures.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("Variable", "CompositeStructures-StructuredActivities-Variable", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "CompositeStructures.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-ComponentDeployments";   
                      
        // Deployments.ComponentDeployments.Deployment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Deployments.ComponentDeployments").getDelegate();       
    	clss  = factory.createClass("Deployment", "Deployments-ComponentDeployments-Deployment", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Deployments.ComponentDeployments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-ComponentDeployments";   
                      
        // Deployments.ComponentDeployments.DeploymentSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Deployments.ComponentDeployments").getDelegate();       
    	clss  = factory.createClass("DeploymentSpecification", "Deployments-ComponentDeployments-DeploymentSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Deployments.ComponentDeployments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // Deployments.Nodes.Deployment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("Deployment", "Deployments-Nodes-Deployment", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // Deployments.Nodes.Node 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("Node", "Deployments-Nodes-Node", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // Deployments.Nodes.Device 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("Device", "Deployments-Nodes-Device", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // Deployments.Nodes.ExecutionEnvironment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("ExecutionEnvironment", "Deployments-Nodes-ExecutionEnvironment", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // Deployments.Nodes.DeploymentTarget 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("DeploymentTarget", "Deployments-Nodes-DeploymentTarget", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // Deployments.Nodes.DeployedArtifact 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("DeployedArtifact", "Deployments-Nodes-DeployedArtifact", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // Deployments.Nodes.CommunicationPath 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("CommunicationPath", "Deployments-Nodes-CommunicationPath", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // Deployments.Nodes.Property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("Property", "Deployments-Nodes-Property", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // Deployments.Nodes.InstanceSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("InstanceSpecification", "Deployments-Nodes-InstanceSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // Deployments.Nodes.Artifact 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("Artifact", "Deployments-Nodes-Artifact", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";   
                      
        // Deployments.Artifacts.Artifact 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Deployments.Artifacts").getDelegate();       
    	clss  = factory.createClass("Artifact", "Deployments-Artifacts-Artifact", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Deployments.Artifacts", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";   
                      
        // Deployments.Artifacts.Manifestation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Deployments.Artifacts").getDelegate();       
    	clss  = factory.createClass("Manifestation", "Deployments-Artifacts-Manifestation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Deployments.Artifacts", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.Interaction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("Interaction", "Interactions-BasicInteractions-Interaction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.Lifeline 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("Lifeline", "Interactions-BasicInteractions-Lifeline", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.InteractionFragment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("InteractionFragment", "Interactions-BasicInteractions-InteractionFragment", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.Message 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("Message", "Interactions-BasicInteractions-Message", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.GeneralOrdering 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("GeneralOrdering", "Interactions-BasicInteractions-GeneralOrdering", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.ExecutionSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("ExecutionSpecification", "Interactions-BasicInteractions-ExecutionSpecification", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.OccurrenceSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("OccurrenceSpecification", "Interactions-BasicInteractions-OccurrenceSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.MessageEnd 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("MessageEnd", "Interactions-BasicInteractions-MessageEnd", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.StateInvariant 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("StateInvariant", "Interactions-BasicInteractions-StateInvariant", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.ActionExecutionSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("ActionExecutionSpecification", "Interactions-BasicInteractions-ActionExecutionSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.BehaviorExecutionSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("BehaviorExecutionSpecification", "Interactions-BasicInteractions-BehaviorExecutionSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.ExecutionEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("ExecutionEvent", "Interactions-BasicInteractions-ExecutionEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.CreationEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("CreationEvent", "Interactions-BasicInteractions-CreationEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.DestructionEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("DestructionEvent", "Interactions-BasicInteractions-DestructionEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.SendOperationEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("SendOperationEvent", "Interactions-BasicInteractions-SendOperationEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.SendSignalEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("SendSignalEvent", "Interactions-BasicInteractions-SendSignalEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.MessageOccurrenceSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("MessageOccurrenceSpecification", "Interactions-BasicInteractions-MessageOccurrenceSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.ExecutionOccurrenceSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("ExecutionOccurrenceSpecification", "Interactions-BasicInteractions-ExecutionOccurrenceSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.ReceiveOperationEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("ReceiveOperationEvent", "Interactions-BasicInteractions-ReceiveOperationEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.ReceiveSignalEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("ReceiveSignalEvent", "Interactions-BasicInteractions-ReceiveSignalEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // Interactions.Fragments.InteractionUse 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("InteractionUse", "Interactions-Fragments-InteractionUse", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // Interactions.Fragments.PartDecomposition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("PartDecomposition", "Interactions-Fragments-PartDecomposition", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // Interactions.Fragments.InteractionOperand 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("InteractionOperand", "Interactions-Fragments-InteractionOperand", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // Interactions.Fragments.InteractionConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("InteractionConstraint", "Interactions-Fragments-InteractionConstraint", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // Interactions.Fragments.Gate 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("Gate", "Interactions-Fragments-Gate", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // Interactions.Fragments.CombinedFragment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("CombinedFragment", "Interactions-Fragments-CombinedFragment", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // Interactions.Fragments.Interaction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("Interaction", "Interactions-Fragments-Interaction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // Interactions.Fragments.Lifeline 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("Lifeline", "Interactions-Fragments-Lifeline", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // Interactions.Fragments.Continuation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("Continuation", "Interactions-Fragments-Continuation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // Interactions.Fragments.InteractionFragment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("InteractionFragment", "Interactions-Fragments-InteractionFragment", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // Interactions.Fragments.ConsiderIgnoreFragment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("ConsiderIgnoreFragment", "Interactions-Fragments-ConsiderIgnoreFragment", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // StateMachines.BehaviorStateMachines.StateMachine 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("StateMachine", "StateMachines-BehaviorStateMachines-StateMachine", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // StateMachines.BehaviorStateMachines.State 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("State", "StateMachines-BehaviorStateMachines-State", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // StateMachines.BehaviorStateMachines.Transition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("Transition", "StateMachines-BehaviorStateMachines-Transition", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // StateMachines.BehaviorStateMachines.Vertex 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("Vertex", "StateMachines-BehaviorStateMachines-Vertex", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // StateMachines.BehaviorStateMachines.Pseudostate 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("Pseudostate", "StateMachines-BehaviorStateMachines-Pseudostate", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // StateMachines.BehaviorStateMachines.FinalState 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("FinalState", "StateMachines-BehaviorStateMachines-FinalState", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // StateMachines.BehaviorStateMachines.ConnectionPointReference 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("ConnectionPointReference", "StateMachines-BehaviorStateMachines-ConnectionPointReference", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // StateMachines.BehaviorStateMachines.Region 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("Region", "StateMachines-BehaviorStateMachines-Region", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // StateMachines.BehaviorStateMachines.TimeEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("TimeEvent", "StateMachines-BehaviorStateMachines-TimeEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";   
                      
        // StateMachines.ProtocolStateMachines.ProtocolConformance 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.ProtocolStateMachines").getDelegate();       
    	clss  = factory.createClass("ProtocolConformance", "StateMachines-ProtocolStateMachines-ProtocolConformance", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "StateMachines.ProtocolStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";   
                      
        // StateMachines.ProtocolStateMachines.Interface 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.ProtocolStateMachines").getDelegate();       
    	clss  = factory.createClass("Interface", "StateMachines-ProtocolStateMachines-Interface", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "StateMachines.ProtocolStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";   
                      
        // StateMachines.ProtocolStateMachines.Port 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.ProtocolStateMachines").getDelegate();       
    	clss  = factory.createClass("Port", "StateMachines-ProtocolStateMachines-Port", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "StateMachines.ProtocolStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";   
                      
        // StateMachines.ProtocolStateMachines.ProtocolTransition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.ProtocolStateMachines").getDelegate();       
    	clss  = factory.createClass("ProtocolTransition", "StateMachines-ProtocolStateMachines-ProtocolTransition", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "StateMachines.ProtocolStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";   
                      
        // StateMachines.ProtocolStateMachines.ProtocolStateMachine 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.ProtocolStateMachines").getDelegate();       
    	clss  = factory.createClass("ProtocolStateMachine", "StateMachines-ProtocolStateMachines-ProtocolStateMachine", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "StateMachines.ProtocolStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";   
                      
        // StateMachines.ProtocolStateMachines.State 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.ProtocolStateMachines").getDelegate();       
    	clss  = factory.createClass("State", "StateMachines-ProtocolStateMachines-State", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "StateMachines.ProtocolStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";   
                      
        // StateMachines.ProtocolStateMachines.Region 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("StateMachines.ProtocolStateMachines").getDelegate();       
    	clss  = factory.createClass("Region", "StateMachines-ProtocolStateMachines-Region", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "StateMachines.ProtocolStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "UseCases";   
                      
        // UseCases.Actor 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UseCases").getDelegate();       
    	clss  = factory.createClass("Actor", "UseCases-Actor", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UseCases", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "UseCases";   
                      
        // UseCases.Extend 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UseCases").getDelegate();       
    	clss  = factory.createClass("Extend", "UseCases-Extend", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UseCases", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "UseCases";   
                      
        // UseCases.Include 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UseCases").getDelegate();       
    	clss  = factory.createClass("Include", "UseCases-Include", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UseCases", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "UseCases";   
                      
        // UseCases.UseCase 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UseCases").getDelegate();       
    	clss  = factory.createClass("UseCase", "UseCases-UseCase", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UseCases", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "UseCases";   
                      
        // UseCases.ExtensionPoint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UseCases").getDelegate();       
    	clss  = factory.createClass("ExtensionPoint", "UseCases-ExtensionPoint", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UseCases", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "UseCases";   
                      
        // UseCases.Classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UseCases").getDelegate();       
    	clss  = factory.createClass("Classifier", "UseCases-Classifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UseCases", this); 
    
    }   

    private void constructEnumerations()
    {
        Enumeration enumeration = null;
        EnumerationLiteral literal = null;
                                                      
        // ObjectNodeOrderingKind
    	enumeration  = factory.createEnumeration("ObjectNodeOrderingKind", "Activities-CompleteActivities-ObjectNodeOrderingKind");
    	mapping.mapEnumeration(enumeration, "Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "unordered",
            "Activities-CompleteActivities-ObjectNodeOrderingKind-unordered");
    	mapping.mapEnumerationLiteral(literal, "Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "ordered",
            "Activities-CompleteActivities-ObjectNodeOrderingKind-ordered");
    	mapping.mapEnumerationLiteral(literal, "Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "LIFO",
            "Activities-CompleteActivities-ObjectNodeOrderingKind-LIFO");
    	mapping.mapEnumerationLiteral(literal, "Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "FIFO",
            "Activities-CompleteActivities-ObjectNodeOrderingKind-FIFO");
    	mapping.mapEnumerationLiteral(literal, "Activities.CompleteActivities", this); 
                                                          
        // ParameterEffectKind
    	enumeration  = factory.createEnumeration("ParameterEffectKind", "Activities-CompleteActivities-ParameterEffectKind");
    	mapping.mapEnumeration(enumeration, "Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "create",
            "Activities-CompleteActivities-ParameterEffectKind-create");
    	mapping.mapEnumerationLiteral(literal, "Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "read",
            "Activities-CompleteActivities-ParameterEffectKind-read");
    	mapping.mapEnumerationLiteral(literal, "Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "update",
            "Activities-CompleteActivities-ParameterEffectKind-update");
    	mapping.mapEnumerationLiteral(literal, "Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "delete",
            "Activities-CompleteActivities-ParameterEffectKind-delete");
    	mapping.mapEnumerationLiteral(literal, "Activities.CompleteActivities", this); 
                                                          
        // ExpansionKind
    	enumeration  = factory.createEnumeration("ExpansionKind", "Activities-ExtraStructuredActivities-ExpansionKind");
    	mapping.mapEnumeration(enumeration, "Activities.ExtraStructuredActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "parallel",
            "Activities-ExtraStructuredActivities-ExpansionKind-parallel");
    	mapping.mapEnumerationLiteral(literal, "Activities.ExtraStructuredActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "iterative",
            "Activities-ExtraStructuredActivities-ExpansionKind-iterative");
    	mapping.mapEnumerationLiteral(literal, "Activities.ExtraStructuredActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "stream",
            "Activities-ExtraStructuredActivities-ExpansionKind-stream");
    	mapping.mapEnumerationLiteral(literal, "Activities.ExtraStructuredActivities", this); 
                                                          
        // AggregationKind
    	enumeration  = factory.createEnumeration("AggregationKind", "Classes-Kernel-AggregationKind");
    	mapping.mapEnumeration(enumeration, "Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "none",
            "Classes-Kernel-AggregationKind-none");
    	mapping.mapEnumerationLiteral(literal, "Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "shared",
            "Classes-Kernel-AggregationKind-shared");
    	mapping.mapEnumerationLiteral(literal, "Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "composite",
            "Classes-Kernel-AggregationKind-composite");
    	mapping.mapEnumerationLiteral(literal, "Classes.Kernel", this); 
                                                          
        // ParameterDirectionKind
    	enumeration  = factory.createEnumeration("ParameterDirectionKind", "Classes-Kernel-ParameterDirectionKind");
    	mapping.mapEnumeration(enumeration, "Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "in",
            "Classes-Kernel-ParameterDirectionKind-in");
    	mapping.mapEnumerationLiteral(literal, "Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "inout",
            "Classes-Kernel-ParameterDirectionKind-inout");
    	mapping.mapEnumerationLiteral(literal, "Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "out",
            "Classes-Kernel-ParameterDirectionKind-out");
    	mapping.mapEnumerationLiteral(literal, "Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "return",
            "Classes-Kernel-ParameterDirectionKind-return");
    	mapping.mapEnumerationLiteral(literal, "Classes.Kernel", this); 
                                                          
        // VisibilityKind
    	enumeration  = factory.createEnumeration("VisibilityKind", "Classes-Kernel-VisibilityKind");
    	mapping.mapEnumeration(enumeration, "Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "public",
            "Classes-Kernel-VisibilityKind-public");
    	mapping.mapEnumerationLiteral(literal, "Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "private",
            "Classes-Kernel-VisibilityKind-private");
    	mapping.mapEnumerationLiteral(literal, "Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "protected",
            "Classes-Kernel-VisibilityKind-protected");
    	mapping.mapEnumerationLiteral(literal, "Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "package",
            "Classes-Kernel-VisibilityKind-package");
    	mapping.mapEnumerationLiteral(literal, "Classes.Kernel", this); 
                                                          
        // CallConcurrencyKind
    	enumeration  = factory.createEnumeration("CallConcurrencyKind", "CommonBehaviors-Communications-CallConcurrencyKind");
    	mapping.mapEnumeration(enumeration, "CommonBehaviors.Communications", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "sequential",
            "CommonBehaviors-Communications-CallConcurrencyKind-sequential");
    	mapping.mapEnumerationLiteral(literal, "CommonBehaviors.Communications", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "guarded",
            "CommonBehaviors-Communications-CallConcurrencyKind-guarded");
    	mapping.mapEnumerationLiteral(literal, "CommonBehaviors.Communications", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "concurrent",
            "CommonBehaviors-Communications-CallConcurrencyKind-concurrent");
    	mapping.mapEnumerationLiteral(literal, "CommonBehaviors.Communications", this); 
                                                          
        // ConnectorKind
    	enumeration  = factory.createEnumeration("ConnectorKind", "Components-BasicComponents-ConnectorKind");
    	mapping.mapEnumeration(enumeration, "Components.BasicComponents", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "assembly",
            "Components-BasicComponents-ConnectorKind-assembly");
    	mapping.mapEnumerationLiteral(literal, "Components.BasicComponents", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "delegation",
            "Components-BasicComponents-ConnectorKind-delegation");
    	mapping.mapEnumerationLiteral(literal, "Components.BasicComponents", this); 
                                                          
        // MessageKind
    	enumeration  = factory.createEnumeration("MessageKind", "Interactions-BasicInteractions-MessageKind");
    	mapping.mapEnumeration(enumeration, "Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "complete",
            "Interactions-BasicInteractions-MessageKind-complete");
    	mapping.mapEnumerationLiteral(literal, "Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "lost",
            "Interactions-BasicInteractions-MessageKind-lost");
    	mapping.mapEnumerationLiteral(literal, "Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "found",
            "Interactions-BasicInteractions-MessageKind-found");
    	mapping.mapEnumerationLiteral(literal, "Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "unknown",
            "Interactions-BasicInteractions-MessageKind-unknown");
    	mapping.mapEnumerationLiteral(literal, "Interactions.BasicInteractions", this); 
                                                          
        // MessageSort
    	enumeration  = factory.createEnumeration("MessageSort", "Interactions-BasicInteractions-MessageSort");
    	mapping.mapEnumeration(enumeration, "Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "synchCall",
            "Interactions-BasicInteractions-MessageSort-synchCall");
    	mapping.mapEnumerationLiteral(literal, "Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "asynchCall",
            "Interactions-BasicInteractions-MessageSort-asynchCall");
    	mapping.mapEnumerationLiteral(literal, "Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "asynchSignal",
            "Interactions-BasicInteractions-MessageSort-asynchSignal");
    	mapping.mapEnumerationLiteral(literal, "Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "createMessage",
            "Interactions-BasicInteractions-MessageSort-createMessage");
    	mapping.mapEnumerationLiteral(literal, "Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "deleteMessage",
            "Interactions-BasicInteractions-MessageSort-deleteMessage");
    	mapping.mapEnumerationLiteral(literal, "Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "reply",
            "Interactions-BasicInteractions-MessageSort-reply");
    	mapping.mapEnumerationLiteral(literal, "Interactions.BasicInteractions", this); 
                                                          
        // InteractionOperatorKind
    	enumeration  = factory.createEnumeration("InteractionOperatorKind", "Interactions-Fragments-InteractionOperatorKind");
    	mapping.mapEnumeration(enumeration, "Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "seq",
            "Interactions-Fragments-InteractionOperatorKind-seq");
    	mapping.mapEnumerationLiteral(literal, "Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "alt",
            "Interactions-Fragments-InteractionOperatorKind-alt");
    	mapping.mapEnumerationLiteral(literal, "Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "opt",
            "Interactions-Fragments-InteractionOperatorKind-opt");
    	mapping.mapEnumerationLiteral(literal, "Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "break",
            "Interactions-Fragments-InteractionOperatorKind-break");
    	mapping.mapEnumerationLiteral(literal, "Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "par",
            "Interactions-Fragments-InteractionOperatorKind-par");
    	mapping.mapEnumerationLiteral(literal, "Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "strict",
            "Interactions-Fragments-InteractionOperatorKind-strict");
    	mapping.mapEnumerationLiteral(literal, "Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "loop",
            "Interactions-Fragments-InteractionOperatorKind-loop");
    	mapping.mapEnumerationLiteral(literal, "Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "critical",
            "Interactions-Fragments-InteractionOperatorKind-critical");
    	mapping.mapEnumerationLiteral(literal, "Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "neg",
            "Interactions-Fragments-InteractionOperatorKind-neg");
    	mapping.mapEnumerationLiteral(literal, "Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "assert",
            "Interactions-Fragments-InteractionOperatorKind-assert");
    	mapping.mapEnumerationLiteral(literal, "Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "ignore",
            "Interactions-Fragments-InteractionOperatorKind-ignore");
    	mapping.mapEnumerationLiteral(literal, "Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "consider",
            "Interactions-Fragments-InteractionOperatorKind-consider");
    	mapping.mapEnumerationLiteral(literal, "Interactions.Fragments", this); 
                                                          
        // PseudostateKind
    	enumeration  = factory.createEnumeration("PseudostateKind", "StateMachines-BehaviorStateMachines-PseudostateKind");
    	mapping.mapEnumeration(enumeration, "StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "initial",
            "StateMachines-BehaviorStateMachines-PseudostateKind-initial");
    	mapping.mapEnumerationLiteral(literal, "StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "deepHistory",
            "StateMachines-BehaviorStateMachines-PseudostateKind-deepHistory");
    	mapping.mapEnumerationLiteral(literal, "StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "shallowHistory",
            "StateMachines-BehaviorStateMachines-PseudostateKind-shallowHistory");
    	mapping.mapEnumerationLiteral(literal, "StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "join",
            "StateMachines-BehaviorStateMachines-PseudostateKind-join");
    	mapping.mapEnumerationLiteral(literal, "StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "fork",
            "StateMachines-BehaviorStateMachines-PseudostateKind-fork");
    	mapping.mapEnumerationLiteral(literal, "StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "junction",
            "StateMachines-BehaviorStateMachines-PseudostateKind-junction");
    	mapping.mapEnumerationLiteral(literal, "StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "choice",
            "StateMachines-BehaviorStateMachines-PseudostateKind-choice");
    	mapping.mapEnumerationLiteral(literal, "StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "entryPoint",
            "StateMachines-BehaviorStateMachines-PseudostateKind-entryPoint");
    	mapping.mapEnumerationLiteral(literal, "StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "exitPoint",
            "StateMachines-BehaviorStateMachines-PseudostateKind-exitPoint");
    	mapping.mapEnumerationLiteral(literal, "StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "terminate",
            "StateMachines-BehaviorStateMachines-PseudostateKind-terminate");
    	mapping.mapEnumerationLiteral(literal, "StateMachines.BehaviorStateMachines", this); 
                                                          
        // TransitionKind
    	enumeration  = factory.createEnumeration("TransitionKind", "StateMachines-BehaviorStateMachines-TransitionKind");
    	mapping.mapEnumeration(enumeration, "StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "internal",
            "StateMachines-BehaviorStateMachines-TransitionKind-internal");
    	mapping.mapEnumerationLiteral(literal, "StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "local",
            "StateMachines-BehaviorStateMachines-TransitionKind-local");
    	mapping.mapEnumerationLiteral(literal, "StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "external",
            "StateMachines-BehaviorStateMachines-TransitionKind-external");
    	mapping.mapEnumerationLiteral(literal, "StateMachines.BehaviorStateMachines", this); 
        
    }   

    private void constructProperties()
    {
        Class_ clss = null;
        Property prop = null;
        
    
        // ReadExtentAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadExtentAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-ReadExtentAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "classifier", 
    	    "Actions-CompleteActions-ReadExtentAction-classifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReclassifyObjectAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReclassifyObjectAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isReplaceAll", 
    	    "Actions-CompleteActions-ReclassifyObjectAction-isReplaceAll",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PucFEG_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "oldClassifier", 
    	    "Actions-CompleteActions-ReclassifyObjectAction-oldClassifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "newClassifier", 
    	    "Actions-CompleteActions-ReclassifyObjectAction-newClassifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-CompleteActions-ReclassifyObjectAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReadIsClassifiedObjectAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadIsClassifiedObjectAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isDirect", 
    	    "Actions-CompleteActions-ReadIsClassifiedObjectAction-isDirect",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_Pul2FG_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "classifier", 
    	    "Actions-CompleteActions-ReadIsClassifiedObjectAction-classifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-ReadIsClassifiedObjectAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-CompleteActions-ReadIsClassifiedObjectAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StartClassifierBehaviorAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-StartClassifierBehaviorAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-CompleteActions-StartClassifierBehaviorAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // QualifierValue
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-QualifierValue").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "qualifier", 
    	    "Actions-CompleteActions-QualifierValue-qualifier",
    	    "Classes-AssociationClasses-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Actions-CompleteActions-QualifierValue-value",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LinkEndData
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-LinkEndData").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "qualifier", 
    	    "Actions-CompleteActions-LinkEndData-qualifier",
    	    "Actions-CompleteActions-QualifierValue",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReadLinkObjectEndAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadLinkObjectEndAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-CompleteActions-ReadLinkObjectEndAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "end", 
    	    "Actions-CompleteActions-ReadLinkObjectEndAction-end",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-ReadLinkObjectEndAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReadLinkObjectEndQualifierAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadLinkObjectEndQualifierAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "qualifier", 
    	    "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-qualifier",
    	    "Classes-AssociationClasses-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CreateLinkObjectAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-CreateLinkObjectAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-CreateLinkObjectAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // AcceptEventAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-AcceptEventAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isUnmarshall", 
    	    "Actions-CompleteActions-AcceptEventAction-isUnmarshall",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_Pul2F2_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-AcceptEventAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "trigger", 
    	    "Actions-CompleteActions-AcceptEventAction-trigger",
    	    "CommonBehaviors-Communications-Trigger",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // AcceptCallAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-AcceptCallAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "returnInformation", 
    	    "Actions-CompleteActions-AcceptCallAction-returnInformation",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReplyAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReplyAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "replyToCall", 
    	    "Actions-CompleteActions-ReplyAction-replyToCall",
    	    "CommonBehaviors-Communications-Trigger",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "returnInformation", 
    	    "Actions-CompleteActions-ReplyAction-returnInformation",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "replyValue", 
    	    "Actions-CompleteActions-ReplyAction-replyValue",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // UnmarshallAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-UnmarshallAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-UnmarshallAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "unmarshallType", 
    	    "Actions-CompleteActions-UnmarshallAction-unmarshallType",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-CompleteActions-UnmarshallAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReduceAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReduceAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "reducer", 
    	    "Actions-CompleteActions-ReduceAction-reducer",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-ReduceAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "collection", 
    	    "Actions-CompleteActions-ReduceAction-collection",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isOrdered", 
    	    "Actions-CompleteActions-ReduceAction-isOrdered",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PuvnE2_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	
        // StartObjectBehaviorAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-StartObjectBehaviorAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-CompleteActions-StartObjectBehaviorAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CreateObjectAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-CreateObjectAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "classifier", 
    	    "Actions-IntermediateActions-CreateObjectAction-classifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-CreateObjectAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DestroyObjectAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-DestroyObjectAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isDestroyLinks", 
    	    "Actions-IntermediateActions-DestroyObjectAction-isDestroyLinks",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PuvnOW_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isDestroyOwnedObjects", 
    	    "Actions-IntermediateActions-DestroyObjectAction-isDestroyOwnedObjects",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PuvnOm_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "target", 
    	    "Actions-IntermediateActions-DestroyObjectAction-target",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TestIdentityAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-TestIdentityAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "first", 
    	    "Actions-IntermediateActions-TestIdentityAction-first",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "second", 
    	    "Actions-IntermediateActions-TestIdentityAction-second",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-TestIdentityAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReadSelfAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ReadSelfAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-ReadSelfAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-StructuralFeatureAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "structuralFeature", 
    	    "Actions-IntermediateActions-StructuralFeatureAction-structuralFeature",
    	    "Classes-Kernel-StructuralFeature",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-IntermediateActions-StructuralFeatureAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReadStructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ReadStructuralFeatureAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-ReadStructuralFeatureAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // WriteStructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-WriteStructuralFeatureAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Actions-IntermediateActions-WriteStructuralFeatureAction-value",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-WriteStructuralFeatureAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ClearStructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ClearStructuralFeatureAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-ClearStructuralFeatureAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // RemoveStructuralFeatureValueAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-RemoveStructuralFeatureValueAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isRemoveDuplicates", 
    	    "Actions-IntermediateActions-RemoveStructuralFeatureValueAction-isRemoveDuplicates",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_Pu4xAm_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "removeAt", 
    	    "Actions-IntermediateActions-RemoveStructuralFeatureValueAction-removeAt",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // AddStructuralFeatureValueAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-AddStructuralFeatureValueAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isReplaceAll", 
    	    "Actions-IntermediateActions-AddStructuralFeatureValueAction-isReplaceAll",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_Pu4xBG_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "insertAt", 
    	    "Actions-IntermediateActions-AddStructuralFeatureValueAction-insertAt",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "endData", 
    	    "Actions-IntermediateActions-LinkAction-endData",
    	    "Actions-IntermediateActions-LinkEndData",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "2");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inputValue", 
    	    "Actions-IntermediateActions-LinkAction-inputValue",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LinkEndData
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkEndData").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Actions-IntermediateActions-LinkEndData-value",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "end", 
    	    "Actions-IntermediateActions-LinkEndData-end",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReadLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ReadLinkAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-ReadLinkAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LinkEndCreationData
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkEndCreationData").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isReplaceAll", 
    	    "Actions-IntermediateActions-LinkEndCreationData-isReplaceAll",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_Pu4xCm_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "insertAt", 
    	    "Actions-IntermediateActions-LinkEndCreationData-insertAt",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CreateLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-CreateLinkAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "endData", 
    	    "Actions-IntermediateActions-CreateLinkAction-endData",
    	    "Actions-IntermediateActions-LinkEndCreationData",
    	    "Actions-IntermediateActions-LinkAction-endData",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "2");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DestroyLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-DestroyLinkAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "endData", 
    	    "Actions-IntermediateActions-DestroyLinkAction-endData",
    	    "Actions-IntermediateActions-LinkEndDestructionData",
    	    "Actions-IntermediateActions-LinkAction-endData",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "2");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // WriteLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-WriteLinkAction").getDelegate();
    	
        // ClearAssociationAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ClearAssociationAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-IntermediateActions-ClearAssociationAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "association", 
    	    "Actions-IntermediateActions-ClearAssociationAction-association",
    	    "Classes-Kernel-Association",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // BroadcastSignalAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-BroadcastSignalAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "signal", 
    	    "Actions-IntermediateActions-BroadcastSignalAction-signal",
    	    "CommonBehaviors-Communications-Signal",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // SendObjectAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-SendObjectAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "target", 
    	    "Actions-IntermediateActions-SendObjectAction-target",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "request", 
    	    "Actions-IntermediateActions-SendObjectAction-request",
    	    "Actions-BasicActions-InputPin",
    	    "Actions-BasicActions-InvocationAction-argument",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LinkEndDestructionData
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkEndDestructionData").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isDestroyDuplicates", 
    	    "Actions-IntermediateActions-LinkEndDestructionData-isDestroyDuplicates",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_Pu4xEG_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "destroyAt", 
    	    "Actions-IntermediateActions-LinkEndDestructionData-destroyAt",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ValueSpecificationAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ValueSpecificationAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Actions-IntermediateActions-ValueSpecificationAction-value",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-ValueSpecificationAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // OpaqueAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-OpaqueAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "body", 
    	    "Actions-BasicActions-OpaqueAction-body",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "language", 
    	    "Actions-BasicActions-OpaqueAction-language",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inputValue", 
    	    "Actions-BasicActions-OpaqueAction-inputValue",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "outputValue", 
    	    "Actions-BasicActions-OpaqueAction-outputValue",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Pin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-Pin").getDelegate();
    	
        // ValuePin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-ValuePin").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Actions-BasicActions-ValuePin-value",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // OutputPin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-OutputPin").getDelegate();
    	
        // InputPin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-InputPin").getDelegate();
    	
        // InvocationAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-InvocationAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "argument", 
    	    "Actions-BasicActions-InvocationAction-argument",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CallAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-CallAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isSynchronous", 
    	    "Actions-BasicActions-CallAction-isSynchronous",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("true"),
    	   "",
    	   "_PvCiKm_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-BasicActions-CallAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // SendSignalAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-SendSignalAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "target", 
    	    "Actions-BasicActions-SendSignalAction-target",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "signal", 
    	    "Actions-BasicActions-SendSignalAction-signal",
    	    "CommonBehaviors-Communications-Signal",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CallOperationAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-CallOperationAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "operation", 
    	    "Actions-BasicActions-CallOperationAction-operation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "target", 
    	    "Actions-BasicActions-CallOperationAction-target",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CallBehaviorAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-CallBehaviorAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "behavior", 
    	    "Actions-BasicActions-CallBehaviorAction-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Action
    	clss  = (Class_)model.getElementById("Actions-BasicActions-Action").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "output", 
    	    "Actions-BasicActions-Action-output",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "input", 
    	    "Actions-BasicActions-Action-input",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "context", 
    	    "Actions-BasicActions-Action-context",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // MultiplicityElement
    	clss  = (Class_)model.getElementById("Actions-BasicActions-MultiplicityElement").getDelegate();
    	
        // VariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-VariableAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "variable", 
    	    "Actions-StructuredActions-VariableAction-variable",
    	    "Activities-StructuredActivities-Variable",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReadVariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-ReadVariableAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-StructuredActions-ReadVariableAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // WriteVariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-WriteVariableAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Actions-StructuredActions-WriteVariableAction-value",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ClearVariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-ClearVariableAction").getDelegate();
    	
        // AddVariableValueAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-AddVariableValueAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isReplaceAll", 
    	    "Actions-StructuredActions-AddVariableValueAction-isReplaceAll",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvMTEW_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "insertAt", 
    	    "Actions-StructuredActions-AddVariableValueAction-insertAt",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // RemoveVariableValueAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-RemoveVariableValueAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isRemoveDuplicates", 
    	    "Actions-StructuredActions-RemoveVariableValueAction-isRemoveDuplicates",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvMTE2_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "removeAt", 
    	    "Actions-StructuredActions-RemoveVariableValueAction-removeAt",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // RaiseExceptionAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-RaiseExceptionAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "exception", 
    	    "Actions-StructuredActions-RaiseExceptionAction-exception",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActionInputPin
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-ActionInputPin").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "fromAction", 
    	    "Actions-StructuredActions-ActionInputPin-fromAction",
    	    "Actions-BasicActions-Action",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ObjectNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ObjectNode").getDelegate();
    	
        // ControlNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ControlNode").getDelegate();
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityEdge").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "activity", 
    	    "Activities-BasicActivities-ActivityEdge-activity",
    	    "Activities-BasicActivities-Activity",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "source", 
    	    "Activities-BasicActivities-ActivityEdge-source",
    	    "Activities-BasicActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "target", 
    	    "Activities-BasicActivities-ActivityEdge-target",
    	    "Activities-BasicActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inGroup", 
    	    "Activities-BasicActivities-ActivityEdge-inGroup",
    	    "Activities-BasicActivities-ActivityGroup",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedEdge", 
    	    "Activities-BasicActivities-ActivityEdge-redefinedEdge",
    	    "Activities-BasicActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ControlFlow
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ControlFlow").getDelegate();
    	
        // ObjectFlow
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ObjectFlow").getDelegate();
    	
        // InitialNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-InitialNode").getDelegate();
    	
        // ActivityFinalNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityFinalNode").getDelegate();
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityGroup").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "containedEdge", 
    	    "Activities-BasicActivities-ActivityGroup-containedEdge",
    	    "Activities-BasicActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityParameterNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityParameterNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "parameter", 
    	    "Activities-BasicActivities-ActivityParameterNode-parameter",
    	    "Classes-Kernel-Parameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "outgoing", 
    	    "Activities-BasicActivities-ActivityNode-outgoing",
    	    "Activities-BasicActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "incoming", 
    	    "Activities-BasicActivities-ActivityNode-incoming",
    	    "Activities-BasicActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedNode", 
    	    "Activities-BasicActivities-ActivityNode-redefinedNode",
    	    "Activities-BasicActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Pin
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-Pin").getDelegate();
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-Activity").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isReadOnly", 
    	    "Activities-BasicActivities-Activity-isReadOnly",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvVc9m_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "edge", 
    	    "Activities-BasicActivities-Activity-edge",
    	    "Activities-BasicActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ValuePin
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ValuePin").getDelegate();
    	
        // ForkNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ForkNode").getDelegate();
    	
        // FlowFinalNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-FlowFinalNode").getDelegate();
    	
        // CentralBufferNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-CentralBufferNode").getDelegate();
    	
        // ActivityPartition
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityPartition").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isDimension", 
    	    "Activities-IntermediateActivities-ActivityPartition-isDimension",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvVc_2_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isExternal", 
    	    "Activities-IntermediateActivities-ActivityPartition-isExternal",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvVdAG_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "edge", 
    	    "Activities-IntermediateActivities-ActivityPartition-edge",
    	    "Activities-IntermediateActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "node", 
    	    "Activities-IntermediateActivities-ActivityPartition-node",
    	    "Activities-IntermediateActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "subpartition", 
    	    "Activities-IntermediateActivities-ActivityPartition-subpartition",
    	    "Activities-IntermediateActivities-ActivityPartition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "superPartition", 
    	    "Activities-IntermediateActivities-ActivityPartition-superPartition",
    	    "Activities-IntermediateActivities-ActivityPartition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "represents", 
    	    "Activities-IntermediateActivities-ActivityPartition-represents",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityEdge").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "inPartition", 
    	    "Activities-IntermediateActivities-ActivityEdge-inPartition",
    	    "Activities-IntermediateActivities-ActivityPartition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "guard", 
    	    "Activities-IntermediateActivities-ActivityEdge-guard",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inGroup", 
    	    "Activities-IntermediateActivities-ActivityEdge-inGroup",
    	    "Activities-IntermediateActivities-ActivityGroup",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "inPartition", 
    	    "Activities-IntermediateActivities-ActivityNode-inPartition",
    	    "Activities-IntermediateActivities-ActivityPartition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inGroup", 
    	    "Activities-IntermediateActivities-ActivityNode-inGroup",
    	    "Activities-IntermediateActivities-ActivityGroup",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // MergeNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-MergeNode").getDelegate();
    	
        // DecisionNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-DecisionNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "decisionInput", 
    	    "Activities-IntermediateActivities-DecisionNode-decisionInput",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "decisionInputFlow", 
    	    "Activities-IntermediateActivities-DecisionNode-decisionInputFlow",
    	    "Activities-BasicActivities-ObjectFlow",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // FinalNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-FinalNode").getDelegate();
    	
        // ActivityFinalNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityFinalNode").getDelegate();
    	
        // JoinNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-JoinNode").getDelegate();
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityGroup").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "containedNode", 
    	    "Activities-IntermediateActivities-ActivityGroup-containedNode",
    	    "Activities-IntermediateActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "containedEdge", 
    	    "Activities-IntermediateActivities-ActivityGroup-containedEdge",
    	    "Activities-IntermediateActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inActivity", 
    	    "Activities-IntermediateActivities-ActivityGroup-inActivity",
    	    "Activities-IntermediateActivities-Activity",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-Activity").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "partition", 
    	    "Activities-IntermediateActivities-Activity-partition",
    	    "Activities-IntermediateActivities-ActivityPartition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "group", 
    	    "Activities-IntermediateActivities-Activity-group",
    	    "Activities-IntermediateActivities-ActivityGroup",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // JoinNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-JoinNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isCombineDuplicate", 
    	    "Activities-CompleteActivities-JoinNode-isCombineDuplicate",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("true"),
    	   "",
    	   "_PvVdI2_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "joinSpec", 
    	    "Activities-CompleteActivities-JoinNode-joinSpec",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DataStoreNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-DataStoreNode").getDelegate();
    	
        // ObjectFlow
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ObjectFlow").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isMulticast", 
    	    "Activities-CompleteActivities-ObjectFlow-isMulticast",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvfN8G_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isMultireceive", 
    	    "Activities-CompleteActivities-ObjectFlow-isMultireceive",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvfN8W_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "transformation", 
    	    "Activities-CompleteActivities-ObjectFlow-transformation",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "selection", 
    	    "Activities-CompleteActivities-ObjectFlow-selection",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ActivityEdge").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "weight", 
    	    "Activities-CompleteActivities-ActivityEdge-weight",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "interrupts", 
    	    "Activities-CompleteActivities-ActivityEdge-interrupts",
    	    "Activities-CompleteActivities-InterruptibleActivityRegion",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ObjectNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ObjectNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ordering", 
    	    "Activities-CompleteActivities-ObjectNode-ordering",
    	    "Activities-CompleteActivities-ObjectNodeOrderingKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("FIFO"),
    	   "",
    	   "_PvfN9W_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isControlType", 
    	    "Activities-CompleteActivities-ObjectNode-isControlType",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvfN9m_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "upperBound", 
    	    "Activities-CompleteActivities-ObjectNode-upperBound",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inState", 
    	    "Activities-CompleteActivities-ObjectNode-inState",
    	    "StateMachines-BehaviorStateMachines-State",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "selection", 
    	    "Activities-CompleteActivities-ObjectNode-selection",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ParameterSet
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ParameterSet").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "parameter", 
    	    "Activities-CompleteActivities-ParameterSet-parameter",
    	    "Activities-CompleteActivities-Parameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "condition", 
    	    "Activities-CompleteActivities-ParameterSet-condition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Activity").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isSingleExecution", 
    	    "Activities-CompleteActivities-Activity-isSingleExecution",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvfN_W_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	
        // Parameter
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Parameter").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isException", 
    	    "Activities-CompleteActivities-Parameter-isException",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvfN_m_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isStream", 
    	    "Activities-CompleteActivities-Parameter-isStream",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvfN_2_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "effect", 
    	    "Activities-CompleteActivities-Parameter-effect",
    	    "Activities-CompleteActivities-ParameterEffectKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "parameterSet", 
    	    "Activities-CompleteActivities-Parameter-parameterSet",
    	    "Activities-CompleteActivities-ParameterSet",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Action
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Action").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "localPrecondition", 
    	    "Activities-CompleteActivities-Action-localPrecondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "localPostcondition", 
    	    "Activities-CompleteActivities-Action-localPostcondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InterruptibleActivityRegion
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-InterruptibleActivityRegion").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "interruptingEdge", 
    	    "Activities-CompleteActivities-InterruptibleActivityRegion-interruptingEdge",
    	    "Activities-CompleteActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "node", 
    	    "Activities-CompleteActivities-InterruptibleActivityRegion-node",
    	    "Activities-CompleteActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ActivityNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "inInterruptibleRegion", 
    	    "Activities-CompleteActivities-ActivityNode-inInterruptibleRegion",
    	    "Activities-CompleteActivities-InterruptibleActivityRegion",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inGroup", 
    	    "Activities-CompleteActivities-ActivityNode-inGroup",
    	    "Activities-CompleteActivities-ActivityGroup",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-BehavioralFeature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedParameterSet", 
    	    "Activities-CompleteActivities-BehavioralFeature-ownedParameterSet",
    	    "Activities-CompleteActivities-ParameterSet",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Behavior
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Behavior").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedParameterSet", 
    	    "Activities-CompleteActivities-Behavior-ownedParameterSet",
    	    "Activities-CompleteActivities-ParameterSet",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Pin
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Pin").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isControl", 
    	    "Activities-CompleteActivities-Pin-isControl",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvfOE2_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ActivityGroup").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "containedNode", 
    	    "Activities-CompleteActivities-ActivityGroup-containedNode",
    	    "Activities-CompleteActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Variable
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Variable").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "scope", 
    	    "Activities-StructuredActivities-Variable-scope",
    	    "Activities-StructuredActivities-StructuredActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "activityScope", 
    	    "Activities-StructuredActivities-Variable-activityScope",
    	    "Activities-StructuredActivities-Activity",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StructuredActivityNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-StructuredActivityNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "variable", 
    	    "Activities-StructuredActivities-StructuredActivityNode-variable",
    	    "Activities-StructuredActivities-Variable",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "node", 
    	    "Activities-StructuredActivities-StructuredActivityNode-node",
    	    "Activities-StructuredActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "activity", 
    	    "Activities-StructuredActivities-StructuredActivityNode-activity",
    	    "Activities-StructuredActivities-Activity",
    	    "Activities-StructuredActivities-ActivityNode-activity Activities-StructuredActivities-ActivityGroup-inActivity",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConditionalNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ConditionalNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isDeterminate", 
    	    "Activities-StructuredActivities-ConditionalNode-isDeterminate",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvoX42_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isAssured", 
    	    "Activities-StructuredActivities-ConditionalNode-isAssured",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvoX5G_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "clause", 
    	    "Activities-StructuredActivities-ConditionalNode-clause",
    	    "Activities-StructuredActivities-Clause",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LoopNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-LoopNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isTestedFirst", 
    	    "Activities-StructuredActivities-LoopNode-isTestedFirst",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvoX5m_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "bodyPart", 
    	    "Activities-StructuredActivities-LoopNode-bodyPart",
    	    "Activities-StructuredActivities-ExecutableNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "setupPart", 
    	    "Activities-StructuredActivities-LoopNode-setupPart",
    	    "Activities-StructuredActivities-ExecutableNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "decider", 
    	    "Activities-StructuredActivities-LoopNode-decider",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "test", 
    	    "Activities-StructuredActivities-LoopNode-test",
    	    "Activities-StructuredActivities-ExecutableNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Clause
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Clause").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "test", 
    	    "Activities-StructuredActivities-Clause-test",
    	    "Activities-StructuredActivities-ExecutableNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "body", 
    	    "Activities-StructuredActivities-Clause-body",
    	    "Activities-StructuredActivities-ExecutableNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "predecessorClause", 
    	    "Activities-StructuredActivities-Clause-predecessorClause",
    	    "Activities-StructuredActivities-Clause",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "successorClause", 
    	    "Activities-StructuredActivities-Clause-successorClause",
    	    "Activities-StructuredActivities-Clause",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "decider", 
    	    "Activities-StructuredActivities-Clause-decider",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Activity").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "structuredNode", 
    	    "Activities-StructuredActivities-Activity-structuredNode",
    	    "Activities-StructuredActivities-StructuredActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "variable", 
    	    "Activities-StructuredActivities-Activity-variable",
    	    "Activities-StructuredActivities-Variable",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "group", 
    	    "Activities-StructuredActivities-Activity-group",
    	    "Activities-StructuredActivities-ActivityGroup",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "node", 
    	    "Activities-StructuredActivities-Activity-node",
    	    "Activities-StructuredActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ActivityNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "inStructuredNode", 
    	    "Activities-StructuredActivities-ActivityNode-inStructuredNode",
    	    "Activities-StructuredActivities-StructuredActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inGroup", 
    	    "Activities-StructuredActivities-ActivityNode-inGroup",
    	    "Activities-StructuredActivities-ActivityGroup",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "activity", 
    	    "Activities-StructuredActivities-ActivityNode-activity",
    	    "Activities-StructuredActivities-Activity",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ExecutableNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ExecutableNode").getDelegate();
    	
        // SequenceNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-SequenceNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "executableNode", 
    	    "Activities-StructuredActivities-SequenceNode-executableNode",
    	    "Activities-StructuredActivities-ExecutableNode",
    	    "Activities-StructuredActivities-StructuredActivityNode-node",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Action
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Action").getDelegate();
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ActivityGroup").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "containedNode", 
    	    "Activities-StructuredActivities-ActivityGroup-containedNode",
    	    "Activities-StructuredActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inActivity", 
    	    "Activities-StructuredActivities-ActivityGroup-inActivity",
    	    "Activities-StructuredActivities-Activity",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InputPin
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-InputPin").getDelegate();
    	
        // OutputPin
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-OutputPin").getDelegate();
    	
        // ExpansionNode
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExpansionNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "regionAsOutput", 
    	    "Activities-ExtraStructuredActivities-ExpansionNode-regionAsOutput",
    	    "Activities-ExtraStructuredActivities-ExpansionRegion",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "regionAsInput", 
    	    "Activities-ExtraStructuredActivities-ExpansionNode-regionAsInput",
    	    "Activities-ExtraStructuredActivities-ExpansionRegion",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ExpansionRegion
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExpansionRegion").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "mode", 
    	    "Activities-ExtraStructuredActivities-ExpansionRegion-mode",
    	    "Activities-ExtraStructuredActivities-ExpansionKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("iterative"),
    	   "",
    	   "_PvoYEG_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "outputElement", 
    	    "Activities-ExtraStructuredActivities-ExpansionRegion-outputElement",
    	    "Activities-ExtraStructuredActivities-ExpansionNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inputElement", 
    	    "Activities-ExtraStructuredActivities-ExpansionRegion-inputElement",
    	    "Activities-ExtraStructuredActivities-ExpansionNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ExecutableNode
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExecutableNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "handler", 
    	    "Activities-ExtraStructuredActivities-ExecutableNode-handler",
    	    "Activities-ExtraStructuredActivities-ExceptionHandler",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ExceptionHandler
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExceptionHandler").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "protectedNode", 
    	    "Activities-ExtraStructuredActivities-ExceptionHandler-protectedNode",
    	    "Activities-ExtraStructuredActivities-ExecutableNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "handlerBody", 
    	    "Activities-ExtraStructuredActivities-ExceptionHandler-handlerBody",
    	    "Activities-ExtraStructuredActivities-ExecutableNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "exceptionInput", 
    	    "Activities-ExtraStructuredActivities-ExceptionHandler-exceptionInput",
    	    "Activities-BasicActivities-ObjectNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "exceptionType", 
    	    "Activities-ExtraStructuredActivities-ExceptionHandler-exceptionType",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConditionalNode
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-ConditionalNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Activities-CompleteStructuredActivities-ConditionalNode-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StructuredActivityNode
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-StructuredActivityNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "mustIsolate", 
    	    "Activities-CompleteStructuredActivities-StructuredActivityNode-mustIsolate",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PvyI4G_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "edge", 
    	    "Activities-CompleteStructuredActivities-StructuredActivityNode-edge",
    	    "Activities-CompleteStructuredActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LoopNode
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-LoopNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Activities-CompleteStructuredActivities-LoopNode-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "loopVariable", 
    	    "Activities-CompleteStructuredActivities-LoopNode-loopVariable",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "bodyOutput", 
    	    "Activities-CompleteStructuredActivities-LoopNode-bodyOutput",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "loopVariableInput", 
    	    "Activities-CompleteStructuredActivities-LoopNode-loopVariableInput",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Clause
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-Clause").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "bodyOutput", 
    	    "Activities-CompleteStructuredActivities-Clause-bodyOutput",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-ActivityEdge").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "inStructuredNode", 
    	    "Activities-CompleteStructuredActivities-ActivityEdge-inStructuredNode",
    	    "Activities-CompleteStructuredActivities-StructuredActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inGroup", 
    	    "Activities-CompleteStructuredActivities-ActivityEdge-inGroup",
    	    "Activities-CompleteStructuredActivities-ActivityGroup",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-ActivityGroup").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "containedEdge", 
    	    "Activities-CompleteStructuredActivities-ActivityGroup-containedEdge",
    	    "Activities-CompleteStructuredActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-Activity").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "node", 
    	    "Activities-FundamentalActivities-Activity-node",
    	    "Activities-FundamentalActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "group", 
    	    "Activities-FundamentalActivities-Activity-group",
    	    "Activities-FundamentalActivities-ActivityGroup",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-ActivityGroup").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "containedNode", 
    	    "Activities-FundamentalActivities-ActivityGroup-containedNode",
    	    "Activities-FundamentalActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inActivity", 
    	    "Activities-FundamentalActivities-ActivityGroup-inActivity",
    	    "Activities-FundamentalActivities-Activity",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "subgroup", 
    	    "Activities-FundamentalActivities-ActivityGroup-subgroup",
    	    "Activities-FundamentalActivities-ActivityGroup",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "superGroup", 
    	    "Activities-FundamentalActivities-ActivityGroup-superGroup",
    	    "Activities-FundamentalActivities-ActivityGroup",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Action
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-Action").getDelegate();
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-ActivityNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "activity", 
    	    "Activities-FundamentalActivities-ActivityNode-activity",
    	    "Activities-FundamentalActivities-Activity",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inGroup", 
    	    "Activities-FundamentalActivities-ActivityNode-inGroup",
    	    "Activities-FundamentalActivities-ActivityGroup",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ExtensionEnd
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Profiles-ExtensionEnd").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "lower", 
    	    "AuxiliaryConstructs-Profiles-ExtensionEnd-lower",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Integer",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("0"),
    	   "",
    	   "_PvyJCG_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	
        // InformationItem
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-InformationFlows-InformationItem").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "represented", 
    	    "AuxiliaryConstructs-InformationFlows-InformationItem-represented",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InformationFlow
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-InformationFlows-InformationFlow").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "realization", 
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow-realization",
    	    "Classes-Kernel-Relationship",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "conveyed", 
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow-conveyed",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "informationSource", 
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow-informationSource",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "informationTarget", 
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow-informationTarget",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "realizingActivityEdge", 
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingActivityEdge",
    	    "Activities-BasicActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "realizingConnector", 
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingConnector",
    	    "CompositeStructures-InternalStructures-Connector",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "realizingMessage", 
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingMessage",
    	    "Interactions-BasicInteractions-Message",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Model
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Models-Model").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "viewpoint", 
    	    "AuxiliaryConstructs-Models-Model-viewpoint",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TemplateSignature
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateSignature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "parameter", 
    	    "AuxiliaryConstructs-Templates-TemplateSignature-parameter",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedParameter", 
    	    "AuxiliaryConstructs-Templates-TemplateSignature-ownedParameter",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "template", 
    	    "AuxiliaryConstructs-Templates-TemplateSignature-template",
    	    "AuxiliaryConstructs-Templates-TemplateableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // NamedElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-NamedElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "nameExpression", 
    	    "AuxiliaryConstructs-Templates-NamedElement-nameExpression",
    	    "AuxiliaryConstructs-Templates-StringExpression",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateParameter").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "signature", 
    	    "AuxiliaryConstructs-Templates-TemplateParameter-signature",
    	    "AuxiliaryConstructs-Templates-TemplateSignature",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "parameteredElement", 
    	    "AuxiliaryConstructs-Templates-TemplateParameter-parameteredElement",
    	    "AuxiliaryConstructs-Templates-ParameterableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedParameteredElement", 
    	    "AuxiliaryConstructs-Templates-TemplateParameter-ownedParameteredElement",
    	    "AuxiliaryConstructs-Templates-ParameterableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "default", 
    	    "AuxiliaryConstructs-Templates-TemplateParameter-default",
    	    "AuxiliaryConstructs-Templates-ParameterableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedDefault", 
    	    "AuxiliaryConstructs-Templates-TemplateParameter-ownedDefault",
    	    "AuxiliaryConstructs-Templates-ParameterableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StringExpression
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-StringExpression").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "subExpression", 
    	    "AuxiliaryConstructs-Templates-StringExpression-subExpression",
    	    "AuxiliaryConstructs-Templates-StringExpression",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "owningExpression", 
    	    "AuxiliaryConstructs-Templates-StringExpression-owningExpression",
    	    "AuxiliaryConstructs-Templates-StringExpression",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TemplateBinding
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateBinding").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "boundElement", 
    	    "AuxiliaryConstructs-Templates-TemplateBinding-boundElement",
    	    "AuxiliaryConstructs-Templates-TemplateableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "signature", 
    	    "AuxiliaryConstructs-Templates-TemplateBinding-signature",
    	    "AuxiliaryConstructs-Templates-TemplateSignature",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "parameterSubstitution", 
    	    "AuxiliaryConstructs-Templates-TemplateBinding-parameterSubstitution",
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TemplateParameterSubstitution
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateParameterSubstitution").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "formal", 
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-formal",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "templateBinding", 
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-templateBinding",
    	    "AuxiliaryConstructs-Templates-TemplateBinding",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "actual", 
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-actual",
    	    "AuxiliaryConstructs-Templates-ParameterableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedActual", 
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-ownedActual",
    	    "AuxiliaryConstructs-Templates-ParameterableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TemplateableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateableElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "templateBinding", 
    	    "AuxiliaryConstructs-Templates-TemplateableElement-templateBinding",
    	    "AuxiliaryConstructs-Templates-TemplateBinding",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedTemplateSignature", 
    	    "AuxiliaryConstructs-Templates-TemplateableElement-ownedTemplateSignature",
    	    "AuxiliaryConstructs-Templates-TemplateSignature",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ParameterableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ParameterableElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "templateParameter", 
    	    "AuxiliaryConstructs-Templates-ParameterableElement-templateParameter",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "owningTemplateParameter", 
    	    "AuxiliaryConstructs-Templates-ParameterableElement-owningTemplateParameter",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Property
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Property").getDelegate();
    	
        // ValueSpecification
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ValueSpecification").getDelegate();
    	
        // Operation
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Operation").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "templateParameter", 
    	    "AuxiliaryConstructs-Templates-Operation-templateParameter",
    	    "AuxiliaryConstructs-Templates-OperationTemplateParameter",
    	    "AuxiliaryConstructs-Templates-ParameterableElement-templateParameter",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // OperationTemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-OperationTemplateParameter").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "parameteredElement", 
    	    "AuxiliaryConstructs-Templates-OperationTemplateParameter-parameteredElement",
    	    "AuxiliaryConstructs-Templates-Operation",
    	    "AuxiliaryConstructs-Templates-TemplateParameter-parameteredElement",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // PackageableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-PackageableElement").getDelegate();
    	
        // Classifier
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Classifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedTemplateSignature", 
    	    "AuxiliaryConstructs-Templates-Classifier-ownedTemplateSignature",
    	    "AuxiliaryConstructs-Templates-RedefinableTemplateSignature",
    	    "AuxiliaryConstructs-Templates-TemplateableElement-ownedTemplateSignature",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "templateParameter", 
    	    "AuxiliaryConstructs-Templates-Classifier-templateParameter",
    	    "AuxiliaryConstructs-Templates-ClassifierTemplateParameter",
    	    "AuxiliaryConstructs-Templates-ParameterableElement-templateParameter",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ClassifierTemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ClassifierTemplateParameter").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "allowSubstitutable", 
    	    "AuxiliaryConstructs-Templates-ClassifierTemplateParameter-allowSubstitutable",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("true"),
    	   "",
    	   "_Pv75_m_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "parameteredElement", 
    	    "AuxiliaryConstructs-Templates-ClassifierTemplateParameter-parameteredElement",
    	    "AuxiliaryConstructs-Templates-Classifier",
    	    "AuxiliaryConstructs-Templates-TemplateParameter-parameteredElement",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "constrainingClassifier", 
    	    "AuxiliaryConstructs-Templates-ClassifierTemplateParameter-constrainingClassifier",
    	    "AuxiliaryConstructs-Templates-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // RedefinableTemplateSignature
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-RedefinableTemplateSignature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "classifier", 
    	    "AuxiliaryConstructs-Templates-RedefinableTemplateSignature-classifier",
    	    "AuxiliaryConstructs-Templates-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "extendedSignature", 
    	    "AuxiliaryConstructs-Templates-RedefinableTemplateSignature-extendedSignature",
    	    "AuxiliaryConstructs-Templates-RedefinableTemplateSignature",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inheritedParameter", 
    	    "AuxiliaryConstructs-Templates-RedefinableTemplateSignature-inheritedParameter",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConnectableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ConnectableElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "templateParameter", 
    	    "AuxiliaryConstructs-Templates-ConnectableElement-templateParameter",
    	    "AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter",
    	    "AuxiliaryConstructs-Templates-ParameterableElement-templateParameter",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConnectableElementTemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "parameteredElement", 
    	    "AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter-parameteredElement",
    	    "AuxiliaryConstructs-Templates-ConnectableElement",
    	    "AuxiliaryConstructs-Templates-TemplateParameter-parameteredElement",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Package
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Package").getDelegate();
    	
        // Element
    	clss  = (Class_)model.getElementById("Classes-Kernel-Element").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedElement", 
    	    "Classes-Kernel-Element-ownedElement",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "owner", 
    	    "Classes-Kernel-Element-owner",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedComment", 
    	    "Classes-Kernel-Element-ownedComment",
    	    "Classes-Kernel-Comment",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Comment
    	clss  = (Class_)model.getElementById("Classes-Kernel-Comment").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "body", 
    	    "Classes-Kernel-Comment-body",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "annotatedElement", 
    	    "Classes-Kernel-Comment-annotatedElement",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DirectedRelationship
    	clss  = (Class_)model.getElementById("Classes-Kernel-DirectedRelationship").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "source", 
    	    "Classes-Kernel-DirectedRelationship-source",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "target", 
    	    "Classes-Kernel-DirectedRelationship-target",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // NamedElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-NamedElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "name", 
    	    "Classes-Kernel-NamedElement-name",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "visibility", 
    	    "Classes-Kernel-NamedElement-visibility",
    	    "Classes-Kernel-VisibilityKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "qualifiedName", 
    	    "Classes-Kernel-NamedElement-qualifiedName",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "namespace", 
    	    "Classes-Kernel-NamedElement-namespace",
    	    "Classes-Kernel-Namespace",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // PackageableElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-PackageableElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "visibility", 
    	    "Classes-Kernel-PackageableElement-visibility",
    	    "Classes-Kernel-VisibilityKind",
    	    "Classes-Kernel-NamedElement-visibility",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("public"),
    	   "",
    	   "_PwFD9m_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	
        // OpaqueExpression
    	clss  = (Class_)model.getElementById("Classes-Kernel-OpaqueExpression").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "body", 
    	    "Classes-Kernel-OpaqueExpression-body",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "language", 
    	    "Classes-Kernel-OpaqueExpression-language",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LiteralSpecification
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralSpecification").getDelegate();
    	
        // LiteralInteger
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralInteger").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Classes-Kernel-LiteralInteger-value",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Integer",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("0"),
    	   "",
    	   "_PwFD-2_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	
        // LiteralString
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralString").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Classes-Kernel-LiteralString-value",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LiteralBoolean
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralBoolean").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Classes-Kernel-LiteralBoolean-value",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PwFD_W_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	
        // LiteralNull
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralNull").getDelegate();
    	
        // Constraint
    	clss  = (Class_)model.getElementById("Classes-Kernel-Constraint").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "constrainedElement", 
    	    "Classes-Kernel-Constraint-constrainedElement",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "specification", 
    	    "Classes-Kernel-Constraint-specification",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "context", 
    	    "Classes-Kernel-Constraint-context",
    	    "Classes-Kernel-Namespace",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ElementImport
    	clss  = (Class_)model.getElementById("Classes-Kernel-ElementImport").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "visibility", 
    	    "Classes-Kernel-ElementImport-visibility",
    	    "Classes-Kernel-VisibilityKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("public"),
    	   "",
    	   "_PwFEAW_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "alias", 
    	    "Classes-Kernel-ElementImport-alias",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "importedElement", 
    	    "Classes-Kernel-ElementImport-importedElement",
    	    "Classes-Kernel-PackageableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "importingNamespace", 
    	    "Classes-Kernel-ElementImport-importingNamespace",
    	    "Classes-Kernel-Namespace",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // MultiplicityElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-MultiplicityElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isOrdered", 
    	    "Classes-Kernel-MultiplicityElement-isOrdered",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PwFEA2_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isUnique", 
    	    "Classes-Kernel-MultiplicityElement-isUnique",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("true"),
    	   "",
    	   "_PwFEBG_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "upper", 
    	    "Classes-Kernel-MultiplicityElement-upper",
    	    "Infrastructure.uml#Core-PrimitiveTypes-UnlimitedNatural",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("1"),
    	   "",
    	   "_PwFEBm_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "lower", 
    	    "Classes-Kernel-MultiplicityElement-lower",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Integer",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("1"),
    	   "",
    	   "_PwFECG_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "upperValue", 
    	    "Classes-Kernel-MultiplicityElement-upperValue",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "lowerValue", 
    	    "Classes-Kernel-MultiplicityElement-lowerValue",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TypedElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-TypedElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "type", 
    	    "Classes-Kernel-TypedElement-type",
    	    "Classes-Kernel-Type",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Classifier
    	clss  = (Class_)model.getElementById("Classes-Kernel-Classifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isAbstract", 
    	    "Classes-Kernel-Classifier-isAbstract",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PwFEDG_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "generalization", 
    	    "Classes-Kernel-Classifier-generalization",
    	    "Classes-Kernel-Generalization",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "feature", 
    	    "Classes-Kernel-Classifier-feature",
    	    "Classes-Kernel-Feature",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inheritedMember", 
    	    "Classes-Kernel-Classifier-inheritedMember",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "attribute", 
    	    "Classes-Kernel-Classifier-attribute",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedClassifier", 
    	    "Classes-Kernel-Classifier-redefinedClassifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "general", 
    	    "Classes-Kernel-Classifier-general",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Feature
    	clss  = (Class_)model.getElementById("Classes-Kernel-Feature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isStatic", 
    	    "Classes-Kernel-Feature-isStatic",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PwFEKW_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "featuringClassifier", 
    	    "Classes-Kernel-Feature-featuringClassifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // RedefinableElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-RedefinableElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isLeaf", 
    	    "Classes-Kernel-RedefinableElement-isLeaf",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PwFELG_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "redefinedElement", 
    	    "Classes-Kernel-RedefinableElement-redefinedElement",
    	    "Classes-Kernel-RedefinableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinitionContext", 
    	    "Classes-Kernel-RedefinableElement-redefinitionContext",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Generalization
    	clss  = (Class_)model.getElementById("Classes-Kernel-Generalization").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isSubstitutable", 
    	    "Classes-Kernel-Generalization-isSubstitutable",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("true"),
    	   "",
    	   "_PwO00W_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "specific", 
    	    "Classes-Kernel-Generalization-specific",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "general", 
    	    "Classes-Kernel-Generalization-general",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("Classes-Kernel-BehavioralFeature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedParameter", 
    	    "Classes-Kernel-BehavioralFeature-ownedParameter",
    	    "Classes-Kernel-Parameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "raisedException", 
    	    "Classes-Kernel-BehavioralFeature-raisedException",
    	    "Classes-Kernel-Type",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Parameter
    	clss  = (Class_)model.getElementById("Classes-Kernel-Parameter").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "direction", 
    	    "Classes-Kernel-Parameter-direction",
    	    "Classes-Kernel-ParameterDirectionKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("in"),
    	   "",
    	   "_PwO01m_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "default", 
    	    "Classes-Kernel-Parameter-default",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "defaultValue", 
    	    "Classes-Kernel-Parameter-defaultValue",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "operation", 
    	    "Classes-Kernel-Parameter-operation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StructuralFeature
    	clss  = (Class_)model.getElementById("Classes-Kernel-StructuralFeature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isReadOnly", 
    	    "Classes-Kernel-StructuralFeature-isReadOnly",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PwO02m_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	
        // InstanceSpecification
    	clss  = (Class_)model.getElementById("Classes-Kernel-InstanceSpecification").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "classifier", 
    	    "Classes-Kernel-InstanceSpecification-classifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "slot", 
    	    "Classes-Kernel-InstanceSpecification-slot",
    	    "Classes-Kernel-Slot",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "specification", 
    	    "Classes-Kernel-InstanceSpecification-specification",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Slot
    	clss  = (Class_)model.getElementById("Classes-Kernel-Slot").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "owningInstance", 
    	    "Classes-Kernel-Slot-owningInstance",
    	    "Classes-Kernel-InstanceSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "definingFeature", 
    	    "Classes-Kernel-Slot-definingFeature",
    	    "Classes-Kernel-StructuralFeature",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Classes-Kernel-Slot-value",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Package
    	clss  = (Class_)model.getElementById("Classes-Kernel-Package").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "packageMerge", 
    	    "Classes-Kernel-Package-packageMerge",
    	    "Classes-Kernel-PackageMerge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "packagedElement", 
    	    "Classes-Kernel-Package-packagedElement",
    	    "Classes-Kernel-PackageableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedType", 
    	    "Classes-Kernel-Package-ownedType",
    	    "Classes-Kernel-Type",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "nestedPackage", 
    	    "Classes-Kernel-Package-nestedPackage",
    	    "Classes-Kernel-Package",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "nestingPackage", 
    	    "Classes-Kernel-Package-nestingPackage",
    	    "Classes-Kernel-Package",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // PackageImport
    	clss  = (Class_)model.getElementById("Classes-Kernel-PackageImport").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "visibility", 
    	    "Classes-Kernel-PackageImport-visibility",
    	    "Classes-Kernel-VisibilityKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("public"),
    	   "",
    	   "_PwO07W_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "importingNamespace", 
    	    "Classes-Kernel-PackageImport-importingNamespace",
    	    "Classes-Kernel-Namespace",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "importedPackage", 
    	    "Classes-Kernel-PackageImport-importedPackage",
    	    "Classes-Kernel-Package",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Class
    	clss  = (Class_)model.getElementById("Classes-Kernel-Class").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isAbstract", 
    	    "Classes-Kernel-Class-isAbstract",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "Classes-Kernel-Classifier-isAbstract",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PwO07m_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "nestedClassifier", 
    	    "Classes-Kernel-Class-nestedClassifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedAttribute", 
    	    "Classes-Kernel-Class-ownedAttribute",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedOperation", 
    	    "Classes-Kernel-Class-ownedOperation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "superClass", 
    	    "Classes-Kernel-Class-superClass",
    	    "Classes-Kernel-Class",
    	    "Classes-Kernel-Classifier-general",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Property
    	clss  = (Class_)model.getElementById("Classes-Kernel-Property").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isDerived", 
    	    "Classes-Kernel-Property-isDerived",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PwO0-2_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isReadOnly", 
    	    "Classes-Kernel-Property-isReadOnly",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "Classes-Kernel-StructuralFeature-isReadOnly",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PwO0_G_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isDerivedUnion", 
    	    "Classes-Kernel-Property-isDerivedUnion",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PwO0_W_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "default", 
    	    "Classes-Kernel-Property-default",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "aggregation", 
    	    "Classes-Kernel-Property-aggregation",
    	    "Classes-Kernel-AggregationKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("none"),
    	   "",
    	   "_PwO0_2_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isComposite", 
    	    "Classes-Kernel-Property-isComposite",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "class", 
    	    "Classes-Kernel-Property-class",
    	    "Classes-Kernel-Class",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedProperty", 
    	    "Classes-Kernel-Property-redefinedProperty",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "owningAssociation", 
    	    "Classes-Kernel-Property-owningAssociation",
    	    "Classes-Kernel-Association",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "datatype", 
    	    "Classes-Kernel-Property-datatype",
    	    "Classes-Kernel-DataType",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "defaultValue", 
    	    "Classes-Kernel-Property-defaultValue",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "opposite", 
    	    "Classes-Kernel-Property-opposite",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "subsettedProperty", 
    	    "Classes-Kernel-Property-subsettedProperty",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "association", 
    	    "Classes-Kernel-Property-association",
    	    "Classes-Kernel-Association",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Operation
    	clss  = (Class_)model.getElementById("Classes-Kernel-Operation").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isQuery", 
    	    "Classes-Kernel-Operation-isQuery",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PwO1DG_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isOrdered", 
    	    "Classes-Kernel-Operation-isOrdered",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PwO1DW_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isUnique", 
    	    "Classes-Kernel-Operation-isUnique",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("true"),
    	   "",
    	   "_PwO1Dm_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "lower", 
    	    "Classes-Kernel-Operation-lower",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Integer",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("1"),
    	   "",
    	   "_PwO1EG_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "upper", 
    	    "Classes-Kernel-Operation-upper",
    	    "Infrastructure.uml#Core-PrimitiveTypes-UnlimitedNatural",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("1"),
    	   "",
    	   "_PwO1Em_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "class", 
    	    "Classes-Kernel-Operation-class",
    	    "Classes-Kernel-Class",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "precondition", 
    	    "Classes-Kernel-Operation-precondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "postcondition", 
    	    "Classes-Kernel-Operation-postcondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedOperation", 
    	    "Classes-Kernel-Operation-redefinedOperation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "datatype", 
    	    "Classes-Kernel-Operation-datatype",
    	    "Classes-Kernel-DataType",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "bodyCondition", 
    	    "Classes-Kernel-Operation-bodyCondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "type", 
    	    "Classes-Kernel-Operation-type",
    	    "Classes-Kernel-Type",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedParameter", 
    	    "Classes-Kernel-Operation-ownedParameter",
    	    "Classes-Kernel-Parameter",
    	    "Classes-Kernel-BehavioralFeature-ownedParameter",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "raisedException", 
    	    "Classes-Kernel-Operation-raisedException",
    	    "Classes-Kernel-Type",
    	    "Classes-Kernel-BehavioralFeature-raisedException",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DataType
    	clss  = (Class_)model.getElementById("Classes-Kernel-DataType").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedAttribute", 
    	    "Classes-Kernel-DataType-ownedAttribute",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedOperation", 
    	    "Classes-Kernel-DataType-ownedOperation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Enumeration
    	clss  = (Class_)model.getElementById("Classes-Kernel-Enumeration").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedLiteral", 
    	    "Classes-Kernel-Enumeration-ownedLiteral",
    	    "Classes-Kernel-EnumerationLiteral",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // EnumerationLiteral
    	clss  = (Class_)model.getElementById("Classes-Kernel-EnumerationLiteral").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "enumeration", 
    	    "Classes-Kernel-EnumerationLiteral-enumeration",
    	    "Classes-Kernel-Enumeration",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // PrimitiveType
    	clss  = (Class_)model.getElementById("Classes-Kernel-PrimitiveType").getDelegate();
    	
        // Association
    	clss  = (Class_)model.getElementById("Classes-Kernel-Association").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isDerived", 
    	    "Classes-Kernel-Association-isDerived",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PwO1Km_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "ownedEnd", 
    	    "Classes-Kernel-Association-ownedEnd",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "endType", 
    	    "Classes-Kernel-Association-endType",
    	    "Classes-Kernel-Type",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "memberEnd", 
    	    "Classes-Kernel-Association-memberEnd",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "2");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "navigableOwnedEnd", 
    	    "Classes-Kernel-Association-navigableOwnedEnd",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Namespace
    	clss  = (Class_)model.getElementById("Classes-Kernel-Namespace").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "elementImport", 
    	    "Classes-Kernel-Namespace-elementImport",
    	    "Classes-Kernel-ElementImport",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "packageImport", 
    	    "Classes-Kernel-Namespace-packageImport",
    	    "Classes-Kernel-PackageImport",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedRule", 
    	    "Classes-Kernel-Namespace-ownedRule",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedMember", 
    	    "Classes-Kernel-Namespace-ownedMember",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "member", 
    	    "Classes-Kernel-Namespace-member",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "importedMember", 
    	    "Classes-Kernel-Namespace-importedMember",
    	    "Classes-Kernel-PackageableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ValueSpecification
    	clss  = (Class_)model.getElementById("Classes-Kernel-ValueSpecification").getDelegate();
    	
        // Relationship
    	clss  = (Class_)model.getElementById("Classes-Kernel-Relationship").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "relatedElement", 
    	    "Classes-Kernel-Relationship-relatedElement",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // PackageMerge
    	clss  = (Class_)model.getElementById("Classes-Kernel-PackageMerge").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "receivingPackage", 
    	    "Classes-Kernel-PackageMerge-receivingPackage",
    	    "Classes-Kernel-Package",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "mergedPackage", 
    	    "Classes-Kernel-PackageMerge-mergedPackage",
    	    "Classes-Kernel-Package",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InstanceValue
    	clss  = (Class_)model.getElementById("Classes-Kernel-InstanceValue").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "instance", 
    	    "Classes-Kernel-InstanceValue-instance",
    	    "Classes-Kernel-InstanceSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LiteralUnlimitedNatural
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralUnlimitedNatural").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Classes-Kernel-LiteralUnlimitedNatural-value",
    	    "Infrastructure.uml#Core-PrimitiveTypes-UnlimitedNatural",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("0"),
    	   "",
    	   "_PwYl0G_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	
        // Type
    	clss  = (Class_)model.getElementById("Classes-Kernel-Type").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "package", 
    	    "Classes-Kernel-Type-package",
    	    "Classes-Kernel-Package",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Expression
    	clss  = (Class_)model.getElementById("Classes-Kernel-Expression").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "symbol", 
    	    "Classes-Kernel-Expression-symbol",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "operand", 
    	    "Classes-Kernel-Expression-operand",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Interface
    	clss  = (Class_)model.getElementById("Classes-Interfaces-Interface").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedAttribute", 
    	    "Classes-Interfaces-Interface-ownedAttribute",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedOperation", 
    	    "Classes-Interfaces-Interface-ownedOperation",
    	    "Classes-Interfaces-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "nestedClassifier", 
    	    "Classes-Interfaces-Interface-nestedClassifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedInterface", 
    	    "Classes-Interfaces-Interface-redefinedInterface",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InterfaceRealization
    	clss  = (Class_)model.getElementById("Classes-Interfaces-InterfaceRealization").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "contract", 
    	    "Classes-Interfaces-InterfaceRealization-contract",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "implementingClassifier", 
    	    "Classes-Interfaces-InterfaceRealization-implementingClassifier",
    	    "Classes-Interfaces-BehavioredClassifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // BehavioredClassifier
    	clss  = (Class_)model.getElementById("Classes-Interfaces-BehavioredClassifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "interfaceRealization", 
    	    "Classes-Interfaces-BehavioredClassifier-interfaceRealization",
    	    "Classes-Interfaces-InterfaceRealization",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Operation
    	clss  = (Class_)model.getElementById("Classes-Interfaces-Operation").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "interface", 
    	    "Classes-Interfaces-Operation-interface",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Usage
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Usage").getDelegate();
    	
        // Abstraction
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Abstraction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "mapping", 
    	    "Classes-Dependencies-Abstraction-mapping",
    	    "Classes-Kernel-OpaqueExpression",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Dependency
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Dependency").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "supplier", 
    	    "Classes-Dependencies-Dependency-supplier",
    	    "Classes-Dependencies-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "client", 
    	    "Classes-Dependencies-Dependency-client",
    	    "Classes-Dependencies-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Realization
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Realization").getDelegate();
    	
        // Substitution
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Substitution").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "contract", 
    	    "Classes-Dependencies-Substitution-contract",
    	    "Classes-Dependencies-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "substitutingClassifier", 
    	    "Classes-Dependencies-Substitution-substitutingClassifier",
    	    "Classes-Dependencies-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Classifier
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Classifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "substitution", 
    	    "Classes-Dependencies-Classifier-substitution",
    	    "Classes-Dependencies-Substitution",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // NamedElement
    	clss  = (Class_)model.getElementById("Classes-Dependencies-NamedElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "clientDependency", 
    	    "Classes-Dependencies-NamedElement-clientDependency",
    	    "Classes-Dependencies-Dependency",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "namespace", 
    	    "Classes-Dependencies-NamedElement-namespace",
    	    "Classes-Dependencies-Namespace",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // PackageableElement
    	clss  = (Class_)model.getElementById("Classes-Dependencies-PackageableElement").getDelegate();
    	
        // Namespace
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Namespace").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedMember", 
    	    "Classes-Dependencies-Namespace-ownedMember",
    	    "Classes-Dependencies-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // GeneralizationSet
    	clss  = (Class_)model.getElementById("Classes-PowerTypes-GeneralizationSet").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isCovering", 
    	    "Classes-PowerTypes-GeneralizationSet-isCovering",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PwrgzW_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isDisjoint", 
    	    "Classes-PowerTypes-GeneralizationSet-isDisjoint",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_Pwrgzm_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "powertype", 
    	    "Classes-PowerTypes-GeneralizationSet-powertype",
    	    "Classes-PowerTypes-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "generalization", 
    	    "Classes-PowerTypes-GeneralizationSet-generalization",
    	    "Classes-PowerTypes-Generalization",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Classifier
    	clss  = (Class_)model.getElementById("Classes-PowerTypes-Classifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "powertypeExtent", 
    	    "Classes-PowerTypes-Classifier-powertypeExtent",
    	    "Classes-PowerTypes-GeneralizationSet",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Generalization
    	clss  = (Class_)model.getElementById("Classes-PowerTypes-Generalization").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "generalizationSet", 
    	    "Classes-PowerTypes-Generalization-generalizationSet",
    	    "Classes-PowerTypes-GeneralizationSet",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // AssociationClass
    	clss  = (Class_)model.getElementById("Classes-AssociationClasses-AssociationClass").getDelegate();
    	
        // Property
    	clss  = (Class_)model.getElementById("Classes-AssociationClasses-Property").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "qualifier", 
    	    "Classes-AssociationClasses-Property-qualifier",
    	    "Classes-AssociationClasses-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "associationEnd", 
    	    "Classes-AssociationClasses-Property-associationEnd",
    	    "Classes-AssociationClasses-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-BehavioralFeature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "concurrency", 
    	    "CommonBehaviors-Communications-BehavioralFeature-concurrency",
    	    "CommonBehaviors-Communications-CallConcurrencyKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("sequential"),
    	   "",
    	   "_Pwrg22_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "raisedException", 
    	    "CommonBehaviors-Communications-BehavioralFeature-raisedException",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CallEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-CallEvent").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "operation", 
    	    "CommonBehaviors-Communications-CallEvent-operation",
    	    "CommonBehaviors-Communications-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ChangeEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-ChangeEvent").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "changeExpression", 
    	    "CommonBehaviors-Communications-ChangeEvent-changeExpression",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Class
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Class").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isActive", 
    	    "CommonBehaviors-Communications-Class-isActive",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_Pwrg3m_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "ownedReception", 
    	    "CommonBehaviors-Communications-Class-ownedReception",
    	    "CommonBehaviors-Communications-Reception",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Trigger
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Trigger").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "event", 
    	    "CommonBehaviors-Communications-Trigger-event",
    	    "CommonBehaviors-Communications-Event",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Interface
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Interface").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedReception", 
    	    "CommonBehaviors-Communications-Interface-ownedReception",
    	    "CommonBehaviors-Communications-Reception",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Reception
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Reception").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "signal", 
    	    "CommonBehaviors-Communications-Reception-signal",
    	    "CommonBehaviors-Communications-Signal",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Signal
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Signal").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedAttribute", 
    	    "CommonBehaviors-Communications-Signal-ownedAttribute",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // SignalEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-SignalEvent").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "signal", 
    	    "CommonBehaviors-Communications-SignalEvent-signal",
    	    "CommonBehaviors-Communications-Signal",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TimeEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-TimeEvent").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isRelative", 
    	    "CommonBehaviors-Communications-TimeEvent-isRelative",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_Pwrg5m_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "when", 
    	    "CommonBehaviors-Communications-TimeEvent-when",
    	    "CommonBehaviors-SimpleTime-TimeEvent",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // MessageEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-MessageEvent").getDelegate();
    	
        // AnyReceiveEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-AnyReceiveEvent").getDelegate();
    	
        // BehavioredClassifier
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-BehavioredClassifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedTrigger", 
    	    "CommonBehaviors-Communications-BehavioredClassifier-ownedTrigger",
    	    "CommonBehaviors-Communications-Trigger",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Event
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Event").getDelegate();
    	
        // Operation
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Operation").getDelegate();
    	
        // Behavior
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-Behavior").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isReentrant", 
    	    "CommonBehaviors-BasicBehaviors-Behavior-isReentrant",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_Pw0quG_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "redefinedBehavior", 
    	    "CommonBehaviors-BasicBehaviors-Behavior-redefinedBehavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "specification", 
    	    "CommonBehaviors-BasicBehaviors-Behavior-specification",
    	    "CommonBehaviors-BasicBehaviors-BehavioralFeature",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedParameter", 
    	    "CommonBehaviors-BasicBehaviors-Behavior-ownedParameter",
    	    "Classes-Kernel-Parameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "context", 
    	    "CommonBehaviors-BasicBehaviors-Behavior-context",
    	    "CommonBehaviors-BasicBehaviors-BehavioredClassifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "precondition", 
    	    "CommonBehaviors-BasicBehaviors-Behavior-precondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "postcondition", 
    	    "CommonBehaviors-BasicBehaviors-Behavior-postcondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // BehavioredClassifier
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-BehavioredClassifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedBehavior", 
    	    "CommonBehaviors-BasicBehaviors-BehavioredClassifier-ownedBehavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "classifierBehavior", 
    	    "CommonBehaviors-BasicBehaviors-BehavioredClassifier-classifierBehavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // OpaqueExpression
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-OpaqueExpression").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "CommonBehaviors-BasicBehaviors-OpaqueExpression-result",
    	    "Classes-Kernel-Parameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "behavior", 
    	    "CommonBehaviors-BasicBehaviors-OpaqueExpression-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-BehavioralFeature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isAbstract", 
    	    "CommonBehaviors-BasicBehaviors-BehavioralFeature-isAbstract",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_Pw0qyG_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "method", 
    	    "CommonBehaviors-BasicBehaviors-BehavioralFeature-method",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // OpaqueBehavior
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-OpaqueBehavior").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "body", 
    	    "CommonBehaviors-BasicBehaviors-OpaqueBehavior-body",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "language", 
    	    "CommonBehaviors-BasicBehaviors-OpaqueBehavior-language",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // FunctionBehavior
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-FunctionBehavior").getDelegate();
    	
        // TimeExpression
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeExpression").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "expr", 
    	    "CommonBehaviors-SimpleTime-TimeExpression-expr",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "observation", 
    	    "CommonBehaviors-SimpleTime-TimeExpression-observation",
    	    "CommonBehaviors-SimpleTime-Observation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Duration
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-Duration").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "expr", 
    	    "CommonBehaviors-SimpleTime-Duration-expr",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "observation", 
    	    "CommonBehaviors-SimpleTime-Duration-observation",
    	    "CommonBehaviors-SimpleTime-Observation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DurationInterval
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-DurationInterval").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "min", 
    	    "CommonBehaviors-SimpleTime-DurationInterval-min",
    	    "CommonBehaviors-SimpleTime-Duration",
    	    "CommonBehaviors-SimpleTime-Interval-min",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "max", 
    	    "CommonBehaviors-SimpleTime-DurationInterval-max",
    	    "CommonBehaviors-SimpleTime-Duration",
    	    "CommonBehaviors-SimpleTime-Interval-max",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TimeConstraint
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeConstraint").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "specification", 
    	    "CommonBehaviors-SimpleTime-TimeConstraint-specification",
    	    "CommonBehaviors-SimpleTime-TimeInterval",
    	    "CommonBehaviors-SimpleTime-IntervalConstraint-specification",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "firstEvent", 
    	    "CommonBehaviors-SimpleTime-TimeConstraint-firstEvent",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("true"),
    	   "",
    	   "_Pw0q42_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	
        // TimeInterval
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeInterval").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "max", 
    	    "CommonBehaviors-SimpleTime-TimeInterval-max",
    	    "CommonBehaviors-SimpleTime-TimeExpression",
    	    "CommonBehaviors-SimpleTime-Interval-max",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "min", 
    	    "CommonBehaviors-SimpleTime-TimeInterval-min",
    	    "CommonBehaviors-SimpleTime-TimeExpression",
    	    "CommonBehaviors-SimpleTime-Interval-min",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DurationConstraint
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-DurationConstraint").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "specification", 
    	    "CommonBehaviors-SimpleTime-DurationConstraint-specification",
    	    "CommonBehaviors-SimpleTime-DurationInterval",
    	    "CommonBehaviors-SimpleTime-IntervalConstraint-specification",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "firstEvent", 
    	    "CommonBehaviors-SimpleTime-DurationConstraint-firstEvent",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "2");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("true"),
    	   "",
    	   "_Pw0q5m_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	
        // IntervalConstraint
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-IntervalConstraint").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "specification", 
    	    "CommonBehaviors-SimpleTime-IntervalConstraint-specification",
    	    "CommonBehaviors-SimpleTime-Interval",
    	    "Classes-Kernel-Constraint-specification",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Interval
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-Interval").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "min", 
    	    "CommonBehaviors-SimpleTime-Interval-min",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "max", 
    	    "CommonBehaviors-SimpleTime-Interval-max",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TimeEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeEvent").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "when", 
    	    "CommonBehaviors-SimpleTime-TimeEvent-when",
    	    "CommonBehaviors-SimpleTime-TimeExpression",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Observation
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-Observation").getDelegate();
    	
        // TimeObservation
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeObservation").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "event", 
    	    "CommonBehaviors-SimpleTime-TimeObservation-event",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "firstEvent", 
    	    "CommonBehaviors-SimpleTime-TimeObservation-firstEvent",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("true"),
    	   "",
    	   "_Pw0q52_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	
        // DurationObservation
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-DurationObservation").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "event", 
    	    "CommonBehaviors-SimpleTime-DurationObservation-event",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "2");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "firstEvent", 
    	    "CommonBehaviors-SimpleTime-DurationObservation-firstEvent",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "2");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("true"),
    	   "",
    	   "_Pw0q62_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	
        // Component
    	clss  = (Class_)model.getElementById("Components-PackagingComponents-Component").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "packagedElement", 
    	    "Components-PackagingComponents-Component-packagedElement",
    	    "Classes-Kernel-PackageableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Component
    	clss  = (Class_)model.getElementById("Components-BasicComponents-Component").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isIndirectlyInstantiated", 
    	    "Components-BasicComponents-Component-isIndirectlyInstantiated",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("true"),
    	   "",
    	   "_Pw0rB2_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "required", 
    	    "Components-BasicComponents-Component-required",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "provided", 
    	    "Components-BasicComponents-Component-provided",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "realization", 
    	    "Components-BasicComponents-Component-realization",
    	    "Components-BasicComponents-ComponentRealization",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ComponentRealization
    	clss  = (Class_)model.getElementById("Components-BasicComponents-ComponentRealization").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "abstraction", 
    	    "Components-BasicComponents-ComponentRealization-abstraction",
    	    "Components-BasicComponents-Component",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "realizingClassifier", 
    	    "Components-BasicComponents-ComponentRealization-realizingClassifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Connector
    	clss  = (Class_)model.getElementById("Components-BasicComponents-Connector").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "kind", 
    	    "Components-BasicComponents-Connector-kind",
    	    "Components-BasicComponents-ConnectorKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "contract", 
    	    "Components-BasicComponents-Connector-contract",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Class
    	clss  = (Class_)model.getElementById("CompositeStructures-StructuredClasses-Class").getDelegate();
    	
        // CollaborationUse
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-CollaborationUse").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "type", 
    	    "CompositeStructures-Collaborations-CollaborationUse-type",
    	    "CompositeStructures-Collaborations-Collaboration",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "roleBinding", 
    	    "CompositeStructures-Collaborations-CollaborationUse-roleBinding",
    	    "Classes-Dependencies-Dependency",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Collaboration
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-Collaboration").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "collaborationRole", 
    	    "CompositeStructures-Collaborations-Collaboration-collaborationRole",
    	    "CompositeStructures-InternalStructures-ConnectableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Classifier
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-Classifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "representation", 
    	    "CompositeStructures-Collaborations-Classifier-representation",
    	    "CompositeStructures-Collaborations-CollaborationUse",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "collaborationUse", 
    	    "CompositeStructures-Collaborations-Classifier-collaborationUse",
    	    "CompositeStructures-Collaborations-CollaborationUse",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Parameter
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-Parameter").getDelegate();
    	
        // Port
    	clss  = (Class_)model.getElementById("CompositeStructures-Ports-Port").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isBehavior", 
    	    "CompositeStructures-Ports-Port-isBehavior",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_Pw0rMW_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isService", 
    	    "CompositeStructures-Ports-Port-isService",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("true"),
    	   "",
    	   "_Pw0rMm_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "required", 
    	    "CompositeStructures-Ports-Port-required",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedPort", 
    	    "CompositeStructures-Ports-Port-redefinedPort",
    	    "CompositeStructures-Ports-Port",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "provided", 
    	    "CompositeStructures-Ports-Port-provided",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // EncapsulatedClassifier
    	clss  = (Class_)model.getElementById("CompositeStructures-Ports-EncapsulatedClassifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedPort", 
    	    "CompositeStructures-Ports-EncapsulatedClassifier-ownedPort",
    	    "CompositeStructures-Ports-Port",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConnectorEnd
    	clss  = (Class_)model.getElementById("CompositeStructures-Ports-ConnectorEnd").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "partWithPort", 
    	    "CompositeStructures-Ports-ConnectorEnd-partWithPort",
    	    "CompositeStructures-InternalStructures-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InvocationAction
    	clss  = (Class_)model.getElementById("CompositeStructures-InvocationActions-InvocationAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "onPort", 
    	    "CompositeStructures-InvocationActions-InvocationAction-onPort",
    	    "CompositeStructures-Ports-Port",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Trigger
    	clss  = (Class_)model.getElementById("CompositeStructures-InvocationActions-Trigger").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "port", 
    	    "CompositeStructures-InvocationActions-Trigger-port",
    	    "CompositeStructures-Ports-Port",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConnectorEnd
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-ConnectorEnd").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "definingEnd", 
    	    "CompositeStructures-InternalStructures-ConnectorEnd-definingEnd",
    	    "CompositeStructures-InternalStructures-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "role", 
    	    "CompositeStructures-InternalStructures-ConnectorEnd-role",
    	    "CompositeStructures-InternalStructures-ConnectableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Connector
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Connector").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "type", 
    	    "CompositeStructures-InternalStructures-Connector-type",
    	    "Classes-Kernel-Association",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedConnector", 
    	    "CompositeStructures-InternalStructures-Connector-redefinedConnector",
    	    "CompositeStructures-InternalStructures-Connector",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "end", 
    	    "CompositeStructures-InternalStructures-Connector-end",
    	    "CompositeStructures-InternalStructures-ConnectorEnd",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "2");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Property
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Property").getDelegate();
    	
        // StructuredClassifier
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-StructuredClassifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedAttribute", 
    	    "CompositeStructures-InternalStructures-StructuredClassifier-ownedAttribute",
    	    "CompositeStructures-InternalStructures-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "part", 
    	    "CompositeStructures-InternalStructures-StructuredClassifier-part",
    	    "CompositeStructures-InternalStructures-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "role", 
    	    "CompositeStructures-InternalStructures-StructuredClassifier-role",
    	    "CompositeStructures-InternalStructures-ConnectableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedConnector", 
    	    "CompositeStructures-InternalStructures-StructuredClassifier-ownedConnector",
    	    "CompositeStructures-InternalStructures-Connector",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConnectableElement
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-ConnectableElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "end", 
    	    "CompositeStructures-InternalStructures-ConnectableElement-end",
    	    "CompositeStructures-InternalStructures-ConnectorEnd",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Classifier
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Classifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "attribute", 
    	    "CompositeStructures-InternalStructures-Classifier-attribute",
    	    "CompositeStructures-InternalStructures-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Variable
    	clss  = (Class_)model.getElementById("CompositeStructures-StructuredActivities-Variable").getDelegate();
    	
        // Deployment
    	clss  = (Class_)model.getElementById("Deployments-ComponentDeployments-Deployment").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "configuration", 
    	    "Deployments-ComponentDeployments-Deployment-configuration",
    	    "Deployments-ComponentDeployments-DeploymentSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DeploymentSpecification
    	clss  = (Class_)model.getElementById("Deployments-ComponentDeployments-DeploymentSpecification").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "deploymentLocation", 
    	    "Deployments-ComponentDeployments-DeploymentSpecification-deploymentLocation",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "executionLocation", 
    	    "Deployments-ComponentDeployments-DeploymentSpecification-executionLocation",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "deployment", 
    	    "Deployments-ComponentDeployments-DeploymentSpecification-deployment",
    	    "Deployments-ComponentDeployments-Deployment",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Deployment
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Deployment").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "deployedArtifact", 
    	    "Deployments-Nodes-Deployment-deployedArtifact",
    	    "Deployments-Nodes-DeployedArtifact",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "location", 
    	    "Deployments-Nodes-Deployment-location",
    	    "Deployments-Nodes-DeploymentTarget",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Node
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Node").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "nestedNode", 
    	    "Deployments-Nodes-Node-nestedNode",
    	    "Deployments-Nodes-Node",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Device
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Device").getDelegate();
    	
        // ExecutionEnvironment
    	clss  = (Class_)model.getElementById("Deployments-Nodes-ExecutionEnvironment").getDelegate();
    	
        // DeploymentTarget
    	clss  = (Class_)model.getElementById("Deployments-Nodes-DeploymentTarget").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "deployment", 
    	    "Deployments-Nodes-DeploymentTarget-deployment",
    	    "Deployments-Nodes-Deployment",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "deployedElement", 
    	    "Deployments-Nodes-DeploymentTarget-deployedElement",
    	    "Classes-Kernel-PackageableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DeployedArtifact
    	clss  = (Class_)model.getElementById("Deployments-Nodes-DeployedArtifact").getDelegate();
    	
        // CommunicationPath
    	clss  = (Class_)model.getElementById("Deployments-Nodes-CommunicationPath").getDelegate();
    	
        // Property
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Property").getDelegate();
    	
        // InstanceSpecification
    	clss  = (Class_)model.getElementById("Deployments-Nodes-InstanceSpecification").getDelegate();
    	
        // Artifact
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Artifact").getDelegate();
    	
        // Artifact
    	clss  = (Class_)model.getElementById("Deployments-Artifacts-Artifact").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "fileName", 
    	    "Deployments-Artifacts-Artifact-fileName",
    	    "Infrastructure.uml#Core-PrimitiveTypes-String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "nestedArtifact", 
    	    "Deployments-Artifacts-Artifact-nestedArtifact",
    	    "Deployments-Artifacts-Artifact",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "manifestation", 
    	    "Deployments-Artifacts-Artifact-manifestation",
    	    "Deployments-Artifacts-Manifestation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedOperation", 
    	    "Deployments-Artifacts-Artifact-ownedOperation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedAttribute", 
    	    "Deployments-Artifacts-Artifact-ownedAttribute",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Manifestation
    	clss  = (Class_)model.getElementById("Deployments-Artifacts-Manifestation").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "utilizedElement", 
    	    "Deployments-Artifacts-Manifestation-utilizedElement",
    	    "Classes-Kernel-PackageableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Interaction
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-Interaction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "lifeline", 
    	    "Interactions-BasicInteractions-Interaction-lifeline",
    	    "Interactions-BasicInteractions-Lifeline",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "message", 
    	    "Interactions-BasicInteractions-Interaction-message",
    	    "Interactions-BasicInteractions-Message",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "fragment", 
    	    "Interactions-BasicInteractions-Interaction-fragment",
    	    "Interactions-BasicInteractions-InteractionFragment",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "action", 
    	    "Interactions-BasicInteractions-Interaction-action",
    	    "Actions-BasicActions-Action",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Lifeline
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-Lifeline").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "coveredBy", 
    	    "Interactions-BasicInteractions-Lifeline-coveredBy",
    	    "Interactions-BasicInteractions-InteractionFragment",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "represents", 
    	    "Interactions-BasicInteractions-Lifeline-represents",
    	    "CompositeStructures-InternalStructures-ConnectableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "interaction", 
    	    "Interactions-BasicInteractions-Lifeline-interaction",
    	    "Interactions-BasicInteractions-Interaction",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "selector", 
    	    "Interactions-BasicInteractions-Lifeline-selector",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InteractionFragment
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-InteractionFragment").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "covered", 
    	    "Interactions-BasicInteractions-InteractionFragment-covered",
    	    "Interactions-BasicInteractions-Lifeline",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "generalOrdering", 
    	    "Interactions-BasicInteractions-InteractionFragment-generalOrdering",
    	    "Interactions-BasicInteractions-GeneralOrdering",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "enclosingInteraction", 
    	    "Interactions-BasicInteractions-InteractionFragment-enclosingInteraction",
    	    "Interactions-BasicInteractions-Interaction",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Message
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-Message").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "messageKind", 
    	    "Interactions-BasicInteractions-Message-messageKind",
    	    "Interactions-BasicInteractions-MessageKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("unknown"),
    	   "",
    	   "_Pw-cAm_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "messageSort", 
    	    "Interactions-BasicInteractions-Message-messageSort",
    	    "Interactions-BasicInteractions-MessageSort",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("synchCall"),
    	   "",
    	   "_Pw-cA2_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "receiveEvent", 
    	    "Interactions-BasicInteractions-Message-receiveEvent",
    	    "Interactions-BasicInteractions-MessageEnd",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "sendEvent", 
    	    "Interactions-BasicInteractions-Message-sendEvent",
    	    "Interactions-BasicInteractions-MessageEnd",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "connector", 
    	    "Interactions-BasicInteractions-Message-connector",
    	    "CompositeStructures-InternalStructures-Connector",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "interaction", 
    	    "Interactions-BasicInteractions-Message-interaction",
    	    "Interactions-BasicInteractions-Interaction",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "argument", 
    	    "Interactions-BasicInteractions-Message-argument",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "signature", 
    	    "Interactions-BasicInteractions-Message-signature",
    	    "Classes-Dependencies-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // GeneralOrdering
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-GeneralOrdering").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "before", 
    	    "Interactions-BasicInteractions-GeneralOrdering-before",
    	    "Interactions-BasicInteractions-OccurrenceSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "after", 
    	    "Interactions-BasicInteractions-GeneralOrdering-after",
    	    "Interactions-BasicInteractions-OccurrenceSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ExecutionSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ExecutionSpecification").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "start", 
    	    "Interactions-BasicInteractions-ExecutionSpecification-start",
    	    "Interactions-BasicInteractions-OccurrenceSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "finish", 
    	    "Interactions-BasicInteractions-ExecutionSpecification-finish",
    	    "Interactions-BasicInteractions-OccurrenceSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // OccurrenceSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-OccurrenceSpecification").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "covered", 
    	    "Interactions-BasicInteractions-OccurrenceSpecification-covered",
    	    "Interactions-BasicInteractions-Lifeline",
    	    "Interactions-BasicInteractions-InteractionFragment-covered",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "toAfter", 
    	    "Interactions-BasicInteractions-OccurrenceSpecification-toAfter",
    	    "Interactions-BasicInteractions-GeneralOrdering",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "toBefore", 
    	    "Interactions-BasicInteractions-OccurrenceSpecification-toBefore",
    	    "Interactions-BasicInteractions-GeneralOrdering",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "event", 
    	    "Interactions-BasicInteractions-OccurrenceSpecification-event",
    	    "CommonBehaviors-Communications-Event",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // MessageEnd
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-MessageEnd").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "message", 
    	    "Interactions-BasicInteractions-MessageEnd-message",
    	    "Interactions-BasicInteractions-Message",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StateInvariant
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-StateInvariant").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "invariant", 
    	    "Interactions-BasicInteractions-StateInvariant-invariant",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "covered", 
    	    "Interactions-BasicInteractions-StateInvariant-covered",
    	    "Interactions-BasicInteractions-Lifeline",
    	    "Interactions-BasicInteractions-InteractionFragment-covered",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActionExecutionSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ActionExecutionSpecification").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "action", 
    	    "Interactions-BasicInteractions-ActionExecutionSpecification-action",
    	    "Actions-BasicActions-Action",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // BehaviorExecutionSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-BehaviorExecutionSpecification").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "behavior", 
    	    "Interactions-BasicInteractions-BehaviorExecutionSpecification-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ExecutionEvent
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ExecutionEvent").getDelegate();
    	
        // CreationEvent
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-CreationEvent").getDelegate();
    	
        // DestructionEvent
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-DestructionEvent").getDelegate();
    	
        // SendOperationEvent
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-SendOperationEvent").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "operation", 
    	    "Interactions-BasicInteractions-SendOperationEvent-operation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // SendSignalEvent
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-SendSignalEvent").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "signal", 
    	    "Interactions-BasicInteractions-SendSignalEvent-signal",
    	    "CommonBehaviors-Communications-Signal",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // MessageOccurrenceSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-MessageOccurrenceSpecification").getDelegate();
    	
        // ExecutionOccurrenceSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ExecutionOccurrenceSpecification").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "execution", 
    	    "Interactions-BasicInteractions-ExecutionOccurrenceSpecification-execution",
    	    "Interactions-BasicInteractions-ExecutionSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "event", 
    	    "Interactions-BasicInteractions-ExecutionOccurrenceSpecification-event",
    	    "Interactions-BasicInteractions-ExecutionEvent",
    	    "Interactions-BasicInteractions-OccurrenceSpecification-event",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReceiveOperationEvent
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ReceiveOperationEvent").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "operation", 
    	    "Interactions-BasicInteractions-ReceiveOperationEvent-operation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReceiveSignalEvent
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ReceiveSignalEvent").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "signal", 
    	    "Interactions-BasicInteractions-ReceiveSignalEvent-signal",
    	    "CommonBehaviors-Communications-Signal",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InteractionUse
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionUse").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "refersTo", 
    	    "Interactions-Fragments-InteractionUse-refersTo",
    	    "Interactions-Fragments-Interaction",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "actualGate", 
    	    "Interactions-Fragments-InteractionUse-actualGate",
    	    "Interactions-Fragments-Gate",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "argument", 
    	    "Interactions-Fragments-InteractionUse-argument",
    	    "Actions-BasicActions-Action",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // PartDecomposition
    	clss  = (Class_)model.getElementById("Interactions-Fragments-PartDecomposition").getDelegate();
    	
        // InteractionOperand
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionOperand").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "guard", 
    	    "Interactions-Fragments-InteractionOperand-guard",
    	    "Interactions-Fragments-InteractionConstraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "fragment", 
    	    "Interactions-Fragments-InteractionOperand-fragment",
    	    "Interactions-Fragments-InteractionFragment",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InteractionConstraint
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionConstraint").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "minint", 
    	    "Interactions-Fragments-InteractionConstraint-minint",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "maxint", 
    	    "Interactions-Fragments-InteractionConstraint-maxint",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Gate
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Gate").getDelegate();
    	
        // CombinedFragment
    	clss  = (Class_)model.getElementById("Interactions-Fragments-CombinedFragment").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "interactionOperator", 
    	    "Interactions-Fragments-CombinedFragment-interactionOperator",
    	    "Interactions-Fragments-InteractionOperatorKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("seq"),
    	   "",
    	   "_PxIMsm_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "operand", 
    	    "Interactions-Fragments-CombinedFragment-operand",
    	    "Interactions-Fragments-InteractionOperand",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "cfragmentGate", 
    	    "Interactions-Fragments-CombinedFragment-cfragmentGate",
    	    "Interactions-Fragments-Gate",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Interaction
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Interaction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "formalGate", 
    	    "Interactions-Fragments-Interaction-formalGate",
    	    "Interactions-Fragments-Gate",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Lifeline
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Lifeline").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "decomposedAs", 
    	    "Interactions-Fragments-Lifeline-decomposedAs",
    	    "Interactions-Fragments-PartDecomposition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Continuation
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Continuation").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "setting", 
    	    "Interactions-Fragments-Continuation-setting",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("true"),
    	   "",
    	   "_PxIMuW_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	
        // InteractionFragment
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionFragment").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "enclosingOperand", 
    	    "Interactions-Fragments-InteractionFragment-enclosingOperand",
    	    "Interactions-Fragments-InteractionOperand",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConsiderIgnoreFragment
    	clss  = (Class_)model.getElementById("Interactions-Fragments-ConsiderIgnoreFragment").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "message", 
    	    "Interactions-Fragments-ConsiderIgnoreFragment-message",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StateMachine
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-StateMachine").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "region", 
    	    "StateMachines-BehaviorStateMachines-StateMachine-region",
    	    "StateMachines-BehaviorStateMachines-Region",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "connectionPoint", 
    	    "StateMachines-BehaviorStateMachines-StateMachine-connectionPoint",
    	    "StateMachines-BehaviorStateMachines-Pseudostate",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "extendedStateMachine", 
    	    "StateMachines-BehaviorStateMachines-StateMachine-extendedStateMachine",
    	    "StateMachines-BehaviorStateMachines-StateMachine",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "submachineState", 
    	    "StateMachines-BehaviorStateMachines-StateMachine-submachineState",
    	    "StateMachines-BehaviorStateMachines-State",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // State
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-State").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isComposite", 
    	    "StateMachines-BehaviorStateMachines-State-isComposite",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PxIMz2_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isOrthogonal", 
    	    "StateMachines-BehaviorStateMachines-State-isOrthogonal",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PxIM0G_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isSimple", 
    	    "StateMachines-BehaviorStateMachines-State-isSimple",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("true"),
    	   "",
    	   "_PxIM0W_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isSubmachineState", 
    	    "StateMachines-BehaviorStateMachines-State-isSubmachineState",
    	    "Infrastructure.uml#Core-PrimitiveTypes-Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("false"),
    	   "",
    	   "_PxIM0m_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "submachine", 
    	    "StateMachines-BehaviorStateMachines-State-submachine",
    	    "StateMachines-BehaviorStateMachines-StateMachine",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "connection", 
    	    "StateMachines-BehaviorStateMachines-State-connection",
    	    "StateMachines-BehaviorStateMachines-ConnectionPointReference",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedState", 
    	    "StateMachines-BehaviorStateMachines-State-redefinedState",
    	    "StateMachines-BehaviorStateMachines-State",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "region", 
    	    "StateMachines-BehaviorStateMachines-State-region",
    	    "StateMachines-BehaviorStateMachines-Region",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinitionContext", 
    	    "StateMachines-BehaviorStateMachines-State-redefinitionContext",
    	    "Classes-Kernel-Classifier",
    	    "Classes-Kernel-RedefinableElement-redefinitionContext",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "stateInvariant", 
    	    "StateMachines-BehaviorStateMachines-State-stateInvariant",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "entry", 
    	    "StateMachines-BehaviorStateMachines-State-entry",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "exit", 
    	    "StateMachines-BehaviorStateMachines-State-exit",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "doActivity", 
    	    "StateMachines-BehaviorStateMachines-State-doActivity",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "connectionPoint", 
    	    "StateMachines-BehaviorStateMachines-State-connectionPoint",
    	    "StateMachines-BehaviorStateMachines-Pseudostate",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "deferrableTrigger", 
    	    "StateMachines-BehaviorStateMachines-State-deferrableTrigger",
    	    "CommonBehaviors-Communications-Trigger",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Transition
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Transition").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "kind", 
    	    "StateMachines-BehaviorStateMachines-Transition-kind",
    	    "StateMachines-BehaviorStateMachines-TransitionKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("external"),
    	   "",
    	   "_PxIM4W_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "container", 
    	    "StateMachines-BehaviorStateMachines-Transition-container",
    	    "StateMachines-BehaviorStateMachines-Region",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "source", 
    	    "StateMachines-BehaviorStateMachines-Transition-source",
    	    "StateMachines-BehaviorStateMachines-Vertex",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "target", 
    	    "StateMachines-BehaviorStateMachines-Transition-target",
    	    "StateMachines-BehaviorStateMachines-Vertex",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedTransition", 
    	    "StateMachines-BehaviorStateMachines-Transition-redefinedTransition",
    	    "StateMachines-BehaviorStateMachines-Transition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "guard", 
    	    "StateMachines-BehaviorStateMachines-Transition-guard",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinitionContext", 
    	    "StateMachines-BehaviorStateMachines-Transition-redefinitionContext",
    	    "Classes-Kernel-Classifier",
    	    "Classes-Kernel-RedefinableElement-redefinitionContext",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "effect", 
    	    "StateMachines-BehaviorStateMachines-Transition-effect",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "trigger", 
    	    "StateMachines-BehaviorStateMachines-Transition-trigger",
    	    "CommonBehaviors-Communications-Trigger",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Vertex
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Vertex").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "container", 
    	    "StateMachines-BehaviorStateMachines-Vertex-container",
    	    "StateMachines-BehaviorStateMachines-Region",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "outgoing", 
    	    "StateMachines-BehaviorStateMachines-Vertex-outgoing",
    	    "StateMachines-BehaviorStateMachines-Transition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "incoming", 
    	    "StateMachines-BehaviorStateMachines-Vertex-incoming",
    	    "StateMachines-BehaviorStateMachines-Transition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Pseudostate
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Pseudostate").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "kind", 
    	    "StateMachines-BehaviorStateMachines-Pseudostate-kind",
    	    "StateMachines-BehaviorStateMachines-PseudostateKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("initial"),
    	   "",
    	   "_PxIM8G_uEd2dGPXl6bl1Xw",  
    	   "uml:LiteralString",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "stateMachine", 
    	    "StateMachines-BehaviorStateMachines-Pseudostate-stateMachine",
    	    "StateMachines-BehaviorStateMachines-StateMachine",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "state", 
    	    "StateMachines-BehaviorStateMachines-Pseudostate-state",
    	    "StateMachines-BehaviorStateMachines-State",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // FinalState
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-FinalState").getDelegate();
    	
        // ConnectionPointReference
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-ConnectionPointReference").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "entry", 
    	    "StateMachines-BehaviorStateMachines-ConnectionPointReference-entry",
    	    "StateMachines-BehaviorStateMachines-Pseudostate",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "state", 
    	    "StateMachines-BehaviorStateMachines-ConnectionPointReference-state",
    	    "StateMachines-BehaviorStateMachines-State",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "exit", 
    	    "StateMachines-BehaviorStateMachines-ConnectionPointReference-exit",
    	    "StateMachines-BehaviorStateMachines-Pseudostate",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Region
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Region").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "subvertex", 
    	    "StateMachines-BehaviorStateMachines-Region-subvertex",
    	    "StateMachines-BehaviorStateMachines-Vertex",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "transition", 
    	    "StateMachines-BehaviorStateMachines-Region-transition",
    	    "StateMachines-BehaviorStateMachines-Transition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "stateMachine", 
    	    "StateMachines-BehaviorStateMachines-Region-stateMachine",
    	    "StateMachines-BehaviorStateMachines-StateMachine",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "state", 
    	    "StateMachines-BehaviorStateMachines-Region-state",
    	    "StateMachines-BehaviorStateMachines-State",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "extendedRegion", 
    	    "StateMachines-BehaviorStateMachines-Region-extendedRegion",
    	    "StateMachines-BehaviorStateMachines-Region",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinitionContext", 
    	    "StateMachines-BehaviorStateMachines-Region-redefinitionContext",
    	    "Classes-Kernel-Classifier",
    	    "Classes-Kernel-RedefinableElement-redefinitionContext",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TimeEvent
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-TimeEvent").getDelegate();
    	
        // ProtocolConformance
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-ProtocolConformance").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "specificMachine", 
    	    "StateMachines-ProtocolStateMachines-ProtocolConformance-specificMachine",
    	    "StateMachines-ProtocolStateMachines-ProtocolStateMachine",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "generalMachine", 
    	    "StateMachines-ProtocolStateMachines-ProtocolConformance-generalMachine",
    	    "StateMachines-ProtocolStateMachines-ProtocolStateMachine",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Interface
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-Interface").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "protocol", 
    	    "StateMachines-ProtocolStateMachines-Interface-protocol",
    	    "StateMachines-ProtocolStateMachines-ProtocolStateMachine",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Port
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-Port").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "protocol", 
    	    "StateMachines-ProtocolStateMachines-Port-protocol",
    	    "StateMachines-ProtocolStateMachines-ProtocolStateMachine",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ProtocolTransition
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-ProtocolTransition").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "postCondition", 
    	    "StateMachines-ProtocolStateMachines-ProtocolTransition-postCondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "referred", 
    	    "StateMachines-ProtocolStateMachines-ProtocolTransition-referred",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "preCondition", 
    	    "StateMachines-ProtocolStateMachines-ProtocolTransition-preCondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ProtocolStateMachine
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-ProtocolStateMachine").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "conformance", 
    	    "StateMachines-ProtocolStateMachines-ProtocolStateMachine-conformance",
    	    "StateMachines-ProtocolStateMachines-ProtocolConformance",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // State
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-State").getDelegate();
    	
        // Region
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-Region").getDelegate();
    	
        // Actor
    	clss  = (Class_)model.getElementById("UseCases-Actor").getDelegate();
    	
        // Extend
    	clss  = (Class_)model.getElementById("UseCases-Extend").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "extendedCase", 
    	    "UseCases-Extend-extendedCase",
    	    "UseCases-UseCase",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "extension", 
    	    "UseCases-Extend-extension",
    	    "UseCases-UseCase",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "condition", 
    	    "UseCases-Extend-condition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "extensionLocation", 
    	    "UseCases-Extend-extensionLocation",
    	    "UseCases-ExtensionPoint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Include
    	clss  = (Class_)model.getElementById("UseCases-Include").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "includingCase", 
    	    "UseCases-Include-includingCase",
    	    "UseCases-UseCase",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "addition", 
    	    "UseCases-Include-addition",
    	    "UseCases-UseCase",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // UseCase
    	clss  = (Class_)model.getElementById("UseCases-UseCase").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "include", 
    	    "UseCases-UseCase-include",
    	    "UseCases-Include",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "extend", 
    	    "UseCases-UseCase-extend",
    	    "UseCases-Extend",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "extensionPoint", 
    	    "UseCases-UseCase-extensionPoint",
    	    "UseCases-ExtensionPoint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "subject", 
    	    "UseCases-UseCase-subject",
    	    "UseCases-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ExtensionPoint
    	clss  = (Class_)model.getElementById("UseCases-ExtensionPoint").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "useCase", 
    	    "UseCases-ExtensionPoint-useCase",
    	    "UseCases-UseCase",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Classifier
    	clss  = (Class_)model.getElementById("UseCases-Classifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedUseCase", 
    	    "UseCases-Classifier-ownedUseCase",
    	    "UseCases-UseCase",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "useCase", 
    	    "UseCases-Classifier-useCase",
    	    "UseCases-UseCase",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
    }
    
    private void constructGeneralizations()
    {
        Class_ clss = null;
        
    
        // ReadExtentAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadExtentAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ReclassifyObjectAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReclassifyObjectAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ReadIsClassifiedObjectAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadIsClassifiedObjectAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // StartClassifierBehaviorAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-StartClassifierBehaviorAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // QualifierValue
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-QualifierValue").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // LinkEndData
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-LinkEndData").getDelegate();
    	
        // ReadLinkObjectEndAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadLinkObjectEndAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ReadLinkObjectEndQualifierAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadLinkObjectEndQualifierAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // CreateLinkObjectAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-CreateLinkObjectAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-CreateLinkAction");
    	
        // AcceptEventAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-AcceptEventAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // AcceptCallAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-AcceptCallAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-CompleteActions-AcceptEventAction");
    	
        // ReplyAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReplyAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // UnmarshallAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-UnmarshallAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ReduceAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReduceAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // StartObjectBehaviorAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-StartObjectBehaviorAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-CallAction");
    	
        // CreateObjectAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-CreateObjectAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // DestroyObjectAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-DestroyObjectAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // TestIdentityAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-TestIdentityAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ReadSelfAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ReadSelfAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // StructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-StructuralFeatureAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ReadStructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ReadStructuralFeatureAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-StructuralFeatureAction");
    	
        // WriteStructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-WriteStructuralFeatureAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-StructuralFeatureAction");
    	
        // ClearStructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ClearStructuralFeatureAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-StructuralFeatureAction");
    	
        // RemoveStructuralFeatureValueAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-RemoveStructuralFeatureValueAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-WriteStructuralFeatureAction");
    	
        // AddStructuralFeatureValueAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-AddStructuralFeatureValueAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-WriteStructuralFeatureAction");
    	
        // LinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // LinkEndData
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkEndData").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // ReadLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ReadLinkAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-LinkAction");
    	
        // LinkEndCreationData
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkEndCreationData").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-LinkEndData");
    	
        // CreateLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-CreateLinkAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-WriteLinkAction");
    	
        // DestroyLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-DestroyLinkAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-WriteLinkAction");
    	
        // WriteLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-WriteLinkAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-LinkAction");
    	
        // ClearAssociationAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ClearAssociationAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // BroadcastSignalAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-BroadcastSignalAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-InvocationAction");
    	
        // SendObjectAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-SendObjectAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-InvocationAction");
    	
        // LinkEndDestructionData
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkEndDestructionData").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-LinkEndData");
    	
        // ValueSpecificationAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ValueSpecificationAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // OpaqueAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-OpaqueAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // Pin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-Pin").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-MultiplicityElement");
    	
        // ValuePin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-ValuePin").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-InputPin");
    	
        // OutputPin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-OutputPin").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Pin");
    	
        // InputPin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-InputPin").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Pin");
    	
        // InvocationAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-InvocationAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // CallAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-CallAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-InvocationAction");
    	
        // SendSignalAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-SendSignalAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-InvocationAction");
    	
        // CallOperationAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-CallOperationAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-CallAction");
    	
        // CallBehaviorAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-CallBehaviorAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-CallAction");
    	
        // Action
    	clss  = (Class_)model.getElementById("Actions-BasicActions-Action").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // MultiplicityElement
    	clss  = (Class_)model.getElementById("Actions-BasicActions-MultiplicityElement").getDelegate();
    	
        // VariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-VariableAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ReadVariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-ReadVariableAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-StructuredActions-VariableAction");
    	
        // WriteVariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-WriteVariableAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-StructuredActions-VariableAction");
    	
        // ClearVariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-ClearVariableAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-StructuredActions-VariableAction");
    	
        // AddVariableValueAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-AddVariableValueAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-StructuredActions-WriteVariableAction");
    	
        // RemoveVariableValueAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-RemoveVariableValueAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-StructuredActions-WriteVariableAction");
    	
        // RaiseExceptionAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-RaiseExceptionAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ActionInputPin
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-ActionInputPin").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-InputPin");
    	
        // ObjectNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ObjectNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ActivityNode");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
        // ControlNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ControlNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ActivityNode");
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityEdge").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // ControlFlow
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ControlFlow").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ActivityEdge");
    	
        // ObjectFlow
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ObjectFlow").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ActivityEdge");
    	
        // InitialNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-InitialNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // ActivityFinalNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityFinalNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityGroup").getDelegate();
    	
        // ActivityParameterNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityParameterNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ObjectNode");
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // Pin
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-Pin").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ObjectNode");
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-Activity").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
    	
        // ValuePin
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ValuePin").getDelegate();
    	
        // ForkNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ForkNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // FlowFinalNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-FlowFinalNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-IntermediateActivities-FinalNode");
    	
        // CentralBufferNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-CentralBufferNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ObjectNode");
    	
        // ActivityPartition
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityPartition").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
    	factory.createGeneralization(clss, "Activities-IntermediateActivities-ActivityGroup");
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityEdge").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // MergeNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-MergeNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // DecisionNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-DecisionNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // FinalNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-FinalNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // ActivityFinalNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityFinalNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-IntermediateActivities-FinalNode");
    	
        // JoinNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-JoinNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityGroup").getDelegate();
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-Activity").getDelegate();
    	
        // JoinNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-JoinNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // DataStoreNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-DataStoreNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-IntermediateActivities-CentralBufferNode");
    	
        // ObjectFlow
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ObjectFlow").getDelegate();
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ActivityEdge").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // ObjectNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ObjectNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
        // ParameterSet
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ParameterSet").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Activity").getDelegate();
    	
        // Parameter
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Parameter").getDelegate();
    	
        // Action
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Action").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // InterruptibleActivityRegion
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-InterruptibleActivityRegion").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ActivityGroup");
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ActivityNode").getDelegate();
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-BehavioralFeature").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Feature");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // Behavior
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Behavior").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Class");
    	
        // Pin
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Pin").getDelegate();
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ActivityGroup").getDelegate();
    	
        // Variable
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Variable").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-MultiplicityElement");
    	
        // StructuredActivityNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-StructuredActivityNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-ActivityGroup");
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-ExecutableNode");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // ConditionalNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ConditionalNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-StructuredActivityNode");
    	
        // LoopNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-LoopNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-StructuredActivityNode");
    	
        // Clause
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Clause").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Activity").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ActivityNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // ExecutableNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ExecutableNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-ActivityNode");
    	
        // SequenceNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-SequenceNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-StructuredActivityNode");
    	
        // Action
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Action").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-ExecutableNode");
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ActivityGroup").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // InputPin
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-InputPin").getDelegate();
    	
        // OutputPin
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-OutputPin").getDelegate();
    	
        // ExpansionNode
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExpansionNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ObjectNode");
    	
        // ExpansionRegion
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExpansionRegion").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-StructuredActivityNode");
    	
        // ExecutableNode
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExecutableNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-ActivityNode");
    	
        // ExceptionHandler
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExceptionHandler").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // ConditionalNode
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-ConditionalNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-CompleteStructuredActivities-StructuredActivityNode");
    	
        // StructuredActivityNode
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-StructuredActivityNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
    	factory.createGeneralization(clss, "Activities-CompleteStructuredActivities-ActivityGroup");
    	
        // LoopNode
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-LoopNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-CompleteStructuredActivities-StructuredActivityNode");
    	
        // Clause
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-Clause").getDelegate();
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-ActivityEdge").getDelegate();
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-ActivityGroup").getDelegate();
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-Activity").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-ActivityGroup").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // Action
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-Action").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-FundamentalActivities-ActivityNode");
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-ActivityNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // ExtensionEnd
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Profiles-ExtensionEnd").getDelegate();
    	
        // InformationItem
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-InformationFlows-InformationItem").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // InformationFlow
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-InformationFlows-InformationFlow").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // Model
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Models-Model").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Package");
    	
        // TemplateSignature
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateSignature").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // NamedElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-NamedElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // TemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateParameter").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // StringExpression
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-StringExpression").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateableElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Expression");
    	
        // TemplateBinding
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateBinding").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
        // TemplateParameterSubstitution
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateParameterSubstitution").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // TemplateableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // ParameterableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ParameterableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // Property
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Property").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
    	
        // ValueSpecification
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ValueSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
    	
        // Operation
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Operation").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateableElement");
    	
        // OperationTemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-OperationTemplateParameter").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateParameter");
    	
        // PackageableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-PackageableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
    	
        // Classifier
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Classifier").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateableElement");
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // ClassifierTemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ClassifierTemplateParameter").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateParameter");
    	
        // RedefinableTemplateSignature
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-RedefinableTemplateSignature").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateSignature");
    	
        // ConnectableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ConnectableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
    	
        // ConnectableElementTemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateParameter");
    	
        // Package
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Package").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateableElement");
    	
        // Element
    	clss  = (Class_)model.getElementById("Classes-Kernel-Element").getDelegate();
    	
        // Comment
    	clss  = (Class_)model.getElementById("Classes-Kernel-Comment").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // DirectedRelationship
    	clss  = (Class_)model.getElementById("Classes-Kernel-DirectedRelationship").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Relationship");
    	
        // NamedElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-NamedElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // PackageableElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-PackageableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // OpaqueExpression
    	clss  = (Class_)model.getElementById("Classes-Kernel-OpaqueExpression").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
    	
        // LiteralSpecification
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
    	
        // LiteralInteger
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralInteger").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
    	
        // LiteralString
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralString").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
    	
        // LiteralBoolean
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralBoolean").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
    	
        // LiteralNull
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralNull").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
    	
        // Constraint
    	clss  = (Class_)model.getElementById("Classes-Kernel-Constraint").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // ElementImport
    	clss  = (Class_)model.getElementById("Classes-Kernel-ElementImport").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
        // MultiplicityElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-MultiplicityElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // TypedElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-TypedElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Classifier
    	clss  = (Class_)model.getElementById("Classes-Kernel-Classifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Type");
    	
        // Feature
    	clss  = (Class_)model.getElementById("Classes-Kernel-Feature").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // RedefinableElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-RedefinableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Generalization
    	clss  = (Class_)model.getElementById("Classes-Kernel-Generalization").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("Classes-Kernel-BehavioralFeature").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Feature");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // Parameter
    	clss  = (Class_)model.getElementById("Classes-Kernel-Parameter").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-MultiplicityElement");
    	
        // StructuralFeature
    	clss  = (Class_)model.getElementById("Classes-Kernel-StructuralFeature").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Feature");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-MultiplicityElement");
    	
        // InstanceSpecification
    	clss  = (Class_)model.getElementById("Classes-Kernel-InstanceSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // Slot
    	clss  = (Class_)model.getElementById("Classes-Kernel-Slot").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // Package
    	clss  = (Class_)model.getElementById("Classes-Kernel-Package").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // PackageImport
    	clss  = (Class_)model.getElementById("Classes-Kernel-PackageImport").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
        // Class
    	clss  = (Class_)model.getElementById("Classes-Kernel-Class").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // Property
    	clss  = (Class_)model.getElementById("Classes-Kernel-Property").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-StructuralFeature");
    	
        // Operation
    	clss  = (Class_)model.getElementById("Classes-Kernel-Operation").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-BehavioralFeature");
    	
        // DataType
    	clss  = (Class_)model.getElementById("Classes-Kernel-DataType").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // Enumeration
    	clss  = (Class_)model.getElementById("Classes-Kernel-Enumeration").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DataType");
    	
        // EnumerationLiteral
    	clss  = (Class_)model.getElementById("Classes-Kernel-EnumerationLiteral").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-InstanceSpecification");
    	
        // PrimitiveType
    	clss  = (Class_)model.getElementById("Classes-Kernel-PrimitiveType").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DataType");
    	
        // Association
    	clss  = (Class_)model.getElementById("Classes-Kernel-Association").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Relationship");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // Namespace
    	clss  = (Class_)model.getElementById("Classes-Kernel-Namespace").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // ValueSpecification
    	clss  = (Class_)model.getElementById("Classes-Kernel-ValueSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // Relationship
    	clss  = (Class_)model.getElementById("Classes-Kernel-Relationship").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // PackageMerge
    	clss  = (Class_)model.getElementById("Classes-Kernel-PackageMerge").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
        // InstanceValue
    	clss  = (Class_)model.getElementById("Classes-Kernel-InstanceValue").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
    	
        // LiteralUnlimitedNatural
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralUnlimitedNatural").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
    	
        // Type
    	clss  = (Class_)model.getElementById("Classes-Kernel-Type").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // Expression
    	clss  = (Class_)model.getElementById("Classes-Kernel-Expression").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
    	
        // Interface
    	clss  = (Class_)model.getElementById("Classes-Interfaces-Interface").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // InterfaceRealization
    	clss  = (Class_)model.getElementById("Classes-Interfaces-InterfaceRealization").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Realization");
    	
        // BehavioredClassifier
    	clss  = (Class_)model.getElementById("Classes-Interfaces-BehavioredClassifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // Operation
    	clss  = (Class_)model.getElementById("Classes-Interfaces-Operation").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-BehavioralFeature");
    	
        // Usage
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Usage").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Dependency");
    	
        // Abstraction
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Abstraction").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Dependency");
    	
        // Dependency
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Dependency").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-PackageableElement");
    	
        // Realization
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Realization").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Abstraction");
    	
        // Substitution
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Substitution").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Realization");
    	
        // Classifier
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Classifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Namespace");
    	
        // NamedElement
    	clss  = (Class_)model.getElementById("Classes-Dependencies-NamedElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // PackageableElement
    	clss  = (Class_)model.getElementById("Classes-Dependencies-PackageableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
    	
        // Namespace
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Namespace").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
    	
        // GeneralizationSet
    	clss  = (Class_)model.getElementById("Classes-PowerTypes-GeneralizationSet").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // Classifier
    	clss  = (Class_)model.getElementById("Classes-PowerTypes-Classifier").getDelegate();
    	
        // Generalization
    	clss  = (Class_)model.getElementById("Classes-PowerTypes-Generalization").getDelegate();
    	
        // AssociationClass
    	clss  = (Class_)model.getElementById("Classes-AssociationClasses-AssociationClass").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Association");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Class");
    	
        // Property
    	clss  = (Class_)model.getElementById("Classes-AssociationClasses-Property").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-StructuralFeature");
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-BehavioralFeature").getDelegate();
    	
        // CallEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-CallEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-MessageEvent");
    	
        // ChangeEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-ChangeEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-Event");
    	
        // Class
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Class").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-BehavioredClassifier");
    	
        // Trigger
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Trigger").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Interface
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Interface").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // Reception
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Reception").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-BehavioralFeature");
    	
        // Signal
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Signal").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // SignalEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-SignalEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-MessageEvent");
    	
        // TimeEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-TimeEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-Event");
    	
        // MessageEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-MessageEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-Event");
    	
        // AnyReceiveEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-AnyReceiveEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-MessageEvent");
    	
        // BehavioredClassifier
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-BehavioredClassifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // Event
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Event").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // Operation
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Operation").getDelegate();
    	
        // Behavior
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-Behavior").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Class");
    	
        // BehavioredClassifier
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-BehavioredClassifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // OpaqueExpression
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-OpaqueExpression").getDelegate();
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-BehavioralFeature").getDelegate();
    	
        // OpaqueBehavior
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-OpaqueBehavior").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
    	
        // FunctionBehavior
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-FunctionBehavior").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-OpaqueBehavior");
    	
        // TimeExpression
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeExpression").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
    	
        // Duration
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-Duration").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
    	
        // DurationInterval
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-DurationInterval").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-Interval");
    	
        // TimeConstraint
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeConstraint").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-IntervalConstraint");
    	
        // TimeInterval
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeInterval").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-Interval");
    	
        // DurationConstraint
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-DurationConstraint").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-IntervalConstraint");
    	
        // IntervalConstraint
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-IntervalConstraint").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Constraint");
    	
        // Interval
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-Interval").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
    	
        // TimeEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-Event");
    	
        // Observation
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-Observation").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // TimeObservation
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeObservation").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-Observation");
    	
        // DurationObservation
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-DurationObservation").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-Observation");
    	
        // Component
    	clss  = (Class_)model.getElementById("Components-PackagingComponents-Component").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // Component
    	clss  = (Class_)model.getElementById("Components-BasicComponents-Component").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-StructuredClasses-Class");
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
    	
        // ComponentRealization
    	clss  = (Class_)model.getElementById("Components-BasicComponents-ComponentRealization").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Realization");
    	
        // Connector
    	clss  = (Class_)model.getElementById("Components-BasicComponents-Connector").getDelegate();
    	
        // Class
    	clss  = (Class_)model.getElementById("CompositeStructures-StructuredClasses-Class").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-Ports-EncapsulatedClassifier");
    	
        // CollaborationUse
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-CollaborationUse").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Collaboration
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-Collaboration").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-Collaborations-Classifier");
    	
    	factory.createGeneralization(clss, "CompositeStructures-InternalStructures-StructuredClassifier");
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-BehavioredClassifier");
    	
        // Classifier
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-Classifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Type");
    	
        // Parameter
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-Parameter").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-InternalStructures-ConnectableElement");
    	
        // Port
    	clss  = (Class_)model.getElementById("CompositeStructures-Ports-Port").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-InternalStructures-Property");
    	
        // EncapsulatedClassifier
    	clss  = (Class_)model.getElementById("CompositeStructures-Ports-EncapsulatedClassifier").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-InternalStructures-StructuredClassifier");
    	
        // ConnectorEnd
    	clss  = (Class_)model.getElementById("CompositeStructures-Ports-ConnectorEnd").getDelegate();
    	
        // InvocationAction
    	clss  = (Class_)model.getElementById("CompositeStructures-InvocationActions-InvocationAction").getDelegate();
    	
        // Trigger
    	clss  = (Class_)model.getElementById("CompositeStructures-InvocationActions-Trigger").getDelegate();
    	
        // ConnectorEnd
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-ConnectorEnd").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-MultiplicityElement");
    	
        // Connector
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Connector").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Feature");
    	
        // Property
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Property").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-InternalStructures-ConnectableElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-StructuralFeature");
    	
        // StructuredClassifier
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-StructuredClassifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // ConnectableElement
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-ConnectableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
        // Classifier
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Classifier").getDelegate();
    	
        // Variable
    	clss  = (Class_)model.getElementById("CompositeStructures-StructuredActivities-Variable").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-InternalStructures-ConnectableElement");
    	
        // Deployment
    	clss  = (Class_)model.getElementById("Deployments-ComponentDeployments-Deployment").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Dependency");
    	
        // DeploymentSpecification
    	clss  = (Class_)model.getElementById("Deployments-ComponentDeployments-DeploymentSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-Artifact");
    	
        // Deployment
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Deployment").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Dependency");
    	
        // Node
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Node").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-StructuredClasses-Class");
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-DeploymentTarget");
    	
        // Device
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Device").getDelegate();
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-Node");
    	
        // ExecutionEnvironment
    	clss  = (Class_)model.getElementById("Deployments-Nodes-ExecutionEnvironment").getDelegate();
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-Node");
    	
        // DeploymentTarget
    	clss  = (Class_)model.getElementById("Deployments-Nodes-DeploymentTarget").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
    	
        // DeployedArtifact
    	clss  = (Class_)model.getElementById("Deployments-Nodes-DeployedArtifact").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
    	
        // CommunicationPath
    	clss  = (Class_)model.getElementById("Deployments-Nodes-CommunicationPath").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Association");
    	
        // Property
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Property").getDelegate();
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-DeploymentTarget");
    	
        // InstanceSpecification
    	clss  = (Class_)model.getElementById("Deployments-Nodes-InstanceSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-DeploymentTarget");
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-DeployedArtifact");
    	
        // Artifact
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Artifact").getDelegate();
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-DeployedArtifact");
    	
        // Artifact
    	clss  = (Class_)model.getElementById("Deployments-Artifacts-Artifact").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
    	
        // Manifestation
    	clss  = (Class_)model.getElementById("Deployments-Artifacts-Manifestation").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Abstraction");
    	
        // Interaction
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-Interaction").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-InteractionFragment");
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
    	
        // Lifeline
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-Lifeline").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // InteractionFragment
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-InteractionFragment").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Message
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-Message").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // GeneralOrdering
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-GeneralOrdering").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // ExecutionSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ExecutionSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-InteractionFragment");
    	
        // OccurrenceSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-OccurrenceSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-InteractionFragment");
    	
        // MessageEnd
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-MessageEnd").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // StateInvariant
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-StateInvariant").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-InteractionFragment");
    	
        // ActionExecutionSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ActionExecutionSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-ExecutionSpecification");
    	
        // BehaviorExecutionSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-BehaviorExecutionSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-ExecutionSpecification");
    	
        // ExecutionEvent
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ExecutionEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-Event");
    	
        // CreationEvent
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-CreationEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-Event");
    	
        // DestructionEvent
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-DestructionEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-Event");
    	
        // SendOperationEvent
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-SendOperationEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-MessageEvent");
    	
        // SendSignalEvent
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-SendSignalEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-MessageEvent");
    	
        // MessageOccurrenceSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-MessageOccurrenceSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-MessageEnd");
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-OccurrenceSpecification");
    	
        // ExecutionOccurrenceSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ExecutionOccurrenceSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-OccurrenceSpecification");
    	
        // ReceiveOperationEvent
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ReceiveOperationEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-MessageEvent");
    	
        // ReceiveSignalEvent
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ReceiveSignalEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-MessageEvent");
    	
        // InteractionUse
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionUse").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-Fragments-InteractionFragment");
    	
        // PartDecomposition
    	clss  = (Class_)model.getElementById("Interactions-Fragments-PartDecomposition").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-Fragments-InteractionUse");
    	
        // InteractionOperand
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionOperand").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-Fragments-InteractionFragment");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // InteractionConstraint
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionConstraint").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Constraint");
    	
        // Gate
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Gate").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-MessageEnd");
    	
        // CombinedFragment
    	clss  = (Class_)model.getElementById("Interactions-Fragments-CombinedFragment").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-Fragments-InteractionFragment");
    	
        // Interaction
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Interaction").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
    	
        // Lifeline
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Lifeline").getDelegate();
    	
        // Continuation
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Continuation").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-Fragments-InteractionFragment");
    	
        // InteractionFragment
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionFragment").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // ConsiderIgnoreFragment
    	clss  = (Class_)model.getElementById("Interactions-Fragments-ConsiderIgnoreFragment").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-Fragments-CombinedFragment");
    	
        // StateMachine
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-StateMachine").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
    	
        // State
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-State").getDelegate();
    	
    	factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-Vertex");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // Transition
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Transition").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // Vertex
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Vertex").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Pseudostate
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Pseudostate").getDelegate();
    	
    	factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-Vertex");
    	
        // FinalState
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-FinalState").getDelegate();
    	
    	factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-State");
    	
        // ConnectionPointReference
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-ConnectionPointReference").getDelegate();
    	
    	factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-Vertex");
    	
        // Region
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Region").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // TimeEvent
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-TimeEvent").getDelegate();
    	
        // ProtocolConformance
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-ProtocolConformance").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
        // Interface
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-Interface").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // Port
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-Port").getDelegate();
    	
        // ProtocolTransition
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-ProtocolTransition").getDelegate();
    	
    	factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-Transition");
    	
        // ProtocolStateMachine
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-ProtocolStateMachine").getDelegate();
    	
    	factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-StateMachine");
    	
        // State
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-State").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // Region
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-Region").getDelegate();
    	
        // Actor
    	clss  = (Class_)model.getElementById("UseCases-Actor").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-BehavioredClassifier");
    	
        // Extend
    	clss  = (Class_)model.getElementById("UseCases-Extend").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Include
    	clss  = (Class_)model.getElementById("UseCases-Include").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // UseCase
    	clss  = (Class_)model.getElementById("UseCases-UseCase").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-BehavioredClassifier");
    	
        // ExtensionPoint
    	clss  = (Class_)model.getElementById("UseCases-ExtensionPoint").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // Classifier
    	clss  = (Class_)model.getElementById("UseCases-Classifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
    }

    private void constructAssociations()
    {
        Package pkg = null;
        String packageId = null;
        Association assoc = null;
        Property prop = null;
        
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_result_readExtentAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readExtentAction", "Actions-CompleteActions-A_result_readExtentAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readExtentAction", 
    	    "Actions-CompleteActions-A_result_readExtentAction-readExtentAction",
    	    "Actions-CompleteActions-ReadExtentAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadExtentAction-result Actions-CompleteActions-A_result_readExtentAction-readExtentAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_classifier_readExtentAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_classifier_readExtentAction", "Actions-CompleteActions-A_classifier_readExtentAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readExtentAction", 
    	    "Actions-CompleteActions-A_classifier_readExtentAction-readExtentAction",
    	    "Actions-CompleteActions-ReadExtentAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadExtentAction-classifier Actions-CompleteActions-A_classifier_readExtentAction-readExtentAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_oldClassifier_reclassifyObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_oldClassifier_reclassifyObjectAction", "Actions-CompleteActions-A_oldClassifier_reclassifyObjectAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "reclassifyObjectAction", 
    	    "Actions-CompleteActions-A_oldClassifier_reclassifyObjectAction-reclassifyObjectAction",
    	    "Actions-CompleteActions-ReclassifyObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReclassifyObjectAction-oldClassifier Actions-CompleteActions-A_oldClassifier_reclassifyObjectAction-reclassifyObjectAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_newClassifier_reclassifyObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_newClassifier_reclassifyObjectAction", "Actions-CompleteActions-A_newClassifier_reclassifyObjectAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "reclassifyObjectAction", 
    	    "Actions-CompleteActions-A_newClassifier_reclassifyObjectAction-reclassifyObjectAction",
    	    "Actions-CompleteActions-ReclassifyObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReclassifyObjectAction-newClassifier Actions-CompleteActions-A_newClassifier_reclassifyObjectAction-reclassifyObjectAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_classifier_readIsClassifiedObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_classifier_readIsClassifiedObjectAction", "Actions-CompleteActions-A_classifier_readIsClassifiedObjectAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readIsClassifiedObjectAction", 
    	    "Actions-CompleteActions-A_classifier_readIsClassifiedObjectAction-readIsClassifiedObjectAction",
    	    "Actions-CompleteActions-ReadIsClassifiedObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadIsClassifiedObjectAction-classifier Actions-CompleteActions-A_classifier_readIsClassifiedObjectAction-readIsClassifiedObjectAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_result_readIsClassifiedObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readIsClassifiedObjectAction", "Actions-CompleteActions-A_result_readIsClassifiedObjectAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readIsClassifiedObjectAction", 
    	    "Actions-CompleteActions-A_result_readIsClassifiedObjectAction-readIsClassifiedObjectAction",
    	    "Actions-CompleteActions-ReadIsClassifiedObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadIsClassifiedObjectAction-result Actions-CompleteActions-A_result_readIsClassifiedObjectAction-readIsClassifiedObjectAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_object_readIsClassifiedObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_readIsClassifiedObjectAction", "Actions-CompleteActions-A_object_readIsClassifiedObjectAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readIsClassifiedObjectAction", 
    	    "Actions-CompleteActions-A_object_readIsClassifiedObjectAction-readIsClassifiedObjectAction",
    	    "Actions-CompleteActions-ReadIsClassifiedObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadIsClassifiedObjectAction-object Actions-CompleteActions-A_object_readIsClassifiedObjectAction-readIsClassifiedObjectAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_object_startClassifierBehaviorAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_startClassifierBehaviorAction", "Actions-CompleteActions-A_object_startClassifierBehaviorAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "startClassifierBehaviorAction", 
    	    "Actions-CompleteActions-A_object_startClassifierBehaviorAction-startClassifierBehaviorAction",
    	    "Actions-CompleteActions-StartClassifierBehaviorAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-StartClassifierBehaviorAction-object Actions-CompleteActions-A_object_startClassifierBehaviorAction-startClassifierBehaviorAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_qualifier_linkEndData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_qualifier_linkEndData", "Actions-CompleteActions-A_qualifier_linkEndData");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "linkEndData", 
    	    "Actions-CompleteActions-A_qualifier_linkEndData-linkEndData",
    	    "Actions-CompleteActions-LinkEndData",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-LinkEndData-qualifier Actions-CompleteActions-A_qualifier_linkEndData-linkEndData");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_qualifier_qualifierValue 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_qualifier_qualifierValue", "Actions-CompleteActions-A_qualifier_qualifierValue");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "qualifierValue", 
    	    "Actions-CompleteActions-A_qualifier_qualifierValue-qualifierValue",
    	    "Actions-CompleteActions-QualifierValue",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-QualifierValue-qualifier Actions-CompleteActions-A_qualifier_qualifierValue-qualifierValue");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_value_qualifierValue 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_value_qualifierValue", "Actions-CompleteActions-A_value_qualifierValue");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "qualifierValue", 
    	    "Actions-CompleteActions-A_value_qualifierValue-qualifierValue",
    	    "Actions-CompleteActions-QualifierValue",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-QualifierValue-value Actions-CompleteActions-A_value_qualifierValue-qualifierValue");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_object_readLinkObjectEndAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_readLinkObjectEndAction", "Actions-CompleteActions-A_object_readLinkObjectEndAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readLinkObjectEndAction", 
    	    "Actions-CompleteActions-A_object_readLinkObjectEndAction-readLinkObjectEndAction",
    	    "Actions-CompleteActions-ReadLinkObjectEndAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndAction-object Actions-CompleteActions-A_object_readLinkObjectEndAction-readLinkObjectEndAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_end_readLinkObjectEndAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_end_readLinkObjectEndAction", "Actions-CompleteActions-A_end_readLinkObjectEndAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readLinkObjectEndAction", 
    	    "Actions-CompleteActions-A_end_readLinkObjectEndAction-readLinkObjectEndAction",
    	    "Actions-CompleteActions-ReadLinkObjectEndAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndAction-end Actions-CompleteActions-A_end_readLinkObjectEndAction-readLinkObjectEndAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_result_readLinkObjectEndAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readLinkObjectEndAction", "Actions-CompleteActions-A_result_readLinkObjectEndAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readLinkObjectEndAction", 
    	    "Actions-CompleteActions-A_result_readLinkObjectEndAction-readLinkObjectEndAction",
    	    "Actions-CompleteActions-ReadLinkObjectEndAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndAction-result Actions-CompleteActions-A_result_readLinkObjectEndAction-readLinkObjectEndAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_object_readLinkObjectEndQualifierAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_readLinkObjectEndQualifierAction", "Actions-CompleteActions-A_object_readLinkObjectEndQualifierAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readLinkObjectEndQualifierAction", 
    	    "Actions-CompleteActions-A_object_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction",
    	    "Actions-CompleteActions-ReadLinkObjectEndQualifierAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-object Actions-CompleteActions-A_object_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_result_readLinkObjectEndQualifierAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readLinkObjectEndQualifierAction", "Actions-CompleteActions-A_result_readLinkObjectEndQualifierAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readLinkObjectEndQualifierAction", 
    	    "Actions-CompleteActions-A_result_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction",
    	    "Actions-CompleteActions-ReadLinkObjectEndQualifierAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-result Actions-CompleteActions-A_result_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_qualifier_readLinkObjectEndQualifierAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_qualifier_readLinkObjectEndQualifierAction", "Actions-CompleteActions-A_qualifier_readLinkObjectEndQualifierAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readLinkObjectEndQualifierAction", 
    	    "Actions-CompleteActions-A_qualifier_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction",
    	    "Actions-CompleteActions-ReadLinkObjectEndQualifierAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-qualifier Actions-CompleteActions-A_qualifier_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_result_createLinkObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_createLinkObjectAction", "Actions-CompleteActions-A_result_createLinkObjectAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "createLinkObjectAction", 
    	    "Actions-CompleteActions-A_result_createLinkObjectAction-createLinkObjectAction",
    	    "Actions-CompleteActions-CreateLinkObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-CreateLinkObjectAction-result Actions-CompleteActions-A_result_createLinkObjectAction-createLinkObjectAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_reclassifyObjectAction_object 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_reclassifyObjectAction_object", "Actions-CompleteActions-A_reclassifyObjectAction_object");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "reclassifyObjectAction", 
    	    "Actions-CompleteActions-A_reclassifyObjectAction_object-reclassifyObjectAction",
    	    "Actions-CompleteActions-ReclassifyObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-A_reclassifyObjectAction_object-reclassifyObjectAction Actions-CompleteActions-ReclassifyObjectAction-object");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_result_acceptEventAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_acceptEventAction", "Actions-CompleteActions-A_result_acceptEventAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "acceptEventAction", 
    	    "Actions-CompleteActions-A_result_acceptEventAction-acceptEventAction",
    	    "Actions-CompleteActions-AcceptEventAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-AcceptEventAction-result Actions-CompleteActions-A_result_acceptEventAction-acceptEventAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_returnInformation_acceptCallAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_returnInformation_acceptCallAction", "Actions-CompleteActions-A_returnInformation_acceptCallAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "acceptCallAction", 
    	    "Actions-CompleteActions-A_returnInformation_acceptCallAction-acceptCallAction",
    	    "Actions-CompleteActions-AcceptCallAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-AcceptCallAction-returnInformation Actions-CompleteActions-A_returnInformation_acceptCallAction-acceptCallAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_replyToCall_replyAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_replyToCall_replyAction", "Actions-CompleteActions-A_replyToCall_replyAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "replyAction", 
    	    "Actions-CompleteActions-A_replyToCall_replyAction-replyAction",
    	    "Actions-CompleteActions-ReplyAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReplyAction-replyToCall Actions-CompleteActions-A_replyToCall_replyAction-replyAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_result_unmarshallAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_unmarshallAction", "Actions-CompleteActions-A_result_unmarshallAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "unmarshallAction", 
    	    "Actions-CompleteActions-A_result_unmarshallAction-unmarshallAction",
    	    "Actions-CompleteActions-UnmarshallAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-UnmarshallAction-result Actions-CompleteActions-A_result_unmarshallAction-unmarshallAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_unmarshallType_unmarshallAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_unmarshallType_unmarshallAction", "Actions-CompleteActions-A_unmarshallType_unmarshallAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "unmarshallAction", 
    	    "Actions-CompleteActions-A_unmarshallType_unmarshallAction-unmarshallAction",
    	    "Actions-CompleteActions-UnmarshallAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-UnmarshallAction-unmarshallType Actions-CompleteActions-A_unmarshallType_unmarshallAction-unmarshallAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_object_unmarshallAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_unmarshallAction", "Actions-CompleteActions-A_object_unmarshallAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "unmarshallAction", 
    	    "Actions-CompleteActions-A_object_unmarshallAction-unmarshallAction",
    	    "Actions-CompleteActions-UnmarshallAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-UnmarshallAction-object Actions-CompleteActions-A_object_unmarshallAction-unmarshallAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_returnInformation_replyAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_returnInformation_replyAction", "Actions-CompleteActions-A_returnInformation_replyAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "replyAction", 
    	    "Actions-CompleteActions-A_returnInformation_replyAction-replyAction",
    	    "Actions-CompleteActions-ReplyAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReplyAction-returnInformation Actions-CompleteActions-A_returnInformation_replyAction-replyAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_replyValue_replyAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_replyValue_replyAction", "Actions-CompleteActions-A_replyValue_replyAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "replyAction", 
    	    "Actions-CompleteActions-A_replyValue_replyAction-replyAction",
    	    "Actions-CompleteActions-ReplyAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReplyAction-replyValue Actions-CompleteActions-A_replyValue_replyAction-replyAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_trigger_acceptEventAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_trigger_acceptEventAction", "Actions-CompleteActions-A_trigger_acceptEventAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "acceptEventAction", 
    	    "Actions-CompleteActions-A_trigger_acceptEventAction-acceptEventAction",
    	    "Actions-CompleteActions-AcceptEventAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-AcceptEventAction-trigger Actions-CompleteActions-A_trigger_acceptEventAction-acceptEventAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_result_reduceAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_reduceAction", "Actions-CompleteActions-A_result_reduceAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "reduceAction", 
    	    "Actions-CompleteActions-A_result_reduceAction-reduceAction",
    	    "Actions-CompleteActions-ReduceAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReduceAction-result Actions-CompleteActions-A_result_reduceAction-reduceAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_collection_reduceAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_collection_reduceAction", "Actions-CompleteActions-A_collection_reduceAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "reduceAction", 
    	    "Actions-CompleteActions-A_collection_reduceAction-reduceAction",
    	    "Actions-CompleteActions-ReduceAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReduceAction-collection Actions-CompleteActions-A_collection_reduceAction-reduceAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_reducer_reduceAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_reducer_reduceAction", "Actions-CompleteActions-A_reducer_reduceAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "reduceAction", 
    	    "Actions-CompleteActions-A_reducer_reduceAction-reduceAction",
    	    "Actions-CompleteActions-ReduceAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReduceAction-reducer Actions-CompleteActions-A_reducer_reduceAction-reduceAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // Actions.CompleteActions.A_object_startObjectBehaviorAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_startObjectBehaviorAction", "Actions-CompleteActions-A_object_startObjectBehaviorAction");
        mapping.mapAssociation(assoc, "Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "", 
    	    "Actions-CompleteActions-A_object_startObjectBehaviorAction-_ownedEnd.0",
    	    "Actions-CompleteActions-StartObjectBehaviorAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-StartObjectBehaviorAction-object Actions-CompleteActions-A_object_startObjectBehaviorAction-_ownedEnd.0");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_classifier_createObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_classifier_createObjectAction", "Actions-IntermediateActions-A_classifier_createObjectAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "createObjectAction", 
    	    "Actions-IntermediateActions-A_classifier_createObjectAction-createObjectAction",
    	    "Actions-IntermediateActions-CreateObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-CreateObjectAction-classifier Actions-IntermediateActions-A_classifier_createObjectAction-createObjectAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_result_createObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_createObjectAction", "Actions-IntermediateActions-A_result_createObjectAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "createObjectAction", 
    	    "Actions-IntermediateActions-A_result_createObjectAction-createObjectAction",
    	    "Actions-IntermediateActions-CreateObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-CreateObjectAction-result Actions-IntermediateActions-A_result_createObjectAction-createObjectAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_target_destroyObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_target_destroyObjectAction", "Actions-IntermediateActions-A_target_destroyObjectAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "destroyObjectAction", 
    	    "Actions-IntermediateActions-A_target_destroyObjectAction-destroyObjectAction",
    	    "Actions-IntermediateActions-DestroyObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-DestroyObjectAction-target Actions-IntermediateActions-A_target_destroyObjectAction-destroyObjectAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_first_testIdentityAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_first_testIdentityAction", "Actions-IntermediateActions-A_first_testIdentityAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "testIdentityAction", 
    	    "Actions-IntermediateActions-A_first_testIdentityAction-testIdentityAction",
    	    "Actions-IntermediateActions-TestIdentityAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-TestIdentityAction-first Actions-IntermediateActions-A_first_testIdentityAction-testIdentityAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_second_testIdentityAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_second_testIdentityAction", "Actions-IntermediateActions-A_second_testIdentityAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "testIdentityAction", 
    	    "Actions-IntermediateActions-A_second_testIdentityAction-testIdentityAction",
    	    "Actions-IntermediateActions-TestIdentityAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-TestIdentityAction-second Actions-IntermediateActions-A_second_testIdentityAction-testIdentityAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_result_testIdentityAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_testIdentityAction", "Actions-IntermediateActions-A_result_testIdentityAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "testIdentityAction", 
    	    "Actions-IntermediateActions-A_result_testIdentityAction-testIdentityAction",
    	    "Actions-IntermediateActions-TestIdentityAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-TestIdentityAction-result Actions-IntermediateActions-A_result_testIdentityAction-testIdentityAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_result_readSelfAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readSelfAction", "Actions-IntermediateActions-A_result_readSelfAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readSelfAction", 
    	    "Actions-IntermediateActions-A_result_readSelfAction-readSelfAction",
    	    "Actions-IntermediateActions-ReadSelfAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ReadSelfAction-result Actions-IntermediateActions-A_result_readSelfAction-readSelfAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_structuralFeatureAction_structuralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_structuralFeatureAction_structuralFeature", "Actions-IntermediateActions-A_structuralFeatureAction_structuralFeature");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "structuralFeatureAction", 
    	    "Actions-IntermediateActions-A_structuralFeatureAction_structuralFeature-structuralFeatureAction",
    	    "Actions-IntermediateActions-StructuralFeatureAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-A_structuralFeatureAction_structuralFeature-structuralFeatureAction Actions-IntermediateActions-StructuralFeatureAction-structuralFeature");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_object_structuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_structuralFeatureAction", "Actions-IntermediateActions-A_object_structuralFeatureAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "structuralFeatureAction", 
    	    "Actions-IntermediateActions-A_object_structuralFeatureAction-structuralFeatureAction",
    	    "Actions-IntermediateActions-StructuralFeatureAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-StructuralFeatureAction-object Actions-IntermediateActions-A_object_structuralFeatureAction-structuralFeatureAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_result_readStructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readStructuralFeatureAction", "Actions-IntermediateActions-A_result_readStructuralFeatureAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readStructuralFeatureAction", 
    	    "Actions-IntermediateActions-A_result_readStructuralFeatureAction-readStructuralFeatureAction",
    	    "Actions-IntermediateActions-ReadStructuralFeatureAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ReadStructuralFeatureAction-result Actions-IntermediateActions-A_result_readStructuralFeatureAction-readStructuralFeatureAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_value_writeStructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_value_writeStructuralFeatureAction", "Actions-IntermediateActions-A_value_writeStructuralFeatureAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "writeStructuralFeatureAction", 
    	    "Actions-IntermediateActions-A_value_writeStructuralFeatureAction-writeStructuralFeatureAction",
    	    "Actions-IntermediateActions-WriteStructuralFeatureAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-WriteStructuralFeatureAction-value Actions-IntermediateActions-A_value_writeStructuralFeatureAction-writeStructuralFeatureAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_insertAt_addStructuralFeatureValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_insertAt_addStructuralFeatureValueAction", "Actions-IntermediateActions-A_insertAt_addStructuralFeatureValueAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "addStructuralFeatureValueAction", 
    	    "Actions-IntermediateActions-A_insertAt_addStructuralFeatureValueAction-addStructuralFeatureValueAction",
    	    "Actions-IntermediateActions-AddStructuralFeatureValueAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-AddStructuralFeatureValueAction-insertAt Actions-IntermediateActions-A_insertAt_addStructuralFeatureValueAction-addStructuralFeatureValueAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_endData_linkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_endData_linkAction", "Actions-IntermediateActions-A_endData_linkAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "linkAction", 
    	    "Actions-IntermediateActions-A_endData_linkAction-linkAction",
    	    "Actions-IntermediateActions-LinkAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkAction-endData Actions-IntermediateActions-A_endData_linkAction-linkAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_value_linkEndData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_value_linkEndData", "Actions-IntermediateActions-A_value_linkEndData");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "linkEndData", 
    	    "Actions-IntermediateActions-A_value_linkEndData-linkEndData",
    	    "Actions-IntermediateActions-LinkEndData",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkEndData-value Actions-IntermediateActions-A_value_linkEndData-linkEndData");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_end_linkEndData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_end_linkEndData", "Actions-IntermediateActions-A_end_linkEndData");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "linkEndData", 
    	    "Actions-IntermediateActions-A_end_linkEndData-linkEndData",
    	    "Actions-IntermediateActions-LinkEndData",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkEndData-end Actions-IntermediateActions-A_end_linkEndData-linkEndData");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_result_readLinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readLinkAction", "Actions-IntermediateActions-A_result_readLinkAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readLinkAction", 
    	    "Actions-IntermediateActions-A_result_readLinkAction-readLinkAction",
    	    "Actions-IntermediateActions-ReadLinkAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ReadLinkAction-result Actions-IntermediateActions-A_result_readLinkAction-readLinkAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_insertAt_linkEndCreationData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_insertAt_linkEndCreationData", "Actions-IntermediateActions-A_insertAt_linkEndCreationData");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "linkEndCreationData", 
    	    "Actions-IntermediateActions-A_insertAt_linkEndCreationData-linkEndCreationData",
    	    "Actions-IntermediateActions-LinkEndCreationData",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkEndCreationData-insertAt Actions-IntermediateActions-A_insertAt_linkEndCreationData-linkEndCreationData");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_endData_createLinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_endData_createLinkAction", "Actions-IntermediateActions-A_endData_createLinkAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "createLinkAction", 
    	    "Actions-IntermediateActions-A_endData_createLinkAction-createLinkAction",
    	    "Actions-IntermediateActions-CreateLinkAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-CreateLinkAction-endData Actions-IntermediateActions-A_endData_createLinkAction-createLinkAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_object_clearAssociationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_clearAssociationAction", "Actions-IntermediateActions-A_object_clearAssociationAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "clearAssociationAction", 
    	    "Actions-IntermediateActions-A_object_clearAssociationAction-clearAssociationAction",
    	    "Actions-IntermediateActions-ClearAssociationAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ClearAssociationAction-object Actions-IntermediateActions-A_object_clearAssociationAction-clearAssociationAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_association_clearAssociationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_association_clearAssociationAction", "Actions-IntermediateActions-A_association_clearAssociationAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "clearAssociationAction", 
    	    "Actions-IntermediateActions-A_association_clearAssociationAction-clearAssociationAction",
    	    "Actions-IntermediateActions-ClearAssociationAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ClearAssociationAction-association Actions-IntermediateActions-A_association_clearAssociationAction-clearAssociationAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_target_sendObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_target_sendObjectAction", "Actions-IntermediateActions-A_target_sendObjectAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "sendObjectAction", 
    	    "Actions-IntermediateActions-A_target_sendObjectAction-sendObjectAction",
    	    "Actions-IntermediateActions-SendObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-SendObjectAction-target Actions-IntermediateActions-A_target_sendObjectAction-sendObjectAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_request_sendObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_request_sendObjectAction", "Actions-IntermediateActions-A_request_sendObjectAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "sendObjectAction", 
    	    "Actions-IntermediateActions-A_request_sendObjectAction-sendObjectAction",
    	    "Actions-IntermediateActions-SendObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-SendObjectAction-request Actions-IntermediateActions-A_request_sendObjectAction-sendObjectAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_signal_broadcastSignalAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_signal_broadcastSignalAction", "Actions-IntermediateActions-A_signal_broadcastSignalAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "broadcastSignalAction", 
    	    "Actions-IntermediateActions-A_signal_broadcastSignalAction-broadcastSignalAction",
    	    "Actions-IntermediateActions-BroadcastSignalAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-BroadcastSignalAction-signal Actions-IntermediateActions-A_signal_broadcastSignalAction-broadcastSignalAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_removeAt_removeStructuralFeatureValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_removeAt_removeStructuralFeatureValueAction", "Actions-IntermediateActions-A_removeAt_removeStructuralFeatureValueAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "removeStructuralFeatureValueAction", 
    	    "Actions-IntermediateActions-A_removeAt_removeStructuralFeatureValueAction-removeStructuralFeatureValueAction",
    	    "Actions-IntermediateActions-RemoveStructuralFeatureValueAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-RemoveStructuralFeatureValueAction-removeAt Actions-IntermediateActions-A_removeAt_removeStructuralFeatureValueAction-removeStructuralFeatureValueAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_destroyAt_linkEndDestructionData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_destroyAt_linkEndDestructionData", "Actions-IntermediateActions-A_destroyAt_linkEndDestructionData");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "linkEndDestructionData", 
    	    "Actions-IntermediateActions-A_destroyAt_linkEndDestructionData-linkEndDestructionData",
    	    "Actions-IntermediateActions-LinkEndDestructionData",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkEndDestructionData-destroyAt Actions-IntermediateActions-A_destroyAt_linkEndDestructionData-linkEndDestructionData");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_endData_destroyLinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_endData_destroyLinkAction", "Actions-IntermediateActions-A_endData_destroyLinkAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "destroyLinkAction", 
    	    "Actions-IntermediateActions-A_endData_destroyLinkAction-destroyLinkAction",
    	    "Actions-IntermediateActions-DestroyLinkAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-DestroyLinkAction-endData Actions-IntermediateActions-A_endData_destroyLinkAction-destroyLinkAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_value_valueSpecificationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_value_valueSpecificationAction", "Actions-IntermediateActions-A_value_valueSpecificationAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "valueSpecificationAction", 
    	    "Actions-IntermediateActions-A_value_valueSpecificationAction-valueSpecificationAction",
    	    "Actions-IntermediateActions-ValueSpecificationAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ValueSpecificationAction-value Actions-IntermediateActions-A_value_valueSpecificationAction-valueSpecificationAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_result_valueSpecificationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_valueSpecificationAction", "Actions-IntermediateActions-A_result_valueSpecificationAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "valueSpecificationAction", 
    	    "Actions-IntermediateActions-A_result_valueSpecificationAction-valueSpecificationAction",
    	    "Actions-IntermediateActions-ValueSpecificationAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ValueSpecificationAction-result Actions-IntermediateActions-A_result_valueSpecificationAction-valueSpecificationAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_inputValue_linkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inputValue_linkAction", "Actions-IntermediateActions-A_inputValue_linkAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "linkAction", 
    	    "Actions-IntermediateActions-A_inputValue_linkAction-linkAction",
    	    "Actions-IntermediateActions-LinkAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkAction-inputValue Actions-IntermediateActions-A_inputValue_linkAction-linkAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_result_writeStructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_writeStructuralFeatureAction", "Actions-IntermediateActions-A_result_writeStructuralFeatureAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "", 
    	    "Actions-IntermediateActions-A_result_writeStructuralFeatureAction-_ownedEnd.0",
    	    "Actions-IntermediateActions-WriteStructuralFeatureAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-WriteStructuralFeatureAction-result Actions-IntermediateActions-A_result_writeStructuralFeatureAction-_ownedEnd.0");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // Actions.IntermediateActions.A_result_clearStructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_clearStructuralFeatureAction", "Actions-IntermediateActions-A_result_clearStructuralFeatureAction");
        mapping.mapAssociation(assoc, "Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "", 
    	    "Actions-IntermediateActions-A_result_clearStructuralFeatureAction-_ownedEnd.0",
    	    "Actions-IntermediateActions-ClearStructuralFeatureAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ClearStructuralFeatureAction-result Actions-IntermediateActions-A_result_clearStructuralFeatureAction-_ownedEnd.0");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.A_behavior_callBehaviorAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_behavior_callBehaviorAction", "Actions-BasicActions-A_behavior_callBehaviorAction");
        mapping.mapAssociation(assoc, "Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "callBehaviorAction", 
    	    "Actions-BasicActions-A_behavior_callBehaviorAction-callBehaviorAction",
    	    "Actions-BasicActions-CallBehaviorAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-BasicActions-CallBehaviorAction-behavior Actions-BasicActions-A_behavior_callBehaviorAction-callBehaviorAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.A_operation_callOperationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_operation_callOperationAction", "Actions-BasicActions-A_operation_callOperationAction");
        mapping.mapAssociation(assoc, "Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "callOperationAction", 
    	    "Actions-BasicActions-A_operation_callOperationAction-callOperationAction",
    	    "Actions-BasicActions-CallOperationAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-BasicActions-CallOperationAction-operation Actions-BasicActions-A_operation_callOperationAction-callOperationAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.A_target_callOperationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_target_callOperationAction", "Actions-BasicActions-A_target_callOperationAction");
        mapping.mapAssociation(assoc, "Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "callOperationAction", 
    	    "Actions-BasicActions-A_target_callOperationAction-callOperationAction",
    	    "Actions-BasicActions-CallOperationAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-BasicActions-CallOperationAction-target Actions-BasicActions-A_target_callOperationAction-callOperationAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.A_target_sendSignalAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_target_sendSignalAction", "Actions-BasicActions-A_target_sendSignalAction");
        mapping.mapAssociation(assoc, "Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "sendSignalAction", 
    	    "Actions-BasicActions-A_target_sendSignalAction-sendSignalAction",
    	    "Actions-BasicActions-SendSignalAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-BasicActions-SendSignalAction-target Actions-BasicActions-A_target_sendSignalAction-sendSignalAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.A_signal_sendSignalAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_signal_sendSignalAction", "Actions-BasicActions-A_signal_sendSignalAction");
        mapping.mapAssociation(assoc, "Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "sendSignalAction", 
    	    "Actions-BasicActions-A_signal_sendSignalAction-sendSignalAction",
    	    "Actions-BasicActions-SendSignalAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-BasicActions-SendSignalAction-signal Actions-BasicActions-A_signal_sendSignalAction-sendSignalAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.A_result_callAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_callAction", "Actions-BasicActions-A_result_callAction");
        mapping.mapAssociation(assoc, "Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "callAction", 
    	    "Actions-BasicActions-A_result_callAction-callAction",
    	    "Actions-BasicActions-CallAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-BasicActions-CallAction-result Actions-BasicActions-A_result_callAction-callAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.A_argument_invocationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_argument_invocationAction", "Actions-BasicActions-A_argument_invocationAction");
        mapping.mapAssociation(assoc, "Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "invocationAction", 
    	    "Actions-BasicActions-A_argument_invocationAction-invocationAction",
    	    "Actions-BasicActions-InvocationAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-BasicActions-InvocationAction-argument Actions-BasicActions-A_argument_invocationAction-invocationAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.A_action_output 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_action_output", "Actions-BasicActions-A_action_output");
        mapping.mapAssociation(assoc, "Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "action", 
    	    "Actions-BasicActions-A_action_output-action",
    	    "Actions-BasicActions-Action",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-BasicActions-A_action_output-action Actions-BasicActions-Action-output");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.A_action_input 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_action_input", "Actions-BasicActions-A_action_input");
        mapping.mapAssociation(assoc, "Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "action", 
    	    "Actions-BasicActions-A_action_input-action",
    	    "Actions-BasicActions-Action",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-BasicActions-A_action_input-action Actions-BasicActions-Action-input");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.A_value_valuePin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_value_valuePin", "Actions-BasicActions-A_value_valuePin");
        mapping.mapAssociation(assoc, "Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "valuePin", 
    	    "Actions-BasicActions-A_value_valuePin-valuePin",
    	    "Actions-BasicActions-ValuePin",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-BasicActions-ValuePin-value Actions-BasicActions-A_value_valuePin-valuePin");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.A_context_action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_context_action", "Actions-BasicActions-A_context_action");
        mapping.mapAssociation(assoc, "Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "action", 
    	    "Actions-BasicActions-A_context_action-action",
    	    "Actions-BasicActions-Action",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-BasicActions-Action-context Actions-BasicActions-A_context_action-action");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.A_inputValue_opaqueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inputValue_opaqueAction", "Actions-BasicActions-A_inputValue_opaqueAction");
        mapping.mapAssociation(assoc, "Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "opaqueAction", 
    	    "Actions-BasicActions-A_inputValue_opaqueAction-opaqueAction",
    	    "Actions-BasicActions-OpaqueAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-BasicActions-OpaqueAction-inputValue Actions-BasicActions-A_inputValue_opaqueAction-opaqueAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // Actions.BasicActions.A_outputValue_opaqueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_outputValue_opaqueAction", "Actions-BasicActions-A_outputValue_opaqueAction");
        mapping.mapAssociation(assoc, "Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "opaqueAction", 
    	    "Actions-BasicActions-A_outputValue_opaqueAction-opaqueAction",
    	    "Actions-BasicActions-OpaqueAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-BasicActions-OpaqueAction-outputValue Actions-BasicActions-A_outputValue_opaqueAction-opaqueAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // Actions.StructuredActions.A_variable_variableAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_variable_variableAction", "Actions-StructuredActions-A_variable_variableAction");
        mapping.mapAssociation(assoc, "Actions.StructuredActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "variableAction", 
    	    "Actions-StructuredActions-A_variable_variableAction-variableAction",
    	    "Actions-StructuredActions-VariableAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-StructuredActions-VariableAction-variable Actions-StructuredActions-A_variable_variableAction-variableAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // Actions.StructuredActions.A_result_readVariableAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readVariableAction", "Actions-StructuredActions-A_result_readVariableAction");
        mapping.mapAssociation(assoc, "Actions.StructuredActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readVariableAction", 
    	    "Actions-StructuredActions-A_result_readVariableAction-readVariableAction",
    	    "Actions-StructuredActions-ReadVariableAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-StructuredActions-ReadVariableAction-result Actions-StructuredActions-A_result_readVariableAction-readVariableAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // Actions.StructuredActions.A_value_writeVariableAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_value_writeVariableAction", "Actions-StructuredActions-A_value_writeVariableAction");
        mapping.mapAssociation(assoc, "Actions.StructuredActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "writeVariableAction", 
    	    "Actions-StructuredActions-A_value_writeVariableAction-writeVariableAction",
    	    "Actions-StructuredActions-WriteVariableAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-StructuredActions-WriteVariableAction-value Actions-StructuredActions-A_value_writeVariableAction-writeVariableAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // Actions.StructuredActions.A_insertAt_addVariableValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_insertAt_addVariableValueAction", "Actions-StructuredActions-A_insertAt_addVariableValueAction");
        mapping.mapAssociation(assoc, "Actions.StructuredActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "addVariableValueAction", 
    	    "Actions-StructuredActions-A_insertAt_addVariableValueAction-addVariableValueAction",
    	    "Actions-StructuredActions-AddVariableValueAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-StructuredActions-AddVariableValueAction-insertAt Actions-StructuredActions-A_insertAt_addVariableValueAction-addVariableValueAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // Actions.StructuredActions.A_removeAt_removeVariableValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_removeAt_removeVariableValueAction", "Actions-StructuredActions-A_removeAt_removeVariableValueAction");
        mapping.mapAssociation(assoc, "Actions.StructuredActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "removeVariableValueAction", 
    	    "Actions-StructuredActions-A_removeAt_removeVariableValueAction-removeVariableValueAction",
    	    "Actions-StructuredActions-RemoveVariableValueAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-StructuredActions-RemoveVariableValueAction-removeAt Actions-StructuredActions-A_removeAt_removeVariableValueAction-removeVariableValueAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // Actions.StructuredActions.A_fromAction_actionInputPin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_fromAction_actionInputPin", "Actions-StructuredActions-A_fromAction_actionInputPin");
        mapping.mapAssociation(assoc, "Actions.StructuredActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "actionInputPin", 
    	    "Actions-StructuredActions-A_fromAction_actionInputPin-actionInputPin",
    	    "Actions-StructuredActions-ActionInputPin",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-StructuredActions-ActionInputPin-fromAction Actions-StructuredActions-A_fromAction_actionInputPin-actionInputPin");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // Actions.StructuredActions.A_exception_raiseExceptionAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_exception_raiseExceptionAction", "Actions-StructuredActions-A_exception_raiseExceptionAction");
        mapping.mapAssociation(assoc, "Actions.StructuredActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "raiseExceptionAction", 
    	    "Actions-StructuredActions-A_exception_raiseExceptionAction-raiseExceptionAction",
    	    "Actions-StructuredActions-RaiseExceptionAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Actions-StructuredActions-RaiseExceptionAction-exception Actions-StructuredActions-A_exception_raiseExceptionAction-raiseExceptionAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.A_activity_edge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_activity_edge", "Activities-BasicActivities-A_activity_edge");
        mapping.mapAssociation(assoc, "Activities.BasicActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityEdge-activity Activities-BasicActivities-Activity-edge");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.A_outgoing_source 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_outgoing_source", "Activities-BasicActivities-A_outgoing_source");
        mapping.mapAssociation(assoc, "Activities.BasicActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityNode-outgoing Activities-BasicActivities-ActivityEdge-source");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.A_target_incoming 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_target_incoming", "Activities-BasicActivities-A_target_incoming");
        mapping.mapAssociation(assoc, "Activities.BasicActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityEdge-target Activities-BasicActivities-ActivityNode-incoming");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.A_containedEdge_inGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_containedEdge_inGroup", "Activities-BasicActivities-A_containedEdge_inGroup");
        mapping.mapAssociation(assoc, "Activities.BasicActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityGroup-containedEdge Activities-BasicActivities-ActivityEdge-inGroup");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.A_parameter_activityParameterNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_parameter_activityParameterNode", "Activities-BasicActivities-A_parameter_activityParameterNode");
        mapping.mapAssociation(assoc, "Activities.BasicActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "activityParameterNode", 
    	    "Activities-BasicActivities-A_parameter_activityParameterNode-activityParameterNode",
    	    "Activities-BasicActivities-ActivityParameterNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityParameterNode-parameter Activities-BasicActivities-A_parameter_activityParameterNode-activityParameterNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.A_redefinedNode_activityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedNode_activityNode", "Activities-BasicActivities-A_redefinedNode_activityNode");
        mapping.mapAssociation(assoc, "Activities.BasicActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "activityNode", 
    	    "Activities-BasicActivities-A_redefinedNode_activityNode-activityNode",
    	    "Activities-BasicActivities-ActivityNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityNode-redefinedNode Activities-BasicActivities-A_redefinedNode_activityNode-activityNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // Activities.BasicActivities.A_redefinedEdge_activityEdge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedEdge_activityEdge", "Activities-BasicActivities-A_redefinedEdge_activityEdge");
        mapping.mapAssociation(assoc, "Activities.BasicActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "activityEdge", 
    	    "Activities-BasicActivities-A_redefinedEdge_activityEdge-activityEdge",
    	    "Activities-BasicActivities-ActivityEdge",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityEdge-redefinedEdge Activities-BasicActivities-A_redefinedEdge_activityEdge-activityEdge");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.A_edge_inPartition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_edge_inPartition", "Activities-IntermediateActivities-A_edge_inPartition");
        mapping.mapAssociation(assoc, "Activities.IntermediateActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityPartition-edge Activities-IntermediateActivities-ActivityEdge-inPartition");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.A_inPartition_node 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inPartition_node", "Activities-IntermediateActivities-A_inPartition_node");
        mapping.mapAssociation(assoc, "Activities.IntermediateActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityNode-inPartition Activities-IntermediateActivities-ActivityPartition-node");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.A_subpartition_superPartition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_subpartition_superPartition", "Activities-IntermediateActivities-A_subpartition_superPartition");
        mapping.mapAssociation(assoc, "Activities.IntermediateActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityPartition-subpartition Activities-IntermediateActivities-ActivityPartition-superPartition");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.A_represents_activityPartition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_represents_activityPartition", "Activities-IntermediateActivities-A_represents_activityPartition");
        mapping.mapAssociation(assoc, "Activities.IntermediateActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "activityPartition", 
    	    "Activities-IntermediateActivities-A_represents_activityPartition-activityPartition",
    	    "Activities-IntermediateActivities-ActivityPartition",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityPartition-represents Activities-IntermediateActivities-A_represents_activityPartition-activityPartition");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.A_activityEdge_guard 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_activityEdge_guard", "Activities-IntermediateActivities-A_activityEdge_guard");
        mapping.mapAssociation(assoc, "Activities.IntermediateActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "activityEdge", 
    	    "Activities-IntermediateActivities-A_activityEdge_guard-activityEdge",
    	    "Activities-IntermediateActivities-ActivityEdge",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-A_activityEdge_guard-activityEdge Activities-IntermediateActivities-ActivityEdge-guard");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.A_decisionInput_decisionNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_decisionInput_decisionNode", "Activities-IntermediateActivities-A_decisionInput_decisionNode");
        mapping.mapAssociation(assoc, "Activities.IntermediateActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "decisionNode", 
    	    "Activities-IntermediateActivities-A_decisionInput_decisionNode-decisionNode",
    	    "Activities-IntermediateActivities-DecisionNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-DecisionNode-decisionInput Activities-IntermediateActivities-A_decisionInput_decisionNode-decisionNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.A_containedNode_inGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_containedNode_inGroup", "Activities-IntermediateActivities-A_containedNode_inGroup");
        mapping.mapAssociation(assoc, "Activities.IntermediateActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityGroup-containedNode Activities-IntermediateActivities-ActivityNode-inGroup");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.A_containedEdge_inGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_containedEdge_inGroup", "Activities-IntermediateActivities-A_containedEdge_inGroup");
        mapping.mapAssociation(assoc, "Activities.IntermediateActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityGroup-containedEdge Activities-IntermediateActivities-ActivityEdge-inGroup");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.A_partition_activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_partition_activity", "Activities-IntermediateActivities-A_partition_activity");
        mapping.mapAssociation(assoc, "Activities.IntermediateActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "activity", 
    	    "Activities-IntermediateActivities-A_partition_activity-activity",
    	    "Activities-IntermediateActivities-Activity",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-Activity-partition Activities-IntermediateActivities-A_partition_activity-activity");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.A_group_inActivity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_group_inActivity", "Activities-IntermediateActivities-A_group_inActivity");
        mapping.mapAssociation(assoc, "Activities.IntermediateActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-Activity-group Activities-IntermediateActivities-ActivityGroup-inActivity");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // Activities.IntermediateActivities.A_decisionInputFlow_decisionNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_decisionInputFlow_decisionNode", "Activities-IntermediateActivities-A_decisionInputFlow_decisionNode");
        mapping.mapAssociation(assoc, "Activities.IntermediateActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "", 
    	    "Activities-IntermediateActivities-A_decisionInputFlow_decisionNode-_ownedEnd.0",
    	    "Activities-IntermediateActivities-DecisionNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-DecisionNode-decisionInputFlow Activities-IntermediateActivities-A_decisionInputFlow_decisionNode-_ownedEnd.0");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_weight_activityEdge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_weight_activityEdge", "Activities-CompleteActivities-A_weight_activityEdge");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "activityEdge", 
    	    "Activities-CompleteActivities-A_weight_activityEdge-activityEdge",
    	    "Activities-CompleteActivities-ActivityEdge",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ActivityEdge-weight Activities-CompleteActivities-A_weight_activityEdge-activityEdge");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_upperBound_objectNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_upperBound_objectNode", "Activities-CompleteActivities-A_upperBound_objectNode");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "objectNode", 
    	    "Activities-CompleteActivities-A_upperBound_objectNode-objectNode",
    	    "Activities-CompleteActivities-ObjectNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ObjectNode-upperBound Activities-CompleteActivities-A_upperBound_objectNode-objectNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_inState_objectNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inState_objectNode", "Activities-CompleteActivities-A_inState_objectNode");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "objectNode", 
    	    "Activities-CompleteActivities-A_inState_objectNode-objectNode",
    	    "Activities-CompleteActivities-ObjectNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ObjectNode-inState Activities-CompleteActivities-A_inState_objectNode-objectNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_parameterSet_parameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_parameterSet_parameter", "Activities-CompleteActivities-A_parameterSet_parameter");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-Parameter-parameterSet Activities-CompleteActivities-ParameterSet-parameter");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_transformation_objectFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_transformation_objectFlow", "Activities-CompleteActivities-A_transformation_objectFlow");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "objectFlow", 
    	    "Activities-CompleteActivities-A_transformation_objectFlow-objectFlow",
    	    "Activities-CompleteActivities-ObjectFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ObjectFlow-transformation Activities-CompleteActivities-A_transformation_objectFlow-objectFlow");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_action_localPrecondition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_action_localPrecondition", "Activities-CompleteActivities-A_action_localPrecondition");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "action", 
    	    "Activities-CompleteActivities-A_action_localPrecondition-action",
    	    "Activities-CompleteActivities-Action",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-A_action_localPrecondition-action Activities-CompleteActivities-Action-localPrecondition");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_action_localPostcondition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_action_localPostcondition", "Activities-CompleteActivities-A_action_localPostcondition");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "action", 
    	    "Activities-CompleteActivities-A_action_localPostcondition-action",
    	    "Activities-CompleteActivities-Action",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-A_action_localPostcondition-action Activities-CompleteActivities-Action-localPostcondition");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_interruptingEdge_interrupts 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_interruptingEdge_interrupts", "Activities-CompleteActivities-A_interruptingEdge_interrupts");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-InterruptibleActivityRegion-interruptingEdge Activities-CompleteActivities-ActivityEdge-interrupts");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_inInterruptibleRegion_node 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inInterruptibleRegion_node", "Activities-CompleteActivities-A_inInterruptibleRegion_node");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ActivityNode-inInterruptibleRegion Activities-CompleteActivities-InterruptibleActivityRegion-node");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_selection_objectFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_selection_objectFlow", "Activities-CompleteActivities-A_selection_objectFlow");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "objectFlow", 
    	    "Activities-CompleteActivities-A_selection_objectFlow-objectFlow",
    	    "Activities-CompleteActivities-ObjectFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ObjectFlow-selection Activities-CompleteActivities-A_selection_objectFlow-objectFlow");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_selection_objectNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_selection_objectNode", "Activities-CompleteActivities-A_selection_objectNode");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "objectNode", 
    	    "Activities-CompleteActivities-A_selection_objectNode-objectNode",
    	    "Activities-CompleteActivities-ObjectNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ObjectNode-selection Activities-CompleteActivities-A_selection_objectNode-objectNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_condition_parameterSet 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_condition_parameterSet", "Activities-CompleteActivities-A_condition_parameterSet");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "parameterSet", 
    	    "Activities-CompleteActivities-A_condition_parameterSet-parameterSet",
    	    "Activities-CompleteActivities-ParameterSet",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ParameterSet-condition Activities-CompleteActivities-A_condition_parameterSet-parameterSet");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_ownedParameterSet_behavioralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedParameterSet_behavioralFeature", "Activities-CompleteActivities-A_ownedParameterSet_behavioralFeature");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavioralFeature", 
    	    "Activities-CompleteActivities-A_ownedParameterSet_behavioralFeature-behavioralFeature",
    	    "Activities-CompleteActivities-BehavioralFeature",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-BehavioralFeature-ownedParameterSet Activities-CompleteActivities-A_ownedParameterSet_behavioralFeature-behavioralFeature");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_ownedParameterSet_behavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedParameterSet_behavior", "Activities-CompleteActivities-A_ownedParameterSet_behavior");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavior", 
    	    "Activities-CompleteActivities-A_ownedParameterSet_behavior-behavior",
    	    "Activities-CompleteActivities-Behavior",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-Behavior-ownedParameterSet Activities-CompleteActivities-A_ownedParameterSet_behavior-behavior");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_containedNode_inGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_containedNode_inGroup", "Activities-CompleteActivities-A_containedNode_inGroup");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ActivityGroup-containedNode Activities-CompleteActivities-ActivityNode-inGroup");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // Activities.CompleteActivities.A_joinSpec_joinNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_joinSpec_joinNode", "Activities-CompleteActivities-A_joinSpec_joinNode");
        mapping.mapAssociation(assoc, "Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "joinNode", 
    	    "Activities-CompleteActivities-A_joinSpec_joinNode-joinNode",
    	    "Activities-CompleteActivities-JoinNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-JoinNode-joinSpec Activities-CompleteActivities-A_joinSpec_joinNode-joinNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_scope_variable 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_scope_variable", "Activities-StructuredActivities-A_scope_variable");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Variable-scope Activities-StructuredActivities-StructuredActivityNode-variable");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_node_inStructuredNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_node_inStructuredNode", "Activities-StructuredActivities-A_node_inStructuredNode");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-StructuredActivityNode-node Activities-StructuredActivities-ActivityNode-inStructuredNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_clause_test 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_clause_test", "Activities-StructuredActivities-A_clause_test");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "clause", 
    	    "Activities-StructuredActivities-A_clause_test-clause",
    	    "Activities-StructuredActivities-Clause",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-A_clause_test-clause Activities-StructuredActivities-Clause-test");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_clause_body 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_clause_body", "Activities-StructuredActivities-A_clause_body");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "clause", 
    	    "Activities-StructuredActivities-A_clause_body-clause",
    	    "Activities-StructuredActivities-Clause",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-A_clause_body-clause Activities-StructuredActivities-Clause-body");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_predecessorClause_successorClause 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_predecessorClause_successorClause", "Activities-StructuredActivities-A_predecessorClause_successorClause");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Clause-predecessorClause Activities-StructuredActivities-Clause-successorClause");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_loopNode_bodyPart 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_loopNode_bodyPart", "Activities-StructuredActivities-A_loopNode_bodyPart");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-StructuredActivities-A_loopNode_bodyPart-loopNode",
    	    "Activities-StructuredActivities-LoopNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-A_loopNode_bodyPart-loopNode Activities-StructuredActivities-LoopNode-bodyPart");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_loopNode_setupPart 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_loopNode_setupPart", "Activities-StructuredActivities-A_loopNode_setupPart");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-StructuredActivities-A_loopNode_setupPart-loopNode",
    	    "Activities-StructuredActivities-LoopNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-A_loopNode_setupPart-loopNode Activities-StructuredActivities-LoopNode-setupPart");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_clause_conditionalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_clause_conditionalNode", "Activities-StructuredActivities-A_clause_conditionalNode");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "conditionalNode", 
    	    "Activities-StructuredActivities-A_clause_conditionalNode-conditionalNode",
    	    "Activities-StructuredActivities-ConditionalNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-ConditionalNode-clause Activities-StructuredActivities-A_clause_conditionalNode-conditionalNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_decider_clause 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_decider_clause", "Activities-StructuredActivities-A_decider_clause");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "clause", 
    	    "Activities-StructuredActivities-A_decider_clause-clause",
    	    "Activities-StructuredActivities-Clause",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Clause-decider Activities-StructuredActivities-A_decider_clause-clause");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_decider_loopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_decider_loopNode", "Activities-StructuredActivities-A_decider_loopNode");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-StructuredActivities-A_decider_loopNode-loopNode",
    	    "Activities-StructuredActivities-LoopNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-LoopNode-decider Activities-StructuredActivities-A_decider_loopNode-loopNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_test_loopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_test_loopNode", "Activities-StructuredActivities-A_test_loopNode");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-StructuredActivities-A_test_loopNode-loopNode",
    	    "Activities-StructuredActivities-LoopNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-LoopNode-test Activities-StructuredActivities-A_test_loopNode-loopNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_activity_structuredNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_activity_structuredNode", "Activities-StructuredActivities-A_activity_structuredNode");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-StructuredActivityNode-activity Activities-StructuredActivities-Activity-structuredNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_variable_activityScope 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_variable_activityScope", "Activities-StructuredActivities-A_variable_activityScope");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Activity-variable Activities-StructuredActivities-Variable-activityScope");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_executableNode_sequenceNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_executableNode_sequenceNode", "Activities-StructuredActivities-A_executableNode_sequenceNode");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "sequenceNode", 
    	    "Activities-StructuredActivities-A_executableNode_sequenceNode-sequenceNode",
    	    "Activities-StructuredActivities-SequenceNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-SequenceNode-executableNode Activities-StructuredActivities-A_executableNode_sequenceNode-sequenceNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_containedNode_inGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_containedNode_inGroup", "Activities-StructuredActivities-A_containedNode_inGroup");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-ActivityGroup-containedNode Activities-StructuredActivities-ActivityNode-inGroup");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_group_inActivity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_group_inActivity", "Activities-StructuredActivities-A_group_inActivity");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Activity-group Activities-StructuredActivities-ActivityGroup-inActivity");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // Activities.StructuredActivities.A_node_activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_node_activity", "Activities-StructuredActivities-A_node_activity");
        mapping.mapAssociation(assoc, "Activities.StructuredActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Activity-node Activities-StructuredActivities-ActivityNode-activity");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // Activities.ExtraStructuredActivities.A_outputElement_regionAsOutput 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_outputElement_regionAsOutput", "Activities-ExtraStructuredActivities-A_outputElement_regionAsOutput");
        mapping.mapAssociation(assoc, "Activities.ExtraStructuredActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExpansionRegion-outputElement Activities-ExtraStructuredActivities-ExpansionNode-regionAsOutput");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // Activities.ExtraStructuredActivities.A_inputElement_regionAsInput 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inputElement_regionAsInput", "Activities-ExtraStructuredActivities-A_inputElement_regionAsInput");
        mapping.mapAssociation(assoc, "Activities.ExtraStructuredActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExpansionRegion-inputElement Activities-ExtraStructuredActivities-ExpansionNode-regionAsInput");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // Activities.ExtraStructuredActivities.A_handler_protectedNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_handler_protectedNode", "Activities-ExtraStructuredActivities-A_handler_protectedNode");
        mapping.mapAssociation(assoc, "Activities.ExtraStructuredActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExecutableNode-handler Activities-ExtraStructuredActivities-ExceptionHandler-protectedNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // Activities.ExtraStructuredActivities.A_handlerBody_exceptionHandler 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_handlerBody_exceptionHandler", "Activities-ExtraStructuredActivities-A_handlerBody_exceptionHandler");
        mapping.mapAssociation(assoc, "Activities.ExtraStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "exceptionHandler", 
    	    "Activities-ExtraStructuredActivities-A_handlerBody_exceptionHandler-exceptionHandler",
    	    "Activities-ExtraStructuredActivities-ExceptionHandler",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExceptionHandler-handlerBody Activities-ExtraStructuredActivities-A_handlerBody_exceptionHandler-exceptionHandler");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // Activities.ExtraStructuredActivities.A_exceptionInput_exceptionHandler 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_exceptionInput_exceptionHandler", "Activities-ExtraStructuredActivities-A_exceptionInput_exceptionHandler");
        mapping.mapAssociation(assoc, "Activities.ExtraStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "exceptionHandler", 
    	    "Activities-ExtraStructuredActivities-A_exceptionInput_exceptionHandler-exceptionHandler",
    	    "Activities-ExtraStructuredActivities-ExceptionHandler",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExceptionHandler-exceptionInput Activities-ExtraStructuredActivities-A_exceptionInput_exceptionHandler-exceptionHandler");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // Activities.ExtraStructuredActivities.A_exceptionType_exceptionHandler 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_exceptionType_exceptionHandler", "Activities-ExtraStructuredActivities-A_exceptionType_exceptionHandler");
        mapping.mapAssociation(assoc, "Activities.ExtraStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "exceptionHandler", 
    	    "Activities-ExtraStructuredActivities-A_exceptionType_exceptionHandler-exceptionHandler",
    	    "Activities-ExtraStructuredActivities-ExceptionHandler",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExceptionHandler-exceptionType Activities-ExtraStructuredActivities-A_exceptionType_exceptionHandler-exceptionHandler");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // Activities.CompleteStructuredActivities.A_result_conditionalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_conditionalNode", "Activities-CompleteStructuredActivities-A_result_conditionalNode");
        mapping.mapAssociation(assoc, "Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "conditionalNode", 
    	    "Activities-CompleteStructuredActivities-A_result_conditionalNode-conditionalNode",
    	    "Activities-CompleteStructuredActivities-ConditionalNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-ConditionalNode-result Activities-CompleteStructuredActivities-A_result_conditionalNode-conditionalNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // Activities.CompleteStructuredActivities.A_result_loopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_loopNode", "Activities-CompleteStructuredActivities-A_result_loopNode");
        mapping.mapAssociation(assoc, "Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-CompleteStructuredActivities-A_result_loopNode-loopNode",
    	    "Activities-CompleteStructuredActivities-LoopNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-LoopNode-result Activities-CompleteStructuredActivities-A_result_loopNode-loopNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // Activities.CompleteStructuredActivities.A_loopVariable_loopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_loopVariable_loopNode", "Activities-CompleteStructuredActivities-A_loopVariable_loopNode");
        mapping.mapAssociation(assoc, "Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-CompleteStructuredActivities-A_loopVariable_loopNode-loopNode",
    	    "Activities-CompleteStructuredActivities-LoopNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-LoopNode-loopVariable Activities-CompleteStructuredActivities-A_loopVariable_loopNode-loopNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // Activities.CompleteStructuredActivities.A_bodyOutput_loopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_bodyOutput_loopNode", "Activities-CompleteStructuredActivities-A_bodyOutput_loopNode");
        mapping.mapAssociation(assoc, "Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-CompleteStructuredActivities-A_bodyOutput_loopNode-loopNode",
    	    "Activities-CompleteStructuredActivities-LoopNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-LoopNode-bodyOutput Activities-CompleteStructuredActivities-A_bodyOutput_loopNode-loopNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // Activities.CompleteStructuredActivities.A_bodyOutput_clause 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_bodyOutput_clause", "Activities-CompleteStructuredActivities-A_bodyOutput_clause");
        mapping.mapAssociation(assoc, "Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "clause", 
    	    "Activities-CompleteStructuredActivities-A_bodyOutput_clause-clause",
    	    "Activities-CompleteStructuredActivities-Clause",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-Clause-bodyOutput Activities-CompleteStructuredActivities-A_bodyOutput_clause-clause");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // Activities.CompleteStructuredActivities.A_loopVariableInput_loopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_loopVariableInput_loopNode", "Activities-CompleteStructuredActivities-A_loopVariableInput_loopNode");
        mapping.mapAssociation(assoc, "Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-CompleteStructuredActivities-A_loopVariableInput_loopNode-loopNode",
    	    "Activities-CompleteStructuredActivities-LoopNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-LoopNode-loopVariableInput Activities-CompleteStructuredActivities-A_loopVariableInput_loopNode-loopNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // Activities.CompleteStructuredActivities.A_edge_inStructuredNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_edge_inStructuredNode", "Activities-CompleteStructuredActivities-A_edge_inStructuredNode");
        mapping.mapAssociation(assoc, "Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-StructuredActivityNode-edge Activities-CompleteStructuredActivities-ActivityEdge-inStructuredNode");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // Activities.CompleteStructuredActivities.A_containedEdge_inGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_containedEdge_inGroup", "Activities-CompleteStructuredActivities-A_containedEdge_inGroup");
        mapping.mapAssociation(assoc, "Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-ActivityGroup-containedEdge Activities-CompleteStructuredActivities-ActivityEdge-inGroup");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // Activities.FundamentalActivities.A_node_activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_node_activity", "Activities-FundamentalActivities-A_node_activity");
        mapping.mapAssociation(assoc, "Activities.FundamentalActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-FundamentalActivities-Activity-node Activities-FundamentalActivities-ActivityNode-activity");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // Activities.FundamentalActivities.A_containedNode_inGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_containedNode_inGroup", "Activities-FundamentalActivities-A_containedNode_inGroup");
        mapping.mapAssociation(assoc, "Activities.FundamentalActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-FundamentalActivities-ActivityGroup-containedNode Activities-FundamentalActivities-ActivityNode-inGroup");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // Activities.FundamentalActivities.A_group_inActivity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_group_inActivity", "Activities-FundamentalActivities-A_group_inActivity");
        mapping.mapAssociation(assoc, "Activities.FundamentalActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-FundamentalActivities-Activity-group Activities-FundamentalActivities-ActivityGroup-inActivity");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // Activities.FundamentalActivities.A_subgroup_superGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_subgroup_superGroup", "Activities-FundamentalActivities-A_subgroup_superGroup");
        mapping.mapAssociation(assoc, "Activities.FundamentalActivities", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Activities-FundamentalActivities-ActivityGroup-subgroup Activities-FundamentalActivities-ActivityGroup-superGroup");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // AuxiliaryConstructs.InformationFlows.A_realization_abstraction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_realization_abstraction", "AuxiliaryConstructs-InformationFlows-A_realization_abstraction");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "abstraction", 
    	    "AuxiliaryConstructs-InformationFlows-A_realization_abstraction-abstraction",
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-realization AuxiliaryConstructs-InformationFlows-A_realization_abstraction-abstraction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // AuxiliaryConstructs.InformationFlows.A_represented_representation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_represented_representation", "AuxiliaryConstructs-InformationFlows-A_represented_representation");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "informationItem", 
    	    "AuxiliaryConstructs-InformationFlows-A_represented_representation-informationItem",
    	    "AuxiliaryConstructs-InformationFlows-InformationItem",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationItem-represented AuxiliaryConstructs-InformationFlows-A_represented_representation-informationItem");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // AuxiliaryConstructs.InformationFlows.A_conveyed_informationFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_conveyed_informationFlow", "AuxiliaryConstructs-InformationFlows-A_conveyed_informationFlow");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "informationFlow", 
    	    "AuxiliaryConstructs-InformationFlows-A_conveyed_informationFlow-informationFlow",
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-conveyed AuxiliaryConstructs-InformationFlows-A_conveyed_informationFlow-informationFlow");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // AuxiliaryConstructs.InformationFlows.A_informationSource_informationFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_informationSource_informationFlow", "AuxiliaryConstructs-InformationFlows-A_informationSource_informationFlow");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "informationFlow", 
    	    "AuxiliaryConstructs-InformationFlows-A_informationSource_informationFlow-informationFlow",
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-informationSource AuxiliaryConstructs-InformationFlows-A_informationSource_informationFlow-informationFlow");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // AuxiliaryConstructs.InformationFlows.A_informationTarget_informationFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_informationTarget_informationFlow", "AuxiliaryConstructs-InformationFlows-A_informationTarget_informationFlow");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "informationFlow", 
    	    "AuxiliaryConstructs-InformationFlows-A_informationTarget_informationFlow-informationFlow",
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-informationTarget AuxiliaryConstructs-InformationFlows-A_informationTarget_informationFlow-informationFlow");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // AuxiliaryConstructs.InformationFlows.A_realizingActivityEdge_informationFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_realizingActivityEdge_informationFlow", "AuxiliaryConstructs-InformationFlows-A_realizingActivityEdge_informationFlow");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "informationFlow", 
    	    "AuxiliaryConstructs-InformationFlows-A_realizingActivityEdge_informationFlow-informationFlow",
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingActivityEdge AuxiliaryConstructs-InformationFlows-A_realizingActivityEdge_informationFlow-informationFlow");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // AuxiliaryConstructs.InformationFlows.A_realizingConnector_informationFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_realizingConnector_informationFlow", "AuxiliaryConstructs-InformationFlows-A_realizingConnector_informationFlow");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "informationFlow", 
    	    "AuxiliaryConstructs-InformationFlows-A_realizingConnector_informationFlow-informationFlow",
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingConnector AuxiliaryConstructs-InformationFlows-A_realizingConnector_informationFlow-informationFlow");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // AuxiliaryConstructs.InformationFlows.A_realizingMessage_informationFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_realizingMessage_informationFlow", "AuxiliaryConstructs-InformationFlows-A_realizingMessage_informationFlow");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "informationFlow", 
    	    "AuxiliaryConstructs-InformationFlows-A_realizingMessage_informationFlow-informationFlow",
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingMessage AuxiliaryConstructs-InformationFlows-A_realizingMessage_informationFlow-informationFlow");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_parameter_templateSignature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_parameter_templateSignature", "AuxiliaryConstructs-Templates-A_parameter_templateSignature");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "templateSignature", 
    	    "AuxiliaryConstructs-Templates-A_parameter_templateSignature-templateSignature",
    	    "AuxiliaryConstructs-Templates-TemplateSignature",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateSignature-parameter AuxiliaryConstructs-Templates-A_parameter_templateSignature-templateSignature");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_ownedParameter_signature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedParameter_signature", "AuxiliaryConstructs-Templates-A_ownedParameter_signature");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateSignature-ownedParameter AuxiliaryConstructs-Templates-TemplateParameter-signature");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_boundElement_templateBinding 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_boundElement_templateBinding", "AuxiliaryConstructs-Templates-A_boundElement_templateBinding");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateBinding-boundElement AuxiliaryConstructs-Templates-TemplateableElement-templateBinding");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_formal_templateParameterSubstitution 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_formal_templateParameterSubstitution", "AuxiliaryConstructs-Templates-A_formal_templateParameterSubstitution");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "templateParameterSubstitution", 
    	    "AuxiliaryConstructs-Templates-A_formal_templateParameterSubstitution-templateParameterSubstitution",
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-formal AuxiliaryConstructs-Templates-A_formal_templateParameterSubstitution-templateParameterSubstitution");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_signature_templateBinding 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_signature_templateBinding", "AuxiliaryConstructs-Templates-A_signature_templateBinding");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "templateBinding", 
    	    "AuxiliaryConstructs-Templates-A_signature_templateBinding-templateBinding",
    	    "AuxiliaryConstructs-Templates-TemplateBinding",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateBinding-signature AuxiliaryConstructs-Templates-A_signature_templateBinding-templateBinding");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_parameterSubstitution_templateBinding 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_parameterSubstitution_templateBinding", "AuxiliaryConstructs-Templates-A_parameterSubstitution_templateBinding");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateBinding-parameterSubstitution AuxiliaryConstructs-Templates-TemplateParameterSubstitution-templateBinding");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_actual_templateParameterSubstitution 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_actual_templateParameterSubstitution", "AuxiliaryConstructs-Templates-A_actual_templateParameterSubstitution");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "templateParameterSubstitution", 
    	    "AuxiliaryConstructs-Templates-A_actual_templateParameterSubstitution-templateParameterSubstitution",
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-actual AuxiliaryConstructs-Templates-A_actual_templateParameterSubstitution-templateParameterSubstitution");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_parameteredElement_templateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_parameteredElement_templateParameter", "AuxiliaryConstructs-Templates-A_parameteredElement_templateParameter");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameter-parameteredElement AuxiliaryConstructs-Templates-ParameterableElement-templateParameter");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_subExpression_owningExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_subExpression_owningExpression", "AuxiliaryConstructs-Templates-A_subExpression_owningExpression");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-StringExpression-subExpression AuxiliaryConstructs-Templates-StringExpression-owningExpression");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_ownedTemplateSignature_template 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedTemplateSignature_template", "AuxiliaryConstructs-Templates-A_ownedTemplateSignature_template");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateableElement-ownedTemplateSignature AuxiliaryConstructs-Templates-TemplateSignature-template");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_ownedParameteredElement_owningTemplateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedParameteredElement_owningTemplateParameter", "AuxiliaryConstructs-Templates-A_ownedParameteredElement_owningTemplateParameter");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameter-ownedParameteredElement AuxiliaryConstructs-Templates-ParameterableElement-owningTemplateParameter");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_default_templateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_default_templateParameter", "AuxiliaryConstructs-Templates-A_default_templateParameter");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "templateParameter", 
    	    "AuxiliaryConstructs-Templates-A_default_templateParameter-templateParameter",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameter-default AuxiliaryConstructs-Templates-A_default_templateParameter-templateParameter");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_ownedDefault_templateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedDefault_templateParameter", "AuxiliaryConstructs-Templates-A_ownedDefault_templateParameter");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "templateParameter", 
    	    "AuxiliaryConstructs-Templates-A_ownedDefault_templateParameter-templateParameter",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameter-ownedDefault AuxiliaryConstructs-Templates-A_ownedDefault_templateParameter-templateParameter");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_ownedActual_templateParameterSubstitution 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedActual_templateParameterSubstitution", "AuxiliaryConstructs-Templates-A_ownedActual_templateParameterSubstitution");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "templateParameterSubstitution", 
    	    "AuxiliaryConstructs-Templates-A_ownedActual_templateParameterSubstitution-templateParameterSubstitution",
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-ownedActual AuxiliaryConstructs-Templates-A_ownedActual_templateParameterSubstitution-templateParameterSubstitution");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_ownedTemplateSignature_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedTemplateSignature_classifier", "AuxiliaryConstructs-Templates-A_ownedTemplateSignature_classifier");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-Classifier-ownedTemplateSignature AuxiliaryConstructs-Templates-RedefinableTemplateSignature-classifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_extendedSignature_redefinableTemplateSignature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_extendedSignature_redefinableTemplateSignature", "AuxiliaryConstructs-Templates-A_extendedSignature_redefinableTemplateSignature");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "redefinableTemplateSignature", 
    	    "AuxiliaryConstructs-Templates-A_extendedSignature_redefinableTemplateSignature-redefinableTemplateSignature",
    	    "AuxiliaryConstructs-Templates-RedefinableTemplateSignature",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-RedefinableTemplateSignature-extendedSignature AuxiliaryConstructs-Templates-A_extendedSignature_redefinableTemplateSignature-redefinableTemplateSignature");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_inheritedParameter_redefinableTemplateSignature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inheritedParameter_redefinableTemplateSignature", "AuxiliaryConstructs-Templates-A_inheritedParameter_redefinableTemplateSignature");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "redefinableTemplateSignature", 
    	    "AuxiliaryConstructs-Templates-A_inheritedParameter_redefinableTemplateSignature-redefinableTemplateSignature",
    	    "AuxiliaryConstructs-Templates-RedefinableTemplateSignature",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-RedefinableTemplateSignature-inheritedParameter AuxiliaryConstructs-Templates-A_inheritedParameter_redefinableTemplateSignature-redefinableTemplateSignature");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_templateParameter_parameteredElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_templateParameter_parameteredElement", "AuxiliaryConstructs-Templates-A_templateParameter_parameteredElement");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-Classifier-templateParameter AuxiliaryConstructs-Templates-ClassifierTemplateParameter-parameteredElement");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_nameExpression_namedElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_nameExpression_namedElement", "AuxiliaryConstructs-Templates-A_nameExpression_namedElement");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "namedElement", 
    	    "AuxiliaryConstructs-Templates-A_nameExpression_namedElement-namedElement",
    	    "AuxiliaryConstructs-Templates-NamedElement",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-NamedElement-nameExpression AuxiliaryConstructs-Templates-A_nameExpression_namedElement-namedElement");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_templateParameter_parameteredElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_templateParameter_parameteredElement", "AuxiliaryConstructs-Templates-A_templateParameter_parameteredElement.1");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-Operation-templateParameter AuxiliaryConstructs-Templates-OperationTemplateParameter-parameteredElement");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_templateParameter_parameteredElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_templateParameter_parameteredElement", "AuxiliaryConstructs-Templates-A_templateParameter_parameteredElement.2");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-ConnectableElement-templateParameter AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter-parameteredElement");
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // AuxiliaryConstructs.Templates.A_constrainingClassifier_classifierTemplateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_constrainingClassifier_classifierTemplateParameter", "AuxiliaryConstructs-Templates-A_constrainingClassifier_classifierTemplateParameter");
        mapping.mapAssociation(assoc, "AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifierTemplateParameter", 
    	    "AuxiliaryConstructs-Templates-A_constrainingClassifier_classifierTemplateParameter-classifierTemplateParameter",
    	    "AuxiliaryConstructs-Templates-ClassifierTemplateParameter",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-ClassifierTemplateParameter-constrainingClassifier AuxiliaryConstructs-Templates-A_constrainingClassifier_classifierTemplateParameter-classifierTemplateParameter");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_ownedElement_owner 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedElement_owner", "Classes-Kernel-A_ownedElement_owner");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Element-ownedElement Classes-Kernel-Element-owner");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_source_directedRelationship 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_source_directedRelationship", "Classes-Kernel-A_source_directedRelationship");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "directedRelationship", 
    	    "Classes-Kernel-A_source_directedRelationship-directedRelationship",
    	    "Classes-Kernel-DirectedRelationship",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-DirectedRelationship-source Classes-Kernel-A_source_directedRelationship-directedRelationship");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_target_directedRelationship 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_target_directedRelationship", "Classes-Kernel-A_target_directedRelationship");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "directedRelationship", 
    	    "Classes-Kernel-A_target_directedRelationship-directedRelationship",
    	    "Classes-Kernel-DirectedRelationship",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-DirectedRelationship-target Classes-Kernel-A_target_directedRelationship-directedRelationship");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_constrainedElement_constraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_constrainedElement_constraint", "Classes-Kernel-A_constrainedElement_constraint");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "constraint", 
    	    "Classes-Kernel-A_constrainedElement_constraint-constraint",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Constraint-constrainedElement Classes-Kernel-A_constrainedElement_constraint-constraint");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_type_typedElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_type_typedElement", "Classes-Kernel-A_type_typedElement");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "typedElement", 
    	    "Classes-Kernel-A_type_typedElement-typedElement",
    	    "Classes-Kernel-TypedElement",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-TypedElement-type Classes-Kernel-A_type_typedElement-typedElement");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_generalization_specific 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_generalization_specific", "Classes-Kernel-A_generalization_specific");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-generalization Classes-Kernel-Generalization-specific");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_general_generalization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_general_generalization", "Classes-Kernel-A_general_generalization");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "generalization", 
    	    "Classes-Kernel-A_general_generalization-generalization",
    	    "Classes-Kernel-Generalization",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Generalization-general Classes-Kernel-A_general_generalization-generalization");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_feature_featuringClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_feature_featuringClassifier", "Classes-Kernel-A_feature_featuringClassifier");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-feature Classes-Kernel-Feature-featuringClassifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_ownedParameter_ownerFormalParam 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedParameter_ownerFormalParam", "Classes-Kernel-A_ownedParameter_ownerFormalParam");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "ownerFormalParam", 
    	    "Classes-Kernel-A_ownedParameter_ownerFormalParam-ownerFormalParam",
    	    "Classes-Kernel-BehavioralFeature",
    	    "Classes-Kernel-NamedElement-namespace",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-BehavioralFeature-ownedParameter Classes-Kernel-A_ownedParameter_ownerFormalParam-ownerFormalParam");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_classifier_instanceSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_classifier_instanceSpecification", "Classes-Kernel-A_classifier_instanceSpecification");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "instanceSpecification", 
    	    "Classes-Kernel-A_classifier_instanceSpecification-instanceSpecification",
    	    "Classes-Kernel-InstanceSpecification",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-InstanceSpecification-classifier Classes-Kernel-A_classifier_instanceSpecification-instanceSpecification");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_slot_owningInstance 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_slot_owningInstance", "Classes-Kernel-A_slot_owningInstance");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-InstanceSpecification-slot Classes-Kernel-Slot-owningInstance");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_definingFeature_slot 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_definingFeature_slot", "Classes-Kernel-A_definingFeature_slot");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "slot", 
    	    "Classes-Kernel-A_definingFeature_slot-slot",
    	    "Classes-Kernel-Slot",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Slot-definingFeature Classes-Kernel-A_definingFeature_slot-slot");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_annotatedElement_comment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_annotatedElement_comment", "Classes-Kernel-A_annotatedElement_comment");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "comment", 
    	    "Classes-Kernel-A_annotatedElement_comment-comment",
    	    "Classes-Kernel-Comment",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Comment-annotatedElement Classes-Kernel-A_annotatedElement_comment-comment");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_ownedComment_owningElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedComment_owningElement", "Classes-Kernel-A_ownedComment_owningElement");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningElement", 
    	    "Classes-Kernel-A_ownedComment_owningElement-owningElement",
    	    "Classes-Kernel-Element",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Element-ownedComment Classes-Kernel-A_ownedComment_owningElement-owningElement");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_importedElement_elementImport 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_importedElement_elementImport", "Classes-Kernel-A_importedElement_elementImport");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "elementImport", 
    	    "Classes-Kernel-A_importedElement_elementImport-elementImport",
    	    "Classes-Kernel-ElementImport",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-ElementImport-importedElement Classes-Kernel-A_importedElement_elementImport-elementImport");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_inheritedMember_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inheritedMember_classifier", "Classes-Kernel-A_inheritedMember_classifier");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifier", 
    	    "Classes-Kernel-A_inheritedMember_classifier-classifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-inheritedMember Classes-Kernel-A_inheritedMember_classifier-classifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_nestedClassifier_class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_nestedClassifier_class", "Classes-Kernel-A_nestedClassifier_class");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "class", 
    	    "Classes-Kernel-A_nestedClassifier_class-class",
    	    "Classes-Kernel-Class",
    	    "Classes-Kernel-NamedElement-namespace Classes-Kernel-RedefinableElement-redefinitionContext",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Class-nestedClassifier Classes-Kernel-A_nestedClassifier_class-class");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_attribute_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_attribute_classifier", "Classes-Kernel-A_attribute_classifier");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifier", 
    	    "Classes-Kernel-A_attribute_classifier-classifier",
    	    "Classes-Kernel-Classifier",
    	    "Classes-Kernel-RedefinableElement-redefinitionContext",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-attribute Classes-Kernel-A_attribute_classifier-classifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_ownedAttribute_class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedAttribute_class", "Classes-Kernel-A_ownedAttribute_class");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Class-ownedAttribute Classes-Kernel-Property-class");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_ownedOperation_class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedOperation_class", "Classes-Kernel-A_ownedOperation_class");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Class-ownedOperation Classes-Kernel-Operation-class");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_precondition_preContext 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_precondition_preContext", "Classes-Kernel-A_precondition_preContext");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "preContext", 
    	    "Classes-Kernel-A_precondition_preContext-preContext",
    	    "Classes-Kernel-Operation",
    	    "Classes-Kernel-Constraint-context",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-precondition Classes-Kernel-A_precondition_preContext-preContext");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_postcondition_postContext 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_postcondition_postContext", "Classes-Kernel-A_postcondition_postContext");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "postContext", 
    	    "Classes-Kernel-A_postcondition_postContext-postContext",
    	    "Classes-Kernel-Operation",
    	    "Classes-Kernel-Constraint-context",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-postcondition Classes-Kernel-A_postcondition_postContext-postContext");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_redefinedOperation_operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedOperation_operation", "Classes-Kernel-A_redefinedOperation_operation");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "operation", 
    	    "Classes-Kernel-A_redefinedOperation_operation-operation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-redefinedOperation Classes-Kernel-A_redefinedOperation_operation-operation");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_redefinedProperty_property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedProperty_property", "Classes-Kernel-A_redefinedProperty_property");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "property", 
    	    "Classes-Kernel-A_redefinedProperty_property-property",
    	    "Classes-Kernel-Property",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Property-redefinedProperty Classes-Kernel-A_redefinedProperty_property-property");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_ownedEnd_owningAssociation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedEnd_owningAssociation", "Classes-Kernel-A_ownedEnd_owningAssociation");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Association-ownedEnd Classes-Kernel-Property-owningAssociation");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_ownedAttribute_datatype 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedAttribute_datatype", "Classes-Kernel-A_ownedAttribute_datatype");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-DataType-ownedAttribute Classes-Kernel-Property-datatype");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_ownedOperation_datatype 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedOperation_datatype", "Classes-Kernel-A_ownedOperation_datatype");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-DataType-ownedOperation Classes-Kernel-Operation-datatype");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_ownedLiteral_enumeration 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedLiteral_enumeration", "Classes-Kernel-A_ownedLiteral_enumeration");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Enumeration-ownedLiteral Classes-Kernel-EnumerationLiteral-enumeration");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_elementImport_importingNamespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_elementImport_importingNamespace", "Classes-Kernel-A_elementImport_importingNamespace");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-elementImport Classes-Kernel-ElementImport-importingNamespace");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_packageImport_importingNamespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_packageImport_importingNamespace", "Classes-Kernel-A_packageImport_importingNamespace");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-packageImport Classes-Kernel-PackageImport-importingNamespace");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_importedPackage_packageImport 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_importedPackage_packageImport", "Classes-Kernel-A_importedPackage_packageImport");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "packageImport", 
    	    "Classes-Kernel-A_importedPackage_packageImport-packageImport",
    	    "Classes-Kernel-PackageImport",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-PackageImport-importedPackage Classes-Kernel-A_importedPackage_packageImport-packageImport");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_redefinedClassifier_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedClassifier_classifier", "Classes-Kernel-A_redefinedClassifier_classifier");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifier", 
    	    "Classes-Kernel-A_redefinedClassifier_classifier-classifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-redefinedClassifier Classes-Kernel-A_redefinedClassifier_classifier-classifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_specification_owningConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_specification_owningConstraint", "Classes-Kernel-A_specification_owningConstraint");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningConstraint", 
    	    "Classes-Kernel-A_specification_owningConstraint-owningConstraint",
    	    "Classes-Kernel-Constraint",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Constraint-specification Classes-Kernel-A_specification_owningConstraint-owningConstraint");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_defaultValue_owningParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_defaultValue_owningParameter", "Classes-Kernel-A_defaultValue_owningParameter");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningParameter", 
    	    "Classes-Kernel-A_defaultValue_owningParameter-owningParameter",
    	    "Classes-Kernel-Parameter",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Parameter-defaultValue Classes-Kernel-A_defaultValue_owningParameter-owningParameter");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_defaultValue_owningProperty 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_defaultValue_owningProperty", "Classes-Kernel-A_defaultValue_owningProperty");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningProperty", 
    	    "Classes-Kernel-A_defaultValue_owningProperty-owningProperty",
    	    "Classes-Kernel-Property",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Property-defaultValue Classes-Kernel-A_defaultValue_owningProperty-owningProperty");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_raisedException_behavioralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_raisedException_behavioralFeature", "Classes-Kernel-A_raisedException_behavioralFeature");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavioralFeature", 
    	    "Classes-Kernel-A_raisedException_behavioralFeature-behavioralFeature",
    	    "Classes-Kernel-BehavioralFeature",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-BehavioralFeature-raisedException Classes-Kernel-A_raisedException_behavioralFeature-behavioralFeature");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_ownedRule_context 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedRule_context", "Classes-Kernel-A_ownedRule_context");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-ownedRule Classes-Kernel-Constraint-context");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_ownedMember_namespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedMember_namespace", "Classes-Kernel-A_ownedMember_namespace");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-ownedMember Classes-Kernel-NamedElement-namespace");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_member_namespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_member_namespace", "Classes-Kernel-A_member_namespace");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "namespace", 
    	    "Classes-Kernel-A_member_namespace-namespace",
    	    "Classes-Kernel-Namespace",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-member Classes-Kernel-A_member_namespace-namespace");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_relatedElement_relationship 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_relatedElement_relationship", "Classes-Kernel-A_relatedElement_relationship");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "relationship", 
    	    "Classes-Kernel-A_relatedElement_relationship-relationship",
    	    "Classes-Kernel-Relationship",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Relationship-relatedElement Classes-Kernel-A_relatedElement_relationship-relationship");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_endType_association 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_endType_association", "Classes-Kernel-A_endType_association");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "association", 
    	    "Classes-Kernel-A_endType_association-association",
    	    "Classes-Kernel-Association",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Association-endType Classes-Kernel-A_endType_association-association");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_upperValue_owningUpper 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_upperValue_owningUpper", "Classes-Kernel-A_upperValue_owningUpper");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningUpper", 
    	    "Classes-Kernel-A_upperValue_owningUpper-owningUpper",
    	    "Classes-Kernel-MultiplicityElement",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-MultiplicityElement-upperValue Classes-Kernel-A_upperValue_owningUpper-owningUpper");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_lowerValue_owningLower 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_lowerValue_owningLower", "Classes-Kernel-A_lowerValue_owningLower");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningLower", 
    	    "Classes-Kernel-A_lowerValue_owningLower-owningLower",
    	    "Classes-Kernel-MultiplicityElement",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-MultiplicityElement-lowerValue Classes-Kernel-A_lowerValue_owningLower-owningLower");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_receivingPackage_packageMerge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_receivingPackage_packageMerge", "Classes-Kernel-A_receivingPackage_packageMerge");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-PackageMerge-receivingPackage Classes-Kernel-Package-packageMerge");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_mergedPackage_packageMerge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_mergedPackage_packageMerge", "Classes-Kernel-A_mergedPackage_packageMerge");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "packageMerge", 
    	    "Classes-Kernel-A_mergedPackage_packageMerge-packageMerge",
    	    "Classes-Kernel-PackageMerge",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-PackageMerge-mergedPackage Classes-Kernel-A_mergedPackage_packageMerge-packageMerge");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_instance_instanceValue 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_instance_instanceValue", "Classes-Kernel-A_instance_instanceValue");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "instanceValue", 
    	    "Classes-Kernel-A_instance_instanceValue-instanceValue",
    	    "Classes-Kernel-InstanceValue",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-InstanceValue-instance Classes-Kernel-A_instance_instanceValue-instanceValue");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_value_owningSlot 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_value_owningSlot", "Classes-Kernel-A_value_owningSlot");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningSlot", 
    	    "Classes-Kernel-A_value_owningSlot-owningSlot",
    	    "Classes-Kernel-Slot",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Slot-value Classes-Kernel-A_value_owningSlot-owningSlot");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_specification_owningInstanceSpec 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_specification_owningInstanceSpec", "Classes-Kernel-A_specification_owningInstanceSpec");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningInstanceSpec", 
    	    "Classes-Kernel-A_specification_owningInstanceSpec-owningInstanceSpec",
    	    "Classes-Kernel-InstanceSpecification",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-InstanceSpecification-specification Classes-Kernel-A_specification_owningInstanceSpec-owningInstanceSpec");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_packagedElement_owningPackage 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_packagedElement_owningPackage", "Classes-Kernel-A_packagedElement_owningPackage");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningPackage", 
    	    "Classes-Kernel-A_packagedElement_owningPackage-owningPackage",
    	    "Classes-Kernel-Package",
    	    "Classes-Kernel-NamedElement-namespace",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Package-packagedElement Classes-Kernel-A_packagedElement_owningPackage-owningPackage");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_importedMember_namespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_importedMember_namespace", "Classes-Kernel-A_importedMember_namespace");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "namespace", 
    	    "Classes-Kernel-A_importedMember_namespace-namespace",
    	    "Classes-Kernel-Namespace",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-importedMember Classes-Kernel-A_importedMember_namespace-namespace");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_opposite_property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_opposite_property", "Classes-Kernel-A_opposite_property");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "property", 
    	    "Classes-Kernel-A_opposite_property-property",
    	    "Classes-Kernel-Property",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Property-opposite Classes-Kernel-A_opposite_property-property");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_subsettedProperty_property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_subsettedProperty_property", "Classes-Kernel-A_subsettedProperty_property");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "property", 
    	    "Classes-Kernel-A_subsettedProperty_property-property",
    	    "Classes-Kernel-Property",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Property-subsettedProperty Classes-Kernel-A_subsettedProperty_property-property");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_memberEnd_association 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_memberEnd_association", "Classes-Kernel-A_memberEnd_association");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Association-memberEnd Classes-Kernel-Property-association");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_ownedType_package 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedType_package", "Classes-Kernel-A_ownedType_package");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Package-ownedType Classes-Kernel-Type-package");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_nestedPackage_nestingPackage 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_nestedPackage_nestingPackage", "Classes-Kernel-A_nestedPackage_nestingPackage");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Package-nestedPackage Classes-Kernel-Package-nestingPackage");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_redefinedElement_redefinableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedElement_redefinableElement", "Classes-Kernel-A_redefinedElement_redefinableElement");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "redefinableElement", 
    	    "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement",
    	    "Classes-Kernel-RedefinableElement",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-RedefinableElement-redefinedElement Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_redefinitionContext_redefinableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinitionContext_redefinableElement", "Classes-Kernel-A_redefinitionContext_redefinableElement");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "redefinableElement", 
    	    "Classes-Kernel-A_redefinitionContext_redefinableElement-redefinableElement",
    	    "Classes-Kernel-RedefinableElement",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-RedefinableElement-redefinitionContext Classes-Kernel-A_redefinitionContext_redefinableElement-redefinableElement");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_general_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_general_classifier", "Classes-Kernel-A_general_classifier");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifier", 
    	    "Classes-Kernel-A_general_classifier-classifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-general Classes-Kernel-A_general_classifier-classifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_superClass_class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_superClass_class", "Classes-Kernel-A_superClass_class");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "class", 
    	    "Classes-Kernel-A_superClass_class-class",
    	    "Classes-Kernel-Class",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Class-superClass Classes-Kernel-A_superClass_class-class");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_bodyCondition_bodyContext 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_bodyCondition_bodyContext", "Classes-Kernel-A_bodyCondition_bodyContext");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "bodyContext", 
    	    "Classes-Kernel-A_bodyCondition_bodyContext-bodyContext",
    	    "Classes-Kernel-Operation",
    	    "Classes-Kernel-Constraint-context",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-bodyCondition Classes-Kernel-A_bodyCondition_bodyContext-bodyContext");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_type_operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_type_operation", "Classes-Kernel-A_type_operation");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "operation", 
    	    "Classes-Kernel-A_type_operation-operation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-type Classes-Kernel-A_type_operation-operation");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_ownedParameter_operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedParameter_operation", "Classes-Kernel-A_ownedParameter_operation");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-ownedParameter Classes-Kernel-Parameter-operation");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_operand_expression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_operand_expression", "Classes-Kernel-A_operand_expression");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "expression", 
    	    "Classes-Kernel-A_operand_expression-expression",
    	    "Classes-Kernel-Expression",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Expression-operand Classes-Kernel-A_operand_expression-expression");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_raisedException_operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_raisedException_operation", "Classes-Kernel-A_raisedException_operation");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "operation", 
    	    "Classes-Kernel-A_raisedException_operation-operation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-raisedException Classes-Kernel-A_raisedException_operation-operation");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // Classes.Kernel.A_navigableOwnedEnd_association 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_navigableOwnedEnd_association", "Classes-Kernel-A_navigableOwnedEnd_association");
        mapping.mapAssociation(assoc, "Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "association", 
    	    "Classes-Kernel-A_navigableOwnedEnd_association-association",
    	    "Classes-Kernel-Association",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Kernel-Association-navigableOwnedEnd Classes-Kernel-A_navigableOwnedEnd_association-association");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // Classes.Interfaces.A_interface_ownedAttribute 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_interface_ownedAttribute", "Classes-Interfaces-A_interface_ownedAttribute");
        mapping.mapAssociation(assoc, "Classes.Interfaces", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "interface", 
    	    "Classes-Interfaces-A_interface_ownedAttribute-interface",
    	    "Classes-Interfaces-Interface",
    	    "Classes-Kernel-A_attribute_classifier-classifier Classes-Kernel-NamedElement-namespace Classes-Kernel-Feature-featuringClassifier",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Interfaces-A_interface_ownedAttribute-interface Classes-Interfaces-Interface-ownedAttribute");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // Classes.Interfaces.A_interface_ownedOperation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_interface_ownedOperation", "Classes-Interfaces-A_interface_ownedOperation");
        mapping.mapAssociation(assoc, "Classes.Interfaces", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Interfaces-Operation-interface Classes-Interfaces-Interface-ownedOperation");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // Classes.Interfaces.A_contract_interfaceRealization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_contract_interfaceRealization", "Classes-Interfaces-A_contract_interfaceRealization");
        mapping.mapAssociation(assoc, "Classes.Interfaces", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "interfaceRealization", 
    	    "Classes-Interfaces-A_contract_interfaceRealization-interfaceRealization",
    	    "Classes-Interfaces-InterfaceRealization",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Interfaces-InterfaceRealization-contract Classes-Interfaces-A_contract_interfaceRealization-interfaceRealization");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // Classes.Interfaces.A_interfaceRealization_implementingClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_interfaceRealization_implementingClassifier", "Classes-Interfaces-A_interfaceRealization_implementingClassifier");
        mapping.mapAssociation(assoc, "Classes.Interfaces", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Interfaces-BehavioredClassifier-interfaceRealization Classes-Interfaces-InterfaceRealization-implementingClassifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // Classes.Interfaces.A_nestedClassifier_interface 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_nestedClassifier_interface", "Classes-Interfaces-A_nestedClassifier_interface");
        mapping.mapAssociation(assoc, "Classes.Interfaces", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "interface", 
    	    "Classes-Interfaces-A_nestedClassifier_interface-interface",
    	    "Classes-Interfaces-Interface",
    	    "Classes-Kernel-NamedElement-namespace Classes-Kernel-RedefinableElement-redefinitionContext",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Interfaces-Interface-nestedClassifier Classes-Interfaces-A_nestedClassifier_interface-interface");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // Classes.Interfaces.A_interface_redefinedInterface 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_interface_redefinedInterface", "Classes-Interfaces-A_interface_redefinedInterface");
        mapping.mapAssociation(assoc, "Classes.Interfaces", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "interface", 
    	    "Classes-Interfaces-A_interface_redefinedInterface-interface",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Interfaces-A_interface_redefinedInterface-interface Classes-Interfaces-Interface-redefinedInterface");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // Classes.Dependencies.A_mapping_abstraction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_mapping_abstraction", "Classes-Dependencies-A_mapping_abstraction");
        mapping.mapAssociation(assoc, "Classes.Dependencies", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "abstraction", 
    	    "Classes-Dependencies-A_mapping_abstraction-abstraction",
    	    "Classes-Dependencies-Abstraction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Dependencies-Abstraction-mapping Classes-Dependencies-A_mapping_abstraction-abstraction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // Classes.Dependencies.A_contract_substitution 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_contract_substitution", "Classes-Dependencies-A_contract_substitution");
        mapping.mapAssociation(assoc, "Classes.Dependencies", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "substitution", 
    	    "Classes-Dependencies-A_contract_substitution-substitution",
    	    "Classes-Dependencies-Substitution",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Dependencies-Substitution-contract Classes-Dependencies-A_contract_substitution-substitution");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // Classes.Dependencies.A_substitution_substitutingClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_substitution_substitutingClassifier", "Classes-Dependencies-A_substitution_substitutingClassifier");
        mapping.mapAssociation(assoc, "Classes.Dependencies", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Dependencies-Classifier-substitution Classes-Dependencies-Substitution-substitutingClassifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // Classes.Dependencies.A_supplierDependency_supplier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_supplierDependency_supplier", "Classes-Dependencies-A_supplierDependency_supplier");
        mapping.mapAssociation(assoc, "Classes.Dependencies", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "supplierDependency", 
    	    "Classes-Dependencies-A_supplierDependency_supplier-supplierDependency",
    	    "Classes-Dependencies-Dependency",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Classes-Dependencies-A_supplierDependency_supplier-supplierDependency Classes-Dependencies-Dependency-supplier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // Classes.Dependencies.A_clientDependency_client 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_clientDependency_client", "Classes-Dependencies-A_clientDependency_client");
        mapping.mapAssociation(assoc, "Classes.Dependencies", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Dependencies-NamedElement-clientDependency Classes-Dependencies-Dependency-client");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // Classes.Dependencies.A_ownedMember_namespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedMember_namespace", "Classes-Dependencies-A_ownedMember_namespace");
        mapping.mapAssociation(assoc, "Classes.Dependencies", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-Dependencies-Namespace-ownedMember Classes-Dependencies-NamedElement-namespace");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-PowerTypes";   
                      
        // Classes.PowerTypes.A_powertypeExtent_powertype 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_powertypeExtent_powertype", "Classes-PowerTypes-A_powertypeExtent_powertype");
        mapping.mapAssociation(assoc, "Classes.PowerTypes", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-PowerTypes-Classifier-powertypeExtent Classes-PowerTypes-GeneralizationSet-powertype");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-PowerTypes";   
                      
        // Classes.PowerTypes.A_generalizationSet_generalization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_generalizationSet_generalization", "Classes-PowerTypes-A_generalizationSet_generalization");
        mapping.mapAssociation(assoc, "Classes.PowerTypes", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-PowerTypes-Generalization-generalizationSet Classes-PowerTypes-GeneralizationSet-generalization");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-AssociationClasses";   
                      
        // Classes.AssociationClasses.A_qualifier_associationEnd 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_qualifier_associationEnd", "Classes-AssociationClasses-A_qualifier_associationEnd");
        mapping.mapAssociation(assoc, "Classes.AssociationClasses", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Classes-AssociationClasses-Property-qualifier Classes-AssociationClasses-Property-associationEnd");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.A_reception_signal 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_reception_signal", "CommonBehaviors-Communications-A_reception_signal");
        mapping.mapAssociation(assoc, "CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "reception", 
    	    "CommonBehaviors-Communications-A_reception_signal-reception",
    	    "CommonBehaviors-Communications-Reception",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-A_reception_signal-reception CommonBehaviors-Communications-Reception-signal");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.A_operation_callEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_operation_callEvent", "CommonBehaviors-Communications-A_operation_callEvent");
        mapping.mapAssociation(assoc, "CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "callEvent", 
    	    "CommonBehaviors-Communications-A_operation_callEvent-callEvent",
    	    "CommonBehaviors-Communications-CallEvent",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-CallEvent-operation CommonBehaviors-Communications-A_operation_callEvent-callEvent");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.A_signal_signalEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_signal_signalEvent", "CommonBehaviors-Communications-A_signal_signalEvent");
        mapping.mapAssociation(assoc, "CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "signalEvent", 
    	    "CommonBehaviors-Communications-A_signal_signalEvent-signalEvent",
    	    "CommonBehaviors-Communications-SignalEvent",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-SignalEvent-signal CommonBehaviors-Communications-A_signal_signalEvent-signalEvent");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.A_ownedReception_interface 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedReception_interface", "CommonBehaviors-Communications-A_ownedReception_interface");
        mapping.mapAssociation(assoc, "CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "interface", 
    	    "CommonBehaviors-Communications-A_ownedReception_interface-interface",
    	    "CommonBehaviors-Communications-Interface",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-Interface-ownedReception CommonBehaviors-Communications-A_ownedReception_interface-interface");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.A_ownedReception_class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedReception_class", "CommonBehaviors-Communications-A_ownedReception_class");
        mapping.mapAssociation(assoc, "CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "class", 
    	    "CommonBehaviors-Communications-A_ownedReception_class-class",
    	    "CommonBehaviors-Communications-Class",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-Class-ownedReception CommonBehaviors-Communications-A_ownedReception_class-class");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.A_when_timeEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_when_timeEvent", "CommonBehaviors-Communications-A_when_timeEvent");
        mapping.mapAssociation(assoc, "CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "timeEvent", 
    	    "CommonBehaviors-Communications-A_when_timeEvent-timeEvent",
    	    "CommonBehaviors-Communications-TimeEvent",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-TimeEvent-when CommonBehaviors-Communications-A_when_timeEvent-timeEvent");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.A_changeExpression_changeEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_changeExpression_changeEvent", "CommonBehaviors-Communications-A_changeExpression_changeEvent");
        mapping.mapAssociation(assoc, "CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "changeEvent", 
    	    "CommonBehaviors-Communications-A_changeExpression_changeEvent-changeEvent",
    	    "CommonBehaviors-Communications-ChangeEvent",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-ChangeEvent-changeExpression CommonBehaviors-Communications-A_changeExpression_changeEvent-changeEvent");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.A_raisedException_behavioralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_raisedException_behavioralFeature", "CommonBehaviors-Communications-A_raisedException_behavioralFeature");
        mapping.mapAssociation(assoc, "CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavioralFeature", 
    	    "CommonBehaviors-Communications-A_raisedException_behavioralFeature-behavioralFeature",
    	    "CommonBehaviors-Communications-BehavioralFeature",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-BehavioralFeature-raisedException CommonBehaviors-Communications-A_raisedException_behavioralFeature-behavioralFeature");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.A_ownedAttribute_owningSignal 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedAttribute_owningSignal", "CommonBehaviors-Communications-A_ownedAttribute_owningSignal");
        mapping.mapAssociation(assoc, "CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningSignal", 
    	    "CommonBehaviors-Communications-A_ownedAttribute_owningSignal-owningSignal",
    	    "CommonBehaviors-Communications-Signal",
    	    "Classes-Kernel-NamedElement-namespace Classes-Kernel-A_attribute_classifier-classifier Classes-Kernel-Feature-featuringClassifier",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-Signal-ownedAttribute CommonBehaviors-Communications-A_ownedAttribute_owningSignal-owningSignal");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.A_ownedTrigger_behavioredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedTrigger_behavioredClassifier", "CommonBehaviors-Communications-A_ownedTrigger_behavioredClassifier");
        mapping.mapAssociation(assoc, "CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavioredClassifier", 
    	    "CommonBehaviors-Communications-A_ownedTrigger_behavioredClassifier-behavioredClassifier",
    	    "CommonBehaviors-Communications-BehavioredClassifier",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-BehavioredClassifier-ownedTrigger CommonBehaviors-Communications-A_ownedTrigger_behavioredClassifier-behavioredClassifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // CommonBehaviors.Communications.A_event_trigger 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_event_trigger", "CommonBehaviors-Communications-A_event_trigger");
        mapping.mapAssociation(assoc, "CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "trigger", 
    	    "CommonBehaviors-Communications-A_event_trigger-trigger",
    	    "CommonBehaviors-Communications-Trigger",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-Trigger-event CommonBehaviors-Communications-A_event_trigger-trigger");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.A_behavioredClassifier_ownedBehavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_behavioredClassifier_ownedBehavior", "CommonBehaviors-BasicBehaviors-A_behavioredClassifier_ownedBehavior");
        mapping.mapAssociation(assoc, "CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavioredClassifier", 
    	    "CommonBehaviors-BasicBehaviors-A_behavioredClassifier_ownedBehavior-behavioredClassifier",
    	    "CommonBehaviors-BasicBehaviors-BehavioredClassifier",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-A_behavioredClassifier_ownedBehavior-behavioredClassifier CommonBehaviors-BasicBehaviors-BehavioredClassifier-ownedBehavior");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.A_classifierBehavior_behavioredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_classifierBehavior_behavioredClassifier", "CommonBehaviors-BasicBehaviors-A_classifierBehavior_behavioredClassifier");
        mapping.mapAssociation(assoc, "CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavioredClassifier", 
    	    "CommonBehaviors-BasicBehaviors-A_classifierBehavior_behavioredClassifier-behavioredClassifier",
    	    "CommonBehaviors-BasicBehaviors-BehavioredClassifier",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-BehavioredClassifier-classifierBehavior CommonBehaviors-BasicBehaviors-A_classifierBehavior_behavioredClassifier-behavioredClassifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.A_redefinedBehavior_behavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedBehavior_behavior", "CommonBehaviors-BasicBehaviors-A_redefinedBehavior_behavior");
        mapping.mapAssociation(assoc, "CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavior", 
    	    "CommonBehaviors-BasicBehaviors-A_redefinedBehavior_behavior-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-Behavior-redefinedBehavior CommonBehaviors-BasicBehaviors-A_redefinedBehavior_behavior-behavior");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.A_method_specification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_method_specification", "CommonBehaviors-BasicBehaviors-A_method_specification");
        mapping.mapAssociation(assoc, "CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-BehavioralFeature-method CommonBehaviors-BasicBehaviors-Behavior-specification");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.A_behavior_ownedParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_behavior_ownedParameter", "CommonBehaviors-BasicBehaviors-A_behavior_ownedParameter");
        mapping.mapAssociation(assoc, "CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavior", 
    	    "CommonBehaviors-BasicBehaviors-A_behavior_ownedParameter-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-A_behavior_ownedParameter-behavior CommonBehaviors-BasicBehaviors-Behavior-ownedParameter");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.A_result_opaqueExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_opaqueExpression", "CommonBehaviors-BasicBehaviors-A_result_opaqueExpression");
        mapping.mapAssociation(assoc, "CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "opaqueExpression", 
    	    "CommonBehaviors-BasicBehaviors-A_result_opaqueExpression-opaqueExpression",
    	    "CommonBehaviors-BasicBehaviors-OpaqueExpression",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-OpaqueExpression-result CommonBehaviors-BasicBehaviors-A_result_opaqueExpression-opaqueExpression");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.A_behavior_opaqueExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_behavior_opaqueExpression", "CommonBehaviors-BasicBehaviors-A_behavior_opaqueExpression");
        mapping.mapAssociation(assoc, "CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "opaqueExpression", 
    	    "CommonBehaviors-BasicBehaviors-A_behavior_opaqueExpression-opaqueExpression",
    	    "CommonBehaviors-BasicBehaviors-OpaqueExpression",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-OpaqueExpression-behavior CommonBehaviors-BasicBehaviors-A_behavior_opaqueExpression-opaqueExpression");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.A_context_behavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_context_behavior", "CommonBehaviors-BasicBehaviors-A_context_behavior");
        mapping.mapAssociation(assoc, "CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavior", 
    	    "CommonBehaviors-BasicBehaviors-A_context_behavior-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-Behavior-context CommonBehaviors-BasicBehaviors-A_context_behavior-behavior");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.A_precondition_behavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_precondition_behavior", "CommonBehaviors-BasicBehaviors-A_precondition_behavior");
        mapping.mapAssociation(assoc, "CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavior", 
    	    "CommonBehaviors-BasicBehaviors-A_precondition_behavior-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "Classes-Kernel-Constraint-context",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-Behavior-precondition CommonBehaviors-BasicBehaviors-A_precondition_behavior-behavior");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // CommonBehaviors.BasicBehaviors.A_postcondition_behavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_postcondition_behavior", "CommonBehaviors-BasicBehaviors-A_postcondition_behavior");
        mapping.mapAssociation(assoc, "CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavior", 
    	    "CommonBehaviors-BasicBehaviors-A_postcondition_behavior-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "Classes-Kernel-Constraint-context",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-Behavior-postcondition CommonBehaviors-BasicBehaviors-A_postcondition_behavior-behavior");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_min_durationInterval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_min_durationInterval", "CommonBehaviors-SimpleTime-A_min_durationInterval");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "durationInterval", 
    	    "CommonBehaviors-SimpleTime-A_min_durationInterval-durationInterval",
    	    "CommonBehaviors-SimpleTime-DurationInterval",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-DurationInterval-min CommonBehaviors-SimpleTime-A_min_durationInterval-durationInterval");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_max_durationInterval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_max_durationInterval", "CommonBehaviors-SimpleTime-A_max_durationInterval");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "durationInterval", 
    	    "CommonBehaviors-SimpleTime-A_max_durationInterval-durationInterval",
    	    "CommonBehaviors-SimpleTime-DurationInterval",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-DurationInterval-max CommonBehaviors-SimpleTime-A_max_durationInterval-durationInterval");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_max_timeInterval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_max_timeInterval", "CommonBehaviors-SimpleTime-A_max_timeInterval");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "timeInterval", 
    	    "CommonBehaviors-SimpleTime-A_max_timeInterval-timeInterval",
    	    "CommonBehaviors-SimpleTime-TimeInterval",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeInterval-max CommonBehaviors-SimpleTime-A_max_timeInterval-timeInterval");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_min_timeInterval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_min_timeInterval", "CommonBehaviors-SimpleTime-A_min_timeInterval");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "timeInterval", 
    	    "CommonBehaviors-SimpleTime-A_min_timeInterval-timeInterval",
    	    "CommonBehaviors-SimpleTime-TimeInterval",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeInterval-min CommonBehaviors-SimpleTime-A_min_timeInterval-timeInterval");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_specification_timeConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_specification_timeConstraint", "CommonBehaviors-SimpleTime-A_specification_timeConstraint");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "timeConstraint", 
    	    "CommonBehaviors-SimpleTime-A_specification_timeConstraint-timeConstraint",
    	    "CommonBehaviors-SimpleTime-TimeConstraint",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeConstraint-specification CommonBehaviors-SimpleTime-A_specification_timeConstraint-timeConstraint");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_specification_durationConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_specification_durationConstraint", "CommonBehaviors-SimpleTime-A_specification_durationConstraint");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "durationConstraint", 
    	    "CommonBehaviors-SimpleTime-A_specification_durationConstraint-durationConstraint",
    	    "CommonBehaviors-SimpleTime-DurationConstraint",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-DurationConstraint-specification CommonBehaviors-SimpleTime-A_specification_durationConstraint-durationConstraint");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_min_interval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_min_interval", "CommonBehaviors-SimpleTime-A_min_interval");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "interval", 
    	    "CommonBehaviors-SimpleTime-A_min_interval-interval",
    	    "CommonBehaviors-SimpleTime-Interval",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-Interval-min CommonBehaviors-SimpleTime-A_min_interval-interval");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_max_interval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_max_interval", "CommonBehaviors-SimpleTime-A_max_interval");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "interval", 
    	    "CommonBehaviors-SimpleTime-A_max_interval-interval",
    	    "CommonBehaviors-SimpleTime-Interval",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-Interval-max CommonBehaviors-SimpleTime-A_max_interval-interval");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_specification_intervalConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_specification_intervalConstraint", "CommonBehaviors-SimpleTime-A_specification_intervalConstraint");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "intervalConstraint", 
    	    "CommonBehaviors-SimpleTime-A_specification_intervalConstraint-intervalConstraint",
    	    "CommonBehaviors-SimpleTime-IntervalConstraint",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-IntervalConstraint-specification CommonBehaviors-SimpleTime-A_specification_intervalConstraint-intervalConstraint");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_observation_duration 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_observation_duration", "CommonBehaviors-SimpleTime-A_observation_duration");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "duration", 
    	    "CommonBehaviors-SimpleTime-A_observation_duration-duration",
    	    "CommonBehaviors-SimpleTime-Duration",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-Duration-observation CommonBehaviors-SimpleTime-A_observation_duration-duration");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_observation_timeExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_observation_timeExpression", "CommonBehaviors-SimpleTime-A_observation_timeExpression");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "timeExpression", 
    	    "CommonBehaviors-SimpleTime-A_observation_timeExpression-timeExpression",
    	    "CommonBehaviors-SimpleTime-TimeExpression",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeExpression-observation CommonBehaviors-SimpleTime-A_observation_timeExpression-timeExpression");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_when_timeEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_when_timeEvent", "CommonBehaviors-SimpleTime-A_when_timeEvent");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "timeEvent", 
    	    "CommonBehaviors-SimpleTime-A_when_timeEvent-timeEvent",
    	    "CommonBehaviors-SimpleTime-TimeEvent",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeEvent-when CommonBehaviors-SimpleTime-A_when_timeEvent-timeEvent");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_expr_timeExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_expr_timeExpression", "CommonBehaviors-SimpleTime-A_expr_timeExpression");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "timeExpression", 
    	    "CommonBehaviors-SimpleTime-A_expr_timeExpression-timeExpression",
    	    "CommonBehaviors-SimpleTime-TimeExpression",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeExpression-expr CommonBehaviors-SimpleTime-A_expr_timeExpression-timeExpression");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_expr_duration 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_expr_duration", "CommonBehaviors-SimpleTime-A_expr_duration");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "duration", 
    	    "CommonBehaviors-SimpleTime-A_expr_duration-duration",
    	    "CommonBehaviors-SimpleTime-Duration",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-Duration-expr CommonBehaviors-SimpleTime-A_expr_duration-duration");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_event_timeObservation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_event_timeObservation", "CommonBehaviors-SimpleTime-A_event_timeObservation");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "timeObservation", 
    	    "CommonBehaviors-SimpleTime-A_event_timeObservation-timeObservation",
    	    "CommonBehaviors-SimpleTime-TimeObservation",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeObservation-event CommonBehaviors-SimpleTime-A_event_timeObservation-timeObservation");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // CommonBehaviors.SimpleTime.A_event_durationObservation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_event_durationObservation", "CommonBehaviors-SimpleTime-A_event_durationObservation");
        mapping.mapAssociation(assoc, "CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "durationObservation", 
    	    "CommonBehaviors-SimpleTime-A_event_durationObservation-durationObservation",
    	    "CommonBehaviors-SimpleTime-DurationObservation",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-DurationObservation-event CommonBehaviors-SimpleTime-A_event_durationObservation-durationObservation");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-PackagingComponents";   
                      
        // Components.PackagingComponents.A_component_packagedElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_component_packagedElement", "Components-PackagingComponents-A_component_packagedElement");
        mapping.mapAssociation(assoc, "Components.PackagingComponents", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "component", 
    	    "Components-PackagingComponents-A_component_packagedElement-component",
    	    "Components-PackagingComponents-Component",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Components-PackagingComponents-A_component_packagedElement-component Components-PackagingComponents-Component-packagedElement");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // Components.BasicComponents.A_required_component 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_required_component", "Components-BasicComponents-A_required_component");
        mapping.mapAssociation(assoc, "Components.BasicComponents", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "component", 
    	    "Components-BasicComponents-A_required_component-component",
    	    "Components-BasicComponents-Component",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Components-BasicComponents-Component-required Components-BasicComponents-A_required_component-component");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // Components.BasicComponents.A_provided_component 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_provided_component", "Components-BasicComponents-A_provided_component");
        mapping.mapAssociation(assoc, "Components.BasicComponents", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "component", 
    	    "Components-BasicComponents-A_provided_component-component",
    	    "Components-BasicComponents-Component",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Components-BasicComponents-Component-provided Components-BasicComponents-A_provided_component-component");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // Components.BasicComponents.A_realization_abstraction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_realization_abstraction", "Components-BasicComponents-A_realization_abstraction");
        mapping.mapAssociation(assoc, "Components.BasicComponents", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Components-BasicComponents-Component-realization Components-BasicComponents-ComponentRealization-abstraction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // Components.BasicComponents.A_realizingClassifier_componentRealization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_realizingClassifier_componentRealization", "Components-BasicComponents-A_realizingClassifier_componentRealization");
        mapping.mapAssociation(assoc, "Components.BasicComponents", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "componentRealization", 
    	    "Components-BasicComponents-A_realizingClassifier_componentRealization-componentRealization",
    	    "Components-BasicComponents-ComponentRealization",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Components-BasicComponents-ComponentRealization-realizingClassifier Components-BasicComponents-A_realizingClassifier_componentRealization-componentRealization");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // Components.BasicComponents.A_contract_connector 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_contract_connector", "Components-BasicComponents-A_contract_connector");
        mapping.mapAssociation(assoc, "Components.BasicComponents", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "connector", 
    	    "Components-BasicComponents-A_contract_connector-connector",
    	    "Components-BasicComponents-Connector",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Components-BasicComponents-Connector-contract Components-BasicComponents-A_contract_connector-connector");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // CompositeStructures.Collaborations.A_type_collaborationUse 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_type_collaborationUse", "CompositeStructures-Collaborations-A_type_collaborationUse");
        mapping.mapAssociation(assoc, "CompositeStructures.Collaborations", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "collaborationUse", 
    	    "CompositeStructures-Collaborations-A_type_collaborationUse-collaborationUse",
    	    "CompositeStructures-Collaborations-CollaborationUse",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-Collaborations-CollaborationUse-type CompositeStructures-Collaborations-A_type_collaborationUse-collaborationUse");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // CompositeStructures.Collaborations.A_roleBinding_collaborationUse 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_roleBinding_collaborationUse", "CompositeStructures-Collaborations-A_roleBinding_collaborationUse");
        mapping.mapAssociation(assoc, "CompositeStructures.Collaborations", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "collaborationUse", 
    	    "CompositeStructures-Collaborations-A_roleBinding_collaborationUse-collaborationUse",
    	    "CompositeStructures-Collaborations-CollaborationUse",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-Collaborations-CollaborationUse-roleBinding CompositeStructures-Collaborations-A_roleBinding_collaborationUse-collaborationUse");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // CompositeStructures.Collaborations.A_classifier_representation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_classifier_representation", "CompositeStructures-Collaborations-A_classifier_representation");
        mapping.mapAssociation(assoc, "CompositeStructures.Collaborations", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifier", 
    	    "CompositeStructures-Collaborations-A_classifier_representation-classifier",
    	    "CompositeStructures-Collaborations-Classifier",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-Collaborations-A_classifier_representation-classifier CompositeStructures-Collaborations-Classifier-representation");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // CompositeStructures.Collaborations.A_collaborationUse_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_collaborationUse_classifier", "CompositeStructures-Collaborations-A_collaborationUse_classifier");
        mapping.mapAssociation(assoc, "CompositeStructures.Collaborations", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifier", 
    	    "CompositeStructures-Collaborations-A_collaborationUse_classifier-classifier",
    	    "CompositeStructures-Collaborations-Classifier",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-Collaborations-Classifier-collaborationUse CompositeStructures-Collaborations-A_collaborationUse_classifier-classifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // CompositeStructures.Collaborations.A_collaborationRole_collaboration 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_collaborationRole_collaboration", "CompositeStructures-Collaborations-A_collaborationRole_collaboration");
        mapping.mapAssociation(assoc, "CompositeStructures.Collaborations", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "collaboration", 
    	    "CompositeStructures-Collaborations-A_collaborationRole_collaboration-collaboration",
    	    "CompositeStructures-Collaborations-Collaboration",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-Collaborations-Collaboration-collaborationRole CompositeStructures-Collaborations-A_collaborationRole_collaboration-collaboration");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";   
                      
        // CompositeStructures.Ports.A_encapsulatedClassifier_ownedPort 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_encapsulatedClassifier_ownedPort", "CompositeStructures-Ports-A_encapsulatedClassifier_ownedPort");
        mapping.mapAssociation(assoc, "CompositeStructures.Ports", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "encapsulatedClassifier", 
    	    "CompositeStructures-Ports-A_encapsulatedClassifier_ownedPort-encapsulatedClassifier",
    	    "CompositeStructures-Ports-EncapsulatedClassifier",
    	    "Classes-Kernel-RedefinableElement-redefinitionContext",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-Ports-A_encapsulatedClassifier_ownedPort-encapsulatedClassifier CompositeStructures-Ports-EncapsulatedClassifier-ownedPort");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";   
                      
        // CompositeStructures.Ports.A_required_port 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_required_port", "CompositeStructures-Ports-A_required_port");
        mapping.mapAssociation(assoc, "CompositeStructures.Ports", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "port", 
    	    "CompositeStructures-Ports-A_required_port-port",
    	    "CompositeStructures-Ports-Port",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-Ports-Port-required CompositeStructures-Ports-A_required_port-port");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";   
                      
        // CompositeStructures.Ports.A_redefinedPort_port 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedPort_port", "CompositeStructures-Ports-A_redefinedPort_port");
        mapping.mapAssociation(assoc, "CompositeStructures.Ports", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "port", 
    	    "CompositeStructures-Ports-A_redefinedPort_port-port",
    	    "CompositeStructures-Ports-Port",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-Ports-Port-redefinedPort CompositeStructures-Ports-A_redefinedPort_port-port");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";   
                      
        // CompositeStructures.Ports.A_provided_port 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_provided_port", "CompositeStructures-Ports-A_provided_port");
        mapping.mapAssociation(assoc, "CompositeStructures.Ports", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "port", 
    	    "CompositeStructures-Ports-A_provided_port-port",
    	    "CompositeStructures-Ports-Port",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-Ports-Port-provided CompositeStructures-Ports-A_provided_port-port");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";   
                      
        // CompositeStructures.Ports.A_partWithPort_connectorEnd 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_partWithPort_connectorEnd", "CompositeStructures-Ports-A_partWithPort_connectorEnd");
        mapping.mapAssociation(assoc, "CompositeStructures.Ports", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "connectorEnd", 
    	    "CompositeStructures-Ports-A_partWithPort_connectorEnd-connectorEnd",
    	    "CompositeStructures-Ports-ConnectorEnd",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-Ports-ConnectorEnd-partWithPort CompositeStructures-Ports-A_partWithPort_connectorEnd-connectorEnd");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InvocationActions";   
                      
        // CompositeStructures.InvocationActions.A_port_trigger 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_port_trigger", "CompositeStructures-InvocationActions-A_port_trigger");
        mapping.mapAssociation(assoc, "CompositeStructures.InvocationActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "trigger", 
    	    "CompositeStructures-InvocationActions-A_port_trigger-trigger",
    	    "CompositeStructures-InvocationActions-Trigger",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-InvocationActions-Trigger-port CompositeStructures-InvocationActions-A_port_trigger-trigger");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InvocationActions";   
                      
        // CompositeStructures.InvocationActions.A_onPort_invocationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_onPort_invocationAction", "CompositeStructures-InvocationActions-A_onPort_invocationAction");
        mapping.mapAssociation(assoc, "CompositeStructures.InvocationActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "invocationAction", 
    	    "CompositeStructures-InvocationActions-A_onPort_invocationAction-invocationAction",
    	    "CompositeStructures-InvocationActions-InvocationAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-InvocationActions-InvocationAction-onPort CompositeStructures-InvocationActions-A_onPort_invocationAction-invocationAction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.A_type_connector 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_type_connector", "CompositeStructures-InternalStructures-A_type_connector");
        mapping.mapAssociation(assoc, "CompositeStructures.InternalStructures", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "connector", 
    	    "CompositeStructures-InternalStructures-A_type_connector-connector",
    	    "CompositeStructures-InternalStructures-Connector",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-Connector-type CompositeStructures-InternalStructures-A_type_connector-connector");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.A_ownedAttribute_structuredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedAttribute_structuredClassifier", "CompositeStructures-InternalStructures-A_ownedAttribute_structuredClassifier");
        mapping.mapAssociation(assoc, "CompositeStructures.InternalStructures", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "structuredClassifier", 
    	    "CompositeStructures-InternalStructures-A_ownedAttribute_structuredClassifier-structuredClassifier",
    	    "CompositeStructures-InternalStructures-StructuredClassifier",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-StructuredClassifier-ownedAttribute CompositeStructures-InternalStructures-A_ownedAttribute_structuredClassifier-structuredClassifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.A_part_structuredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_part_structuredClassifier", "CompositeStructures-InternalStructures-A_part_structuredClassifier");
        mapping.mapAssociation(assoc, "CompositeStructures.InternalStructures", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "structuredClassifier", 
    	    "CompositeStructures-InternalStructures-A_part_structuredClassifier-structuredClassifier",
    	    "CompositeStructures-InternalStructures-StructuredClassifier",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-StructuredClassifier-part CompositeStructures-InternalStructures-A_part_structuredClassifier-structuredClassifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.A_role_structuredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_role_structuredClassifier", "CompositeStructures-InternalStructures-A_role_structuredClassifier");
        mapping.mapAssociation(assoc, "CompositeStructures.InternalStructures", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "structuredClassifier", 
    	    "CompositeStructures-InternalStructures-A_role_structuredClassifier-structuredClassifier",
    	    "CompositeStructures-InternalStructures-StructuredClassifier",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-StructuredClassifier-role CompositeStructures-InternalStructures-A_role_structuredClassifier-structuredClassifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.A_ownedConnector_structuredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedConnector_structuredClassifier", "CompositeStructures-InternalStructures-A_ownedConnector_structuredClassifier");
        mapping.mapAssociation(assoc, "CompositeStructures.InternalStructures", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "structuredClassifier", 
    	    "CompositeStructures-InternalStructures-A_ownedConnector_structuredClassifier-structuredClassifier",
    	    "CompositeStructures-InternalStructures-StructuredClassifier",
    	    "Classes-Kernel-RedefinableElement-redefinitionContext",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-StructuredClassifier-ownedConnector CompositeStructures-InternalStructures-A_ownedConnector_structuredClassifier-structuredClassifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.A_redefinedConnector_connector 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedConnector_connector", "CompositeStructures-InternalStructures-A_redefinedConnector_connector");
        mapping.mapAssociation(assoc, "CompositeStructures.InternalStructures", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "connector", 
    	    "CompositeStructures-InternalStructures-A_redefinedConnector_connector-connector",
    	    "CompositeStructures-InternalStructures-Connector",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-Connector-redefinedConnector CompositeStructures-InternalStructures-A_redefinedConnector_connector-connector");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.A_end_connector 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_end_connector", "CompositeStructures-InternalStructures-A_end_connector");
        mapping.mapAssociation(assoc, "CompositeStructures.InternalStructures", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "connector", 
    	    "CompositeStructures-InternalStructures-A_end_connector-connector",
    	    "CompositeStructures-InternalStructures-Connector",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-Connector-end CompositeStructures-InternalStructures-A_end_connector-connector");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.A_definingEnd_connectorEnd 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_definingEnd_connectorEnd", "CompositeStructures-InternalStructures-A_definingEnd_connectorEnd");
        mapping.mapAssociation(assoc, "CompositeStructures.InternalStructures", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "connectorEnd", 
    	    "CompositeStructures-InternalStructures-A_definingEnd_connectorEnd-connectorEnd",
    	    "CompositeStructures-InternalStructures-ConnectorEnd",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-ConnectorEnd-definingEnd CompositeStructures-InternalStructures-A_definingEnd_connectorEnd-connectorEnd");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.A_end_role 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_end_role", "CompositeStructures-InternalStructures-A_end_role");
        mapping.mapAssociation(assoc, "CompositeStructures.InternalStructures", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-ConnectableElement-end CompositeStructures-InternalStructures-ConnectorEnd-role");
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // CompositeStructures.InternalStructures.A_attribute_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_attribute_classifier", "CompositeStructures-InternalStructures-A_attribute_classifier");
        mapping.mapAssociation(assoc, "CompositeStructures.InternalStructures", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifier", 
    	    "CompositeStructures-InternalStructures-A_attribute_classifier-classifier",
    	    "CompositeStructures-InternalStructures-Classifier",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-Classifier-attribute CompositeStructures-InternalStructures-A_attribute_classifier-classifier");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-ComponentDeployments";   
                      
        // Deployments.ComponentDeployments.A_configuration_deployment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_configuration_deployment", "Deployments-ComponentDeployments-A_configuration_deployment");
        mapping.mapAssociation(assoc, "Deployments.ComponentDeployments", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Deployments-ComponentDeployments-Deployment-configuration Deployments-ComponentDeployments-DeploymentSpecification-deployment");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // Deployments.Nodes.A_deployedArtifact_deployment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_deployedArtifact_deployment", "Deployments-Nodes-A_deployedArtifact_deployment");
        mapping.mapAssociation(assoc, "Deployments.Nodes", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "deployment", 
    	    "Deployments-Nodes-A_deployedArtifact_deployment-deployment",
    	    "Deployments-Nodes-Deployment",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Deployments-Nodes-Deployment-deployedArtifact Deployments-Nodes-A_deployedArtifact_deployment-deployment");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // Deployments.Nodes.A_deployment_location 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_deployment_location", "Deployments-Nodes-A_deployment_location");
        mapping.mapAssociation(assoc, "Deployments.Nodes", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Deployments-Nodes-DeploymentTarget-deployment Deployments-Nodes-Deployment-location");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // Deployments.Nodes.A_nestedNode_node 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_nestedNode_node", "Deployments-Nodes-A_nestedNode_node");
        mapping.mapAssociation(assoc, "Deployments.Nodes", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "node", 
    	    "Deployments-Nodes-A_nestedNode_node-node",
    	    "Deployments-Nodes-Node",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Deployments-Nodes-Node-nestedNode Deployments-Nodes-A_nestedNode_node-node");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // Deployments.Nodes.A_deployedElement_deploymentTarget 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_deployedElement_deploymentTarget", "Deployments-Nodes-A_deployedElement_deploymentTarget");
        mapping.mapAssociation(assoc, "Deployments.Nodes", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "deploymentTarget", 
    	    "Deployments-Nodes-A_deployedElement_deploymentTarget-deploymentTarget",
    	    "Deployments-Nodes-DeploymentTarget",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Deployments-Nodes-DeploymentTarget-deployedElement Deployments-Nodes-A_deployedElement_deploymentTarget-deploymentTarget");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";   
                      
        // Deployments.Artifacts.A_utilizedElement_manifestation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_utilizedElement_manifestation", "Deployments-Artifacts-A_utilizedElement_manifestation");
        mapping.mapAssociation(assoc, "Deployments.Artifacts", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "manifestation", 
    	    "Deployments-Artifacts-A_utilizedElement_manifestation-manifestation",
    	    "Deployments-Artifacts-Manifestation",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Deployments-Artifacts-Manifestation-utilizedElement Deployments-Artifacts-A_utilizedElement_manifestation-manifestation");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";   
                      
        // Deployments.Artifacts.A_nestedArtifact_artifact 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_nestedArtifact_artifact", "Deployments-Artifacts-A_nestedArtifact_artifact");
        mapping.mapAssociation(assoc, "Deployments.Artifacts", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "artifact", 
    	    "Deployments-Artifacts-A_nestedArtifact_artifact-artifact",
    	    "Deployments-Artifacts-Artifact",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Deployments-Artifacts-Artifact-nestedArtifact Deployments-Artifacts-A_nestedArtifact_artifact-artifact");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";   
                      
        // Deployments.Artifacts.A_manifestation_artifact 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_manifestation_artifact", "Deployments-Artifacts-A_manifestation_artifact");
        mapping.mapAssociation(assoc, "Deployments.Artifacts", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "artifact", 
    	    "Deployments-Artifacts-A_manifestation_artifact-artifact",
    	    "Deployments-Artifacts-Artifact",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Deployments-Artifacts-Artifact-manifestation Deployments-Artifacts-A_manifestation_artifact-artifact");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";   
                      
        // Deployments.Artifacts.A_ownedOperation_artifact 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedOperation_artifact", "Deployments-Artifacts-A_ownedOperation_artifact");
        mapping.mapAssociation(assoc, "Deployments.Artifacts", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "artifact", 
    	    "Deployments-Artifacts-A_ownedOperation_artifact-artifact",
    	    "Deployments-Artifacts-Artifact",
    	    "Classes-Kernel-RedefinableElement-redefinitionContext Classes-Kernel-NamedElement-namespace Classes-Kernel-Feature-featuringClassifier",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Deployments-Artifacts-Artifact-ownedOperation Deployments-Artifacts-A_ownedOperation_artifact-artifact");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";   
                      
        // Deployments.Artifacts.A_ownedAttribute_artifact 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedAttribute_artifact", "Deployments-Artifacts-A_ownedAttribute_artifact");
        mapping.mapAssociation(assoc, "Deployments.Artifacts", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "artifact", 
    	    "Deployments-Artifacts-A_ownedAttribute_artifact-artifact",
    	    "Deployments-Artifacts-Artifact",
    	    "Classes-Kernel-NamedElement-namespace Classes-Kernel-Feature-featuringClassifier Classes-Kernel-A_attribute_classifier-classifier",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Deployments-Artifacts-Artifact-ownedAttribute Deployments-Artifacts-A_ownedAttribute_artifact-artifact");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_covered_coveredBy 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_covered_coveredBy", "Interactions-BasicInteractions-A_covered_coveredBy");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-InteractionFragment-covered Interactions-BasicInteractions-Lifeline-coveredBy");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_executionSpecification_start 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_executionSpecification_start", "Interactions-BasicInteractions-A_executionSpecification_start");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "executionSpecification", 
    	    "Interactions-BasicInteractions-A_executionSpecification_start-executionSpecification",
    	    "Interactions-BasicInteractions-ExecutionSpecification",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-A_executionSpecification_start-executionSpecification Interactions-BasicInteractions-ExecutionSpecification-start");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_executionSpecification_finish 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_executionSpecification_finish", "Interactions-BasicInteractions-A_executionSpecification_finish");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "executionSpecification", 
    	    "Interactions-BasicInteractions-A_executionSpecification_finish-executionSpecification",
    	    "Interactions-BasicInteractions-ExecutionSpecification",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-A_executionSpecification_finish-executionSpecification Interactions-BasicInteractions-ExecutionSpecification-finish");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_lifeline_represents 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_lifeline_represents", "Interactions-BasicInteractions-A_lifeline_represents");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "lifeline", 
    	    "Interactions-BasicInteractions-A_lifeline_represents-lifeline",
    	    "Interactions-BasicInteractions-Lifeline",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-A_lifeline_represents-lifeline Interactions-BasicInteractions-Lifeline-represents");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_lifeline_interaction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_lifeline_interaction", "Interactions-BasicInteractions-A_lifeline_interaction");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Interaction-lifeline Interactions-BasicInteractions-Lifeline-interaction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_receiveEvent_message 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_receiveEvent_message", "Interactions-BasicInteractions-A_receiveEvent_message");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "message", 
    	    "Interactions-BasicInteractions-A_receiveEvent_message-message",
    	    "Interactions-BasicInteractions-Message",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Message-receiveEvent Interactions-BasicInteractions-A_receiveEvent_message-message");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_sendEvent_message 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_sendEvent_message", "Interactions-BasicInteractions-A_sendEvent_message");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "message", 
    	    "Interactions-BasicInteractions-A_sendEvent_message-message",
    	    "Interactions-BasicInteractions-Message",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Message-sendEvent Interactions-BasicInteractions-A_sendEvent_message-message");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_events_covered 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_events_covered", "Interactions-BasicInteractions-A_events_covered");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "events", 
    	    "Interactions-BasicInteractions-A_events_covered-events",
    	    "Interactions-BasicInteractions-OccurrenceSpecification",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-A_events_covered-events Interactions-BasicInteractions-OccurrenceSpecification-covered");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_selector_lifeline 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_selector_lifeline", "Interactions-BasicInteractions-A_selector_lifeline");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "lifeline", 
    	    "Interactions-BasicInteractions-A_selector_lifeline-lifeline",
    	    "Interactions-BasicInteractions-Lifeline",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Lifeline-selector Interactions-BasicInteractions-A_selector_lifeline-lifeline");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_connector_message 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_connector_message", "Interactions-BasicInteractions-A_connector_message");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "message", 
    	    "Interactions-BasicInteractions-A_connector_message-message",
    	    "Interactions-BasicInteractions-Message",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Message-connector Interactions-BasicInteractions-A_connector_message-message");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_message_interaction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_message_interaction", "Interactions-BasicInteractions-A_message_interaction");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Interaction-message Interactions-BasicInteractions-Message-interaction");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_before_toAfter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_before_toAfter", "Interactions-BasicInteractions-A_before_toAfter");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-GeneralOrdering-before Interactions-BasicInteractions-OccurrenceSpecification-toAfter");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_toBefore_after 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_toBefore_after", "Interactions-BasicInteractions-A_toBefore_after");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-OccurrenceSpecification-toBefore Interactions-BasicInteractions-GeneralOrdering-after");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_argument_message 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_argument_message", "Interactions-BasicInteractions-A_argument_message");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "message", 
    	    "Interactions-BasicInteractions-A_argument_message-message",
    	    "Interactions-BasicInteractions-Message",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Message-argument Interactions-BasicInteractions-A_argument_message-message");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_invariant_stateInvariant 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_invariant_stateInvariant", "Interactions-BasicInteractions-A_invariant_stateInvariant");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "stateInvariant", 
    	    "Interactions-BasicInteractions-A_invariant_stateInvariant-stateInvariant",
    	    "Interactions-BasicInteractions-StateInvariant",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-StateInvariant-invariant Interactions-BasicInteractions-A_invariant_stateInvariant-stateInvariant");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_stateInvariant_covered 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_stateInvariant_covered", "Interactions-BasicInteractions-A_stateInvariant_covered");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "stateInvariant", 
    	    "Interactions-BasicInteractions-A_stateInvariant_covered-stateInvariant",
    	    "Interactions-BasicInteractions-StateInvariant",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-A_stateInvariant_covered-stateInvariant Interactions-BasicInteractions-StateInvariant-covered");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_generalOrdering_interactionFragment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_generalOrdering_interactionFragment", "Interactions-BasicInteractions-A_generalOrdering_interactionFragment");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "interactionFragment", 
    	    "Interactions-BasicInteractions-A_generalOrdering_interactionFragment-interactionFragment",
    	    "Interactions-BasicInteractions-InteractionFragment",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-InteractionFragment-generalOrdering Interactions-BasicInteractions-A_generalOrdering_interactionFragment-interactionFragment");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_enclosingInteraction_fragment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_enclosingInteraction_fragment", "Interactions-BasicInteractions-A_enclosingInteraction_fragment");
        mapping.mapAssociation(assoc, "Interactions.BasicInteractions", this);
        // create owned ends
    	    
        factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-InteractionFragment-enclosingInteraction Interactions-BasicInteractions-Interaction-fragment");
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // Interactions.BasicInteractions.A_behavior_behaviorExecutionSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_behavior_beh