/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.CommonBehaviors.Communications;

import UMLPrimitiveTypes.intList;
import fUML.Debug;
import fUML.Semantics.Classes.Kernel.Object_;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.ParameterValueList;
import fUML.Semantics.CommonBehaviors.Communications.ArrivalSignal;
import fUML.Semantics.CommonBehaviors.Communications.ClassifierBehaviorExecution;
import fUML.Semantics.CommonBehaviors.Communications.ClassifierBehaviorExecutionList;
import fUML.Semantics.CommonBehaviors.Communications.EventAccepter;
import fUML.Semantics.CommonBehaviors.Communications.EventAccepterList;
import fUML.Semantics.CommonBehaviors.Communications.GetNextEventStrategy;
import fUML.Semantics.CommonBehaviors.Communications.SignalInstance;
import fUML.Semantics.CommonBehaviors.Communications.SignalInstanceList;
import fUML.Semantics.Loci.LociL1.ChoiceStrategy;
import fUML.Syntax.Classes.Kernel.Class_;
import fUML.Syntax.Classes.Kernel.Class_List;
import fUML.Syntax.CommonBehaviors.BasicBehaviors.Behavior;
import org.modeldriven.fuml.FumlObject;

public class ObjectActivation
extends FumlObject {
    public ClassifierBehaviorExecutionList classifierBehaviorExecutions = new ClassifierBehaviorExecutionList();
    public EventAccepterList waitingEventAccepters = new EventAccepterList();
    public SignalInstanceList eventPool = new SignalInstanceList();
    public Object_ object = null;

    public void startBehavior(Class_ classifier, ParameterValueList inputs) {
        this._startObjectBehavior();
        if (classifier == null) {
            Debug.println("[startBehavior] Starting behavior for all classifiers...");
            Class_List types = this.object.types;
            for (Class_ type : types) {
                if (!(type instanceof Behavior | type.classifierBehavior != null)) continue;
                this.startBehavior(type, new ParameterValueList());
            }
        } else {
            Debug.println("[startBehavior] Starting behavior for " + classifier.name + "...");
            boolean notYetStarted = true;
            int i = 1;
            while (notYetStarted & i <= this.classifierBehaviorExecutions.size()) {
                notYetStarted = this.classifierBehaviorExecutions.getValue((int)(i - 1)).classifier != classifier;
                ++i;
            }
            if (notYetStarted) {
                ClassifierBehaviorExecution newExecution = new ClassifierBehaviorExecution();
                newExecution.objectActivation = this;
                this.classifierBehaviorExecutions.addValue(newExecution);
                newExecution.execute(classifier, inputs);
            }
        }
    }

    public void stop() {
        ClassifierBehaviorExecutionList classifierBehaviorExecutions = this.classifierBehaviorExecutions;
        for (int i = 0; i < classifierBehaviorExecutions.size(); ++i) {
            ClassifierBehaviorExecution classifierBehaviorExecution = classifierBehaviorExecutions.getValue(i);
            classifierBehaviorExecution.terminate();
        }
    }

    public void register(EventAccepter accepter) {
        Debug.println("[register] object = " + this.object);
        Debug.println("[register] accepter = " + accepter);
        this.waitingEventAccepters.addValue(accepter);
    }

    public void unregister(EventAccepter accepter) {
        Debug.println("[unregister] object = " + this.object);
        Debug.println("[unregister] accepter = " + accepter);
        boolean notFound = true;
        int i = 1;
        while (notFound & i <= this.waitingEventAccepters.size()) {
            if (this.waitingEventAccepters.getValue(i - 1) == accepter) {
                this.waitingEventAccepters.remove(i - 1);
                notFound = false;
            }
            ++i;
        }
    }

    public void send(SignalInstance signalInstance) {
        this.eventPool.addValue((SignalInstance)signalInstance.copy());
        this._send(new ArrivalSignal());
    }

    public void dispatchNextEvent() {
        if (this.eventPool.size() > 0) {
            SignalInstance signalInstance = this.getNextEvent();
            Debug.println("[dispatchNextEvent] signalInstance = " + signalInstance);
            intList matchingEventAccepterIndexes = new intList();
            EventAccepterList waitingEventAccepters = this.waitingEventAccepters;
            for (int i = 0; i < waitingEventAccepters.size(); ++i) {
                EventAccepter eventAccepter = waitingEventAccepters.getValue(i);
                if (!eventAccepter.match(signalInstance)) continue;
                matchingEventAccepterIndexes.addValue(i);
            }
            if (matchingEventAccepterIndexes.size() > 0) {
                int j = ((ChoiceStrategy)this.object.locus.factory.getStrategy("choice")).choose(matchingEventAccepterIndexes.size());
                EventAccepter selectedEventAccepter = this.waitingEventAccepters.getValue(matchingEventAccepterIndexes.getValue(j - 1));
                this.waitingEventAccepters.removeValue(j - 1);
                selectedEventAccepter.accept(signalInstance);
            }
        }
    }

    public SignalInstance getNextEvent() {
        return ((GetNextEventStrategy)this.object.locus.factory.getStrategy("getNextEvent")).getNextEvent(this);
    }

    public void _startObjectBehavior() {
    }

    public void _send(ArrivalSignal signal) {
        this.dispatchNextEvent();
    }
}

