/*
 * Decompiled with CFR 0.152.
 */
package fUML.Test;

import fUML.Debug;
import fUML.Semantics.Classes.Kernel.Object_;
import fUML.Semantics.Classes.Kernel.Value;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.Execution;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.ParameterValue;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.ParameterValueList;
import fUML.Syntax.Classes.Kernel.Class_;
import fUML.Syntax.Classes.Kernel.Classifier;
import fUML.Syntax.Classes.Kernel.NamedElement;
import fUML.Syntax.Classes.Kernel.ParameterDirectionKind;
import fUML.Syntax.Classes.Kernel.ParameterList;
import fUML.Syntax.Classes.Kernel.ValueSpecification;
import fUML.Syntax.CommonBehaviors.BasicBehaviors.Behavior;
import fUML.Test.Test;
import fUML.Test.TestEnvironment;

public class ExecutorTest
extends Test {
    public ExecutorTest(TestEnvironment environment) {
        this.environment = environment;
    }

    protected ParameterValueList createDefaultInputValues(ParameterList parameters) {
        ParameterValueList parameterValues = new ParameterValueList();
        for (int i = 0; i < parameters.size(); ++i) {
            ParameterDirectionKind direction = parameters.getValue((int)i).direction;
            if (!direction.equals((Object)ParameterDirectionKind.in) && !direction.equals((Object)ParameterDirectionKind.inout)) continue;
            Debug.println("[createDefaultParameterValues] Creating parameter value for parameter " + parameters.getValue((int)i).name + "...");
            ParameterValue parameterValue = new ParameterValue();
            parameterValue.parameter = parameters.getValue(i);
            Value value = this.environment.makeValue((Classifier)parameters.getValue((int)i).type);
            if (value == null) {
                Debug.println("[createDefaultParameterValues] Error creating parameter value.");
                return null;
            }
            Debug.println("[createDefaultParameterValues] value = " + value);
            parameterValue.values.addValue(value);
            parameterValues.addValue(parameterValue);
        }
        return parameterValues;
    }

    public void testEvaluate(String typeName) {
        Debug.println("");
        Classifier type = this.environment.getType(typeName);
        if (type == null) {
            Debug.println("[testEvaluate] " + typeName + " not found or not a classifier.");
            return;
        }
        Value originalValue = this.environment.makeValue(type);
        Debug.println("[testEvaluate] Original value = " + originalValue);
        ValueSpecification specification = originalValue.specify();
        Debug.println("[testEvaluate] Value specification is " + specification.getClass().getName());
        Value evaluatedValue = this.environment.locus.executor.evaluate(specification);
        Debug.println("[testEvaluate] Evaluated value = " + evaluatedValue);
        Debug.println("[testEvaluate] Equality test = " + evaluatedValue.equals(originalValue));
    }

    public void testExecute(String behaviorName) {
        Debug.println("");
        NamedElement element = this.environment.getElement(behaviorName);
        if (element == null || !(element instanceof Behavior)) {
            Debug.println("[testExecute] " + behaviorName + " not found or is not a behavior.");
            return;
        }
        Behavior behavior = (Behavior)element;
        ParameterList parameters = behavior.ownedParameter;
        ParameterValueList parameterValues = this.createDefaultInputValues(parameters);
        if (parameterValues == null) {
            return;
        }
        Debug.println("[testExecute] Executing the behavior...");
        ParameterValueList outputParameterValues = this.environment.locus.executor.execute(behavior, null, parameterValues);
        for (int i = 0; i < outputParameterValues.size(); ++i) {
            ParameterValue outputParameterValue = outputParameterValues.getValue(i);
            Debug.println("[testExecute] Output parameter " + outputParameterValue.parameter.name + " has " + outputParameterValue.values.size() + " value(s):");
            for (int j = 0; j < outputParameterValue.values.size(); ++j) {
                Debug.println("[testExecute] value [" + j + "] = " + outputParameterValue.values.getValue(j));
            }
        }
        Debug.println("");
    }

    public void testStart(String typeName) {
        Behavior behavior;
        Debug.println("");
        NamedElement element = this.environment.getElement(typeName);
        if (element == null || !(element instanceof Class_)) {
            Debug.println("[testStart] " + typeName + " not found or is not a class.");
            return;
        }
        Class_ type = (Class_)element;
        if (type instanceof Behavior) {
            behavior = (Behavior)type;
        } else if (type.classifierBehavior != null) {
            behavior = type.classifierBehavior;
        } else {
            Debug.println("[testStart] " + typeName + " does not have behavior.");
            return;
        }
        ParameterList parameters = behavior.ownedParameter;
        ParameterValueList parameterValues = this.createDefaultInputValues(parameters);
        if (parameterValues == null) {
            return;
        }
        Debug.println("[testStart] Starting the behavior...");
        Object_ object = this.environment.locus.executor.start((Class_)type, (ParameterValueList)parameterValues).referent;
        Debug.println("[testStart] Instantiated object:" + object);
        ParameterValueList outputParameterValues = object instanceof Execution ? ((Execution)object).getOutputParameterValues() : object.objectActivation.classifierBehaviorExecutions.getValue((int)0).execution.getOutputParameterValues();
        for (int i = 0; i < outputParameterValues.size(); ++i) {
            ParameterValue outputParameterValue = outputParameterValues.getValue(i);
            Debug.println("[testStart] Output parameter " + outputParameterValue.parameter.name + " has " + outputParameterValue.values.size() + " value(s):");
            for (int j = 0; j < outputParameterValue.values.size(); ++j) {
                Debug.println("[testStart] value [" + j + "] = " + outputParameterValue.values.getValue(j));
            }
        }
    }
}

