/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.environment;

import fUML.Semantics.Classes.Kernel.RedefinitionBasedDispatchStrategy;
import fUML.Semantics.CommonBehaviors.Communications.FIFOGetNextEventStrategy;
import fUML.Semantics.Loci.LociL1.FirstChoiceStrategy;
import fUML.Syntax.Classes.Kernel.PrimitiveType;
import fUML.Syntax.CommonBehaviors.BasicBehaviors.Behavior;
import fUML.Test.TestEnvironment;
import org.modeldriven.fuml.common.uuid.UUIDGenerator;
import org.modeldriven.fuml.environment.EnvironmentException;
import org.modeldriven.fuml.environment.ExecutionFactory;
import org.modeldriven.fuml.repository.Element;
import org.modeldriven.fuml.repository.Repository;

public class Environment
extends TestEnvironment {
    private static Environment instance = null;

    private Environment() {
        this.locus.setFactory(new ExecutionFactory());
        this.locus.factory.setStrategy(new RedefinitionBasedDispatchStrategy());
        this.locus.factory.setStrategy(new FIFOGetNextEventStrategy());
        this.locus.factory.setStrategy(new FirstChoiceStrategy());
        this.primitiveTypes.Boolean.setXmiId(UUIDGenerator.instance().getIdString36());
        this.primitiveTypes.String.setXmiId(UUIDGenerator.instance().getIdString36());
        this.primitiveTypes.Integer.setXmiId(UUIDGenerator.instance().getIdString36());
        this.primitiveTypes.UnlimitedNatural.setXmiId(UUIDGenerator.instance().getIdString36());
    }

    public static Environment getInstance() {
        if (instance == null) {
            Environment.initializeInstance();
        }
        return instance;
    }

    private static synchronized void initializeInstance() {
        if (instance == null) {
            instance = new Environment();
        }
    }

    public Behavior findBehavior(String name) {
        Element elem = Repository.INSTANCE.findElementByName(name);
        if (elem != null) {
            if (elem.getDelegate() instanceof Behavior) {
                return (Behavior)elem.getDelegate();
            }
            throw new EnvironmentException("Element '" + name + "' is not a Behavior, it is a '" + elem.getDelegate().getClass().getSimpleName() + "'");
        }
        return null;
    }

    public fUML.Syntax.Classes.Kernel.Element findElementById(String id) {
        Element elem = Repository.INSTANCE.findElementById(id);
        if (elem != null) {
            return elem.getDelegate();
        }
        return null;
    }

    public int getBehaviorCount() {
        return Repository.INSTANCE.getElementCount(Behavior.class);
    }

    public String[] getBehaviorNames() {
        return Repository.INSTANCE.getElementNames(Behavior.class);
    }

    public PrimitiveType getBoolean() {
        return this.primitiveTypes.Boolean;
    }

    public PrimitiveType getString() {
        return this.primitiveTypes.String;
    }

    public PrimitiveType getInteger() {
        return this.primitiveTypes.Integer;
    }

    public PrimitiveType getUnlimitedNatural() {
        return this.primitiveTypes.UnlimitedNatural;
    }
}

