/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.repository.merge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.repository.Package;
import org.modeldriven.fuml.repository.merge.PackageGraphVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageGraphNode {
    private Log log = LogFactory.getLog(PackageGraphNode.class);
    private String id;
    private Package pkg;
    private List<PackageGraphNode> nodes;

    private PackageGraphNode() {
    }

    public PackageGraphNode(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public void setPackage(Package pkg) {
        this.pkg = pkg;
    }

    public List<PackageGraphNode> getNodes() {
        return this.nodes;
    }

    public void addNode(PackageGraphNode node) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<PackageGraphNode>();
        }
        this.nodes.add(node);
    }

    public void accept(PackageGraphVisitor visitor) {
        this.accept(visitor, this, null, new HashMap<PackageGraphNode, PackageGraphNode>());
    }

    private void accept(PackageGraphVisitor visitor, PackageGraphNode target, PackageGraphNode source, Map<PackageGraphNode, PackageGraphNode> visited) {
        if (this.log.isDebugEnabled()) {
            if (source != null) {
                this.log.debug((Object)("accept: " + target.getPackage().getQualifiedName() + "<-" + source.getPackage().getQualifiedName()));
            } else {
                this.log.debug((Object)("accept: " + target.getPackage().getQualifiedName()));
            }
        }
        if (visited.get(target) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ignoring, " + target.getPackage().getQualifiedName()));
            }
            return;
        }
        visited.put(target, target);
        List<PackageGraphNode> nodes = target.getNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.size(); ++i) {
                PackageGraphNode child = nodes.get(i);
                this.accept(visitor, child, target, visited);
            }
        }
        visitor.visit(target, source);
    }

    public boolean contains(PackageGraphNode source) {
        return this.nodes != null && this.nodes.contains(source);
    }
}

