/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Classes.Kernel;

import fUML.Semantics.Classes.Kernel.FeatureValue;
import fUML.Semantics.Classes.Kernel.FeatureValueList;
import fUML.Semantics.Classes.Kernel.StructuredValue;
import fUML.Semantics.Classes.Kernel.Value;
import fUML.Semantics.Classes.Kernel.ValueList;
import fUML.Syntax.Classes.Kernel.Classifier;
import fUML.Syntax.Classes.Kernel.ClassifierList;
import fUML.Syntax.Classes.Kernel.StructuralFeature;

public abstract class CompoundValue
extends StructuredValue {
    public FeatureValueList featureValues = new FeatureValueList();

    @Override
    public boolean equals(Value otherValue) {
        boolean isEqual = otherValue instanceof CompoundValue;
        if (isEqual) {
            CompoundValue otherCompoundValue = (CompoundValue)otherValue;
            isEqual = super.equals(otherValue) & otherCompoundValue.featureValues.size() == this.featureValues.size();
            int i = 1;
            while (isEqual & i <= this.featureValues.size()) {
                FeatureValue thisFeatureValue = this.featureValues.getValue(i - 1);
                boolean matched = false;
                int j = 1;
                while (!matched & j <= otherCompoundValue.featureValues.size()) {
                    FeatureValue otherFeatureValue = otherCompoundValue.featureValues.getValue(j - 1);
                    if (thisFeatureValue.feature == otherFeatureValue.feature) {
                        matched = thisFeatureValue.hasEqualValues(otherFeatureValue);
                    }
                    ++j;
                }
                isEqual = matched;
                ++i;
            }
        }
        return isEqual;
    }

    @Override
    public Value copy() {
        CompoundValue newValue = (CompoundValue)super.copy();
        FeatureValueList featureValues = this.featureValues;
        for (int i = 0; i < featureValues.size(); ++i) {
            FeatureValue featureValue = featureValues.getValue(i);
            newValue.featureValues.addValue(featureValue.copy());
        }
        return newValue;
    }

    @Override
    public FeatureValue getFeatureValue(StructuralFeature feature) {
        FeatureValue featureValue = null;
        int i = 1;
        while (featureValue == null & i <= this.featureValues.size()) {
            if (this.featureValues.getValue((int)(i - 1)).feature == feature) {
                featureValue = this.featureValues.getValue(i - 1);
            }
            ++i;
        }
        return featureValue;
    }

    @Override
    public void setFeatureValue(StructuralFeature feature, ValueList values, int position) {
        FeatureValue featureValue = this.getFeatureValue(feature);
        if (featureValue == null) {
            featureValue = new FeatureValue();
            this.featureValues.addValue(featureValue);
        }
        featureValue.feature = feature;
        featureValue.values = values;
        featureValue.position = position;
    }

    @Override
    public FeatureValueList getFeatureValues() {
        return this.featureValues;
    }

    public void removeFeatureValues(Classifier classifier) {
        int i = 1;
        while (i <= this.featureValues.size()) {
            if (this.featureValues.getValue((int)(i - 1)).feature.typedElement.type == classifier) {
                this.featureValues.remove(i - 1);
                continue;
            }
            ++i;
        }
    }

    @Override
    public String toString() {
        String buffer = "(" + this.objectId() + ":";
        ClassifierList types = this.getTypes();
        for (int i = 1; i <= types.size(); ++i) {
            buffer = buffer + " " + types.getValue((int)(i - 1)).name;
        }
        for (int k = 1; k <= this.featureValues.size(); ++k) {
            FeatureValue featureValue = this.featureValues.getValue(k - 1);
            buffer = buffer + "\n\t\t" + featureValue.feature.name + "[" + featureValue.position + "]  =";
            for (int j = 1; j <= featureValue.values.size(); ++j) {
                buffer = buffer + " " + featureValue.values.getValue(j - 1).toString();
            }
        }
        return buffer + ")";
    }
}

