/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.io;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.assembly.ElementAssemblerEventListener;
import org.modeldriven.fuml.assembly.ElementGraphAssembler;
import org.modeldriven.fuml.assembly.ElementStubAssembler;
import org.modeldriven.fuml.io.ElementReader;
import org.modeldriven.fuml.io.IOException;
import org.modeldriven.fuml.xmi.XmiChildFinder;
import org.modeldriven.fuml.xmi.stream.StreamNodeEvent;
import org.modeldriven.fuml.xmi.stream.StreamNodeListener;
import org.modeldriven.fuml.xmi.validation.ErrorCode;
import org.modeldriven.fuml.xmi.validation.ValidationError;
import org.modeldriven.fuml.xmi.validation.ValidationErrorCollector;
import org.modeldriven.fuml.xmi.validation.ValidationEventListener;

public class IncrementalElementReader
extends ElementReader
implements StreamNodeListener {
    private static Log log = LogFactory.getLog(IncrementalElementReader.class);
    private static String STREAM_ELEMENT_NAME_PACKAGED_ELEMENT = "packagedElement";

    @Override
    public String[] getElementNames() {
        return new String[]{STREAM_ELEMENT_NAME_PACKAGED_ELEMENT};
    }

    @Override
    public void nodeCreated(StreamNodeEvent event) {
    }

    @Override
    public void nodeCompleted(StreamNodeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("nodeCompleted '" + event.getSource().getLocalName() + "'"));
        }
        XmiChildFinder childFinder = new XmiChildFinder(event.getSource().getLocalName());
        event.getSource().accept(childFinder);
        if (childFinder.getResult() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ignoring element '" + event.getSource().getLocalName() + "' as non-atomic packaged element"));
            }
            return;
        }
        if (!event.getSource().getContext().getUmlNamespace().getNamespaceURI().equals(event.getSource().getNamespaceURI())) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("validating: " + event.getSource().getXmiType() + "(" + event.getSource().getXmiId() + ")"));
        }
        ValidationErrorCollector errorCollector = new ValidationErrorCollector(event.getSource());
        if (this.validationEventListeners != null) {
            for (ValidationEventListener listener : this.validationEventListeners) {
                errorCollector.addEventListener(listener);
            }
        }
        errorCollector.validate();
        int count = errorCollector.getErrorCount();
        if (count == 0) {
            ElementGraphAssembler assembler = new ElementGraphAssembler(event.getSource());
            if (this.elementAssemblerEventListeners != null) {
                for (ElementAssemblerEventListener listener : this.elementAssemblerEventListeners) {
                    assembler.addEventListener(listener);
                }
            }
            assembler.start();
            assembler.clear();
            this.freeNode(event);
        } else {
            int internalCount = errorCollector.getErrorCount(ErrorCode.INVALID_REFERENCE);
            if (count > internalCount) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("found invalid node: " + event.getSource().getXmiType() + " (" + event.getSource().getXmiId() + ")"));
                }
                ElementStubAssembler stubAssembler = new ElementStubAssembler(event.getSource());
                if (this.elementAssemblerEventListeners != null) {
                    for (ElementAssemblerEventListener listener : this.elementAssemblerEventListeners) {
                        stubAssembler.addEventListener(listener);
                    }
                }
                stubAssembler.start();
                for (ValidationError error : errorCollector.getErrors()) {
                    stubAssembler.addErrorText(error.getText());
                }
                this.freeNode(event);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("found node with unresolved references: " + event.getSource().getXmiType() + " (" + event.getSource().getXmiId() + ") - ignoring during incremental loading"));
            }
        }
    }

    private void freeNode(StreamNodeEvent event) {
        if (event.getParent() != null && !event.getParent().removeChild(event.getSource())) {
            throw new IOException("could not remove assembled node: " + event.getSource().getXmiType() + " (" + event.getSource().getXmiId() + ")");
        }
    }
}

