/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.repository.model;

import fUML.Syntax.Classes.Kernel.Operation;
import fUML.Syntax.Classes.Kernel.PackageableElement;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.FumlSystemProperty;
import org.modeldriven.fuml.bind.DefaultValidationEventHandler;
import org.modeldriven.fuml.common.reflect.ReflectionUtils;
import org.modeldriven.fuml.config.ExtensionPackage;
import org.modeldriven.fuml.config.FumlConfiguration;
import org.modeldriven.fuml.repository.Class_;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.repository.Element;
import org.modeldriven.fuml.repository.Extension;
import org.modeldriven.fuml.repository.Repository;
import org.modeldriven.fuml.repository.RepositoryArtifact;
import org.modeldriven.fuml.repository.RepositoryConfigDataBinding;
import org.modeldriven.fuml.repository.RepositoryMapping;
import org.modeldriven.fuml.repository.RepositorylException;
import org.modeldriven.fuml.repository.Stereotype;
import org.modeldriven.fuml.repository.config.Artifact;
import org.modeldriven.fuml.repository.config.IgnoredClass;
import org.modeldriven.fuml.repository.config.IgnoredPackage;
import org.modeldriven.fuml.repository.config.RegisteredPackage;
import org.modeldriven.fuml.repository.config.RepositoryConfig;
import org.modeldriven.fuml.repository.merge.PackageGraphNode;
import org.modeldriven.fuml.repository.merge.PackageGraphVisitor;
import org.modeldriven.fuml.repository.model.InMemoryMapping;
import org.modeldriven.fuml.repository.model.ModelAssembler;
import org.modeldriven.fuml.repository.model.Package;
import org.modeldriven.fuml.repository.model.Property;
import org.modeldriven.fuml.xmi.InvalidReferenceException;
import org.modeldriven.fuml.xmi.XmiException;
import org.xml.sax.SAXException;

public class InMemoryRepository
extends InMemoryMapping
implements Repository {
    private static Log log = LogFactory.getLog(InMemoryRepository.class);
    private static InMemoryRepository instance = null;
    private static String defaultConfigFileName = "RepositoryConfig.xml";
    private static final List<Classifier> EMPTY_CLASSIFIER_LIST = new ArrayList<Classifier>();
    private RepositoryConfig config;
    private Map<String, IgnoredPackage> ignoredPackageNameMap = new HashMap<String, IgnoredPackage>();
    private Map<String, IgnoredClass> ignoredClassNameMap = new HashMap<String, IgnoredClass>();
    private String activeConfigFileName;

    private InMemoryRepository() {
        log.info((Object)"initializing...");
        try {
            RepositoryConfigDataBinding configBinding = new RepositoryConfigDataBinding(new DefaultValidationEventHandler());
            this.activeConfigFileName = System.getProperty(FumlSystemProperty.REPOSITORY.getProperty(), defaultConfigFileName);
            this.config = this.unmarshalConfig(this.activeConfigFileName, configBinding);
        }
        catch (SAXException e) {
            throw new RepositorylException(e);
        }
        catch (JAXBException e) {
            throw new RepositorylException(e);
        }
        for (IgnoredPackage pkg : this.config.getIgnoredPackage()) {
            this.ignoredPackageNameMap.put(pkg.getName(), pkg);
        }
        for (IgnoredClass c : this.config.getIgnoredClass()) {
            this.ignoredClassNameMap.put(c.getName(), c);
        }
        this.bootstrap();
        this.construct();
    }

    public static InMemoryRepository getInstance() throws RepositorylException {
        if (instance == null) {
            InMemoryRepository.initializeInstance();
        }
        return instance;
    }

    private static synchronized void initializeInstance() throws RepositorylException {
        if (instance == null) {
            instance = new InMemoryRepository();
        }
    }

    private void construct() {
        log.info((Object)"cacheing classifier attributes and operations...");
        for (String className : this.classifierNameToClassifierMap.keySet()) {
            Classifier classifier = (Classifier)this.classifierNameToClassifierMap.get(className);
            if (!(classifier instanceof Class_)) continue;
            this.construct((Class_)classifier, className);
        }
    }

    private void construct(Class_ clss, String className) {
        ArrayList<org.modeldriven.fuml.repository.Property> attributes = new ArrayList<org.modeldriven.fuml.repository.Property>();
        this.collectAttributes(clss, attributes);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        this.collectOperations(clss, operations);
        org.modeldriven.fuml.repository.model.Class_ implClass = (org.modeldriven.fuml.repository.model.Class_)clss;
        implClass.setAttributes(attributes);
        implClass.setOperations(operations);
        String namespaceQualifiedName = this.config.getDefaultUMLNamespaceURI() + "#" + className;
        this.qualifiedClassifierNameToClassifierMap.put(namespaceQualifiedName, clss);
        String artifactQualifiedName = clss.getArtifact().getNamespaceURI() + "#" + className;
        this.qualifiedClassifierNameToClassifierMap.put(artifactQualifiedName, clss);
    }

    @Override
    public void loadClass(Class_ clss) {
        ArrayList<org.modeldriven.fuml.repository.Property> attributes = new ArrayList<org.modeldriven.fuml.repository.Property>();
        this.collectAttributes(clss, attributes);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        this.collectOperations(clss, operations);
        org.modeldriven.fuml.repository.model.Class_ implClass = (org.modeldriven.fuml.repository.model.Class_)clss;
        implClass.setAttributes(attributes);
        implClass.setOperations(operations);
        String artifactQualifiedName = clss.getArtifact().getNamespaceURI() + "#" + clss.getName();
        this.qualifiedClassifierNameToClassifierMap.put(artifactQualifiedName, clss);
    }

    private void bootstrap() {
        HashMap<Artifact, ModelAssembler> factoryMap = new HashMap<Artifact, ModelAssembler>();
        for (Artifact artifact : this.config.getArtifact()) {
            Object[] args = new Object[]{artifact, this, this};
            Class[] types = new Class[]{Artifact.class, RepositoryMapping.class, Repository.class};
            try {
                ModelAssembler factory = (ModelAssembler)ReflectionUtils.instanceForName(artifact.getFactoryClassName(), args, types);
                factoryMap.put(artifact, factory);
            }
            catch (Throwable e) {
                log.error((Object)e.getMessage(), e);
                throw new RepositorylException(e);
            }
        }
        log.info((Object)"performing package merge...");
        this.merge();
        for (Artifact artifact : this.config.getArtifact()) {
            ModelAssembler factory = (ModelAssembler)factoryMap.get(artifact);
            for (RegisteredPackage pkg : artifact.getRegisteredPackage()) {
                this.registerPackage((RepositoryArtifact)((Object)factory), pkg.getName());
            }
        }
    }

    private void merge() {
        List<PackageGraphNode> roots = this.findMergeRoots();
        for (PackageGraphNode root : roots) {
            org.modeldriven.fuml.repository.Package rootPackage = (org.modeldriven.fuml.repository.Package)this.getElementById(root.getId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("merging package root:  " + rootPackage.getHref()));
            }
            PackageGraphVisitor visitor = new PackageGraphVisitor(){

                @Override
                public void visit(PackageGraphNode target, PackageGraphNode source) {
                    if (source != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("visit: " + target.getPackage().getQualifiedName() + "<-" + source.getPackage().getQualifiedName()));
                        }
                        InMemoryRepository.this.mergePackage(source.getPackage().getDelegate(), target.getPackage().getDelegate());
                    }
                }
            };
            root.accept(visitor);
        }
    }

    private org.modeldriven.fuml.repository.Package getPackage(RepositoryArtifact artifact, String qualifiedName) {
        List artifactPackages = (List)this.artifactURIToPackagesMap.get(artifact.getURN());
        for (org.modeldriven.fuml.repository.Package p : artifactPackages) {
            if (!qualifiedName.equals(p.getQualifiedName())) continue;
            return p;
        }
        throw new RepositorylException("could not get package, " + qualifiedName);
    }

    private void registerPackage(RepositoryArtifact aftifact, String qualifiedName) {
        org.modeldriven.fuml.repository.Package p = this.getPackage(aftifact, qualifiedName);
        this.registerPackage(p);
    }

    private void registerPackage(org.modeldriven.fuml.repository.Package p) {
        for (PackageableElement element : p.getPackagedElement()) {
            fUML.Syntax.Classes.Kernel.Classifier c;
            if (element instanceof fUML.Syntax.Classes.Kernel.Class_) {
                c = (fUML.Syntax.Classes.Kernel.Class_)element;
                org.modeldriven.fuml.repository.model.Class_ clss = new org.modeldriven.fuml.repository.model.Class_((fUML.Syntax.Classes.Kernel.Class_)c, p.getArtifact());
                this.classifierNameToClassifierMap.put(c.name, clss);
                this.classifierNameToPackageNameMap.put(c.name, p.getQualifiedName());
                continue;
            }
            if (element instanceof fUML.Syntax.Classes.Kernel.Classifier) {
                c = (fUML.Syntax.Classes.Kernel.Classifier)element;
                org.modeldriven.fuml.repository.model.Classifier classifier = new org.modeldriven.fuml.repository.model.Classifier(c, p.getArtifact());
                this.classifierNameToClassifierMap.put(c.name, classifier);
                this.classifierNameToPackageNameMap.put(c.name, p.getQualifiedName());
                continue;
            }
            if (!(element instanceof fUML.Syntax.Classes.Kernel.Package)) continue;
            Package pkg = new Package((fUML.Syntax.Classes.Kernel.Package)element, p.getArtifact());
            this.registerPackage(pkg);
        }
    }

    private List<PackageGraphNode> findMergeRoots() {
        HashMap<String, PackageGraphNode> sources = new HashMap<String, PackageGraphNode>();
        Iterator merges = this.packageIdToPackageMergeMap.keySet().iterator();
        while (merges.hasNext()) {
            PackageGraphNode target = (PackageGraphNode)this.packageIdToPackageMergeMap.get(merges.next());
            org.modeldriven.fuml.repository.Package targetPackage = (org.modeldriven.fuml.repository.Package)this.getElementById(target.getId());
            target.setPackage(targetPackage);
            if (target.getNodes() == null) continue;
            for (PackageGraphNode source : target.getNodes()) {
                org.modeldriven.fuml.repository.Package sourcePackage = (org.modeldriven.fuml.repository.Package)this.getElementById(source.getId());
                source.setPackage(sourcePackage);
                sources.put(source.getId(), source);
            }
        }
        ArrayList<PackageGraphNode> roots = new ArrayList<PackageGraphNode>();
        merges = this.packageIdToPackageMergeMap.keySet().iterator();
        while (merges.hasNext()) {
            PackageGraphNode target = (PackageGraphNode)this.packageIdToPackageMergeMap.get(merges.next());
            if (sources.get(target.getId()) != null) continue;
            roots.add(target);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("found " + String.valueOf(roots.size()) + " merge-root and " + String.valueOf(sources.size()) + " source packages"));
        }
        return roots;
    }

    private RepositoryConfig unmarshalConfig(String configFileName, RepositoryConfigDataBinding binding) {
        try {
            InputStream stream = Element.class.getResourceAsStream(configFileName);
            if (stream == null) {
                stream = Element.class.getClassLoader().getResourceAsStream(configFileName);
            }
            if (stream == null) {
                throw new RepositorylException("cannot find resource '" + configFileName + "'");
            }
            JAXBElement root = (JAXBElement)binding.validate(stream);
            RepositoryConfig result = (RepositoryConfig)root.getValue();
            return result;
        }
        catch (UnmarshalException e) {
            throw new RepositorylException(e);
        }
        catch (JAXBException e) {
            throw new RepositorylException(e);
        }
    }

    protected void collectAttributes(Class_ clss, List<org.modeldriven.fuml.repository.Property> attributes) {
        fUML.Syntax.Classes.Kernel.Property[] props = new fUML.Syntax.Classes.Kernel.Property[clss.getDelegate().ownedAttribute.size()];
        clss.getDelegate().ownedAttribute.toArray(props);
        for (int i = 0; i < props.length; ++i) {
            fUML.Syntax.Classes.Kernel.Property fumlProperty = props[i];
            Property property = new Property(fumlProperty, clss.getArtifact());
            attributes.add(property);
        }
        for (Classifier generalization : clss.getGeneralization()) {
            String superclassXmiId = generalization.getXmiId();
            Element element = (Element)this.elementIdToElementMap.get(superclassXmiId);
            if (element == null) {
                throw new InvalidReferenceException(superclassXmiId);
            }
            Class_ umlSuperClass = (Class_)element;
            this.collectAttributes(umlSuperClass, attributes);
        }
    }

    protected void collectOperations(Class_ clss, List<Operation> operations) {
        for (Operation oper : clss.getDelegate().ownedOperation) {
            operations.add(oper);
        }
        for (Classifier generalization : clss.getGeneralization()) {
            String superclassXmiId = generalization.getXmiId();
            Element element = (Element)this.elementIdToElementMap.get(superclassXmiId);
            if (element == null) {
                throw new InvalidReferenceException(superclassXmiId);
            }
            Class_ umlSuperClass = (Class_)element;
            this.collectOperations(umlSuperClass, operations);
        }
    }

    @Override
    public RepositoryMapping getMapping() {
        return this;
    }

    @Override
    public String getDefaultUMLNamespaceURI() {
        return this.config.getDefaultUMLNamespaceURI();
    }

    @Override
    public Classifier getClassifier(String name) {
        return this.getClassifier(name, false);
    }

    @Override
    public Classifier findClassifier(String name) {
        return this.getClassifier(name, true);
    }

    private Classifier getClassifier(String name, boolean supressErrors) {
        Classifier result = null;
        result = name.indexOf(".") == -1 && name.indexOf("#") == -1 ? (Classifier)this.classifierNameToClassifierMap.get(name) : (Classifier)this.qualifiedClassifierNameToClassifierMap.get(name);
        if (result == null && !supressErrors) {
            throw new RepositorylException("no classifier found for name, '" + name + "'");
        }
        return result;
    }

    public Classifier[] getAllClassifiers() {
        Iterator iter = this.classifierNameToClassifierMap.keySet().iterator();
        ArrayList list = new ArrayList();
        while (iter.hasNext()) {
            list.add(this.classifierNameToClassifierMap.get(iter.next()));
        }
        Classifier[] result = new Classifier[list.size()];
        list.toArray(result);
        return result;
    }

    @Override
    public List<Extension> getExtensions(Element element) {
        List result = (List)this.elementToExtensionListMap.get(element.getXmiId());
        if (result != null) {
            return result;
        }
        return new ArrayList<Extension>();
    }

    @Override
    public List<Stereotype> getStereotypes(Element element) {
        List result = (List)this.elementToStereotypeListMap.get(element.getXmiId());
        if (result != null) {
            return result;
        }
        return new ArrayList<Stereotype>();
    }

    @Override
    public List<Stereotype> getStereotypes(Class<?> clss) {
        List result = (List)this.classToStereotypeListMap.get(clss);
        if (result != null) {
            return result;
        }
        return new ArrayList<Stereotype>();
    }

    @Override
    public List<Stereotype> getAllStereotypes() {
        ArrayList<Stereotype> result = new ArrayList<Stereotype>();
        for (List sublist : this.elementToStereotypeListMap.values()) {
            result.addAll(sublist);
        }
        return result;
    }

    @Override
    public String getJavaPackageNameForClass(Classifier classifier) {
        return this.getJavaPackageNameForClass(classifier, false);
    }

    @Override
    public String findJavaPackageNamePackageForClass(Classifier classifier) {
        return this.getJavaPackageNameForClass(classifier, true);
    }

    private String getJavaPackageNameForClass(Classifier classifier, boolean supressErrors) {
        String classifierName = classifier.getName();
        String result = null;
        if (classifierName.indexOf(".") == -1) {
            for (ExtensionPackage extPkg : FumlConfiguration.getInstance().getConfig().getImportConfiguration().getExtensionPackage()) {
                String qualifiedClassName = extPkg.getName() + "." + classifierName;
                try {
                    Class.forName(qualifiedClassName);
                    result = extPkg.getName();
                    break;
                }
                catch (ClassNotFoundException e) {
                }
            }
            if (result == null) {
                result = (String)this.classifierNameToPackageNameMap.get(classifierName);
            }
        } else {
            result = (String)this.qualifiedClassifierNameToPackageNameMap.get(classifierName);
        }
        if (result == null && !supressErrors) {
            throw new XmiException("no package found for class '" + classifierName + "'");
        }
        return result;
    }

    public boolean isIgnoredClassifier(String classifierName) {
        return this.ignoredClassNameMap.get(classifierName) != null;
    }

    @Override
    public boolean isIgnoredClassifier(Classifier classifier) {
        String packageName = this.getJavaPackageNameForClass(classifier);
        if (this.isIgnoredPackage(packageName)) {
            return true;
        }
        return this.ignoredClassNameMap.get(classifier.getName()) != null;
    }

    public boolean isIgnoredPackage(String packageName) {
        return this.ignoredPackageNameMap.get(packageName) != null;
    }

    public static void main(String[] args) {
        InMemoryRepository.getInstance();
    }

    @Override
    public List<Classifier> getSpecializations(Classifier classifier) {
        List result = (List)this.classifierIdToSpecializationClassifierMap.get(classifier.getXmiId());
        if (result != null) {
            return result;
        }
        return EMPTY_CLASSIFIER_LIST;
    }
}

