/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Activities.CompleteStructuredActivities;

import fUML.Debug;
import fUML.Semantics.Activities.CompleteStructuredActivities.ClauseActivation;
import fUML.Semantics.Activities.CompleteStructuredActivities.ClauseActivationList;
import fUML.Semantics.Activities.CompleteStructuredActivities.StructuredActivityNodeActivation;
import fUML.Semantics.Activities.IntermediateActivities.ActivityNodeActivation;
import fUML.Semantics.Activities.IntermediateActivities.ActivityNodeActivationList;
import fUML.Semantics.Activities.IntermediateActivities.TokenList;
import fUML.Semantics.Loci.LociL1.ChoiceStrategy;
import fUML.Syntax.Actions.BasicActions.OutputPin;
import fUML.Syntax.Actions.BasicActions.OutputPinList;
import fUML.Syntax.Actions.BasicActions.Pin;
import fUML.Syntax.Activities.CompleteStructuredActivities.Clause;
import fUML.Syntax.Activities.CompleteStructuredActivities.ClauseList;
import fUML.Syntax.Activities.CompleteStructuredActivities.ConditionalNode;
import fUML.Syntax.Activities.CompleteStructuredActivities.ExecutableNode;
import fUML.Syntax.Activities.CompleteStructuredActivities.ExecutableNodeList;

public class ConditionalNodeActivation
extends StructuredActivityNodeActivation {
    public ClauseActivationList clauseActivations = new ClauseActivationList();
    public ClauseList selectedClauses = new ClauseList();
    public Clause selectedClause = null;

    @Override
    public void doStructuredActivity() {
        ClauseActivation clauseActivation2;
        ConditionalNode node = (ConditionalNode)this.node;
        ActivityNodeActivationList nodeActivations = this.activationGroup.nodeActivations;
        ActivityNodeActivationList nonExecutableNodeActivations = new ActivityNodeActivationList();
        for (int i = 0; i < nodeActivations.size(); ++i) {
            ActivityNodeActivation nodeActivation = nodeActivations.getValue(i);
            if (nodeActivation.node instanceof ExecutableNode | nodeActivation.node instanceof Pin) continue;
            nonExecutableNodeActivations.addValue(nodeActivation);
        }
        this.activationGroup.run(nonExecutableNodeActivations);
        this.clauseActivations.clear();
        ClauseList clauses = node.clause;
        for (int i = 0; i < clauses.size(); ++i) {
            Clause clause = clauses.getValue(i);
            clauseActivation2 = new ClauseActivation();
            clauseActivation2.clause = clause;
            clauseActivation2.conditionalNodeActivation = this;
            this.clauseActivations.addValue(clauseActivation2);
        }
        this.selectedClauses.clear();
        ClauseActivationList readyClauseActivations = new ClauseActivationList();
        for (int i = 0; i < this.clauseActivations.size(); ++i) {
            clauseActivation2 = this.clauseActivations.getValue(i);
            Debug.println("[doStructuredActivity] clauseActivations[" + i + "] = " + clauseActivation2);
            if (!clauseActivation2.isReady()) continue;
            Debug.println("[doStructuredActivity] Clause activation is ready.");
            readyClauseActivations.addValue(clauseActivation2);
        }
        for (ClauseActivation clauseActivation2 : readyClauseActivations) {
            Debug.println("[doStructuredActivity] Giving control to " + clauseActivation2 + "...");
            clauseActivation2.receiveControl();
        }
        this.selectedClause = null;
        if (this.selectedClauses.size() > 0 & this.isRunning()) {
            Debug.println("[doStructuredActivity] " + this.selectedClauses.size() + " clause(s) selected.");
            int i = ((ChoiceStrategy)this.getExecutionLocus().factory.getStrategy("choice")).choose(this.selectedClauses.size());
            this.selectedClause = this.selectedClauses.getValue(i - 1);
            Debug.println("[doStructuredActivity] Running selectedClauses[" + i + "] = " + this.selectedClause);
            for (int j = 0; j < clauses.size(); ++j) {
                Clause clause = clauses.getValue(j);
                if (clause == this.selectedClause) continue;
                ExecutableNodeList testNodes = clause.test;
                for (int k = 0; k < testNodes.size(); ++k) {
                    ExecutableNode testNode = testNodes.getValue(k);
                    this.activationGroup.getNodeActivation(testNode).terminate();
                }
            }
            this.activationGroup.runNodes(this.makeActivityNodeList(this.selectedClause.body));
        }
    }

    public void completeBody() {
        if (this.selectedClause != null) {
            ConditionalNode node = (ConditionalNode)this.node;
            OutputPinList resultPins = node.result;
            OutputPinList bodyOutputPins = this.selectedClause.bodyOutput;
            for (int k = 0; k < resultPins.size(); ++k) {
                OutputPin resultPin = resultPins.getValue(k);
                OutputPin bodyOutputPin = bodyOutputPins.getValue(k);
                this.putTokens(resultPin, this.getPinValues(bodyOutputPin));
            }
        }
        this.activationGroup.terminateAll();
    }

    @Override
    public TokenList completeAction() {
        if (!this.isSuspended()) {
            this.completeBody();
        }
        return super.completeAction();
    }

    public ClauseActivation getClauseActivation(Clause clause) {
        ClauseActivation selectedClauseActivation = null;
        int i = 1;
        while (selectedClauseActivation == null & i <= this.clauseActivations.size()) {
            ClauseActivation clauseActivation = this.clauseActivations.getValue(i - 1);
            if (clauseActivation.clause == clause) {
                selectedClauseActivation = clauseActivation;
            }
            ++i;
        }
        return selectedClauseActivation;
    }

    public void runTest(Clause clause) {
        if (this.isRunning()) {
            this.activationGroup.runNodes(this.makeActivityNodeList(clause.test));
        }
    }

    public void selectBody(Clause clause) {
        this.selectedClauses.addValue(clause);
    }

    @Override
    public void resume() {
        this.completeBody();
        super.resume();
    }
}

