/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.bind;

import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.bind.BindingValidationEventHandler;

public class DefaultValidationEventHandler
implements BindingValidationEventHandler {
    private static Log log = LogFactory.getLog(DefaultValidationEventHandler.class);
    private int errorCount;
    private boolean cumulative = true;

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    public DefaultValidationEventHandler() {
    }

    public DefaultValidationEventHandler(boolean cumulative) {
        this.cumulative = cumulative;
    }

    public boolean handleEvent(ValidationEvent ve) {
        boolean result = this.cumulative;
        ++this.errorCount;
        ValidationEventLocator vel = ve.getLocator();
        String message = "Line:Col:Offset[" + vel.getLineNumber() + ":" + vel.getColumnNumber() + ":" + String.valueOf(vel.getOffset()) + "] - " + ve.getMessage();
        switch (ve.getSeverity()) {
            case 0: {
                log.warn((Object)message);
                break;
            }
            case 1: {
                log.error((Object)message);
                break;
            }
            case 2: {
                log.fatal((Object)message);
                break;
            }
            default: {
                log.error((Object)message);
            }
        }
        return result;
    }

    public void reset() {
        this.errorCount = 0;
    }
}

