/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.library.channel;

import fUML.Semantics.Classes.Kernel.Value;
import org.modeldriven.fuml.library.channel.TextOutputChannelObject;
import org.modeldriven.fuml.library.common.Status;

public class StandardOutputChannelObject
extends TextOutputChannelObject {
    private boolean opened = true;

    @Override
    public String getName() {
        return "StandardOutput";
    }

    @Override
    public void open(Status errorStatus) {
        this.opened = true;
    }

    @Override
    public void close(Status errorStatus) {
        this.opened = false;
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public void write(Value value, Status errorStatus) {
        this.writeString(value.toString(), errorStatus);
    }

    @Override
    public void writeString(String value, Status errorStatus) {
        if (this.isOpen()) {
            System.out.print(value);
        } else {
            errorStatus.setStatus("StandardOutputChannel", -1, "Not open");
        }
    }

    @Override
    public void writeNewLine(Status errorStatus) {
        if (this.isOpen()) {
            System.out.println();
        } else {
            errorStatus.setStatus("StandardOutputChannel", -1, "Not open");
        }
    }

    @Override
    public Value new_() {
        return new StandardOutputChannelObject();
    }
}

