/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.io;

import fUML.Syntax.Activities.IntermediateActivities.Activity;
import fUML.Syntax.Classes.Kernel.Class_;
import fUML.Syntax.Classes.Kernel.DataType;
import fUML.Syntax.Classes.Kernel.Element;
import fUML.Syntax.Classes.Kernel.Enumeration;
import fUML.Syntax.Classes.Kernel.EnumerationLiteral;
import fUML.Syntax.Classes.Kernel.NamedElement;
import fUML.Syntax.Classes.Kernel.Package;
import fUML.Syntax.Classes.Kernel.PrimitiveType;
import fUML.Syntax.Classes.Kernel.Property;
import fUML.Syntax.CommonBehaviors.BasicBehaviors.OpaqueBehavior;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.FumlObject;
import org.modeldriven.fuml.assembly.ElementAssemblerEvent;
import org.modeldriven.fuml.assembly.ElementAssemblerEventListener;
import org.modeldriven.fuml.assembly.ElementAssemblerResultsEvent;
import org.modeldriven.fuml.io.BasicElementReader;
import org.modeldriven.fuml.io.ElementReaderEvent;
import org.modeldriven.fuml.io.ElementReaderEventListener;
import org.modeldriven.fuml.io.FileArtifact;
import org.modeldriven.fuml.io.IOException;
import org.modeldriven.fuml.io.ResourceArtifact;
import org.modeldriven.fuml.repository.Repository;
import org.modeldriven.fuml.repository.RepositoryArtifact;
import org.modeldriven.fuml.repository.model.Stereotype;
import org.modeldriven.fuml.xmi.stream.StreamReader;
import org.modeldriven.fuml.xmi.validation.ErrorSeverity;
import org.modeldriven.fuml.xmi.validation.ValidationErrorEvent;
import org.modeldriven.fuml.xmi.validation.ValidationEvent;
import org.modeldriven.fuml.xmi.validation.ValidationEventListener;

public class ArtifactLoader
implements ValidationEventListener,
ElementAssemblerEventListener,
ElementReaderEventListener {
    private static Log log = LogFactory.getLog(ArtifactLoader.class);
    protected List<Class_> classList = new ArrayList<Class_>();
    protected RepositoryArtifact artifact;
    protected BasicElementReader modelElementReader;
    protected boolean validateExternalReferences = true;
    protected boolean assembleExternalReferences = true;

    public ArtifactLoader() {
        this.modelElementReader = new BasicElementReader();
    }

    public ArtifactLoader(BasicElementReader modelElementReader) {
        this.modelElementReader = modelElementReader;
    }

    public boolean isValidateExternalReferences() {
        return this.modelElementReader.isValidateExternalReferences();
    }

    public void setValidateExternalReferences(boolean validateExternalReferences) {
        this.modelElementReader.setValidateExternalReferences(validateExternalReferences);
    }

    public boolean isAssembleExternalReferences() {
        return this.modelElementReader.isAssembleExternalReferences();
    }

    public void setAssembleExternalReferences(boolean assembleExternalReferences) {
        this.modelElementReader.setAssembleExternalReferences(assembleExternalReferences);
    }

    public void read(FileArtifact artifact) {
        log.debug((Object)("reading " + artifact.getURN()));
        this.artifact = artifact;
        StreamReader reader = new StreamReader();
        reader.addStreamNodeListener(this.modelElementReader);
        this.modelElementReader.addValidationEventListener(this);
        this.modelElementReader.addElementAssemblerEventListener(this);
        this.modelElementReader.addElementReaderEventListener(this);
        try {
            reader.read(new FileInputStream(artifact.getFile()));
        }
        catch (FileNotFoundException e) {
            throw new IOException(e);
        }
    }

    public void read(ResourceArtifact artifact) {
        this.artifact = artifact;
        log.debug((Object)("reading " + artifact.getURN()));
        StreamReader reader = new StreamReader();
        reader.addStreamNodeListener(this.modelElementReader);
        this.modelElementReader.addValidationEventListener(this);
        this.modelElementReader.addElementAssemblerEventListener(this);
        this.modelElementReader.addElementReaderEventListener(this);
        reader.read(artifact.getInputStream());
    }

    @Override
    public void validationCompleted(ValidationEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"validation completed");
        }
    }

    @Override
    public void validationError(ValidationErrorEvent event) {
        if (event.getError().getSeverity().ordinal() == ErrorSeverity.FATAL.ordinal()) {
            log.error((Object)("(" + this.artifact.getURN() + ") validation error " + event.getError().getText()));
        } else if (event.getError().getSeverity().ordinal() == ErrorSeverity.WARN.ordinal()) {
            log.warn((Object)("(" + this.artifact.getURN() + ") validation error " + event.getError().getText()));
        } else if (event.getError().getSeverity().ordinal() == ErrorSeverity.INFO.ordinal()) {
            log.info((Object)("(" + this.artifact.getURN() + ") validation error " + event.getError().getText()));
        } else {
            log.error((Object)("(" + this.artifact.getURN() + ") validation error " + event.getError().getText()));
        }
    }

    @Override
    public void validationStarted(ValidationEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"validation started");
        }
    }

    @Override
    public void elementAssembled(ElementAssemblerEvent event) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("element assembled: (" + event.getSource().getClass().getName() + ") " + event.getSource().getXmiId()));
            }
        }
        catch (NullPointerException e) {
            if (event == null) {
                log.error((Object)"found null event");
            }
            if (event.getSource() == null) {
                log.error((Object)"found null event source");
            }
            log.error((Object)e);
        }
    }

    @Override
    public void elementGraphAssembled(ElementAssemblerResultsEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"element graph assembled");
        }
        for (String id : event.getSource().getResultsXmiIds()) {
            NamedElement namedElement;
            FumlObject fumlObject = event.getSource().lookupResult(id);
            if (fumlObject == null) {
                log.warn((Object)("could not lookup element from id '" + id + "'"));
                continue;
            }
            if (fumlObject instanceof NamedElement) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("loading: (" + fumlObject.getClass().getName() + ") " + ((NamedElement)fumlObject).qualifiedName + " (" + id + ")"));
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("loading: (" + fumlObject.getClass().getName() + ") " + "(" + id + ")"));
                }
            }
            if (fumlObject instanceof Activity) {
                namedElement = (NamedElement)fumlObject;
                Repository.INSTANCE.getMapping().mapElementByName(namedElement, this.artifact);
                Repository.INSTANCE.getMapping().mapElementById(namedElement, this.artifact);
                continue;
            }
            if (fumlObject instanceof Class_ && !(fumlObject instanceof OpaqueBehavior)) {
                Class_ clss = (Class_)fumlObject;
                this.classList.add(clss);
                if (!(clss instanceof org.modeldriven.fuml.repository.ext.Stereotype)) {
                    if (clss.package_ != null) {
                        Repository.INSTANCE.getMapping().mapClass(clss, this.getQualifiedPackageName(clss.package_), this.artifact);
                        continue;
                    }
                    Repository.INSTANCE.getMapping().mapClass(clss, null, this.artifact);
                    continue;
                }
                org.modeldriven.fuml.repository.ext.Stereotype stereotype = (org.modeldriven.fuml.repository.ext.Stereotype)clss;
                if (stereotype.package_ != null) {
                    Repository.INSTANCE.getMapping().mapStereotype(stereotype, this.getQualifiedPackageName(stereotype.package_), this.artifact);
                    continue;
                }
                Repository.INSTANCE.getMapping().mapStereotype(stereotype, null, this.artifact);
                continue;
            }
            if (fumlObject instanceof Enumeration) {
                Enumeration enumeration = (Enumeration)fumlObject;
                if (enumeration.package_ != null) {
                    Repository.INSTANCE.getMapping().mapEnumerationExternal(enumeration, this.getQualifiedPackageName(enumeration.package_), this.artifact);
                    continue;
                }
                Repository.INSTANCE.getMapping().mapEnumerationExternal(enumeration, null, this.artifact);
                continue;
            }
            if (fumlObject instanceof DataType) {
                if (fumlObject instanceof PrimitiveType) continue;
                DataType datatype = (DataType)fumlObject;
                if (datatype.package_ != null) {
                    Repository.INSTANCE.getMapping().mapDataType(datatype, this.getQualifiedPackageName(datatype.package_), this.artifact);
                    continue;
                }
                Repository.INSTANCE.getMapping().mapDataType(datatype, null, this.artifact);
                continue;
            }
            if (fumlObject instanceof Property) {
                Property property = (Property)fumlObject;
                Repository.INSTANCE.getMapping().mapProperty(property.class_, property, this.artifact);
                continue;
            }
            if (fumlObject instanceof EnumerationLiteral) {
                EnumerationLiteral literal = (EnumerationLiteral)fumlObject;
                Repository.INSTANCE.getMapping().mapEnumerationLiteral(literal, null, this.artifact);
                continue;
            }
            if (fumlObject instanceof Package) {
                Package pkg = (Package)fumlObject;
                Repository.INSTANCE.getMapping().mapPackage(pkg, null, this.artifact);
                continue;
            }
            if (fumlObject instanceof NamedElement) {
                namedElement = (NamedElement)fumlObject;
                Repository.INSTANCE.getMapping().mapElementByName(namedElement, this.artifact);
                Repository.INSTANCE.getMapping().mapElementById(namedElement, this.artifact);
                continue;
            }
            if (fumlObject instanceof Element) {
                Element element = (Element)fumlObject;
                Repository.INSTANCE.getMapping().mapElementById(element, this.artifact);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("ignoring class, " + fumlObject.getClass().getName()));
        }
    }

    @Override
    public void elementStubAssembled(ElementAssemblerResultsEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"element stub assembled");
        }
        for (String id : event.getSource().getResultsXmiIds()) {
            FumlObject fumlObject = event.getSource().lookupResult(id);
            if (fumlObject instanceof NamedElement) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("loading: (" + fumlObject.getClass().getName() + ") " + ((NamedElement)fumlObject).qualifiedName + " (" + id + ")"));
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("loading: (" + fumlObject.getClass().getName() + ") " + "(" + id + ")"));
                }
            }
            if (fumlObject instanceof NamedElement) {
                NamedElement namedElement = (NamedElement)fumlObject;
                Repository.INSTANCE.getMapping().mapElementByName(namedElement, this.artifact);
                Repository.INSTANCE.getMapping().mapElementById(namedElement, this.artifact);
                log.warn((Object)("imported invalid " + namedElement.getClass() + " (" + namedElement.getXmiId() + ") '" + namedElement.name + "' as non-executable \"stub\" element"));
                continue;
            }
            if (fumlObject instanceof Element) {
                NamedElement element = (NamedElement)fumlObject;
                Repository.INSTANCE.getMapping().mapElementById(element, this.artifact);
                log.warn((Object)("imported invalid " + fumlObject.getClass() + " (" + fumlObject.getXmiId() + " as non-executable \"stub\" element"));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("ignoring class, " + fumlObject.getClass().getName()));
        }
    }

    @Override
    public void streamCompleted(ElementReaderEvent event) {
        for (Class_ c : this.classList) {
            org.modeldriven.fuml.repository.model.Class_ clss = null;
            clss = !(c instanceof org.modeldriven.fuml.repository.ext.Stereotype) ? new org.modeldriven.fuml.repository.model.Class_(c, this.artifact) : new Stereotype((org.modeldriven.fuml.repository.ext.Stereotype)c, this.artifact);
            Repository.INSTANCE.loadClass(clss);
        }
    }

    private String getQualifiedPackageName(Package pkg) {
        ArrayList<Package> list = new ArrayList<Package>();
        Package p = pkg;
        while (p != null) {
            list.add(p);
            p = p.nestingPackage;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i < list.size() - 1) {
                buf.append(".");
            }
            buf.append(((Package)list.get((int)i)).name);
        }
        return buf.toString();
    }
}

