/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Loci.LociL1;

import fUML.Semantics.Classes.Kernel.ExtensionalValue;
import fUML.Semantics.Classes.Kernel.ExtensionalValueList;
import fUML.Semantics.Classes.Kernel.Object_;
import fUML.Semantics.Loci.LociL1.ExecutionFactory;
import fUML.Semantics.Loci.LociL1.Executor;
import fUML.Syntax.Classes.Kernel.Class_;
import fUML.Syntax.Classes.Kernel.Classifier;
import fUML.Syntax.Classes.Kernel.ClassifierList;
import fUML.Syntax.CommonBehaviors.BasicBehaviors.Behavior;
import org.modeldriven.fuml.FumlObject;

public class Locus
extends FumlObject {
    public String identifier = Integer.toHexString(this.hashCode());
    public Executor executor = null;
    public ExecutionFactory factory = null;
    public ExtensionalValueList extensionalValues = new ExtensionalValueList();

    public void setExecutor(Executor executor) {
        this.executor = executor;
        this.executor.locus = this;
    }

    public void setFactory(ExecutionFactory factory) {
        this.factory = factory;
        this.factory.locus = this;
    }

    public ExtensionalValueList getExtent(Classifier classifier) {
        ExtensionalValueList extent = new ExtensionalValueList();
        ExtensionalValueList extensionalValues = this.extensionalValues;
        for (int i = 0; i < extensionalValues.size(); ++i) {
            ExtensionalValue value = extensionalValues.getValue(i);
            ClassifierList types = value.getTypes();
            boolean conforms = false;
            int j = 1;
            while (!conforms & j <= types.size()) {
                conforms = this.conforms(types.getValue(j - 1), classifier);
                ++j;
            }
            if (!conforms) continue;
            extent.addValue(value);
        }
        return extent;
    }

    public void add(ExtensionalValue value) {
        value.locus = this;
        value.identifier = this.identifier + "#" + this.makeIdentifier(value);
        this.extensionalValues.addValue(value);
    }

    public String makeIdentifier(ExtensionalValue value) {
        return Integer.toHexString(value.hashCode());
    }

    public void remove(ExtensionalValue value) {
        value.locus = null;
        boolean notFound = true;
        int i = 1;
        while (notFound & i <= this.extensionalValues.size()) {
            if (this.extensionalValues.getValue(i - 1) == value) {
                this.extensionalValues.remove(i - 1);
                notFound = false;
            }
            ++i;
        }
    }

    public Object_ instantiate(Class_ type) {
        Object_ object = null;
        if (type instanceof Behavior) {
            object = this.factory.createExecution((Behavior)type, null);
        } else {
            object = new Object_();
            object.types.addValue(type);
            object.createFeatureValues();
            this.add(object);
        }
        return object;
    }

    public boolean conforms(Classifier type, Classifier classifier) {
        boolean doesConform = false;
        if (type == classifier) {
            doesConform = true;
        } else {
            int i = 1;
            while (!doesConform & i <= type.general.size()) {
                doesConform = this.conforms(type.general.getValue(i - 1), classifier);
                ++i;
            }
        }
        return doesConform;
    }
}

