/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Classes.Kernel;

import fUML.Semantics.Classes.Kernel.FeatureValue;
import fUML.Semantics.Classes.Kernel.FeatureValueList;
import fUML.Semantics.Classes.Kernel.Value;
import fUML.Semantics.Classes.Kernel.ValueList;
import fUML.Syntax.Classes.Kernel.Classifier;
import fUML.Syntax.Classes.Kernel.ClassifierList;
import fUML.Syntax.Classes.Kernel.InstanceSpecification;
import fUML.Syntax.Classes.Kernel.InstanceValue;
import fUML.Syntax.Classes.Kernel.NamedElement;
import fUML.Syntax.Classes.Kernel.NamedElementList;
import fUML.Syntax.Classes.Kernel.Slot;
import fUML.Syntax.Classes.Kernel.StructuralFeature;
import fUML.Syntax.Classes.Kernel.ValueSpecification;

public abstract class StructuredValue
extends Value {
    @Override
    public ValueSpecification specify() {
        InstanceValue instanceValue = new InstanceValue();
        InstanceSpecification instance = new InstanceSpecification();
        instanceValue.type = null;
        instanceValue.instance = instance;
        instance.classifier = this.getTypes();
        FeatureValueList featureValues = this.getFeatureValues();
        for (int i = 0; i < featureValues.size(); ++i) {
            FeatureValue featureValue = featureValues.getValue(i);
            Slot slot = new Slot();
            slot.definingFeature = featureValue.feature;
            ValueList values = featureValue.values;
            for (int j = 0; j < values.size(); ++j) {
                Value value = values.getValue(j);
                slot.value.addValue(value.specify());
            }
            instance.slot.addValue(slot);
        }
        return instanceValue;
    }

    public abstract FeatureValue getFeatureValue(StructuralFeature var1);

    public abstract void setFeatureValue(StructuralFeature var1, ValueList var2, int var3);

    public abstract FeatureValueList getFeatureValues();

    public FeatureValueList getMemberValues() {
        FeatureValueList featureValues = this.getFeatureValues();
        FeatureValueList memberValues = new FeatureValueList();
        ClassifierList types = this.getTypes();
        for (int i = 0; i < featureValues.size(); ++i) {
            FeatureValue featureValue = featureValues.getValue(i);
            Boolean isMember = false;
            int j = 1;
            while (j <= types.size() & isMember == false) {
                Classifier type = types.getValue(j - 1);
                NamedElementList members = type.member;
                int k = 1;
                while (k <= members.size() & isMember == false) {
                    NamedElement member = members.getValue(k - 1);
                    isMember = featureValue.feature == member;
                    ++k;
                }
                ++j;
            }
            if (!isMember.booleanValue()) continue;
            memberValues.addValue(featureValue);
        }
        return memberValues;
    }

    public void createFeatureValues() {
        this.addFeatureValues(new FeatureValueList());
    }

    public void addFeatureValues(FeatureValueList oldFeatureValues) {
        ClassifierList types = this.getTypes();
        for (int i = 0; i < types.size(); ++i) {
            Classifier type = types.getValue(i);
            this.addFeatureValuesForType(type, oldFeatureValues);
        }
    }

    public void addFeatureValuesForType(Classifier type, FeatureValueList oldFeatureValues) {
        NamedElementList ownedMembers = type.ownedMember;
        for (int j = 0; j < ownedMembers.size(); ++j) {
            NamedElement ownedMember = ownedMembers.getValue(j);
            if (!(ownedMember instanceof StructuralFeature)) continue;
            this.setFeatureValue((StructuralFeature)ownedMember, this.getValues(ownedMember, oldFeatureValues), 0);
        }
        ClassifierList supertypes = type.general;
        for (int i = 0; i < supertypes.size(); ++i) {
            Classifier supertype = supertypes.getValue(i);
            this.addFeatureValuesForType(supertype, oldFeatureValues);
        }
    }

    public ValueList getValues(NamedElement feature, FeatureValueList featureValues) {
        FeatureValue foundFeatureValue = null;
        int i = 1;
        while (foundFeatureValue == null & i <= featureValues.size()) {
            FeatureValue featureValue = featureValues.getValue(i - 1);
            if (featureValue.feature == feature) {
                foundFeatureValue = featureValue;
            }
            ++i;
        }
        ValueList values = foundFeatureValue == null ? new ValueList() : foundFeatureValue.values;
        return values;
    }
}

