/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Actions.CompleteActions;

import fUML.Debug;
import fUML.Semantics.Actions.BasicActions.ActionActivation;
import fUML.Semantics.Actions.CompleteActions.AcceptEventActionEventAccepter;
import fUML.Semantics.Activities.IntermediateActivities.ActivityNodeActivationGroup;
import fUML.Semantics.Activities.IntermediateActivities.TokenList;
import fUML.Semantics.Classes.Kernel.ValueList;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.ParameterValue;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.ParameterValueList;
import fUML.Semantics.CommonBehaviors.Communications.EventOccurrence;
import fUML.Semantics.CommonBehaviors.Communications.SignalEventOccurrence;
import fUML.Semantics.CommonBehaviors.Communications.SignalInstance;
import fUML.Syntax.Actions.BasicActions.OutputPin;
import fUML.Syntax.Actions.BasicActions.OutputPinList;
import fUML.Syntax.Actions.CompleteActions.AcceptEventAction;
import fUML.Syntax.Activities.IntermediateActivities.ActivityNode;
import fUML.Syntax.CommonBehaviors.Communications.TriggerList;

public class AcceptEventActionActivation
extends ActionActivation {
    public AcceptEventActionEventAccepter eventAccepter = null;
    public Boolean waiting = false;

    @Override
    public void initialize(ActivityNode node, ActivityNodeActivationGroup group) {
        super.initialize(node, group);
        this.waiting = false;
    }

    @Override
    public void run() {
        super.run();
        this.eventAccepter = new AcceptEventActionEventAccepter();
        this.eventAccepter.actionActivation = this;
        this.waiting = false;
    }

    @Override
    public void fire(TokenList incomingTokens) {
        Debug.println("[fire] Action " + this.node.name + "...");
        this.getExecutionContext().register(this.eventAccepter);
        this.waiting = true;
        this.firing = false;
        this.suspend();
    }

    @Override
    public boolean isReady() {
        boolean ready = this.waiting != false ? false : super.isReady();
        return ready;
    }

    @Override
    public void doAction() {
    }

    public void accept(EventOccurrence eventOccurrence) {
        block1: {
            block3: {
                OutputPinList resultPins;
                block2: {
                    AcceptEventAction action = (AcceptEventAction)this.node;
                    resultPins = action.result;
                    Debug.println("[accept] action = " + action.name + ", eventOccurrence = " + eventOccurrence);
                    if (!this.running) break block1;
                    if (action.isUnmarshall) break block2;
                    if (!(eventOccurrence instanceof SignalEventOccurrence)) break block3;
                    SignalInstance signalInstance = ((SignalEventOccurrence)eventOccurrence).signalInstance;
                    Debug.println("[accept] isUnmarshall = false, signalInstance = " + signalInstance);
                    ValueList result = new ValueList();
                    result.addValue(signalInstance);
                    if (resultPins.size() <= 0) break block3;
                    this.putTokens(resultPins.getValue(0), result);
                    break block3;
                }
                ParameterValueList parameterValues = eventOccurrence.getParameterValues();
                for (int i = 0; i < parameterValues.size(); ++i) {
                    ParameterValue parameterValue = parameterValues.getValue(i);
                    OutputPin resultPin = resultPins.getValue(i);
                    this.putTokens(resultPin, parameterValue.values);
                }
            }
            this.sendOffers();
            this.waiting = false;
            Debug.println("[accept] Checking if " + this.node.name + " should fire again...");
            this.receiveOffer();
            this.resume();
        }
    }

    public boolean match(EventOccurrence eventOccurrence) {
        AcceptEventAction action = (AcceptEventAction)this.node;
        TriggerList triggers = action.trigger;
        return eventOccurrence.matchAny(triggers);
    }

    @Override
    public void terminate() {
        super.terminate();
        if (this.waiting.booleanValue()) {
            this.getExecutionContext().unregister(this.eventAccepter);
            this.waiting = false;
        }
    }
}

