/*
 * Initial version copyright 2008 Lockheed Martin Corporation, except
 * as stated in the file entitled Licensing-Information.
 *
 * Modifications:
 * Copyright 2009 Data Access Technologies, Inc.
 * Copyright 2013 Ivar Jacobson International SA
 *
 * Licensed under the Academic Free License version 3.0
 * (http://www.opensource.org/licenses/afl-3.0.php), except as stated
 * in the file entitled Licensing-Information.
 *
 * Contributors:
 *   MDS - initial API and implementation
 *   IJI
 *
 */
package org.modeldriven.fuml.test.load.profile;

import org.modeldriven.fuml.repository.ext.Stereotype;

import fuml.syntax.commonstructure.Comment;

/**
 * 
 * This stereotype annotates or tags a UML owned comment for any UML element in
 * a model providing hints as to the nature of the comment and how it might be
 * presented.
 * 
 */
public class Documentation extends Stereotype {

	public static final String BASE__COMMENT = "base_Comment";
	public static final String TYPE = "type";

	private Comment base_Comment;
	private DocumentationType type;

	public Comment getBase_Comment() {
		return this.base_Comment;
	}

	public void setBase_Comment(Comment value) {
		this.base_Comment = value;
	}

	public DocumentationType getType() {
		return this.type;
	}

	public void setType(DocumentationType value) {
		this.type = value;
	}
}
