/*
 * Initial version copyright 2008 Lockheed Martin Corporation, except
 * as stated in the file entitled Licensing-Information.
 *
 * Modifications:
 * Copyright 2009 Data Access Technologies, Inc.
 * Copyright 2013 Ivar Jacobson International SA
 *
 * Licensed under the Academic Free License version 3.0
 * (http://www.opensource.org/licenses/afl-3.0.php), except as stated
 * in the file entitled Licensing-Information.
 *
 * Contributors:
 *   MDS - initial API and implementation
 *   IJI
 *
 */
package org.modeldriven.fuml.test.load.profile;

/**
 * 
 * Specifies the nature of the data with respect to concurrency for a UML
 * Property
 * 
 */
public enum ConcurrentDataFlavor {

	/**
	 * Indicates the data is an integral version number, typically incremented
	 * for every successful update of the owning entity.
	 */
	version,
	/**
	 * Indicates the data represents a system username, typically reset to the
	 * current system user on successful update of the owning entity.
	 */
	user,
	/**
	 * Indicates the data is temporal in nature typically reset to the system
	 * data or time for every successful update of the owning entity.
	 */
	time,
}
