/*
 * Initial version copyright 2008 Lockheed Martin Corporation, except
 * as stated in the file entitled Licensing-Information.
 *
 * Modifications:
 * Copyright 2009 Data Access Technologies, Inc.
 * Copyright 2013 Ivar Jacobson International SA
 *
 * Licensed under the Academic Free License version 3.0
 * (http://www.opensource.org/licenses/afl-3.0.php), except as stated
 * in the file entitled Licensing-Information.
 *
 * Contributors:
 *   MDS - initial API and implementation
 *   IJI
 *
 */
package org.modeldriven.fuml.test.load.profile;

/**
 * 
 * This enumeration specifies the set of key types possible for any UML Property
 * tagged with the Key stereotype.
 * 
 */
public enum KeyType {

	/**
	 * A key used as a primary identifier for the UML Class of the UML Property
	 * tagged with the SDOKey stereotype.
	 */
	primary,
	/**
	 * Tags a property as a key used as an internal identifier for a Class
	 */
	internal,
	/**
	 * Tags a property as a key used as an external identifier for a Class. An
	 * external identifier may be used by external systems and processes to
	 * uniquely idendify an object within the source system without significant
	 * central coordination. An external key is typically a universally unique
	 * identifier (UUID), globally unique identifier (GUID) or variant
	 */
	external,
}
