/*
 * Decompiled with CFR 0.152.
 */
package fuml.semantics.actions;

import fuml.Debug;
import fuml.semantics.actions.AcceptEventActionEventAccepter;
import fuml.semantics.actions.ActionActivation;
import fuml.semantics.activities.ActivityNodeActivationGroup;
import fuml.semantics.activities.TokenList;
import fuml.semantics.commonbehavior.EventOccurrence;
import fuml.semantics.commonbehavior.ParameterValue;
import fuml.semantics.commonbehavior.ParameterValueList;
import fuml.semantics.commonbehavior.SignalEventOccurrence;
import fuml.semantics.simpleclassifiers.SignalInstance;
import fuml.semantics.values.ValueList;
import fuml.syntax.actions.AcceptEventAction;
import fuml.syntax.actions.OutputPin;
import fuml.syntax.actions.OutputPinList;
import fuml.syntax.activities.ActivityNode;
import fuml.syntax.commonbehavior.Trigger;
import fuml.syntax.commonbehavior.TriggerList;

public class AcceptEventActionActivation
extends ActionActivation {
    public AcceptEventActionEventAccepter eventAccepter = null;
    public Boolean waiting = false;

    @Override
    public void initialize(ActivityNode node, ActivityNodeActivationGroup group) {
        super.initialize(node, group);
        this.waiting = false;
    }

    @Override
    public void run() {
        super.run();
        this.eventAccepter = new AcceptEventActionEventAccepter();
        this.eventAccepter.actionActivation = this;
        this.waiting = false;
    }

    @Override
    public void fire(TokenList incomingTokens) {
        Debug.println("[fire] Action " + this.node.name + "...");
        this.getExecutionContext().register(this.eventAccepter);
        this.waiting = true;
        this.firing = false;
        this.suspend();
    }

    @Override
    public boolean isReady() {
        boolean ready = this.waiting != false ? false : super.isReady();
        return ready;
    }

    @Override
    public void doAction() {
    }

    public void accept(EventOccurrence eventOccurrence) {
        block1: {
            block3: {
                OutputPinList resultPins;
                AcceptEventAction action;
                block2: {
                    action = (AcceptEventAction)this.node;
                    resultPins = action.result;
                    Debug.println("[accept] action = " + action.name + ", eventOccurrence = " + eventOccurrence);
                    if (!this.running) break block1;
                    if (action.isUnmarshall) break block2;
                    if (!(eventOccurrence instanceof SignalEventOccurrence)) break block3;
                    SignalInstance signalInstance = ((SignalEventOccurrence)eventOccurrence).signalInstance;
                    Debug.println("[accept] isUnmarshall = false, signalInstance = " + signalInstance);
                    ValueList result = new ValueList();
                    result.addValue(signalInstance);
                    if (resultPins.size() <= 0) break block3;
                    this.putTokens(resultPins.getValue(0), result);
                    break block3;
                }
                ParameterValueList parameterValues = eventOccurrence.getParameterValues(((Trigger)action.trigger.get((int)0)).event);
                for (int i = 0; i < parameterValues.size(); ++i) {
                    ParameterValue parameterValue = parameterValues.getValue(i);
                    OutputPin resultPin = resultPins.getValue(i);
                    this.putTokens(resultPin, parameterValue.values);
                }
            }
            this.sendOffers();
            this.waiting = false;
            Debug.println("[accept] Checking if " + this.node.name + " should fire again...");
            this.receiveOffer();
            this.resume();
        }
    }

    public boolean match(EventOccurrence eventOccurrence) {
        AcceptEventAction action = (AcceptEventAction)this.node;
        TriggerList triggers = action.trigger;
        return eventOccurrence.matchAny(triggers);
    }

    @Override
    public void terminate() {
        super.terminate();
        if (this.waiting.booleanValue()) {
            this.getExecutionContext().unregister(this.eventAccepter);
            this.waiting = false;
        }
    }
}

