/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.assembly;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.assembly.AssemblerVisitor;
import org.modeldriven.fuml.assembly.ElementAssembler;
import org.modeldriven.fuml.xmi.XmiElement;

public class AssemblerNode
implements XmiElement {
    private static Log log = LogFactory.getLog(AssemblerNode.class);
    private List<AssemblerNode> assemblers;
    private XmiElement xmiElement;

    protected AssemblerNode() {
    }

    public AssemblerNode(XmiElement xmiType) {
        this.xmiElement = xmiType;
    }

    @Override
    public String getXmiType() {
        return this.xmiElement.getXmiType();
    }

    @Override
    public boolean hasXmiType() {
        String xmiType = this.xmiElement.getXmiType();
        return xmiType != null && xmiType.length() > 0;
    }

    @Override
    public String getLocalName() {
        return this.xmiElement.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return this.xmiElement.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.xmiElement.getPrefix();
    }

    @Override
    public String getData() {
        return this.xmiElement.getData();
    }

    @Override
    public String getXmiId() {
        return this.xmiElement.getXmiId();
    }

    public void add(ElementAssembler assembler) {
        if (this.assemblers == null) {
            this.assemblers = new ArrayList<AssemblerNode>();
        }
        this.assemblers.add(assembler);
    }

    public List<AssemblerNode> getNodes() {
        return this.assemblers;
    }

    public void accept(AssemblerVisitor visitor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)this.getClass().getSimpleName());
        }
        this.acceptBreadthFirst(visitor);
    }

    public void acceptDepthFirst(AssemblerVisitor visitor) {
        this.accept(visitor, this, null, null, this, true, new HashMap<AssemblerNode, AssemblerNode>(), 0);
    }

    public void acceptBreadthFirst(AssemblerVisitor visitor) {
        this.accept(visitor, this, null, null, this, false, new HashMap<AssemblerNode, AssemblerNode>(), 0);
    }

    private void accept(AssemblerVisitor visitor, AssemblerNode target, AssemblerNode source, String sourceKey, AssemblerNode root, boolean depthFirst, Map<AssemblerNode, AssemblerNode> visited, int level) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("accept: " + target.getLocalName()));
        }
        if (visited.get(target) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ignoring, " + target.getClass().getName()));
            }
            return;
        }
        visited.put(target, target);
        if (!depthFirst) {
            visitor.begin(target, source, sourceKey, level);
        } else {
            visitor.end(target, source, sourceKey, level);
        }
        List<AssemblerNode> nodes = target.getNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.size(); ++i) {
                AssemblerNode child = nodes.get(i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("processing node: " + child.getLocalName()));
                }
                this.accept(visitor, child, target, child.getLocalName(), root, depthFirst, visited, level++);
            }
        }
        if (depthFirst) {
            visitor.begin(target, source, sourceKey, level);
        } else {
            visitor.end(target, source, sourceKey, level);
        }
    }
}

