/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml;

import fuml.syntax.commonbehavior.Behavior;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.FumlException;
import org.modeldriven.fuml.environment.Environment;
import org.modeldriven.fuml.environment.ExecutionEnvironment;
import org.modeldriven.fuml.io.ArtifactLoader;
import org.modeldriven.fuml.io.FileArtifact;
import org.modeldriven.fuml.io.IncrementalArtifactLoader;
import org.modeldriven.fuml.io.ResourceArtifact;

public class Fuml {
    private static Log log = LogFactory.getLog(Fuml.class);

    private Fuml() {
    }

    public Fuml(File file) {
        this.execute(file, file.getName(), null);
    }

    public Fuml(File file, String uri, String target) {
        this.execute(file, uri != null ? uri : file.getName(), target);
    }

    public Fuml(File file, String target) {
        this.execute(file, file.getName(), target);
    }

    public Fuml(String namespaceURI, String target) {
        this.execute(namespaceURI, target);
    }

    public static void load(File file, String uri) {
        try {
            log.info((Object)("loading artifact, " + file.getName()));
            ArtifactLoader reader = new ArtifactLoader();
            reader.read(new FileArtifact(file, uri));
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
            throw new FumlException(t);
        }
    }

    public static void load(FileArtifact fileArtifact) {
        try {
            log.info((Object)("loading artifact, " + fileArtifact.getURN()));
            ArtifactLoader reader = new ArtifactLoader();
            reader.read(fileArtifact);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
            throw new FumlException(t);
        }
    }

    public static void loadIncrementally(File file, String uri) {
        try {
            log.info((Object)("reading artifact, " + file.getName()));
            IncrementalArtifactLoader reader = new IncrementalArtifactLoader();
            reader.read(new FileArtifact(file, uri));
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
            throw new FumlException(t);
        }
    }

    public static void load(ResourceArtifact artifact) {
        try {
            log.info((Object)("loading artifact, " + artifact.getURN()));
            ArtifactLoader reader = new ArtifactLoader();
            reader.read(artifact);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
            throw new FumlException(t);
        }
    }

    public static void loadIncrementally(ResourceArtifact artifact) {
        try {
            log.info((Object)("reading artifact, " + artifact.getURN()));
            IncrementalArtifactLoader reader = new IncrementalArtifactLoader();
            reader.read(artifact);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
            throw new FumlException(t);
        }
    }

    protected void execute(String uri, String target) {
        try {
            Environment environment = Environment.getInstance();
            Behavior behavior = environment.findBehavior(target);
            if (behavior == null) {
                throw new FumlException("unknown behavior name, '" + target + "'");
            }
            ExecutionEnvironment execution = new ExecutionEnvironment(environment);
            log.info((Object)("executing behavior: " + behavior.name));
            execution.execute(behavior);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
            throw new FumlException(t);
        }
    }

    protected void execute(File file, String uri, String target) {
        try {
            log.info((Object)("loading artifact, " + file.getName()));
            IncrementalArtifactLoader reader = new IncrementalArtifactLoader();
            reader.read(new FileArtifact(file, uri));
            Environment environment = Environment.getInstance();
            Behavior behavior = null;
            if (target != null) {
                behavior = environment.findBehavior(target);
                if (behavior == null) {
                    throw new FumlException("unknown behavior name, '" + target + "'");
                }
            } else {
                String[] names = environment.getBehaviorNames();
                if (names.length > 1) {
                    StringBuffer namesBuf = new StringBuffer();
                    namesBuf.append("[");
                    for (int i = 0; i < names.length; ++i) {
                        if (i > 0) {
                            namesBuf.append(", ");
                        }
                        namesBuf.append("'");
                        namesBuf.append(names[i]);
                        namesBuf.append("'");
                        if (i <= 10) continue;
                        namesBuf.append("...");
                    }
                    namesBuf.append("]");
                    throw new FumlException("ambiguous execution target - file '" + file.getName() + "' contains " + String.valueOf(names.length) + " behaviors to execute " + namesBuf.toString() + " - please specify a behavior");
                }
                if (names.length == 0) {
                    throw new FumlException("invalid execution target - file '" + file.getName() + "' contains " + String.valueOf(names.length) + " behaviors");
                }
                behavior = environment.findBehavior(names[0]);
                if (behavior == null) {
                    throw new FumlException("unknown behavior name, '" + names[0] + "'");
                }
            }
            ExecutionEnvironment execution = new ExecutionEnvironment(environment);
            log.info((Object)("executing behavior: " + behavior.name));
            execution.execute(behavior);
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
            throw new FumlException(t);
        }
    }

    protected static void printUsage() {
        log.info((Object)"====================================================================");
        log.info((Object)"USAGE: fuml <model-file-name> [<behavior-name> <behavior-name> <behavior-name> <...>]");
        log.info((Object)"====================================================================");
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            Fuml.printUsage();
            System.exit(1);
        }
        File modelFile = new File(args[0]);
        if (args.length == 1) {
            new Fuml(modelFile);
        } else {
            Fuml fuml = new Fuml(modelFile, args[1]);
            for (int i = 2; i < args.length; ++i) {
                fuml.execute(modelFile.getName(), args[i]);
            }
        }
    }
}

