/*
 * Decompiled with CFR 0.152.
 */
package fuml.semantics.actions;

import fuml.semantics.actions.InputPinActivation;
import fuml.semantics.actions.InvocationActionActivation;
import fuml.semantics.actions.PinStreamingParameterListener;
import fuml.semantics.activities.ActivityNodeActivationGroup;
import fuml.semantics.activities.TokenList;
import fuml.semantics.commonbehavior.Execution;
import fuml.semantics.commonbehavior.ExecutionList;
import fuml.semantics.commonbehavior.ParameterValue;
import fuml.semantics.commonbehavior.ParameterValueList;
import fuml.semantics.commonbehavior.StreamingParameterValue;
import fuml.syntax.actions.CallAction;
import fuml.syntax.actions.InputPin;
import fuml.syntax.actions.InputPinList;
import fuml.syntax.actions.OutputPin;
import fuml.syntax.actions.OutputPinList;
import fuml.syntax.activities.ActivityNode;
import fuml.syntax.classification.Parameter;
import fuml.syntax.classification.ParameterDirectionKind;
import fuml.syntax.classification.ParameterList;

public abstract class CallActionActivation
extends InvocationActionActivation {
    public ExecutionList callExecutions = new ExecutionList();
    public Boolean isStreaming;
    public OutputPinList nonStreamingOutputPins = new OutputPinList();
    public ParameterList nonStreamingOutputParameters = new ParameterList();

    @Override
    public void initialize(ActivityNode node, ActivityNodeActivationGroup group) {
        super.initialize(node, group);
        this.isStreaming = false;
    }

    @Override
    public boolean isReady() {
        boolean ready = this.isControlReady();
        CallAction callAction = (CallAction)this.node;
        InputPinList argumentPins = callAction.argument;
        if (ready & argumentPins.size() > 0) {
            ParameterList parameters = this.getParameters();
            ParameterList inputParameters = new ParameterList();
            for (int i = 0; i < parameters.size(); ++i) {
                Parameter parameter = parameters.getValue(i);
                if (!(parameter.direction == ParameterDirectionKind.in | parameter.direction == ParameterDirectionKind.inout)) continue;
                inputParameters.addValue(parameter);
            }
            boolean streamingReady = false;
            int j = 1;
            while (ready & j <= argumentPins.size()) {
                InputPin argumentPin = argumentPins.getValue(j - 1);
                InputPinActivation pinActivation = (InputPinActivation)this.getPinActivation(argumentPin);
                if (j > inputParameters.size()) {
                    ready = pinActivation.isReady();
                }
                boolean isStream = false;
                if (j <= inputParameters.size()) {
                    isStream = inputParameters.getValue((int)(j - 1)).isStream;
                }
                if (!isStream) {
                    streamingReady = true;
                    ready = pinActivation.isReady();
                } else if (pinActivation.isReadyForStreaming()) {
                    streamingReady = true;
                }
                ++j;
            }
            ready &= streamingReady;
        }
        return ready;
    }

    @Override
    public void doAction() {
        Execution callExecution = this.getCallExecution();
        if (callExecution != null) {
            this.callExecutions.addValue(callExecution);
            CallAction callAction = (CallAction)this.node;
            InputPinList argumentPins = callAction.argument;
            OutputPinList resultPins = callAction.result;
            ParameterList parameters = callExecution.getBehavior().ownedParameter;
            int pinNumber = 1;
            int outputPinNumber = 1;
            InputPinActivation streamingPinActivation = null;
            this.nonStreamingOutputPins.clear();
            this.nonStreamingOutputParameters.clear();
            for (int i = 1; i <= parameters.size(); ++i) {
                ParameterValue parameterValue;
                Parameter parameter = parameters.getValue(i - 1);
                if (parameter.direction == ParameterDirectionKind.in | parameter.direction == ParameterDirectionKind.inout) {
                    InputPin argumentPin = argumentPins.getValue(pinNumber - 1);
                    if (parameter.isStream) {
                        parameterValue = new StreamingParameterValue();
                        parameterValue.values = this.getTokens(argumentPin);
                        streamingPinActivation = (InputPinActivation)this.getPinActivation(argumentPin);
                        streamingPinActivation.streamingParameterValue = parameterValue;
                    } else {
                        parameterValue = new ParameterValue();
                        parameterValue.values = this.takeTokens(argumentPin);
                    }
                    parameterValue.parameter = parameter;
                    callExecution.setParameterValue(parameterValue);
                    ++pinNumber;
                }
                if (!(parameter.direction == ParameterDirectionKind.out | parameter.direction == ParameterDirectionKind.inout | parameter.direction == ParameterDirectionKind.return_)) continue;
                OutputPin resultPin = resultPins.getValue(outputPinNumber - 1);
                if (!parameter.isStream) {
                    this.nonStreamingOutputPins.addValue(resultPin);
                    this.nonStreamingOutputParameters.addValue(parameter);
                } else {
                    parameterValue = new StreamingParameterValue();
                    parameterValue.parameter = parameter;
                    PinStreamingParameterListener listener = new PinStreamingParameterListener();
                    listener.nodeActivation = this.getPinActivation(resultPin);
                    ((StreamingParameterValue)parameterValue).register(listener);
                    callExecution.parameterValues.addValue(parameterValue);
                }
                ++outputPinNumber;
            }
            callExecution.execute();
            this.isStreaming = streamingPinActivation == null ? Boolean.valueOf(false) : Boolean.valueOf(!streamingPinActivation.streamingIsTerminated());
            if (!this.isStreaming.booleanValue()) {
                this.completeCall(callExecution);
            }
        }
    }

    @Override
    public TokenList completeAction() {
        TokenList incomingTokens = this.isStreaming != false ? new TokenList() : super.completeAction();
        return incomingTokens;
    }

    public void completeCall(Execution callExecution) {
        if (callExecution.exception != null) {
            this.propagateException(callExecution.exception);
        } else {
            OutputPinList resultPins = this.nonStreamingOutputPins;
            ParameterList parameters = this.nonStreamingOutputParameters;
            ParameterValueList outputParameterValues = callExecution.getOutputParameterValues();
            for (int i = 0; i < resultPins.size(); ++i) {
                OutputPin resultPin = resultPins.getValue(i);
                Parameter parameter = parameters.getValue(i);
                for (int j = 0; j < outputParameterValues.size(); ++j) {
                    ParameterValue outputParameterValue = outputParameterValues.getValue(j);
                    if (outputParameterValue.parameter != parameter) continue;
                    this.putTokens(resultPin, outputParameterValue.values);
                }
            }
        }
        callExecution.destroy();
        this.removeCallExecution(callExecution);
    }

    public void completeStreamingCall() {
        if (this.callExecutions.size() > 0) {
            this.completeCall(this.callExecutions.getValue(0));
            super.completeAction();
        }
    }

    @Override
    public OutputPinList getOfferingOutputPins() {
        return this.nonStreamingOutputPins;
    }

    public abstract ParameterList getParameters();

    public abstract Execution getCallExecution();

    @Override
    public void terminate() {
        if (this.isStreaming.booleanValue()) {
            this.completeStreamingCall();
        } else {
            for (int i = 0; i < this.callExecutions.size(); ++i) {
                Execution execution = this.callExecutions.getValue(i);
                execution.terminate();
            }
        }
        super.terminate();
    }

    public void removeCallExecution(Execution execution) {
        boolean notFound = true;
        int i = 1;
        while (notFound & i <= this.callExecutions.size()) {
            if (this.callExecutions.getValue(i - 1) == execution) {
                this.callExecutions.removeValue(i - 1);
                notFound = false;
            }
            ++i;
        }
    }
}

