/*
 * Decompiled with CFR 0.152.
 */
package fuml.semantics.actions;

import fuml.Debug;
import fuml.semantics.actions.OutputPinActivation;
import fuml.semantics.actions.StructuredActivityNodeActivation;
import fuml.semantics.actions.Values;
import fuml.semantics.actions.ValuesList;
import fuml.semantics.activities.ActivityNodeActivation;
import fuml.semantics.activities.ActivityNodeActivationList;
import fuml.semantics.simpleclassifiers.BooleanValue;
import fuml.semantics.values.ValueList;
import fuml.syntax.actions.InputPin;
import fuml.syntax.actions.InputPinList;
import fuml.syntax.actions.LoopNode;
import fuml.syntax.actions.OutputPin;
import fuml.syntax.actions.OutputPinList;
import fuml.syntax.actions.Pin;
import fuml.syntax.activities.ActivityNodeList;
import fuml.syntax.activities.ExecutableNode;

public class LoopNodeActivation
extends StructuredActivityNodeActivation {
    public ValuesList bodyOutputLists = new ValuesList();
    public boolean isTerminateAll = false;

    @Override
    public void doStructuredActivity() {
        LoopNode loopNode = (LoopNode)this.node;
        InputPinList loopVariableInputs = loopNode.loopVariableInput;
        this.bodyOutputLists.clear();
        for (int i = 0; i < loopVariableInputs.size(); ++i) {
            InputPin loopVariableInput = loopVariableInputs.getValue(i);
            Values bodyOutputList = new Values();
            bodyOutputList.values = this.takeTokens(loopVariableInput);
            this.bodyOutputLists.addValue(bodyOutputList);
        }
        this.isTerminateAll = false;
        this.doLoop(true);
    }

    public void doLoop(boolean continuing) {
        LoopNode loopNode = (LoopNode)this.node;
        OutputPinList loopVariables = loopNode.loopVariable;
        OutputPinList resultPins = loopNode.result;
        while (continuing) {
            this.runLoopVariables();
            for (int i = 0; i < loopVariables.size(); ++i) {
                OutputPin loopVariable = loopVariables.getValue(i);
                Values bodyOutputList = this.bodyOutputLists.getValue(i);
                ValueList values = bodyOutputList.values;
                this.putPinValues(loopVariable, values);
                ((OutputPinActivation)this.activationGroup.getNodeActivation(loopVariable)).sendUnofferedTokens();
            }
            ActivityNodeActivationList nodeActivations = this.activationGroup.nodeActivations;
            ActivityNodeActivationList nonExecutableNodeActivations = new ActivityNodeActivationList();
            for (int i = 0; i < nodeActivations.size(); ++i) {
                ActivityNodeActivation nodeActivation = nodeActivations.getValue(i);
                if (nodeActivation.node instanceof ExecutableNode | nodeActivation.node instanceof Pin) continue;
                nonExecutableNodeActivations.addValue(nodeActivation);
            }
            this.activationGroup.run(nonExecutableNodeActivations);
            if (loopNode.isTestedFirst) {
                continuing = this.runTest();
                if (continuing) {
                    this.runBody();
                }
            } else {
                this.runBody();
                if (this.isRunning() & !this.isSuspended()) {
                    continuing = this.runTest();
                }
            }
            if (!this.isTerminateAll & this.isRunning() & !this.isSuspended()) {
                this.activationGroup.terminateAll();
            } else {
                continuing = false;
            }
            Debug.println("[doStructuredActivity] " + (continuing ? "Continuing." : (this.isSuspended() ? "Suspended" : "Done.")));
        }
        if (!this.isTerminateAll & this.isRunning() & !this.isSuspended()) {
            for (int i = 0; i < this.bodyOutputLists.size(); ++i) {
                Values bodyOutputList = this.bodyOutputLists.getValue(i);
                OutputPin resultPin = resultPins.getValue(i);
                this.putTokens(resultPin, bodyOutputList.values);
            }
        }
    }

    public boolean runTest() {
        Debug.println("[runTest] Running test...");
        LoopNode loopNode = (LoopNode)this.node;
        this.activationGroup.runNodes(this.makeActivityNodeList(loopNode.test));
        ValueList values = this.getPinValues(loopNode.decider);
        boolean decision = false;
        if (values.size() > 0) {
            decision = ((BooleanValue)values.getValue((int)0)).value;
        }
        Debug.println("[runTest] " + (decision ? "Test succeeded." : "Test failed."));
        return decision;
    }

    public void runBody() {
        Debug.println("[runBody] Running body...");
        LoopNode loopNode = (LoopNode)this.node;
        this.activationGroup.runNodes(this.makeActivityNodeList(loopNode.bodyPart));
        if (!this.isTerminateAll & !this.isSuspended()) {
            this.saveBodyOutputs();
        }
    }

    public void saveBodyOutputs() {
        LoopNode loopNode = (LoopNode)this.node;
        OutputPinList bodyOutputs = loopNode.bodyOutput;
        ValuesList bodyOutputLists = this.bodyOutputLists;
        for (int i = 0; i < bodyOutputs.size(); ++i) {
            OutputPin bodyOutput = bodyOutputs.getValue(i);
            Values bodyOutputList = bodyOutputLists.getValue(i);
            bodyOutputList.values = this.getPinValues(bodyOutput);
        }
    }

    public void runLoopVariables() {
        this.activationGroup.runNodes(this.makeLoopVariableList());
    }

    @Override
    public void createNodeActivations() {
        super.createNodeActivations();
        this.activationGroup.createNodeActivations(this.makeLoopVariableList());
    }

    public ActivityNodeList makeLoopVariableList() {
        LoopNode loopNode = (LoopNode)this.node;
        ActivityNodeList nodes = new ActivityNodeList();
        OutputPinList loopVariables = loopNode.loopVariable;
        for (int i = 0; i < loopVariables.size(); ++i) {
            OutputPin loopVariable = loopVariables.getValue(i);
            nodes.addValue(loopVariable);
        }
        return nodes;
    }

    @Override
    public void terminateAll() {
        this.isTerminateAll = true;
        LoopNode loopNode = (LoopNode)this.node;
        OutputPinList bodyOutputs = loopNode.bodyOutput;
        OutputPinList resultPins = loopNode.result;
        for (int i = 0; i < bodyOutputs.size(); ++i) {
            OutputPin bodyOutput = bodyOutputs.getValue(i);
            OutputPin resultPin = resultPins.getValue(i);
            this.putTokens(resultPin, this.getPinValues(bodyOutput));
        }
        super.terminateAll();
    }

    @Override
    public void resume() {
        LoopNode loopNode = (LoopNode)this.node;
        this.saveBodyOutputs();
        if (!this.isTerminateAll) {
            if (loopNode.mustIsolate) {
                LoopNodeActivation._beginIsolation();
                this.continueLoop();
                LoopNodeActivation._endIsolation();
            } else {
                this.continueLoop();
            }
        }
        if (this.isSuspended()) {
            this.group.resume(this);
        } else {
            super.resume();
        }
    }

    public void continueLoop() {
        LoopNode loopNode = (LoopNode)this.node;
        boolean continuing = true;
        if (!loopNode.isTestedFirst) {
            continuing = this.runTest();
        }
        if (this.isRunning()) {
            this.activationGroup.terminateAll();
            this.doLoop(continuing);
        }
    }
}

