/*
 * Decompiled with CFR 0.152.
 */
package fuml.semantics.activities;

import fuml.Debug;
import fuml.semantics.activities.ActivityNodeActivationGroup;
import fuml.semantics.activities.ActivityParameterNodeActivation;
import fuml.semantics.activities.ActivityParameterNodeActivationList;
import fuml.semantics.activities.ObjectToken;
import fuml.semantics.activities.Token;
import fuml.semantics.activities.TokenList;
import fuml.semantics.commonbehavior.Execution;
import fuml.semantics.commonbehavior.ParameterValue;
import fuml.semantics.values.Value;
import fuml.syntax.activities.Activity;
import fuml.syntax.activities.ActivityParameterNode;
import fuml.syntax.classification.Parameter;
import fuml.syntax.classification.ParameterDirectionKind;
import fuml.syntax.classification.ParameterList;

public class ActivityExecution
extends Execution {
    public ActivityNodeActivationGroup activationGroup = null;
    public Boolean isStreaming;

    @Override
    public void execute() {
        Activity activity = (Activity)this.getTypes().getValue(0);
        Debug.println("[execute] Activity " + activity.name + "...");
        Debug.println("[event] Execute activity=" + activity.name);
        this.isStreaming = false;
        int i = 1;
        ParameterList parameters = activity.ownedParameter;
        while (i <= parameters.size() & this.isStreaming == false) {
            Parameter parameter = parameters.getValue(i - 1);
            this.isStreaming = (parameter.direction == ParameterDirectionKind.in | parameter.direction == ParameterDirectionKind.inout) & parameter.isStream;
            ++i;
        }
        Debug.println("[execute] isStreaming = " + this.isStreaming);
        this.activationGroup = new ActivityNodeActivationGroup();
        this.activationGroup.activityExecution = this;
        this.activationGroup.activate(activity.node, activity.edge);
        if (!this.isStreaming.booleanValue()) {
            this.complete();
        }
    }

    public void complete() {
        Activity activity = (Activity)this.getTypes().getValue(0);
        ActivityParameterNodeActivationList outputActivations = this.activationGroup.getOutputParameterNodeActivations();
        for (int i = 0; i < outputActivations.size(); ++i) {
            ActivityParameterNodeActivation outputActivation = outputActivations.getValue(i);
            Parameter parameter = ((ActivityParameterNode)outputActivation.node).parameter;
            if (parameter.isStream) continue;
            ParameterValue parameterValue = new ParameterValue();
            parameterValue.parameter = parameter;
            TokenList tokens = outputActivation.getTokens();
            for (int j = 0; j < tokens.size(); ++j) {
                Token token = tokens.getValue(j);
                Value value = ((ObjectToken)token).value;
                if (value == null) continue;
                parameterValue.values.addValue(value);
                Debug.println("[event] Output activity=" + activity.name + " parameter=" + parameterValue.parameter.name + " value=" + value);
            }
            this.setParameterValue(parameterValue);
        }
        Debug.println("[execute] Activity " + activity.name + " completed.");
    }

    @Override
    public Value copy() {
        return super.copy();
    }

    @Override
    public Value new_() {
        return new ActivityExecution();
    }

    @Override
    public void terminate() {
        if (this.activationGroup != null) {
            this.activationGroup.terminateAll();
        }
        if (this.isStreaming.booleanValue()) {
            this.complete();
        }
    }
}

