/*
 * Decompiled with CFR 0.152.
 */
package fuml.semantics.activities;

import fuml.Debug;
import fuml.semantics.activities.ActivityParameterNodeStreamingParameterListener;
import fuml.semantics.activities.ObjectNodeActivation;
import fuml.semantics.activities.ObjectToken;
import fuml.semantics.activities.Token;
import fuml.semantics.activities.TokenList;
import fuml.semantics.commonbehavior.ParameterValue;
import fuml.semantics.commonbehavior.StreamingParameterValue;
import fuml.semantics.values.Value;
import fuml.semantics.values.ValueList;
import fuml.syntax.activities.ActivityParameterNode;
import fuml.syntax.classification.Parameter;

public class ActivityParameterNodeActivation
extends ObjectNodeActivation {
    @Override
    public void run() {
        super.run();
        Parameter parameter = ((ActivityParameterNode)this.node).parameter;
        ParameterValue parameterValue = this.getActivityExecution().getParameterValue(parameter);
        if (this.node.incoming.size() == 0 & parameterValue instanceof StreamingParameterValue) {
            ActivityParameterNodeStreamingParameterListener listener = new ActivityParameterNodeStreamingParameterListener();
            listener.nodeActivation = this;
            ((StreamingParameterValue)parameterValue).register(listener);
            Debug.println("[run] Registering for streaming parameter " + parameter.name + ".");
        }
    }

    @Override
    public void fire(TokenList incomingTokens) {
        Parameter parameter = ((ActivityParameterNode)this.node).parameter;
        ParameterValue parameterValue = this.getActivityExecution().getParameterValue(parameter);
        if (this.node.incoming.size() == 0) {
            Debug.println("[fire] Input activity parameter node " + this.node.name + "...");
            if (parameterValue != null) {
                Debug.println("[fire] Parameter has " + parameterValue.values.size() + " value(s).");
                ValueList values = parameterValue.values;
                for (int i = 0; i < values.size(); ++i) {
                    Value value = values.getValue(i);
                    ObjectToken token = new ObjectToken();
                    token.value = value;
                    this.addToken(token);
                }
                this.sendUnofferedTokens();
            }
        } else {
            Debug.println("[fire] Output activity parameter node " + this.node.name + "...");
            this.addTokens(incomingTokens);
            if (parameterValue instanceof StreamingParameterValue) {
                ValueList values = new ValueList();
                for (int i = 0; i < incomingTokens.size(); ++i) {
                    Token token = incomingTokens.getValue(i);
                    Value value = token.getValue();
                    if (value == null) continue;
                    values.addValue(value);
                    Debug.println("[event] Post activity=" + this.getActivityExecution().getBehavior().name + " parameter=" + parameterValue.parameter.name + " value=" + value);
                }
                ((StreamingParameterValue)parameterValue).post(values);
                super.clearTokens();
            }
        }
    }

    @Override
    public void clearTokens() {
        if (this.node.incoming.size() == 0) {
            super.clearTokens();
        }
    }
}

