
package org.modeldriven.fuml.repository.model;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fuml.syntax.classification.Classifier;
import fuml.syntax.classification.Generalization;
import fuml.syntax.classification.Property;
import fuml.syntax.packages.Package;
import fuml.syntax.simpleclassifiers.Enumeration;
import fuml.syntax.simpleclassifiers.EnumerationLiteral;
import fuml.syntax.simpleclassifiers.PrimitiveType;
import fuml.syntax.structuredclassifiers.Association;
import fuml.syntax.structuredclassifiers.Class_;
import fuml.syntax.values.LiteralInteger;
import fuml.syntax.values.LiteralUnlimitedNatural;
import fuml.syntax.values.ValueSpecification;

import UMLPrimitiveTypes.UnlimitedNatural;

import org.modeldriven.fuml.repository.RepositoryArtifact;
import org.modeldriven.fuml.repository.RepositoryMapping;
import org.modeldriven.fuml.repository.Repository;

import org.modeldriven.fuml.repository.config.Artifact;

// this needs to read the artifact namespace info from the content
public class PrimitiveTypesAssembler extends ModelAssembler 
    implements RepositoryArtifact
{

    private static Log log = LogFactory.getLog(PrimitiveTypesAssembler.class);
    private ModelFactory factory;

    public PrimitiveTypesAssembler(Artifact artifact, RepositoryMapping mapping, Repository model) {
        super(artifact, mapping, model);
        this.factory = new ModelFactory(mapping, model);
        construct();
    }

    private void construct() {
        log.info("initializing...");
        constructPackages();
        constructPrimitiveTypes();
        constructEnumerations();
        constructClasses();
        constructProperties();
        constructGeneralizations();
        constructAssociations();
    } 

    public String getURN() {
        return this.artifact.getUrn();
    }
    
    public String getNamespaceURI() {
        return this.artifact.getNamespaceURI();
    }
    
    private void constructPackages()
    {
        Package pkg = null;
         
                     
        // PrimitiveTypes            
    	pkg  = factory.createPackage("PrimitiveTypes", "PrimitiveTypes", "PrimitiveTypes", this); // root package
    	mapping.mapPackage(pkg, null, this); 
            
     }   

    private void constructPrimitiveTypes()
    {
    Package pkg = null;
    String packageId = null;
    PrimitiveType type = null;
                                                      
        packageId = this.artifact.getUrn() + "#" + "PrimitiveTypes";   
        
        // PrimitiveTypes.Boolean 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        
        // Boolean
    	type  = factory.createPrimitiveType("Boolean", "Boolean", pkg);
    	mapping.mapPrimitiveType(type, "PrimitiveTypes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "PrimitiveTypes";   
        
        // PrimitiveTypes.Integer 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        
        // Integer
    	type  = factory.createPrimitiveType("Integer", "Integer", pkg);
    	mapping.mapPrimitiveType(type, "PrimitiveTypes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "PrimitiveTypes";   
        
        // PrimitiveTypes.Real 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        
        // Real
    	type  = factory.createPrimitiveType("Real", "Real", pkg);
    	mapping.mapPrimitiveType(type, "PrimitiveTypes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "PrimitiveTypes";   
        
        // PrimitiveTypes.String 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        
        // String
    	type  = factory.createPrimitiveType("String", "String", pkg);
    	mapping.mapPrimitiveType(type, "PrimitiveTypes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "PrimitiveTypes";   
        
        // PrimitiveTypes.UnlimitedNatural 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        
        // UnlimitedNatural
    	type  = factory.createPrimitiveType("UnlimitedNatural", "UnlimitedNatural", pkg);
    	mapping.mapPrimitiveType(type, "PrimitiveTypes", this); 
    
    }   
       
    private void constructClasses()
    {
        Package pkg = null;
        String packageId = null;
        Class_ clss = null;
    
    }   

    private void constructEnumerations()
    {
        Enumeration enumeration = null;
        EnumerationLiteral literal = null;
    
    }   

    private void constructProperties()
    {
        Class_ clss = null;
        Property prop = null;
        
    
    }
    
    private void constructGeneralizations()
    {
        Class_ clss = null;
        
    
    }

    private void constructAssociations()
    {
        Package pkg = null;
        String packageId = null;
        Association assoc = null;
        Property prop = null;
        
    
    }

}
    
    