/*
 * Initial version copyright 2008 Lockheed Martin Corporation, except
 * as stated in the file entitled Licensing-Information.
 *
 * Modifications:
 * Copyright 2009 Data Access Technologies, Inc.
 * Copyright 2013 Ivar Jacobson International SA
 *
 * Licensed under the Academic Free License version 3.0
 * (http://www.opensource.org/licenses/afl-3.0.php), except as stated
 * in the file entitled Licensing-Information.
 *
 * Contributors:
 *   MDS - initial API and implementation
 *   IJI
 *
 */
package org.modeldriven.fuml.test.load.profile;

import org.modeldriven.fuml.repository.ext.Stereotype;

import fuml.syntax.classification.Property;
import fuml.syntax.commonstructure.NamedElement;

/**
 * 
 * This stereotype tags or annotates a UML property as representing some type of
 * key within a data store, data transfer or transient storage medium.
 * 
 */
public class Key extends Stereotype

{

	/**
	 * Specifies the type of key
	 */
	public static final String TYPE = "type";
	public static final String BASE__PROPERTY = "base_Property";
	/**
	 * Links a property element which supplies the actual data for the key where
	 * multiple possible targets exist. Where a key property is a reference SDO
	 * property and the target entity has multiple primary keys, the supplier is
	 * used by services to disambiguate which target key actually supplies the
	 * data.
	 */
	public static final String SUPPLIER = "supplier";

	/**
	 * Specifies the type of key
	 */
	private KeyType type;
	private Property base_Property;
	/**
	 * Links a property element which supplies the actual data for the key where
	 * multiple possible targets exist. Where a key property is a reference SDO
	 * property and the target entity has multiple primary keys, the supplier is
	 * used by services to disambiguate which target key actually supplies the
	 * data.
	 */
	private NamedElement supplier;

	public KeyType getType() {
		return this.type;
	}

	public void setType(KeyType value) {
		this.type = value;
	}

	public Property getBase_Property() {
		return this.base_Property;
	}

	public void setBase_Property(Property value) {
		this.base_Property = value;
	}

	public NamedElement getSupplier() {
		return this.supplier;
	}

	public void setSupplier(NamedElement value) {
		this.supplier = value;
	}
}
