/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.xmi;

import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.bind.BindingValidationEventHandler;

public class XmiValidationEventHandler
implements BindingValidationEventHandler {
    private static Log log = LogFactory.getLog(XmiValidationEventHandler.class);
    private int errorCount;
    private boolean cumulative = true;

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    public XmiValidationEventHandler() {
    }

    public XmiValidationEventHandler(boolean cumulative) {
        this.cumulative = cumulative;
    }

    public boolean handleEvent(ValidationEvent ve) {
        boolean result = this.cumulative;
        ++this.errorCount;
        ValidationEventLocator vel = ve.getLocator();
        String message = "Line:Col:Offset[" + vel.getLineNumber() + ":" + vel.getColumnNumber() + ":" + String.valueOf(vel.getOffset()) + "] - " + ve.getMessage();
        switch (ve.getSeverity()) {
            case 0: {
                log.warn((Object)message);
                break;
            }
            case 1: {
                log.error((Object)message);
                break;
            }
            case 2: {
                log.fatal((Object)message);
                break;
            }
            default: {
                log.error((Object)message);
            }
        }
        return result;
    }

    public void reset() {
        this.errorCount = 0;
    }
}

