/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.statistic;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.math.FloatOperations;
import org.modeshape.common.math.IntegerOperations;
import org.modeshape.common.math.MathOperations;
import org.modeshape.common.statistic.SimpleStatistics;

public class SimpleStatisticsTest {
    private SimpleStatistics<Integer> intStats = new SimpleStatistics((MathOperations)new IntegerOperations());
    private SimpleStatistics<Float> floatStats = new SimpleStatistics((MathOperations)new FloatOperations());

    @Test
    public void shouldHaveValidValuesWhenUnused() {
        Assert.assertThat((Object)this.intStats.getCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getMinimum(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getMaximum(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getMean(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCorrectStatisitcValuesWhenUnusedOnce() {
        this.intStats.add((Number)10);
        Assert.assertThat((Object)this.intStats.getCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.intStats.getMinimum(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)this.intStats.getMaximum(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)this.intStats.getMeanValue(), (Matcher)Is.is((Object)10.0));
    }

    @Test
    public void shouldCorrectStatisitcValuesWhenUsedAnOddNumberOfTimesButMoreThanOnce() {
        this.intStats.add((Number)1);
        this.intStats.add((Number)2);
        this.intStats.add((Number)3);
        Assert.assertThat((Object)this.intStats.getCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.intStats.getMinimum(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.intStats.getMaximum(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.intStats.getMeanValue(), (Matcher)Is.is((Object)2.0));
    }

    @Test
    public void shouldCorrectStatisitcValuesWhenUsedAnEvenNumberOfTimes() {
        this.intStats.add((Number)2);
        this.intStats.add((Number)4);
        this.intStats.add((Number)1);
        this.intStats.add((Number)3);
        Assert.assertThat((Object)this.intStats.getCount(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)this.intStats.getMinimum(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.intStats.getMaximum(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)this.intStats.getMeanValue(), (Matcher)Is.is((Object)2.5));
    }

    @Test
    public void shouldCorrectStatisitcValuesWhenAllValuesAreTheSame() {
        this.intStats.add((Number)2);
        this.intStats.add((Number)2);
        this.intStats.add((Number)2);
        this.intStats.add((Number)2);
        Assert.assertThat((Object)this.intStats.getCount(), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)this.intStats.getMinimum(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.intStats.getMaximum(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.intStats.getMeanValue(), (Matcher)Is.is((Object)2.0));
    }

    @Test
    public void shouldCorrectStatisitcValuesForComplexIntegerData() {
        this.intStats.add((Number)19);
        this.intStats.add((Number)10);
        this.intStats.add((Number)20);
        this.intStats.add((Number)7);
        this.intStats.add((Number)73);
        this.intStats.add((Number)72);
        this.intStats.add((Number)42);
        this.intStats.add((Number)9);
        this.intStats.add((Number)47);
        this.intStats.add((Number)24);
        System.out.println(this.intStats);
        Assert.assertThat((Object)this.intStats.getCount(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)this.intStats.getMinimum(), (Matcher)Is.is((Object)7));
        Assert.assertThat((Object)this.intStats.getMaximum(), (Matcher)Is.is((Object)73));
        Assert.assertEquals((double)32.3, (double)this.intStats.getMeanValue(), (double)1.0E-4);
    }

    @Test
    public void shouldCorrectStatisitcValuesForComplexFloatData() {
        this.floatStats.add((Number)Float.valueOf(1.9f));
        this.floatStats.add((Number)Float.valueOf(1.0f));
        this.floatStats.add((Number)Float.valueOf(2.0f));
        this.floatStats.add((Number)Float.valueOf(0.7f));
        this.floatStats.add((Number)Float.valueOf(7.3f));
        this.floatStats.add((Number)Float.valueOf(7.2f));
        this.floatStats.add((Number)Float.valueOf(4.2f));
        this.floatStats.add((Number)Float.valueOf(0.9f));
        this.floatStats.add((Number)Float.valueOf(4.7f));
        this.floatStats.add((Number)Float.valueOf(2.4f));
        System.out.println(this.floatStats);
        Assert.assertThat((Object)this.floatStats.getCount(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)this.floatStats.getMinimum(), (Matcher)Is.is((Object)Float.valueOf(0.7f)));
        Assert.assertThat((Object)this.floatStats.getMaximum(), (Matcher)Is.is((Object)Float.valueOf(7.3f)));
        Assert.assertEquals((double)3.23f, (double)this.floatStats.getMeanValue(), (double)1.0E-4f);
    }

    @Test
    public void shouldHaveNoStatisticValuesAfterUnusedAndReset() {
        this.intStats.add((Number)19);
        this.intStats.add((Number)10);
        this.intStats.add((Number)20);
        Assert.assertThat((Object)this.intStats.getCount(), (Matcher)Is.is((Object)3));
        this.intStats.reset();
        Assert.assertThat((Object)this.intStats.getCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getMinimum(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getMaximum(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.intStats.getMean(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldHaveStringRepresentationWithoutStatisticsForSingleSample() {
        this.intStats.add((Number)19);
        String str = this.intStats.toString();
        System.out.println(str);
        Assert.assertTrue((boolean)str.matches("1 sample.*"));
        Assert.assertTrue((boolean)str.matches(".*min=\\d{1,5}.*"));
        Assert.assertTrue((boolean)str.matches(".*max=\\d{1,5}.*"));
        Assert.assertTrue((boolean)str.matches(".*avg=\\d{1,5}.*"));
    }

    @Test
    public void shouldHaveStringRepresentationWithStatisticsForMultipleSample() {
        this.intStats.add((Number)19);
        this.intStats.add((Number)10);
        this.intStats.add((Number)20);
        String str = this.intStats.toString();
        System.out.println(str);
        Assert.assertTrue((boolean)str.matches("^\\d{1,5}.*"));
        Assert.assertTrue((boolean)str.matches(".*3 samples.*"));
        Assert.assertTrue((boolean)str.matches(".*min=\\d{1,5}.*"));
        Assert.assertTrue((boolean)str.matches(".*max=\\d{1,5}.*"));
        Assert.assertTrue((boolean)str.matches(".*avg=\\d{1,5}.*"));
    }
}

