/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.util.DelegatingClassLoader;

public class DelegatingClassLoaderTest {
    private static final URLClassLoader EMPTY_URL_CLASS_LOADER = new URLClassLoader(new URL[0], null);

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullDelegates() throws Exception {
        new DelegatingClassLoader(null, null);
    }

    @Test
    public void shouldAllowNullParent() throws Exception {
        new DelegatingClassLoader(null, Collections.emptyList());
    }

    @Test(expected=ClassNotFoundException.class)
    public void shouldNotClassIfNoDelegateCanFindIt() throws Exception {
        DelegatingClassLoader classLoader = new DelegatingClassLoader(null, Arrays.asList(EMPTY_URL_CLASS_LOADER));
        classLoader.loadClass(DelegatingClassLoaderTest.class.getName());
    }

    @Test
    public void shouldFindClassIfOneDelegateCanFindIt() throws Exception {
        DelegatingClassLoader classLoader = new DelegatingClassLoader(null, Arrays.asList(EMPTY_URL_CLASS_LOADER, DelegatingClassLoaderTest.class.getClassLoader()));
        Assert.assertNotNull((Object)classLoader.loadClass(DelegatingClassLoaderTest.class.getName()));
    }

    @Test
    public void shouldFindClassIfParentCanFindIt() throws Exception {
        DelegatingClassLoader classLoader = new DelegatingClassLoader(DelegatingClassLoaderTest.class.getClassLoader(), Arrays.asList(EMPTY_URL_CLASS_LOADER));
        Assert.assertNotNull((Object)classLoader.loadClass(DelegatingClassLoaderTest.class.getName()));
    }
}

