/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.math;

import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.math.FloatOperations;

public class FloatOperationsTest {
    private FloatOperations ops = new FloatOperations();

    @Test
    public void shouldReturnProperExponenentInScientificNotation() {
        Assert.assertEquals((long)-3L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(0.001f)));
        Assert.assertEquals((long)-3L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(0.002f)));
        Assert.assertEquals((long)-3L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(0.009999f)));
        Assert.assertEquals((long)-2L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(0.02f)));
        Assert.assertEquals((long)-2L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(0.09999f)));
        Assert.assertEquals((long)-1L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(0.1f)));
        Assert.assertEquals((long)-1L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(0.2f)));
        Assert.assertEquals((long)-1L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(0.9999f)));
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(0.0f)));
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(1.0f)));
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(2.0f)));
        Assert.assertEquals((long)0L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(9.999f)));
        Assert.assertEquals((long)1L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(10.0f)));
        Assert.assertEquals((long)1L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(20.0f)));
        Assert.assertEquals((long)1L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(99.999f)));
        Assert.assertEquals((long)2L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(100.0f)));
        Assert.assertEquals((long)2L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(200.0f)));
        Assert.assertEquals((long)2L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(999.999f)));
        Assert.assertEquals((long)3L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(1000.0f)));
        Assert.assertEquals((long)3L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(2000.0f)));
        Assert.assertEquals((long)3L, (long)this.ops.getExponentInScientificNotation(Float.valueOf(9999.999f)));
    }

    @Test
    public void shouldRoundNumbersGreaterThan10() {
        Assert.assertEquals((double)101.0, (double)this.ops.roundUp(Float.valueOf(101.2523f), 0).floatValue(), (double)0.01f);
        Assert.assertEquals((double)101.0, (double)this.ops.roundUp(Float.valueOf(101.2323f), 0).floatValue(), (double)0.01f);
        Assert.assertEquals((double)101.3f, (double)this.ops.roundUp(Float.valueOf(101.2523f), 1).floatValue(), (double)0.01f);
        Assert.assertEquals((double)101.2f, (double)this.ops.roundUp(Float.valueOf(101.2323f), 1).floatValue(), (double)0.01f);
        Assert.assertEquals((double)110.0, (double)this.ops.roundUp(Float.valueOf(109.2323f), -1).floatValue(), (double)1.0);
        Assert.assertEquals((double)100.0, (double)this.ops.roundUp(Float.valueOf(101.2323f), -1).floatValue(), (double)1.0);
    }
}

