/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.util.CheckArg;

public class ArgCheckTest {
    @Test
    public void isNonNegativeShouldNotThrowExceptionIfPositiveNumber() {
        CheckArg.isNonNegative((int)1, (String)"test");
    }

    @Test
    public void isNonNegativeShouldNotThrowExceptionIfZero() {
        CheckArg.isNonNegative((int)0, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNonNegativeShouldThrowExceptionIfNegative() {
        CheckArg.isNonNegative((int)-1, (String)"test");
    }

    @Test
    public void isNonPositiveShouldNotThrowExceptionIfNegativeNumber() {
        CheckArg.isNonPositive((int)-1, (String)"test");
    }

    @Test
    public void isNonPositiveShouldNotThrowExceptionIfZero() {
        CheckArg.isNonPositive((int)0, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNonPositiveShouldThrowExceptionIfPositive() {
        CheckArg.isNonPositive((int)1, (String)"test");
    }

    @Test
    public void isNegativeShouldNotThrowExceptionIfNegativeNumber() {
        CheckArg.isNegative((int)-1, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNegativeShouldThrowExceptionIfZero() {
        CheckArg.isNegative((int)0, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNegativeShouldThrowExceptionIfPositive() {
        CheckArg.isNegative((int)1, (String)"test");
    }

    @Test
    public void isPositiveShouldNotThrowExceptionIfPositiveNumber() {
        CheckArg.isPositive((int)1, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isPositiveShouldThrowExceptionIfZero() {
        CheckArg.isPositive((int)0, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isPositiveShouldThrowExceptionIfNegative() {
        CheckArg.isPositive((int)-1, (String)"test");
    }

    @Test
    public void isNonNegativeLongShouldNotThrowExceptionIfPositiveNumber() {
        CheckArg.isNonNegative((long)1L, (String)"test");
    }

    @Test
    public void isNonNegativeLongShouldNotThrowExceptionIfZero() {
        CheckArg.isNonNegative((long)0L, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNonNegativeLongShouldThrowExceptionIfNegative() {
        CheckArg.isNonNegative((long)-1L, (String)"test");
    }

    @Test
    public void isNonPositiveLongShouldNotThrowExceptionIfNegativeNumber() {
        CheckArg.isNonPositive((long)-1L, (String)"test");
    }

    @Test
    public void isNonPositiveLongShouldNotThrowExceptionIfZero() {
        CheckArg.isNonPositive((long)0L, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNonPositiveLongShouldThrowExceptionIfPositive() {
        CheckArg.isNonPositive((long)1L, (String)"test");
    }

    @Test
    public void isNegativeLongShouldNotThrowExceptionIfNegativeNumber() {
        CheckArg.isNegative((long)-1L, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNegativeLongShouldThrowExceptionIfZero() {
        CheckArg.isNegative((long)0L, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNegativeLongShouldThrowExceptionIfPositive() {
        CheckArg.isNegative((long)1L, (String)"test");
    }

    @Test
    public void isPositiveLongShouldNotThrowExceptionIfPositiveNumber() {
        CheckArg.isPositive((long)1L, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isPositiveLongShouldThrowExceptionIfZero() {
        CheckArg.isPositive((long)0L, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isPositiveLongShouldThrowExceptionIfNegative() {
        CheckArg.isPositive((long)-1L, (String)"test");
    }

    @Test
    public void isNotEmptyStringShouldNotThrowExceptionIfGivenStringWithAtLeastOneCharacter() {
        CheckArg.isNotEmpty((String)"a string", (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotEmptyStringShouldThrowExceptionIfGivenNullString() {
        CheckArg.isNotEmpty((String)null, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotEmptyStringShouldThrowExceptionIfGivenEmptyString() {
        CheckArg.isNotEmpty((String)"", (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotEmptyStringShouldThrowExceptionIfGivenStringWithOnlyWhitespace() {
        CheckArg.isNotEmpty((String)"\t\t  ", (String)"test");
    }

    @Test
    public void isNotZeroLengthShouldNotThrowExceptionIfGivenAStringOneCharacterOrLonger() {
        CheckArg.isNotZeroLength((String)"a", (String)"test");
    }

    @Test
    public void isNotZeroLengthShouldNotThrowExceptionIfGivenAStringWithOnlyWhitespace() {
        CheckArg.isNotZeroLength((String)" ", (String)"test");
        CheckArg.isNotZeroLength((String)"\t\t", (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotZeroLengthShouldThrowExceptionIfGivenAStringWithNoCharacters() {
        CheckArg.isNotZeroLength((String)"", (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotZeroLengthShouldThrowExceptionIfGivenANullString() {
        CheckArg.isNotZeroLength(null, (String)"test");
    }

    @Test
    public void isNotNullShouldNotThrowExceptionIfGivenNonNullReference() {
        CheckArg.isNotNull((Object)"a", (String)"test");
        CheckArg.isNotNull((Object)new Object(), (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotNullShouldThrowExceptionIfGivenNullReference() {
        CheckArg.isNotNull(null, (String)"test");
    }

    @Test
    public void getNotNullShouldReturnArgument() {
        Assert.assertThat((Object)"a", (Matcher)Is.is((Object)"a"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getNotNullShouldThrowExceptionIfGivenNullReference() {
        CheckArg.getNotNull(null, (String)"test");
    }

    @Test
    public void isNullShouldNotThrowExceptionIfGivenNullReference() {
        CheckArg.isNull(null, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNullShouldThrowExceptionIfGivenNonNullReference() {
        CheckArg.isNull((Object)this, (String)"test");
    }

    @Test
    public void isInstanceOfShouldNotThrowExceptionIfReferenceIsInstanceOfTheSuppliedClass() {
        CheckArg.isInstanceOf((Object)this, this.getClass(), (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isInstanceOfShouldNotThrowExceptionIfReferenceIsNotInstanceOfTheSuppliedClass() {
        CheckArg.isInstanceOf((Object)" ", this.getClass(), (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isInstanceOfShouldNotThrowExceptionIfReferenceIsNull() {
        CheckArg.isInstanceOf(null, this.getClass(), (String)"test");
    }

    @Test
    public void getInstanceOfShouldReturnCastArgument() {
        String obj = "a";
        ((String)CheckArg.getInstanceOf((Object)obj, String.class, (String)"test")).length();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getInstanceOfShouldThrowExceptionIfGivenNullReference() {
        CheckArg.getInstanceOf(null, this.getClass(), (String)"test");
    }

    @Test
    public void isNotEmptyCollectionShouldNotThrowExceptionIfGivenCollectionWithAtLeastOneObject() {
        CheckArg.isNotEmpty(Collections.singletonList(" "), (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotEmptyCollectionShouldThrowExceptionIfGivenNullCollection() {
        CheckArg.isNotEmpty((Collection)null, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotEmptyCollectionShouldThrowExceptionIfGivenEmptyCollection() {
        CheckArg.isNotEmpty(Collections.emptyList(), (String)"test");
    }

    @Test
    public void isNotEmptyMapShouldNotThrowExceptionIfGivenMapWithAtLeastOneEntry() {
        CheckArg.isNotEmpty(Collections.singletonMap("key", "value"), (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotEmptyMapShouldThrowExceptionIfGivenNullMap() {
        CheckArg.isNotEmpty((Map)null, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotEmptyMapShouldThrowExceptionIfGivenEmptyMap() {
        CheckArg.isNotEmpty(Collections.emptyMap(), (String)"test");
    }

    @Test
    public void isNotEmptyArrayShouldNotThrowExceptionIfGivenArrayWithAtLeastOneEntry() {
        CheckArg.isNotEmpty((Object[])new Object[]{"key", "value"}, (String)"test");
    }

    @Test
    public void isNotEmptyArrayShouldNotThrowExceptionIfGivenArrayWithAtNullEntry() {
        CheckArg.isNotEmpty((Object[])new Object[]{"key", "value", null}, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotEmptyArrayShouldThrowExceptionIfGivenNullArray() {
        CheckArg.isNotEmpty((Object[])null, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotEmptyArrayShouldThrowExceptionIfGivenEmptyArray() {
        CheckArg.isNotEmpty((Object[])new Object[0], (String)"test");
    }

    @Test
    public void isNotSameShouldNotThrowAnExceptionIfPassedSameObject() {
        CheckArg.isNotSame((Object)"a", (String)"first", (Object)"b", (String)"second");
        CheckArg.isNotSame((Object)new String("a"), (String)"first", (Object)new String("a"), (String)"second");
    }

    @Test
    public void isNotSameShouldNotThrowAnExceptionIfPassedSameObjectWithNoNames() {
        CheckArg.isNotSame((Object)"a", null, (Object)"b", null);
        CheckArg.isNotSame((Object)new String("a"), null, (Object)new String("a"), null);
    }

    @Test
    public void isNotSameShouldNotThrowAnExceptionIfPassedNullFirstObjectAndNonNullSecondObject() {
        CheckArg.isNotSame(null, (String)"first", (Object)"b", (String)"second");
    }

    @Test
    public void isNotSameShouldNotThrowAnExceptionIfPassedNonNullFirstObjectAndNullSecondObject() {
        CheckArg.isNotSame((Object)"a", (String)"first", null, (String)"second");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotSameShouldThrowAnExceptionIfPassedNullFirstObjectAndNullSecondObject() {
        CheckArg.isNotSame(null, (String)"first", null, (String)"second");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotSameShouldThrowAnExceptionIfPassedSameReferenceForFirstSecondObject() {
        String obj = "something";
        CheckArg.isNotSame((Object)obj, (String)"first", (Object)obj, (String)"second");
    }

    @Test
    public void containsShouldNotThrowExceptionIfPassedObjectInCollection() {
        CheckArg.contains(Collections.singletonList(" "), (Object)" ", (String)"test");
    }

    @Test
    public void containsShouldNotThrowExceptionIfPassedNullIfCollectionContainsNull() {
        CheckArg.contains(Collections.singletonList(null), null, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void containsShouldThrowExceptionIfPassedObjectNotInCollection() {
        CheckArg.contains(Collections.singletonList(" "), (Object)"a", (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void containsShouldThrowExceptionIfPassedNullAndCollectionDoesNotContainNull() {
        CheckArg.contains(Collections.singletonList(" "), null, (String)"test");
    }

    @Test
    public void containsKeyShouldNotThrowExceptionIfPassedObjectInCollection() {
        CheckArg.containsKey(Collections.singletonMap("key", "value"), (Object)"key", (String)"test");
    }

    @Test
    public void containsKeyShouldNotThrowExceptionIfPassedNullIfMapContainsNullKey() {
        CheckArg.containsKey(Collections.singletonMap(null, "value"), null, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void containsKeyShouldThrowExceptionIfPassedKeyNotInMap() {
        CheckArg.containsKey(Collections.singletonMap("key", "value"), (Object)"a", (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void containsKeyShouldThrowExceptionIfPassedNullAndMapDoesNotContainNullKey() {
        CheckArg.containsKey(Collections.singletonMap("key", "value"), null, (String)"test");
    }

    @Test
    public void containsNoNullsCollectionShouldNotThrowExceptionIfGivenArrayWithAtLeastOneEntry() {
        CheckArg.containsNoNulls(Collections.singletonList(" "), (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void containsNoNullsCollectionShouldThrowExceptionIfGivenNullCollection() {
        CheckArg.containsNoNulls((Iterable)null, (String)"test");
    }

    @Test
    public void containsNoNullsCollectionShouldNotThrowExceptionIfGivenEmptyCollection() {
        CheckArg.containsNoNulls(Collections.emptyList(), (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void containsNoNullsCollectionShouldThrowExceptionIfGivenCollectionWithNullEntry() {
        CheckArg.containsNoNulls(Collections.singletonList(null), (String)"test");
    }

    @Test
    public void containsNoNullsArrayShouldNotThrowExceptionIfGivenArrayWithAtLeastOneEntry() {
        CheckArg.containsNoNulls((Object[])new Object[]{"key", "value"}, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void containsNoNullsArrayShouldThrowExceptionIfGivenNullArray() {
        CheckArg.containsNoNulls((Object[])null, (String)"test");
    }

    @Test
    public void containsNoNullsArrayShouldNotThrowExceptionIfGivenEmptyArray() {
        CheckArg.containsNoNulls((Object[])new Object[0], (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void containsNoNullsArrayShouldThrowExceptionIfGivenArrayWithNullEntry() {
        CheckArg.containsNoNulls((Object[])new Object[]{"some", null, "thing", null}, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotLessThanShouldThrowExceptionIfValueIsLessThanSuppliedValue() {
        CheckArg.isNotLessThan((int)0, (int)1, (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotGreaterThanShouldThrowExceptionIfValueIsGreaterThanSuppliedValue() {
        CheckArg.isNotGreaterThan((int)1, (int)0, (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotLessThanShouldThrowExceptionIfValueIsEqualToSuppliedValue() {
        CheckArg.isNotLessThan((int)1, (int)2, (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isNotGreaterThanShouldThrowExceptionIfValueIsEqualToSuppliedValue() {
        CheckArg.isNotGreaterThan((int)2, (int)1, (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isLessThanShouldThrowExceptionIfValueIsGreaterThanSuppliedValue() {
        CheckArg.isLessThan((int)1, (int)0, (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isGreaterThanShouldThrowExceptionIfValueIsLessThanSuppliedValue() {
        CheckArg.isGreaterThan((int)0, (int)1, (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isLessThanShouldThrowExceptionIfValueIsEqualToSuppliedValue() {
        CheckArg.isLessThan((int)1, (int)1, (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isGreaterThanShouldThrowExceptionIfValueIsEqualToSuppliedValue() {
        CheckArg.isGreaterThan((int)1, (int)1, (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isLessThanOrEqualToShouldThrowExceptionIfValueIsNotLessThanOrEqualToSuppliedValue() {
        CheckArg.isLessThanOrEqualTo((int)1, (int)0, (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void isGreaterThanOrEqualToShouldThrowExceptionIfValueIsNotGreaterThanOrEqualToSuppliedValue() {
        CheckArg.isGreaterThanOrEqualTo((int)0, (int)1, (String)"value");
    }

    @Test
    public void isNotLessThanShouldNotThrowExceptionIfValueIsNotLessThanSuppliedValue() {
        CheckArg.isNotLessThan((int)1, (int)1, (String)"value");
        CheckArg.isNotLessThan((int)2, (int)1, (String)"value");
        CheckArg.isNotLessThan((int)100, (int)1, (String)"value");
    }

    @Test
    public void isNotGreaterThanShouldNotThrowExceptionIfValueIsNotGreaterThanSuppliedValue() {
        CheckArg.isNotGreaterThan((int)1, (int)1, (String)"value");
        CheckArg.isNotGreaterThan((int)1, (int)2, (String)"value");
        CheckArg.isNotGreaterThan((int)1, (int)100, (String)"value");
    }

    @Test
    public void isLessThanShouldNotThrowExceptionIfValueIsLessThanSuppliedValue() {
        CheckArg.isLessThanOrEqualTo((int)1, (int)2, (String)"value");
        CheckArg.isLessThanOrEqualTo((int)1, (int)100, (String)"value");
    }

    @Test
    public void isGreaterThanShouldNotThrowExceptionIfValueIsGreaterThanSuppliedValue() {
        CheckArg.isGreaterThan((int)2, (int)1, (String)"value");
        CheckArg.isGreaterThan((int)100, (int)1, (String)"value");
    }

    @Test
    public void isLessThanOrEqualToShouldNotThrowExceptionIfValueIsLessThanOrEqualToSuppliedValue() {
        CheckArg.isLessThanOrEqualTo((int)1, (int)1, (String)"value");
        CheckArg.isLessThanOrEqualTo((int)1, (int)2, (String)"value");
        CheckArg.isLessThanOrEqualTo((int)1, (int)100, (String)"value");
    }

    @Test
    public void isGreaterThanOrEqualToShouldNotThrowExceptionIfValueIsGreaterThanOrEqualToSuppliedValue() {
        CheckArg.isGreaterThanOrEqualTo((int)1, (int)1, (String)"value");
        CheckArg.isGreaterThanOrEqualTo((int)2, (int)1, (String)"value");
        CheckArg.isGreaterThanOrEqualTo((int)100, (int)1, (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void hasSizeOfAtLeastShouldThrowExceptionIfCollectionSizeIsSmallerThanSuppliedValue() {
        CheckArg.hasSizeOfAtLeast(Collections.singletonList(" "), (int)2, (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void hasSizeOfAtMostShouldThrowExceptionIfCollectionSizeIsLargerThanSuppliedValue() {
        CheckArg.hasSizeOfAtMost(Collections.singletonList(" "), (int)0, (String)"value");
    }

    @Test
    public void hasSizeOfAtLeastShouldNotThrowExceptionIfCollectionSizeIsEqualToSuppliedValue() {
        CheckArg.hasSizeOfAtLeast(Collections.singletonList(" "), (int)1, (String)"value");
    }

    @Test
    public void hasSizeOfAtMostShouldNotThrowExceptionIfCollectionSizeIsEqualToSuppliedValue() {
        CheckArg.hasSizeOfAtMost(Collections.singletonList(" "), (int)1, (String)"value");
    }

    @Test
    public void hasSizeOfAtLeastShouldNotThrowExceptionIfCollectionSizeIsGreaterThanSuppliedValue() {
        CheckArg.hasSizeOfAtLeast(Collections.singletonList(" "), (int)0, (String)"value");
    }

    @Test
    public void hasSizeOfAtMostShouldNotThrowExceptionIfCollectionSizeIsGreaterThanSuppliedValue() {
        CheckArg.hasSizeOfAtMost(Collections.singletonList(" "), (int)2, (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void hasSizeOfAtLeastShouldThrowExceptionIfMapSizeIsSmallerThanSuppliedValue() {
        CheckArg.hasSizeOfAtLeast(Collections.singletonMap("key", "value"), (int)2, (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void hasSizeOfAtMostShouldThrowExceptionIfMapSizeIsLargerThanSuppliedValue() {
        CheckArg.hasSizeOfAtMost(Collections.singletonMap("key", "value"), (int)0, (String)"value");
    }

    @Test
    public void hasSizeOfAtLeastShouldNotThrowExceptionIfMapSizeIsEqualToSuppliedValue() {
        CheckArg.hasSizeOfAtLeast(Collections.singletonMap("key", "value"), (int)1, (String)"value");
    }

    @Test
    public void hasSizeOfAtMostShouldNotThrowExceptionIfMapSizeIsEqualToSuppliedValue() {
        CheckArg.hasSizeOfAtMost(Collections.singletonMap("key", "value"), (int)1, (String)"value");
    }

    @Test
    public void hasSizeOfAtLeastShouldNotThrowExceptionIfMapSizeIsGreaterThanSuppliedValue() {
        CheckArg.hasSizeOfAtLeast(Collections.singletonMap("key", "value"), (int)0, (String)"value");
    }

    @Test
    public void hasSizeOfAtMostShouldNotThrowExceptionIfMapSizeIsGreaterThanSuppliedValue() {
        CheckArg.hasSizeOfAtMost(Collections.singletonMap("key", "value"), (int)2, (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void hasSizeOfAtLeastShouldThrowExceptionIfArraySizeIsSmallerThanSuppliedValue() {
        CheckArg.hasSizeOfAtLeast((Object[])new Object[]{"key", "value"}, (int)3, (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void hasSizeOfAtMostShouldThrowExceptionIfArraySizeIsLargerThanSuppliedValue() {
        CheckArg.hasSizeOfAtMost((Object[])new Object[]{"key", "value"}, (int)1, (String)"value");
    }

    @Test
    public void hasSizeOfAtLeastShouldNotThrowExceptionIfArraySizeIsEqualToSuppliedValue() {
        CheckArg.hasSizeOfAtLeast((Object[])new Object[]{"key", "value"}, (int)2, (String)"value");
    }

    @Test
    public void hasSizeOfAtMostShouldNotThrowExceptionIfArraySizeIsEqualToSuppliedValue() {
        CheckArg.hasSizeOfAtMost((Object[])new Object[]{"key", "value"}, (int)2, (String)"value");
    }

    @Test
    public void hasSizeOfAtLeastShouldNotThrowExceptionIfArraySizeIsGreaterThanSuppliedValue() {
        CheckArg.hasSizeOfAtLeast((Object[])new Object[]{"key", "value"}, (int)1, (String)"value");
    }

    @Test
    public void hasSizeOfAtMostShouldNotThrowExceptionIfArraySizeIsGreaterThanSuppliedValue() {
        CheckArg.hasSizeOfAtMost((Object[])new Object[]{"key", "value"}, (int)3, (String)"value");
    }
}

