/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.util.ClassUtil;

public class ClassUtilTest {
    @Test
    public void shouldConsiderValidClassnamesToBeValid() {
        this.assertValidClassname(this.getClass().getName());
        this.assertValidClassname("org.jboss.a.b.c.d.e.f.SomeClass");
        this.assertValidClassname("SomeClass");
    }

    @Test
    public void shouldConsiderInvalidClassnamesToBeInvalid() {
        this.assertNotValidClassname(null);
        this.assertNotValidClassname("");
        this.assertNotValidClassname("  " + this.getClass().getName() + "  \t ");
        this.assertNotValidClassname("1.2.3.4");
        this.assertNotValidClassname("org.jboss.a.b.c.d.e.f.2SomeClass");
        this.assertNotValidClassname("org/jboss/a/b/c/d/e.f.SomeClass");
    }

    protected void assertValidClassname(String classname) {
        Assert.assertThat((Object)ClassUtil.isFullyQualifiedClassname((String)classname), (Matcher)Is.is((Object)true));
    }

    protected void assertNotValidClassname(String classname) {
        Assert.assertThat((Object)ClassUtil.isFullyQualifiedClassname((String)classname), (Matcher)Is.is((Object)false));
    }
}

