/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection.ring;

import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.collection.ring.Consumer;
import org.modeshape.common.collection.ring.RingBuffer;
import org.modeshape.common.collection.ring.RingBufferBuilder;
import org.modeshape.common.statistic.Stopwatch;

public class RingBufferTest {
    protected static final Random RANDOM = new Random();
    protected volatile boolean print = false;
    protected volatile boolean slightPausesInConsumers = false;

    @Before
    public void beforeEach() {
        this.print = false;
    }

    @Test
    public void shouldBuildWithNoGarbageCollection() {
        ExecutorService executor = Executors.newCachedThreadPool();
        RingBuffer ringBuffer = RingBufferBuilder.withSingleProducer((Executor)executor, Long.class).ofSize(8).garbageCollect(false).build();
        this.print = false;
        long value = 0L;
        for (int i = 0; i != 10; ++i) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        MonotonicallyIncreasingConsumer consumer1 = new MonotonicallyIncreasingConsumer("first", 10L, 10L, 0);
        ringBuffer.addConsumer((Object)consumer1);
        for (int i = 0; i != 10; ++i) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        ringBuffer.shutdown();
        this.print("");
        this.print("Ring buffer shutdown completed");
        Assert.assertTrue((boolean)consumer1.isClosed());
    }

    @Test
    public void shouldBuildWithGarbageCollectionAnd8Entries() {
        ExecutorService executor = Executors.newCachedThreadPool();
        RingBuffer ringBuffer = RingBufferBuilder.withSingleProducer((Executor)executor, Long.class).ofSize(8).garbageCollect(true).build();
        this.print = false;
        long value = 0L;
        for (int i = 0; i != 10; ++i) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        MonotonicallyIncreasingConsumer consumer1 = new MonotonicallyIncreasingConsumer("first", 10L, 10L, 0);
        ringBuffer.addConsumer((Object)consumer1);
        for (int i = 0; i != 10; ++i) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        ringBuffer.shutdown();
        this.print("");
        this.print("Ring buffer shutdown completed");
    }

    @Test
    public void shouldBuildWithGarbageCollectionAnd1024Entries() {
        ExecutorService executor = Executors.newCachedThreadPool();
        RingBuffer ringBuffer = RingBufferBuilder.withSingleProducer((Executor)executor, Long.class).ofSize(1024).garbageCollect(true).build();
        this.print = false;
        long value = 0L;
        for (int i = 0; i != 10; ++i) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        MonotonicallyIncreasingConsumer consumer1 = new MonotonicallyIncreasingConsumer("first", 10L, 10L, 0);
        ringBuffer.addConsumer((Object)consumer1);
        for (int i = 0; i != 1000; ++i) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        ringBuffer.shutdown();
        this.print("");
        this.print("Ring buffer shutdown completed");
    }

    @Test
    public void shouldBeAbleToAddAndRemoveConsumers() throws Exception {
        int i;
        ExecutorService executor = Executors.newCachedThreadPool();
        RingBuffer ringBuffer = RingBufferBuilder.withSingleProducer((Executor)executor, Long.class).ofSize(8).build();
        this.print = false;
        long value = 0L;
        for (int i2 = 0; i2 != 10; ++i2) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        MonotonicallyIncreasingConsumer consumer1 = new MonotonicallyIncreasingConsumer("first", 10L, 10L, 0);
        ringBuffer.addConsumer((Object)consumer1);
        for (int i3 = 0; i3 != 10; ++i3) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        MonotonicallyIncreasingConsumer consumer2 = new MonotonicallyIncreasingConsumer("second", 20L, 20L, 0);
        ringBuffer.addConsumer((Object)consumer2);
        for (i = 0; i != 10; ++i) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        ringBuffer.remove((Object)consumer2);
        for (i = 0; i != 10; ++i) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        Assert.assertTrue((boolean)consumer2.isClosed());
        ringBuffer.shutdown();
        this.print("");
        this.print("Ring buffer shutdown completed");
        Assert.assertTrue((boolean)consumer1.isClosed());
        Assert.assertTrue((boolean)consumer2.isClosed());
    }

    @Test
    public void consumersShouldSeeEventsInCorrectOrder() throws Exception {
        int i;
        ExecutorService executor = Executors.newCachedThreadPool();
        RingBuffer ringBuffer = RingBufferBuilder.withSingleProducer((Executor)executor, (RingBuffer.ConsumerAdapter)LongConsumerAdapter.INSTANCE).ofSize(8).garbageCollect(false).build();
        this.print = false;
        long value = 0L;
        for (int i2 = 0; i2 != 10; ++i2) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        MonotonicallyIncreasingConsumer consumer1 = new MonotonicallyIncreasingConsumer("first", 10L, 10L, 0);
        ringBuffer.addConsumer((Object)consumer1);
        for (int i3 = 0; i3 != 10; ++i3) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        MonotonicallyIncreasingConsumer consumer2 = new MonotonicallyIncreasingConsumer("second", 20L, 20L, 0);
        ringBuffer.addConsumer((Object)consumer2);
        for (int i4 = 0; i4 != 10; ++i4) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        MonotonicallyIncreasingConsumer consumer3 = new MonotonicallyIncreasingConsumer("third", 30L, 30L, 0);
        ringBuffer.addConsumer((Object)consumer3);
        for (int i5 = 0; i5 != 10; ++i5) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        MonotonicallyIncreasingConsumer consumer4 = new MonotonicallyIncreasingConsumer("fourth", 40L, 40L, 0);
        ringBuffer.addConsumer((Object)consumer4);
        for (int i6 = 0; i6 != 10; ++i6) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        this.slightPausesInConsumers = false;
        boolean slightPauseBetweenEvents = false;
        Stopwatch sw = new Stopwatch();
        int count = 2000;
        sw.start();
        for (i = 0; i != count; ++i) {
            ringBuffer.add((Object)value++);
            if (!slightPauseBetweenEvents) continue;
            Thread.sleep(RANDOM.nextInt(50));
        }
        sw.stop();
        for (i = 0; i != 10; ++i) {
            this.print("Adding entry " + value);
            ringBuffer.add((Object)value++);
        }
        ringBuffer.shutdown();
        this.print("");
        this.print("Ring buffer shutdown completed");
        Assert.assertTrue((boolean)consumer1.isClosed());
        Assert.assertTrue((boolean)consumer2.isClosed());
        Assert.assertTrue((boolean)consumer3.isClosed());
        Assert.assertTrue((boolean)consumer4.isClosed());
        Assert.assertThat((Object)consumer1.getLastValue(), (Matcher)Is.is((Object)(--value)));
        Assert.assertThat((Object)consumer2.getLastValue(), (Matcher)Is.is((Object)value));
        Assert.assertThat((Object)consumer3.getLastValue(), (Matcher)Is.is((Object)value));
        Assert.assertThat((Object)consumer4.getLastValue(), (Matcher)Is.is((Object)value));
        this.print("");
        this.print("Time to add " + count + " entries: " + sw.getAverageDuration());
    }

    @Test
    @FixFor(value={"MODE-2195"})
    public void shouldAutomaticallySetTheBufferSizeToTheNextPowerOf2() throws Exception {
        ExecutorService executor = Executors.newCachedThreadPool();
        RingBuffer ringBuffer = RingBufferBuilder.withSingleProducer((Executor)executor, Long.class).ofSize(5).garbageCollect(false).build();
        Assert.assertEquals((long)8L, (long)ringBuffer.getBufferSize());
        ringBuffer = RingBufferBuilder.withSingleProducer((Executor)executor, Long.class).ofSize(1023).garbageCollect(false).build();
        Assert.assertEquals((long)1024L, (long)ringBuffer.getBufferSize());
    }

    protected void print(String message) {
        if (this.print) {
            System.out.println(message);
        }
    }

    private static class LongConsumerAdapter
    implements RingBuffer.ConsumerAdapter<Long, MonotonicallyIncreasingConsumer> {
        protected static final LongConsumerAdapter INSTANCE = new LongConsumerAdapter();

        private LongConsumerAdapter() {
        }

        public boolean consume(MonotonicallyIncreasingConsumer consumer, Long event, long position, long maxPosition) {
            consumer.consume(event, position, maxPosition);
            return true;
        }

        public void close(MonotonicallyIncreasingConsumer consumer) {
            consumer.close();
        }

        public void handleException(MonotonicallyIncreasingConsumer consumer, Throwable t, Long entry, long position, long maxPosition) {
            throw new AssertionError("Test failure", t);
        }
    }

    protected class MonotonicallyIncreasingConsumer
    extends Consumer<Long> {
        private final String id;
        private boolean first = true;
        private long lastValue = -1L;
        private long lastPosition = -1L;
        private boolean closed = false;
        private final int secondsToWork;

        public MonotonicallyIncreasingConsumer(String id, long firstValue, long firstPosition, int secondsToWork) {
            this.id = id;
            this.lastValue = firstValue;
            this.lastPosition = firstPosition;
            this.secondsToWork = secondsToWork;
        }

        public boolean consume(Long entry, long position, long max) {
            Assert.assertTrue((!this.closed ? 1 : 0) != 0);
            RingBufferTest.this.print(this.id + " consuming " + entry + " at position " + position + " with max " + max);
            try {
                Thread.sleep(this.secondsToWork * 1000);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
            if (RingBufferTest.this.slightPausesInConsumers && position % 1000L == 0L) {
                try {
                    Thread.sleep(RANDOM.nextInt(100));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
            if (this.first) {
                Assert.assertTrue((entry == this.lastValue ? 1 : 0) != 0);
                Assert.assertTrue((position == this.lastPosition ? 1 : 0) != 0);
                this.first = false;
            } else {
                Assert.assertTrue((entry == this.lastValue + 1L ? 1 : 0) != 0);
                this.lastValue = entry;
                Assert.assertTrue((position == this.lastPosition + 1L ? 1 : 0) != 0);
                this.lastPosition = position;
            }
            return true;
        }

        public void close() {
            super.close();
            RingBufferTest.this.print(this.id + " closing");
            this.closed = true;
        }

        public long getLastPosition() {
            return this.lastPosition;
        }

        public long getLastValue() {
            return this.lastValue;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }
}

