/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.modeshape.common.collection.EmptyIterator;

public class Collections {
    public static <T> Iterator<T> emptyIterator() {
        return new EmptyIterator();
    }

    public static <T> Set<T> unmodifiableSet(T ... values) {
        return Collections.unmodifiableSet(Arrays.asList(values));
    }

    public static <T> Set<T> unmodifiableSet(Collection<T> values) {
        return java.util.Collections.unmodifiableSet(new HashSet<T>(values));
    }

    public static <T> Set<T> unmodifiableSet(Set<T> values) {
        return java.util.Collections.unmodifiableSet(values);
    }

    private Collections() {
    }

    public static <T> Iterable<T> concat(final Iterable<T> a, final Iterable<T> b) {
        assert (a != null);
        assert (b != null);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Collections.concat(a.iterator(), b.iterator());
            }
        };
    }

    public static <T> Iterator<T> concat(final Iterator<T> a, final Iterator<T> b) {
        assert (a != null);
        assert (b != null);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return a.hasNext() || b.hasNext();
            }

            @Override
            public T next() {
                if (a.hasNext()) {
                    return a.next();
                }
                return b.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

