/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.math;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Random;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.math.MathOperations;

@Immutable
public class LongOperations
implements MathOperations<Long>,
Comparator<Long> {
    @Override
    public Class<Long> getOperandClass() {
        return Long.class;
    }

    @Override
    public Long add(Long value1, Long value2) {
        if (value1 == null) {
            return value2 != null ? value2 : this.createZeroValue();
        }
        if (value2 == null) {
            return value1;
        }
        return value1 + value2;
    }

    @Override
    public Long subtract(Long value1, Long value2) {
        if (value1 == null) {
            return this.negate(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return value1 - value2;
    }

    @Override
    public Long multiply(Long value1, Long value2) {
        if (value1 == null || value2 == null) {
            return this.createZeroValue();
        }
        return value1 * value2;
    }

    @Override
    public double divide(Long value1, Long value2) {
        if (value1 == null || value2 == null) {
            throw new IllegalArgumentException();
        }
        return value1 / value2;
    }

    @Override
    public Long negate(Long value) {
        if (value == null) {
            return this.createZeroValue();
        }
        return value * -1L;
    }

    @Override
    public Long increment(Long value) {
        if (value == null) {
            return this.createZeroValue();
        }
        return value + 1L;
    }

    @Override
    public Long maximum(Long value1, Long value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return Math.max(value1, value2);
    }

    @Override
    public Long minimum(Long value1, Long value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return Math.min(value1, value2);
    }

    @Override
    public int compare(Long value1, Long value2) {
        if (value1 == null) {
            return value2 != null ? -1 : 0;
        }
        if (value2 == null) {
            return 1;
        }
        return value1.compareTo(value2);
    }

    @Override
    public BigDecimal asBigDecimal(Long value) {
        return value != null ? new BigDecimal(value) : null;
    }

    @Override
    public Long fromBigDecimal(BigDecimal value) {
        return value != null ? Long.valueOf(value.longValue()) : null;
    }

    @Override
    public Long createZeroValue() {
        return 0L;
    }

    @Override
    public Long create(int value) {
        return value;
    }

    @Override
    public Long create(long value) {
        return value;
    }

    @Override
    public Long create(double value) {
        return (long)value;
    }

    @Override
    public double sqrt(Long value) {
        return Math.sqrt(value.longValue());
    }

    @Override
    public Comparator<Long> getComparator() {
        return this;
    }

    @Override
    public Long random(Long minimum, Long maximum, Random rng) {
        Long difference = this.subtract(maximum, minimum);
        return minimum + (long)rng.nextInt(difference.intValue());
    }

    @Override
    public double doubleValue(Long value) {
        return value.doubleValue();
    }

    @Override
    public float floatValue(Long value) {
        return value.floatValue();
    }

    @Override
    public int intValue(Long value) {
        return value.intValue();
    }

    @Override
    public long longValue(Long value) {
        return value;
    }

    @Override
    public short shortValue(Long value) {
        return value.shortValue();
    }

    @Override
    public int getExponentInScientificNotation(Long value) {
        int exp;
        block3: {
            long v;
            block2: {
                v = Math.abs(value);
                exp = 0;
                if (v <= 1L) break block2;
                while (v >= 10L) {
                    v /= 10L;
                    ++exp;
                }
                break block3;
            }
            if (v == 0L || v >= 1L) break block3;
            while (v < 1L) {
                v *= 10L;
                --exp;
            }
        }
        return exp;
    }

    @Override
    public Long roundUp(Long value, int decimalShift) {
        if (value == 0L) {
            return 0L;
        }
        if (decimalShift >= 0) {
            return value;
        }
        long shiftedValueP5 = Math.abs(value);
        for (int i = 0; i != -decimalShift - 1; ++i) {
            shiftedValueP5 /= 10L;
        }
        long shiftedValue = (shiftedValueP5 += 5L) / 10L;
        if (shiftedValue * 10L - shiftedValueP5 >= 5L) {
            ++shiftedValue;
        }
        shiftedValue *= (long)Long.signum(value);
        for (int i = 0; i != -decimalShift; ++i) {
            shiftedValue *= 10L;
        }
        return shiftedValue;
    }

    @Override
    public Long roundDown(Long value, int decimalShift) {
        int i;
        if (value == 0L) {
            return 0L;
        }
        if (decimalShift >= 0) {
            return value;
        }
        long shiftedValue = Math.abs(value);
        for (i = 0; i != -decimalShift; ++i) {
            shiftedValue /= 10L;
        }
        shiftedValue *= (long)Long.signum(value);
        for (i = 0; i != -decimalShift; ++i) {
            shiftedValue *= 10L;
        }
        return shiftedValue;
    }

    @Override
    public Long keepSignificantFigures(Long value, int numSigFigs) {
        if (value == 0L) {
            return value;
        }
        if (numSigFigs < 0) {
            return value;
        }
        if (numSigFigs == 0) {
            return 0L;
        }
        int currentExp = this.getExponentInScientificNotation(value);
        int decimalShift = -currentExp + numSigFigs - 1;
        return this.roundUp(value, decimalShift);
    }
}

