/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jca;

import java.io.Serializable;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import org.modeshape.jca.JcrConnectionRequestInfo;
import org.modeshape.jca.JcrManagedConnectionFactory;

public class JcrRepositoryHandle
implements Referenceable,
Serializable,
Repository {
    private static final long serialVersionUID = 1L;
    private Reference reference;
    private final JcrManagedConnectionFactory mcf;
    private final ConnectionManager cm;
    private Repository repository;

    public JcrRepositoryHandle(JcrManagedConnectionFactory mcf, ConnectionManager cm) throws ResourceException {
        this.mcf = mcf;
        this.cm = cm;
        try {
            this.repository = mcf.getRepository();
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public String[] getDescriptorKeys() {
        return this.repository.getDescriptorKeys();
    }

    public boolean isStandardDescriptor(String key) {
        return this.repository.isStandardDescriptor(key);
    }

    public boolean isSingleValueDescriptor(String key) {
        return this.repository.isSingleValueDescriptor(key);
    }

    public Value getDescriptorValue(String key) {
        return this.repository.getDescriptorValue(key);
    }

    public Value[] getDescriptorValues(String key) {
        return this.repository.getDescriptorValues(key);
    }

    public String getDescriptor(String key) {
        return this.repository.getDescriptor(key);
    }

    public Session login(Credentials c) throws LoginException, RepositoryException {
        return this.login(c, null);
    }

    public Session login(String ws) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, ws);
    }

    public Session login() throws LoginException, RepositoryException {
        return this.login(null, null);
    }

    public Session login(Credentials c, String workspace) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        try {
            return (Session)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)new JcrConnectionRequestInfo(c, workspace));
        }
        catch (ResourceException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e.getLinkedException();
            }
            if (cause instanceof LoginException) {
                throw (LoginException)cause;
            }
            if (cause instanceof NoSuchWorkspaceException) {
                throw (NoSuchWorkspaceException)cause;
            }
            if (cause instanceof RepositoryException) {
                throw (RepositoryException)cause;
            }
            if (cause != null) {
                throw new RepositoryException(cause);
            }
            throw new RepositoryException((Throwable)e);
        }
    }

    public Session getConnection() throws ResourceException {
        try {
            return this.login();
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }
}

