/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jca;

import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.Connector;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.TransactionSupport;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jca.JcaI18n;
import org.modeshape.jca.JcrManagedConnectionFactory;
import org.modeshape.jcr.ModeShapeEngine;

@Connector(reauthenticationSupport=false, transactionSupport=TransactionSupport.TransactionSupportLevel.XATransaction)
public class JcrResourceAdapter
implements ResourceAdapter,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(JcrResourceAdapter.class);
    private final XAResource[] xaResources = new XAResource[0];
    private ModeShapeEngine engine;

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
    }

    public synchronized void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        if (this.engine == null) {
            this.engine = new ModeShapeEngine();
            this.engine.start();
        }
    }

    public synchronized void stop() {
        if (this.engine != null) {
            Future shutdown = this.engine.shutdown();
            int SHUTDOWN_TIMEOUT = 30;
            try {
                LOGGER.debug("Shutting down engine to stop resource adapter", new Object[0]);
                if (!((Boolean)shutdown.get(30L, TimeUnit.SECONDS)).booleanValue()) {
                    LOGGER.error((I18nResource)JcaI18n.unableToStopEngine, new Object[0]);
                }
            }
            catch (TimeoutException e) {
                LOGGER.error((Throwable)e, (I18nResource)JcaI18n.unableToStopEngineWithinTimeLimit, new Object[]{30});
            }
            catch (InterruptedException e) {
                LOGGER.error((Throwable)e, (I18nResource)JcaI18n.interruptedWhileStoppingJcaAdapter, new Object[]{e.getMessage()});
            }
            catch (ExecutionException e) {
                LOGGER.error((Throwable)e, (I18nResource)JcaI18n.errorWhileStoppingJcaAdapter, new Object[]{e.getMessage()});
            }
            this.engine = null;
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return this.xaResources;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof JcrManagedConnectionFactory) {
            return this == other;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public synchronized ModeShapeEngine getEngine() {
        if (this.engine == null) {
            ModeShapeEngine engine = new ModeShapeEngine();
            engine.start();
            this.engine = engine;
        }
        return this.engine;
    }
}

