/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jca;

import java.io.PrintWriter;
import java.net.URL;
import java.util.Set;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.resource.ResourceException;
import javax.resource.spi.ConfigProperty;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.security.auth.Subject;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.logging.Logger;
import org.modeshape.jca.JcrConnectionManager;
import org.modeshape.jca.JcrConnectionRequestInfo;
import org.modeshape.jca.JcrManagedConnection;
import org.modeshape.jca.JcrRepositoryHandle;
import org.modeshape.jca.JcrResourceAdapter;
import org.modeshape.jca.JcrSessionHandle;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.RepositoryConfiguration;

@ConnectionDefinition(connectionFactory=Repository.class, connectionFactoryImpl=JcrRepositoryHandle.class, connection=Session.class, connectionImpl=JcrSessionHandle.class)
public class JcrManagedConnectionFactory
implements ManagedConnectionFactory,
ResourceAdapterAssociation {
    private static final Logger LOGGER = Logger.getLogger(JcrManagedConnectionFactory.class);
    private static final long serialVersionUID = 1L;
    private JcrResourceAdapter ra;
    private PrintWriter logwriter;
    @ConfigProperty
    private String repositoryURL;
    private Repository repository;
    private ModeShapeEngine engine;

    private boolean isAbsolutePath(String uri) {
        return !uri.startsWith("jndi") && !uri.startsWith("file");
    }

    private Repository deployRepository(String uri) throws ResourceException {
        if (this.engine == null) {
            this.engine = this.ra.getEngine();
            if (this.engine == null) {
                throw new ResourceException("Engine not started by resource adapter!");
            }
        }
        RepositoryConfiguration config = null;
        try {
            URL url = this.isAbsolutePath(uri) ? this.getClass().getClassLoader().getResource(uri) : new URL(uri);
            config = RepositoryConfiguration.read((URL)url);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
        Problems problems = config.validate();
        if (problems.hasErrors()) {
            throw new ResourceException(problems.toString());
        }
        try {
            return this.engine.deploy(config);
        }
        catch (RepositoryException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public void setRepositoryURL(String repositoryURL) {
        LOGGER.debug("Set repository URL=[{0}]", new Object[]{repositoryURL});
        this.repositoryURL = repositoryURL;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public synchronized Repository getRepository() throws ResourceException {
        if (this.repository == null) {
            LOGGER.debug("Deploying repository URL [{0}]", new Object[]{this.repositoryURL});
            this.repository = this.deployRepository(this.repositoryURL);
        }
        return this.repository;
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        JcrRepositoryHandle handle = new JcrRepositoryHandle(this, cxManager);
        return handle;
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(new JcrConnectionManager());
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        return new JcrManagedConnection(this, (JcrConnectionRequestInfo)cxRequestInfo);
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        for (Object connection : connectionSet) {
            JcrConnectionRequestInfo otherCri;
            JcrManagedConnection mc;
            if (!(connection instanceof JcrManagedConnection) || !this.equals((mc = (JcrManagedConnection)connection).getManagedConnectionFactory()) || cxRequestInfo != (otherCri = mc.getConnectionRequestInfo()) && (cxRequestInfo == null || !cxRequestInfo.equals((Object)otherCri))) continue;
            return mc;
        }
        return null;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logwriter;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logwriter = out;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public void setResourceAdapter(ResourceAdapter ra) {
        this.ra = (JcrResourceAdapter)ra;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.repositoryURL == null ? 0 : this.repositoryURL.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JcrManagedConnectionFactory other = (JcrManagedConnectionFactory)obj;
        return !(this.repositoryURL == null ? other.repositoryURL != null : !this.repositoryURL.equals(other.repositoryURL));
    }
}

