/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jca;

import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.txn.Transactions;

@Immutable
public final class JcrLocalTransaction
implements LocalTransaction {
    private final Transactions transactions;

    protected JcrLocalTransaction(Transactions transactions) {
        this.transactions = transactions;
    }

    public void begin() throws ResourceException {
        try {
            this.transactions.begin();
        }
        catch (NotSupportedException | RollbackException | SystemException e) {
            throw new LocalTransactionException(e);
        }
    }

    public void commit() throws ResourceException {
        try {
            Transactions.Transaction transaction = this.transactions.currentTransaction();
            if (transaction == null) {
                throw new LocalTransactionException("A local transaction does not exist");
            }
            transaction.commit();
        }
        catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
            throw new LocalTransactionException(e);
        }
    }

    public void rollback() throws ResourceException {
        Transactions.Transaction transaction = this.transactions.currentTransaction();
        if (transaction == null) {
            throw new LocalTransactionException("A local transaction does not exist");
        }
        try {
            transaction.rollback();
        }
        catch (SystemException e) {
            throw new LocalTransactionException((Throwable)e);
        }
    }
}

