/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.infinispan.util.FileLookup;
import org.infinispan.util.FileLookupFactory;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.text.TokenStream;
import org.modeshape.common.util.IoUtil;
import org.modeshape.jcr.CndI18n;
import org.modeshape.jcr.CndTokenizer;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrNodeDefinitionTemplate;
import org.modeshape.jcr.JcrNodeTypeTemplate;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinitionTemplate;
import org.modeshape.jcr.JcrValueFactory;
import org.modeshape.jcr.cache.PropertyTypeUtil;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;
import org.modeshape.jcr.value.basic.LocalNamespaceRegistry;

@NotThreadSafe
public class CndImporter {
    protected final List<String> VALID_PROPERTY_TYPES = Collections.unmodifiableList(Arrays.asList("STRING", "BINARY", "LONG", "DOUBLE", "BOOLEAN", "DATE", "NAME", "PATH", "REFERENCE", "WEAKREFERENCE", "DECIMAL", "URI", "UNDEFINED", "*", "?"));
    protected final List<String> VALID_ON_PARENT_VERSION = Collections.unmodifiableList(Arrays.asList("COPY", "VERSION", "INITIALIZE", "COMPUTE", "IGNORE", "ABORT"));
    protected final Set<String> VALID_QUERY_OPERATORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("=", "<>", "<", "<=", ">", ">=", "LIKE")));
    protected final List<String> BUILT_INS = Collections.unmodifiableList(Arrays.asList("org/modeshape/jcr/jsr_283_builtins.cnd", "org/modeshape/jcr/modeshape_builtins.cnd"));
    public static final boolean DEFAULT_USE_VENDOR_EXTENSIONS = true;
    public static final boolean DEFAULT_COMPATIBLE_WITH_PREJCR2 = true;
    protected final String VENDOR_PATTERN_STRING = "([^\\s]+)(\\s+(.*))";
    protected final Pattern VENDOR_PATTERN = Pattern.compile("([^\\s]+)(\\s+(.*))");
    protected final ExecutionContext context;
    protected final LocalNamespaceRegistry localRegistry;
    protected final NameFactory nameFactory;
    protected final ValueFactory<String> stringFactory;
    protected final javax.jcr.ValueFactory valueFactory;
    protected final boolean jcr170;
    protected final List<NodeTypeDefinition> nodeTypes;

    public CndImporter(ExecutionContext context, boolean compatibleWithPreJcr2) {
        assert (context != null);
        this.localRegistry = new LocalNamespaceRegistry(context.getNamespaceRegistry());
        this.context = context.with(this.localRegistry);
        this.valueFactory = new JcrValueFactory(this.context);
        this.nameFactory = this.context.getValueFactories().getNameFactory();
        this.stringFactory = this.context.getValueFactories().getStringFactory();
        this.jcr170 = compatibleWithPreJcr2;
        this.nodeTypes = new LinkedList<NodeTypeDefinition>();
    }

    public void importFrom(InputStream stream, Problems problems, String resourceName) throws IOException {
        this.importFrom(IoUtil.read((InputStream)stream), problems, resourceName);
    }

    public void importFrom(File file, Problems problems) throws IOException {
        this.importFrom(IoUtil.read((File)file), problems, file.getCanonicalPath());
    }

    public void importFrom(String content, Problems problems, String resourceName) {
        try {
            this.parse(content);
        }
        catch (RuntimeException e) {
            problems.addError((Throwable)e, CndI18n.errorImportingCndContent, new Object[]{resourceName, e.getMessage()});
        }
    }

    public void importBuiltIns(Problems problems) throws IOException {
        for (String resource : this.BUILT_INS) {
            FileLookup factory = FileLookupFactory.newInstance();
            InputStream stream = factory.lookupFile(resource, Thread.currentThread().getContextClassLoader());
            if (stream == null) {
                stream = factory.lookupFile(resource, this.getClass().getClassLoader());
            }
            this.importFrom(stream, problems, resource);
        }
    }

    public Set<NamespaceRegistry.Namespace> getNamespaces() {
        return new HashSet<NamespaceRegistry.Namespace>(this.localRegistry.getLocalNamespaces());
    }

    public List<NodeTypeDefinition> getNodeTypeDefinitions() {
        return Collections.unmodifiableList(new ArrayList<NodeTypeDefinition>(this.nodeTypes));
    }

    protected void parse(String content) {
        CndTokenizer tokenizer = new CndTokenizer(false, true);
        TokenStream tokens = new TokenStream(content, (TokenStream.Tokenizer)tokenizer, false);
        tokens.start();
        while (tokens.hasNext()) {
            if (tokens.matches("<", new String[]{"any value", "=", "any value", ">"})) {
                this.parseNamespaceMapping(tokens);
                continue;
            }
            if (tokens.matches("[", new String[]{"any value", "]"})) {
                this.parseNodeTypeDefinition(tokens);
                continue;
            }
            Position position = tokens.previousPosition();
            throw new ParsingException(position, CndI18n.expectedNamespaceOrNodeDefinition.text(new Object[]{tokens.consume(), position.getLine(), position.getColumn()}));
        }
    }

    protected void parseNamespaceMapping(TokenStream tokens) {
        tokens.consume('<');
        String prefix = this.removeQuotes(tokens.consume());
        tokens.consume('=');
        String uri = this.removeQuotes(tokens.consume());
        tokens.consume('>');
        this.context.getNamespaceRegistry().register(prefix, uri);
    }

    protected void parseNodeTypeDefinition(TokenStream tokens) {
        JcrNodeTypeTemplate nodeType;
        block5: {
            block4: {
                Name name = this.parseNodeTypeName(tokens);
                nodeType = new JcrNodeTypeTemplate(this.context);
                try {
                    nodeType.setName(this.string(name));
                }
                catch (ConstraintViolationException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)"Names should always be syntactically valid");
                }
            }
            List<Name> supertypes = this.parseSupertypes(tokens);
            try {
                nodeType.setDeclaredSuperTypeNames(this.names(supertypes));
                this.parseNodeTypeOptions(tokens, nodeType);
                this.parsePropertyOrChildNodeDefinitions(tokens, nodeType);
            }
            catch (ConstraintViolationException e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)"Names should always be syntactically valid");
            }
        }
        this.nodeTypes.add((NodeTypeDefinition)nodeType);
    }

    protected Name parseNodeTypeName(TokenStream tokens) {
        tokens.consume('[');
        Name name = this.parseName(tokens);
        tokens.consume(']');
        return name;
    }

    protected List<Name> parseSupertypes(TokenStream tokens) {
        if (tokens.canConsume('>')) {
            return this.parseNameList(tokens);
        }
        return Collections.emptyList();
    }

    protected List<String> parseStringList(TokenStream tokens) {
        ArrayList<String> strings = new ArrayList<String>();
        if (tokens.canConsume('?')) {
            strings.add("?");
        } else {
            do {
                strings.add(this.removeQuotes(tokens.consume()));
            } while (tokens.canConsume(','));
        }
        return strings;
    }

    protected List<Name> parseNameList(TokenStream tokens) {
        ArrayList<Name> names = new ArrayList<Name>();
        if (!tokens.canConsume('?')) {
            do {
                names.add(this.parseName(tokens));
            } while (tokens.canConsume(','));
        }
        return names;
    }

    protected void parseNodeTypeOptions(TokenStream tokens, JcrNodeTypeTemplate nodeType) throws ConstraintViolationException {
        boolean isOrderable = false;
        boolean isMixin = false;
        boolean isAbstract = false;
        boolean isQueryable = true;
        String primaryItem = null;
        while (true) {
            if (tokens.canConsumeAnyOf("ORDERABLE", new String[]{"ORD", "O"})) {
                tokens.canConsume('?');
                isOrderable = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("MIXIN", new String[]{"MIX", "M"})) {
                tokens.canConsume('?');
                isMixin = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("ABSTRACT", new String[]{"ABS", "A"})) {
                tokens.canConsume('?');
                isAbstract = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("NOQUERY", new String[]{"NOQ"})) {
                tokens.canConsume('?');
                isQueryable = false;
                continue;
            }
            if (tokens.canConsumeAnyOf("QUERY", new String[]{"Q"})) {
                tokens.canConsume('?');
                isQueryable = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("PRIMARYITEM", new String[]{"!"})) {
                primaryItem = this.removeQuotes(tokens.consume());
                tokens.canConsume('?');
                continue;
            }
            if (!tokens.matches(7)) break;
            LinkedList<Property> properties = new LinkedList<Property>();
            this.parseVendorExtensions(tokens, properties);
            this.applyVendorExtensions(nodeType, properties);
        }
        nodeType.setAbstract(isAbstract);
        nodeType.setMixin(isMixin);
        nodeType.setOrderableChildNodes(isOrderable);
        nodeType.setQueryable(isQueryable);
        if (primaryItem != null) {
            nodeType.setPrimaryItemName(this.string(primaryItem));
        }
    }

    protected void parsePropertyOrChildNodeDefinitions(TokenStream tokens, JcrNodeTypeTemplate nodeType) throws ConstraintViolationException {
        while (true) {
            if (tokens.matches('-')) {
                this.parsePropertyDefinition(tokens, nodeType);
                continue;
            }
            if (!tokens.matches('+')) break;
            this.parseChildNodeDefinition(tokens, nodeType);
        }
    }

    protected void parsePropertyDefinition(TokenStream tokens, JcrNodeTypeTemplate nodeType) throws ConstraintViolationException {
        tokens.consume('-');
        Name name = this.parseName(tokens);
        JcrPropertyDefinitionTemplate propDefn = new JcrPropertyDefinitionTemplate(this.context);
        propDefn.setName(this.string(name));
        this.parsePropertyType(tokens, propDefn, PropertyType.STRING.getName());
        this.parseDefaultValues(tokens, propDefn);
        this.parsePropertyAttributes(tokens, propDefn, nodeType);
        this.parseValueConstraints(tokens, propDefn);
        LinkedList<Property> properties = new LinkedList<Property>();
        this.parseVendorExtensions(tokens, properties);
        this.applyVendorExtensions(nodeType, properties);
        nodeType.getPropertyDefinitionTemplates().add(propDefn);
    }

    protected void parsePropertyType(TokenStream tokens, JcrPropertyDefinitionTemplate propDefn, String defaultPropertyType) {
        if (tokens.canConsume('(')) {
            String propertyType = defaultPropertyType;
            if (tokens.matchesAnyOf(this.VALID_PROPERTY_TYPES) && "*".equals(propertyType = tokens.consume())) {
                propertyType = "UNDEFINED";
            }
            tokens.consume(')');
            PropertyType type = PropertyType.valueFor(propertyType.toLowerCase());
            int jcrType = PropertyTypeUtil.jcrPropertyTypeFor(type);
            propDefn.setRequiredType(jcrType);
        }
    }

    protected void parseDefaultValues(TokenStream tokens, JcrPropertyDefinitionTemplate propDefn) {
        List<String> defaultValues;
        if (tokens.canConsume('=') && !(defaultValues = this.parseStringList(tokens)).isEmpty()) {
            propDefn.setDefaultValues(this.values(defaultValues));
        }
    }

    protected void parseValueConstraints(TokenStream tokens, JcrPropertyDefinitionTemplate propDefn) {
        List<String> defaultValues;
        if (tokens.canConsume('<') && !(defaultValues = this.parseStringList(tokens)).isEmpty()) {
            propDefn.setValueConstraints(this.strings(defaultValues));
        }
    }

    protected void parsePropertyAttributes(TokenStream tokens, JcrPropertyDefinitionTemplate propDefn, JcrNodeTypeTemplate nodeType) throws ConstraintViolationException {
        boolean autoCreated = false;
        boolean mandatory = false;
        boolean isProtected = false;
        boolean multiple = false;
        boolean isFullTextSearchable = true;
        boolean isQueryOrderable = true;
        String onParentVersion = "COPY";
        while (true) {
            if (tokens.canConsumeAnyOf("AUTOCREATED", new String[]{"AUT", "A"})) {
                tokens.canConsume('?');
                autoCreated = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("MANDATORY", new String[]{"MAN", "M"})) {
                tokens.canConsume('?');
                mandatory = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("PROTECTED", new String[]{"PRO", "P"})) {
                tokens.canConsume('?');
                isProtected = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("MULTIPLE", new String[]{"MUL", "*"})) {
                tokens.canConsume('?');
                multiple = true;
                continue;
            }
            if (tokens.matchesAnyOf(this.VALID_ON_PARENT_VERSION)) {
                onParentVersion = tokens.consume();
                tokens.canConsume('?');
                continue;
            }
            if (tokens.matches("OPV")) {
                onParentVersion = tokens.consume();
                tokens.canConsume('?');
                continue;
            }
            if (tokens.canConsumeAnyOf("NOFULLTEXT", new String[]{"NOF"})) {
                tokens.canConsume('?');
                isFullTextSearchable = false;
                continue;
            }
            if (tokens.canConsumeAnyOf("NOQUERYORDER", new String[]{"NQORD"})) {
                tokens.canConsume('?');
                isQueryOrderable = false;
                continue;
            }
            if (tokens.canConsumeAnyOf("QUERYOPS", new String[]{"QOP"})) {
                this.parseQueryOperators(tokens, propDefn);
                continue;
            }
            if (tokens.canConsumeAnyOf("PRIMARY", new String[]{"PRI", "!"})) {
                if (!this.jcr170) {
                    Position pos = tokens.previousPosition();
                    int line = pos.getLine();
                    int column = pos.getColumn();
                    throw new ParsingException(tokens.previousPosition(), CndI18n.primaryKeywordNotValidInJcr2CndFormat.text(new Object[]{line, column}));
                }
                nodeType.setPrimaryItemName(propDefn.getName());
                continue;
            }
            if (!tokens.matches(7)) break;
            LinkedList<Property> properties = new LinkedList<Property>();
            this.parseVendorExtensions(tokens, properties);
            this.applyVendorExtensions(propDefn, properties);
        }
        propDefn.setAutoCreated(autoCreated);
        propDefn.setMandatory(mandatory);
        propDefn.setProtected(isProtected);
        propDefn.setOnParentVersion(OnParentVersionAction.valueFromName((String)onParentVersion.toUpperCase()));
        propDefn.setMultiple(multiple);
        propDefn.setFullTextSearchable(isFullTextSearchable);
        propDefn.setQueryOrderable(isQueryOrderable);
    }

    protected void parseQueryOperators(TokenStream tokens, JcrPropertyDefinitionTemplate propDefn) {
        if (tokens.canConsume('?')) {
            return;
        }
        ArrayList<String> operators = new ArrayList<String>();
        String operatorList = this.removeQuotes(tokens.consume());
        for (String operatorValue : operatorList.split(",")) {
            String operator = operatorValue.trim();
            if (!this.VALID_QUERY_OPERATORS.contains(operator)) {
                throw new ParsingException(tokens.previousPosition(), CndI18n.expectedValidQueryOperator.text(new Object[]{operator}));
            }
            operators.add(operator);
        }
        if (operators.isEmpty()) {
            operators.addAll(this.VALID_QUERY_OPERATORS);
        }
        propDefn.setAvailableQueryOperators(this.strings(operators));
    }

    protected void parseChildNodeDefinition(TokenStream tokens, JcrNodeTypeTemplate nodeType) throws ConstraintViolationException {
        tokens.consume('+');
        Name name = this.parseName(tokens);
        JcrNodeDefinitionTemplate childDefn = new JcrNodeDefinitionTemplate(this.context);
        childDefn.setName(this.string(name));
        this.parseRequiredPrimaryTypes(tokens, childDefn);
        this.parseDefaultType(tokens, childDefn);
        this.parseNodeAttributes(tokens, childDefn, nodeType);
        nodeType.getNodeDefinitionTemplates().add(childDefn);
    }

    protected void parseRequiredPrimaryTypes(TokenStream tokens, JcrNodeDefinitionTemplate childDefn) throws ConstraintViolationException {
        if (tokens.canConsume('(')) {
            List<Name> requiredTypes = this.parseNameList(tokens);
            if (requiredTypes.isEmpty()) {
                requiredTypes.add(JcrNtLexicon.BASE);
            }
            childDefn.setRequiredPrimaryTypeNames(this.names(requiredTypes));
            tokens.consume(')');
        }
    }

    protected void parseDefaultType(TokenStream tokens, JcrNodeDefinitionTemplate childDefn) throws ConstraintViolationException {
        if (tokens.canConsume('=') && !tokens.canConsume('?')) {
            Name defaultType = this.parseName(tokens);
            childDefn.setDefaultPrimaryTypeName(this.string(defaultType));
        }
    }

    protected void parseNodeAttributes(TokenStream tokens, JcrNodeDefinitionTemplate childDefn, JcrNodeTypeTemplate nodeType) throws ConstraintViolationException {
        boolean autoCreated = false;
        boolean mandatory = false;
        boolean isProtected = false;
        boolean sns = false;
        String onParentVersion = "COPY";
        while (true) {
            if (tokens.canConsumeAnyOf("AUTOCREATED", new String[]{"AUT", "A"})) {
                tokens.canConsume('?');
                autoCreated = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("MANDATORY", new String[]{"MAN", "M"})) {
                tokens.canConsume('?');
                mandatory = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("PROTECTED", new String[]{"PRO", "P"})) {
                tokens.canConsume('?');
                isProtected = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("SNS", new String[]{"*"})) {
                tokens.canConsume('?');
                sns = true;
                continue;
            }
            if (tokens.canConsumeAnyOf("MULTIPLE", new String[]{"MUL", "*"})) {
                if (!this.jcr170) {
                    Position pos = tokens.previousPosition();
                    int line = pos.getLine();
                    int column = pos.getColumn();
                    throw new ParsingException(tokens.previousPosition(), CndI18n.multipleKeywordNotValidInJcr2CndFormat.text(new Object[]{line, column}));
                }
                tokens.canConsume('?');
                sns = true;
                continue;
            }
            if (tokens.matchesAnyOf(this.VALID_ON_PARENT_VERSION)) {
                onParentVersion = tokens.consume();
                tokens.canConsume('?');
                continue;
            }
            if (tokens.matches("OPV")) {
                onParentVersion = tokens.consume();
                tokens.canConsume('?');
                continue;
            }
            if (tokens.canConsumeAnyOf("PRIMARYITEM", new String[]{"PRIMARY", "PRI", "!"})) {
                nodeType.setPrimaryItemName(childDefn.getName());
                continue;
            }
            if (!tokens.matches(7)) break;
            LinkedList<Property> properties = new LinkedList<Property>();
            this.parseVendorExtensions(tokens, properties);
            this.applyVendorExtensions(childDefn, properties);
        }
        childDefn.setAutoCreated(autoCreated);
        childDefn.setMandatory(mandatory);
        childDefn.setProtected(isProtected);
        childDefn.setOnParentVersion(OnParentVersionAction.valueFromName((String)onParentVersion.toUpperCase()));
        childDefn.setSameNameSiblings(sns);
    }

    protected Name parseName(TokenStream tokens) {
        String value = tokens.consume();
        try {
            return (Name)this.nameFactory.create(this.removeQuotes(value));
        }
        catch (ValueFormatException e) {
            throw new ParsingException(tokens.previousPosition(), CndI18n.expectedValidNameLiteral.text(new Object[]{value}));
        }
    }

    protected final String removeQuotes(String text) {
        return text.replaceFirst("^['\"]+", "").replaceAll("['\"]+$", "");
    }

    protected final void parseVendorExtensions(TokenStream tokens, List<Property> properties) {
        while (tokens.matches(7)) {
            Property extension = this.parseVendorExtension(tokens.consume());
            if (extension == null) continue;
            properties.add(extension);
        }
    }

    protected final Property parseVendorExtension(String vendorExtension) {
        if (vendorExtension == null) {
            return null;
        }
        String extension = vendorExtension.replaceFirst("^[{]", "").replaceAll("[}]$", "");
        if (extension.trim().length() == 0) {
            return null;
        }
        return this.parseVendorExtensionContent(extension);
    }

    protected final Property parseVendorExtensionContent(String vendorExtension) {
        Matcher matcher = this.VENDOR_PATTERN.matcher(vendorExtension);
        if (!matcher.find()) {
            return null;
        }
        String vendorName = this.removeQuotes(matcher.group(1));
        String vendorValue = this.removeQuotes(matcher.group(3));
        assert (vendorName != null);
        assert (vendorValue != null);
        assert (vendorName.length() != 0);
        assert (vendorValue.length() != 0);
        return this.context.getPropertyFactory().create((Name)this.nameFactory.create(vendorName), vendorValue);
    }

    protected void applyVendorExtensions(JcrNodeTypeTemplate nodeType, List<Property> extensions) {
    }

    protected void applyVendorExtensions(JcrNodeDefinitionTemplate childDefn, List<Property> extensions) {
    }

    protected void applyVendorExtensions(JcrPropertyDefinitionTemplate propDefn, List<Property> extensions) {
    }

    protected final String string(Object name) {
        return this.stringFactory.create(name);
    }

    protected final String[] names(Collection<Name> names) {
        String[] result = new String[names.size()];
        int i = 0;
        for (Name name : names) {
            result[i++] = this.string(name);
        }
        return result;
    }

    protected final String[] strings(Collection<String> values) {
        String[] result = new String[values.size()];
        int i = 0;
        for (String value : values) {
            result[i++] = value;
        }
        return result;
    }

    protected final Value[] values(Collection<String> values) {
        Value[] result = new Value[values.size()];
        int i = 0;
        for (String value : values) {
            result[i++] = this.valueFactory.createValue(value);
        }
        return result;
    }
}

