/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.binary;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStoreException;

public class Database {
    protected final Connection connection;
    private String prefix;
    protected Type databaseType;
    private SQLBuilder sqlBuilder = new SQLBuilder();
    private SQLType sqlType = new SQLType();

    public Database(Connection connection) throws BinaryStoreException {
        this.connection = connection;
        this.databaseType = this.determineType();
    }

    public Type getDatabaseType() {
        return this.databaseType;
    }

    protected void setDatabaseType(Type databaseType) {
        this.databaseType = databaseType;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private String tableName() {
        return StringUtil.isBlank((String)this.prefix) ? "CONTENT_STORE" : this.prefix + "_CONTENT_STORE";
    }

    private long now() {
        return new Date().getTime();
    }

    public PreparedStatement insertContentSQL(BinaryKey key, InputStream stream) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.sqlBuilder.insert().into(this.tableName()).columns("cid", "usage_time", "payload", "usage").values("?", "?", "?", "1").build();
            sql.setString(1, key.toString());
            sql.setTimestamp(2, new Timestamp(this.now()));
            sql.setBinaryStream(3, stream);
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement retrieveContentSQL(BinaryKey key, boolean inUse) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.sqlBuilder.select().columns("payload").from(this.tableName()).where().condition("cid", this.sqlType.integer(), "=", "?").and().condition("usage", this.sqlType.integer(), "=", "?").build();
            sql.setString(1, key.toString());
            if (inUse) {
                sql.setInt(2, 1);
            } else {
                sql.setInt(2, 0);
            }
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement markUnusedSQL(BinaryKey key) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.sqlBuilder.update(this.tableName()).set("usage", "?").set("usage_time", "?").where().condition("cid", this.sqlType.integer(), "=", "?").build();
            sql.setInt(1, 0);
            sql.setTimestamp(2, new Timestamp(this.now()));
            sql.setString(3, key.toString());
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement restoreContentSQL(BinaryKey key) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.sqlBuilder.update(this.tableName()).set("usage", "?").where().condition("cid", this.sqlType.integer(), "=", "?").build();
            sql.setInt(1, 1);
            sql.setString(2, key.toString());
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement removeExpiredContentSQL(long deadline) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.sqlBuilder.delete().from(this.tableName()).where().condition("usage_time", this.sqlType.timestamp(), "<", "?").build();
            sql.setTimestamp(1, new Timestamp(deadline));
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement retrieveMimeTypeSQL(BinaryKey key) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.sqlBuilder.select().columns("mime_type").from(this.tableName()).where().condition("cid", this.sqlType.integer(), "=", "?").build();
            sql.setString(1, key.toString());
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement updateMimeTypeSQL(BinaryKey key, String mimeType) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.sqlBuilder.update(this.tableName()).set("mime_type", "?").where().condition("cid", this.sqlType.integer(), "=", "?").build();
            sql.setString(1, mimeType);
            sql.setString(2, key.toString());
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement retrieveExtTextSQL(BinaryKey key) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.sqlBuilder.select().columns("ext_text").from(this.tableName()).where().condition("cid", this.sqlType.integer(), "=", "?").build();
            sql.setString(1, key.toString());
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement updateExtTextSQL(BinaryKey key, String text) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.sqlBuilder.update(this.tableName()).set("ext_text", "?").where().condition("cid", this.sqlType.integer(), "=", "?").build();
            sql.setString(1, text);
            sql.setString(2, key.toString());
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public PreparedStatement retrieveBinaryKeys(Set<BinaryKey> keys) throws BinaryStoreException {
        try {
            PreparedStatement sql = this.sqlBuilder.select().columns("cid").from(this.tableName()).where().condition("usage", this.sqlType.integer(), "=", "1").build();
            return sql;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public static void execute(PreparedStatement sql) throws BinaryStoreException {
        try {
            sql.execute();
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public static ResultSet executeQuery(PreparedStatement sql) throws BinaryStoreException {
        try {
            return sql.executeQuery();
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public static void executeUpdate(PreparedStatement sql) throws BinaryStoreException {
        try {
            sql.executeUpdate();
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public static InputStream asStream(ResultSet rs) throws BinaryStoreException {
        try {
            boolean hasRaw = rs.first();
            if (!hasRaw) {
                return null;
            }
            return rs.getBinaryStream(1);
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public static String asString(ResultSet rs) throws BinaryStoreException {
        try {
            boolean hasRaw = rs.first();
            if (!hasRaw) {
                return null;
            }
            return rs.getString(1);
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public static List<String> asStringList(ResultSet rs) throws BinaryStoreException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
        return result;
    }

    public boolean tableExists() throws BinaryStoreException {
        try {
            PreparedStatement sql = this.connection.prepareStatement("select count(*) from " + this.tableName());
            Database.execute(sql);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public void createTable() throws BinaryStoreException {
        try {
            PreparedStatement sql = this.connection.prepareStatement("create table " + this.tableName() + " (" + "cid " + this.sqlType.varchar(255) + " not null," + "mime_type " + this.sqlType.varchar(255) + ", " + "ext_text " + this.sqlType.varchar(1000) + "," + "usage " + this.sqlType.integer() + "," + "usage_time " + this.sqlType.timestamp() + "," + "payload " + this.sqlType.blob() + "," + "primary key(cid))");
            Database.execute(sql);
        }
        catch (Exception e) {
            throw new BinaryStoreException(e);
        }
    }

    private Type determineType() throws BinaryStoreException {
        if (this.connection == null) {
            return Type.UNKNOWN;
        }
        try {
            String name = this.connection.getMetaData().getDatabaseProductName().toLowerCase();
            if (name.toLowerCase().contains("mysql")) {
                return Type.MYSQL;
            }
            if (name.contains("postgres")) {
                return Type.POSTGRES;
            }
            if (name.contains("derby")) {
                return Type.DERBY;
            }
            if (name.contains("hsql") || name.toLowerCase().contains("hypersonic")) {
                return Type.HSQL;
            }
            if (name.contains("h2")) {
                return Type.H2;
            }
            if (name.contains("sqlite")) {
                return Type.SQLITE;
            }
            if (name.contains("db2")) {
                return Type.DB2;
            }
            if (name.contains("informix")) {
                return Type.INFORMIX;
            }
            if (name.contains("interbase")) {
                return Type.INTERBASE;
            }
            if (name.contains("firebird")) {
                return Type.FIREBIRD;
            }
            if (name.contains("sqlserver") || name.toLowerCase().contains("microsoft")) {
                return Type.SQL_SERVER;
            }
            if (name.contains("access")) {
                return Type.ACCESS;
            }
            if (name.contains("oracle")) {
                return Type.ORACLE;
            }
            if (name.contains("adaptive")) {
                return Type.SYBASE;
            }
            return Type.UNKNOWN;
        }
        catch (SQLException e) {
            throw new BinaryStoreException(e);
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public class SQLBuilder {
        private boolean set = false;
        private StringBuilder sql;

        public PreparedStatement build() throws SQLException {
            return Database.this.connection.prepareStatement(this.sql.toString());
        }

        public String getSQL() {
            return this.sql.toString();
        }

        public SQLBuilder insert() {
            this.set = false;
            this.sql = new StringBuilder();
            this.sql.append("INSERT ");
            return this;
        }

        public SQLBuilder select() {
            this.set = false;
            this.sql = new StringBuilder();
            this.sql.append("SELECT ");
            return this;
        }

        public SQLBuilder delete() {
            this.set = false;
            this.sql = new StringBuilder();
            this.sql.append("DELETE ");
            return this;
        }

        public SQLBuilder update(String tableName) {
            this.set = false;
            this.sql = new StringBuilder();
            this.sql.append("UPDATE ");
            this.sql.append(tableName);
            return this;
        }

        public SQLBuilder set(String col, String val) {
            if (!this.set) {
                this.sql.append(" SET ");
                this.set = true;
            } else {
                this.sql.append(", ");
            }
            this.sql.append(col);
            this.sql.append("=");
            this.sql.append(val);
            return this;
        }

        public SQLBuilder into(String tableName) {
            this.sql.append("INTO ");
            this.sql.append(tableName);
            this.sql.append(" (");
            return this;
        }

        public SQLBuilder columns(String ... columns) {
            this.sql.append(columns[0]);
            for (int i = 1; i < columns.length; ++i) {
                this.sql.append(", ");
                this.sql.append(columns[i]);
            }
            return this;
        }

        public SQLBuilder values(String ... columns) {
            this.sql.append(") VALUES (");
            this.sql.append(columns[0]);
            for (int i = 1; i < columns.length; ++i) {
                this.sql.append(", ");
                this.sql.append(columns[i]);
            }
            this.sql.append(")");
            return this;
        }

        public SQLBuilder from(String tableName) {
            this.sql.append(" FROM ");
            this.sql.append(tableName);
            return this;
        }

        public SQLBuilder where() {
            this.sql.append(" WHERE ");
            return this;
        }

        public SQLBuilder and() {
            this.sql.append(" AND ");
            return this;
        }

        public SQLBuilder condition(String column, String colType, String sign, String value) {
            this.sql.append(column);
            this.sql.append(sign);
            switch (Database.this.databaseType) {
                case SYBASE: {
                    this.sql.append("convert(");
                    this.sql.append(colType);
                    this.sql.append(",");
                    this.sql.append(value);
                    this.sql.append(")");
                    break;
                }
                case POSTGRES: {
                    this.sql.append("cast(");
                    this.sql.append(value);
                    this.sql.append(" as ");
                    this.sql.append(colType);
                    this.sql.append(")");
                    break;
                }
                default: {
                    this.sql.append(value);
                }
            }
            return this;
        }
    }

    private class SQLType {
        protected SQLType() {
        }

        public String integer() {
            return "INTEGER";
        }

        public String timestamp() {
            return "TIMESTAMP";
        }

        protected String blob() {
            switch (Database.this.databaseType) {
                case SQL_SERVER: 
                case SYBASE: {
                    return "IMAGE";
                }
                case HSQL: {
                    return "OBJECT";
                }
            }
            return "BLOB";
        }

        protected String varchar(int size) {
            switch (Database.this.databaseType) {
                case ORACLE: {
                    return "VARCHAR2(" + size + ")";
                }
            }
            return "VARCHAR(" + size + ")";
        }
    }

    public static enum Type {
        MYSQL,
        POSTGRES,
        DERBY,
        HSQL,
        H2,
        SQLITE,
        DB2,
        DB2_390,
        INFORMIX,
        INTERBASE,
        FIREBIRD,
        SQL_SERVER,
        ACCESS,
        ORACLE,
        SYBASE,
        UNKNOWN;

    }
}

