/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.mimetype;

import java.io.IOException;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.mimetype.MimeTypeDetector;
import org.modeshape.jcr.mimetype.NullMimeTypeDetector;
import org.modeshape.jcr.mimetype.TikaMimeTypeDetector;

@ThreadSafe
public final class MimeTypeDetectors
implements MimeTypeDetector {
    private static final Logger LOGGER = Logger.getLogger(MimeTypeDetectors.class);
    private final MimeTypeDetector delegate;

    public MimeTypeDetectors() {
        this(null);
    }

    public MimeTypeDetectors(Environment environment) {
        ClassLoader defaultLoader = this.getClass().getClassLoader();
        ClassLoader classLoader = environment != null ? environment.getClassLoader(defaultLoader, "org.modeshape.extractor.tika") : defaultLoader;
        MimeTypeDetector delegate = null;
        try {
            delegate = new TikaMimeTypeDetector(classLoader);
        }
        catch (Throwable e) {
            delegate = NullMimeTypeDetector.INSTANCE;
            LOGGER.warn((I18nResource)JcrI18n.noMimeTypeDetectorsFound, new Object[0]);
        }
        this.delegate = delegate;
    }

    @Override
    public String mimeTypeOf(String name, Binary binaryValue) throws RepositoryException, IOException {
        String mime = this.delegate.mimeTypeOf(name, binaryValue);
        LOGGER.trace("MIME type for '" + name + "' ==> " + mime, new Object[0]);
        return mime;
    }
}

