/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.basic.JodaDateTime;

@Immutable
public class IndexRules {
    public static final IndexRules DEFAULT_RULES;
    protected static final Factory DEFAULT_RULES_FACTORY;
    public static final Rule SKIP;
    private final Map<Name, Rule> rulesByName;
    private final Rule defaultRule;

    protected IndexRules(Map<Name, Rule> rulesByName, Rule defaultRule) {
        this.rulesByName = rulesByName;
        Rule rule = this.defaultRule = defaultRule != null ? defaultRule : SKIP;
        assert (this.defaultRule != null);
    }

    public Rule getRule(Name name) {
        Rule result = this.rulesByName.get(name);
        return result != null ? result : this.defaultRule;
    }

    public static Builder createBuilder() {
        return new Builder(new HashMap<Name, Rule>(), null);
    }

    public static Builder createBuilder(IndexRules initialRules) {
        CheckArg.isNotNull((Object)initialRules, (String)"initialRules");
        return new Builder(new HashMap<Name, Rule>(initialRules.rulesByName), initialRules.defaultRule);
    }

    static {
        DEFAULT_RULES_FACTORY = new Factory(){

            @Override
            public IndexRules getRules() {
                return DEFAULT_RULES;
            }
        };
        long earliestChangeDate = new JodaDateTime(2009, 11, 1, 0, 0, 0, 0).getMilliseconds();
        Builder builder = IndexRules.createBuilder();
        builder.defaultTo(Field.Store.NO, Field.Index.ANALYZED, true, true);
        builder.stringField(JcrLexicon.UUID, Field.Store.NO, Field.Index.NOT_ANALYZED, false, false);
        builder.dateField(JcrLexicon.CREATED, Field.Store.NO, Field.Index.NOT_ANALYZED, earliestChangeDate);
        builder.dateField(JcrLexicon.LAST_MODIFIED, Field.Store.NO, Field.Index.NOT_ANALYZED, earliestChangeDate);
        DEFAULT_RULES = builder.build();
        SKIP = new SkipRule();
    }

    @NotThreadSafe
    public static class Builder {
        private final Map<Name, Rule> rulesByName;
        private Rule defaultRule;

        Builder(Map<Name, Rule> rulesByName, Rule defaultRule) {
            assert (rulesByName != null);
            this.rulesByName = rulesByName;
            this.defaultRule = defaultRule;
        }

        public Builder skip(Name ... namesToIndex) {
            if (namesToIndex != null) {
                for (Name name : namesToIndex) {
                    this.rulesByName.put(name, SKIP);
                }
            }
            return this;
        }

        public Builder defaultTo(Field.Store store, Field.Index index, boolean canBeReference, boolean fullTextSearchable) {
            if (store == null) {
                store = Field.Store.YES;
            }
            if (index == null) {
                index = Field.Index.NOT_ANALYZED;
            }
            this.defaultRule = new TypedRule(FieldType.STRING, store, index, canBeReference, fullTextSearchable);
            return this;
        }

        public Builder stringField(Name name, Field.Store store, Field.Index index, boolean canBeReference, boolean fullTextSearchable) {
            if (store == null) {
                store = Field.Store.YES;
            }
            if (index == null) {
                index = Field.Index.NOT_ANALYZED;
            }
            TypedRule rule = new TypedRule(FieldType.STRING, store, index, canBeReference, fullTextSearchable);
            this.rulesByName.put(name, rule);
            return this;
        }

        public Builder binaryField(Name name, Field.Store store, Field.Index index, boolean fullTextSearchable) {
            if (store == null) {
                store = Field.Store.YES;
            }
            if (index == null) {
                index = Field.Index.NOT_ANALYZED;
            }
            TypedRule rule = new TypedRule(FieldType.BINARY, store, index, false, fullTextSearchable);
            this.rulesByName.put(name, rule);
            return this;
        }

        public Builder pathField(Name name, Field.Store store, Field.Index index) {
            if (store == null) {
                store = Field.Store.YES;
            }
            if (index == null) {
                index = Field.Index.NOT_ANALYZED;
            }
            TypedRule rule = new TypedRule(FieldType.STRING, store, index, false, false);
            this.rulesByName.put(name, rule);
            return this;
        }

        public Builder referenceField(Name name, Field.Store store, Field.Index index) {
            if (store == null) {
                store = Field.Store.YES;
            }
            if (index == null) {
                index = Field.Index.NOT_ANALYZED;
            }
            TypedRule rule = new TypedRule(FieldType.REFERENCE, store, index, true, false);
            this.rulesByName.put(name, rule);
            return this;
        }

        public Builder weakReferenceField(Name name, Field.Store store, Field.Index index, boolean fullTextSearchable) {
            if (store == null) {
                store = Field.Store.YES;
            }
            if (index == null) {
                index = Field.Index.NOT_ANALYZED;
            }
            TypedRule rule = new TypedRule(FieldType.WEAK_REFERENCE, store, index, false, fullTextSearchable);
            this.rulesByName.put(name, rule);
            return this;
        }

        protected <T> Builder numericField(Name name, FieldType type, Field.Store store, Field.Index index, T minValue, T maxValue) {
            if (store == null) {
                store = Field.Store.YES;
            }
            if (index == null) {
                index = Field.Index.NOT_ANALYZED;
            }
            NumericTypedRule<T> rule = new NumericTypedRule<T>(type, store, index, minValue, maxValue);
            this.rulesByName.put(name, rule);
            return this;
        }

        public Builder booleanField(Name name, Field.Store store, Field.Index index) {
            return this.numericField(name, FieldType.BOOLEAN, store, index, Boolean.FALSE, Boolean.TRUE);
        }

        public Builder integerField(Name name, Field.Store store, Field.Index index, Integer minValue, Integer maxValue) {
            if (minValue == null) {
                minValue = Integer.MIN_VALUE;
            }
            if (maxValue == null) {
                maxValue = Integer.MAX_VALUE;
            }
            return this.numericField(name, FieldType.INT, store, index, minValue, maxValue);
        }

        public Builder longField(Name name, Field.Store store, Field.Index index, Long minValue, Long maxValue) {
            if (minValue == null) {
                minValue = Long.MIN_VALUE;
            }
            if (maxValue == null) {
                maxValue = Long.MAX_VALUE;
            }
            return this.numericField(name, FieldType.LONG, store, index, minValue, maxValue);
        }

        public Builder decimalField(Name name, Field.Store store, Field.Index index, BigDecimal minValue, BigDecimal maxValue) {
            if (store == null) {
                store = Field.Store.YES;
            }
            if (index == null) {
                index = Field.Index.NOT_ANALYZED;
            }
            TypedRule rule = new TypedRule(FieldType.STRING, store, index, false, false);
            this.rulesByName.put(name, rule);
            return this;
        }

        public Builder dateField(Name name, Field.Store store, Field.Index index, Long minValue, Long maxValue) {
            if (minValue == null) {
                minValue = 0L;
            }
            if (maxValue == null) {
                maxValue = Long.MAX_VALUE;
            }
            return this.numericField(name, FieldType.DATE, store, index, minValue, maxValue);
        }

        public Builder floatField(Name name, Field.Store store, Field.Index index, Float minValue, Float maxValue) {
            if (minValue == null) {
                minValue = Float.valueOf(Float.MIN_VALUE);
            }
            if (maxValue == null) {
                maxValue = Float.valueOf(Float.MAX_VALUE);
            }
            return this.numericField(name, FieldType.FLOAT, store, index, minValue, maxValue);
        }

        public Builder doubleField(Name name, Field.Store store, Field.Index index, Double minValue, Double maxValue) {
            if (minValue == null) {
                minValue = Double.MIN_VALUE;
            }
            if (maxValue == null) {
                maxValue = Double.MAX_VALUE;
            }
            return this.numericField(name, FieldType.DOUBLE, store, index, minValue, maxValue);
        }

        public Builder integerField(Name name, Field.Store store, Field.Index index, Integer minValue) {
            return this.integerField(name, store, index, minValue, null);
        }

        public Builder longField(Name name, Field.Store store, Field.Index index, Long minValue) {
            return this.longField(name, store, index, minValue, null);
        }

        public Builder dateField(Name name, Field.Store store, Field.Index index, Long minValue) {
            return this.dateField(name, store, index, minValue, null);
        }

        public Builder floatField(Name name, Field.Store store, Field.Index index, Float minValue) {
            return this.floatField(name, store, index, minValue, null);
        }

        public Builder doubleField(Name name, Field.Store store, Field.Index index, Double minValue) {
            return this.doubleField(name, store, index, minValue, null);
        }

        public Builder integerField(Name name, Field.Store store, Field.Index index) {
            return this.integerField(name, store, index, null, null);
        }

        public Builder longField(Name name, Field.Store store, Field.Index index) {
            return this.longField(name, store, index, null, null);
        }

        public Builder dateField(Name name, Field.Store store, Field.Index index) {
            return this.dateField(name, store, index, null, null);
        }

        public Builder floatField(Name name, Field.Store store, Field.Index index) {
            return this.floatField(name, store, index, null, null);
        }

        public Builder doubleField(Name name, Field.Store store, Field.Index index) {
            return this.doubleField(name, store, index, null, null);
        }

        public IndexRules build() {
            return new IndexRules(Collections.unmodifiableMap(new HashMap<Name, Rule>(this.rulesByName)), this.defaultRule);
        }
    }

    @Immutable
    protected static class NumericTypedRule<T>
    extends TypedRule
    implements NumericRule<T> {
        protected final T minValue;
        protected final T maxValue;

        protected NumericTypedRule(FieldType type, Field.Store store, Field.Index index, T minValue, T maxValue) {
            super(type, store, index, false, false);
            this.minValue = minValue;
            this.maxValue = maxValue;
            assert (this.minValue != null);
            assert (this.maxValue != null);
        }

        @Override
        public T getMaximum() {
            return this.maxValue;
        }

        @Override
        public T getMinimum() {
            return this.minValue;
        }

        @Override
        public String toString() {
            return super.toString() + " with range [" + this.minValue + "," + this.maxValue + "]";
        }
    }

    @Immutable
    protected static class TypedRule
    implements Rule {
        protected final boolean canBeReference;
        protected final boolean fullTextSearchable;
        protected final FieldType type;
        protected final Field.Store store;
        protected final Field.Index index;

        protected TypedRule(FieldType type, Field.Store store, Field.Index index, boolean canBeReference, boolean fullTextSearchable) {
            this.type = type;
            this.index = index;
            this.store = store;
            this.canBeReference = canBeReference;
            this.fullTextSearchable = fullTextSearchable;
            assert (this.type != null);
            assert (this.index != null);
            assert (this.store != null);
        }

        @Override
        public FieldType getType() {
            return this.type;
        }

        @Override
        public boolean isSkipped() {
            return false;
        }

        @Override
        public boolean isFullTextSearchable() {
            return this.fullTextSearchable;
        }

        @Override
        public boolean canBeReference() {
            return this.canBeReference;
        }

        @Override
        public Field.Index getIndexOption() {
            return this.index;
        }

        @Override
        public Field.Store getStoreOption() {
            return this.store;
        }

        public String toString() {
            return this.type.name() + " rule (" + this.store + "," + this.index + ")";
        }
    }

    @Immutable
    protected static class SkipRule
    implements Rule {
        protected SkipRule() {
        }

        @Override
        public FieldType getType() {
            return FieldType.STRING;
        }

        @Override
        public boolean isSkipped() {
            return true;
        }

        @Override
        public boolean isFullTextSearchable() {
            return false;
        }

        @Override
        public boolean canBeReference() {
            return false;
        }

        @Override
        public Field.Index getIndexOption() {
            return Field.Index.NO;
        }

        @Override
        public Field.Store getStoreOption() {
            return Field.Store.NO;
        }
    }

    @Immutable
    public static interface NumericRule<T>
    extends Rule {
        public T getMinimum();

        public T getMaximum();
    }

    @Immutable
    public static interface Rule {
        public boolean isSkipped();

        public boolean canBeReference();

        public boolean isFullTextSearchable();

        public FieldType getType();

        public Field.Store getStoreOption();

        public Field.Index getIndexOption();
    }

    public static class FixedFactory
    implements Factory {
        private final IndexRules rules;

        public FixedFactory(IndexRules rules) {
            this.rules = rules;
        }

        @Override
        public IndexRules getRules() {
            return this.rules;
        }
    }

    public static interface Factory {
        public IndexRules getRules();
    }

    public static enum FieldType {
        STRING,
        DOUBLE,
        FLOAT,
        INT,
        BOOLEAN,
        LONG,
        DATE,
        BINARY,
        REFERENCE,
        WEAK_REFERENCE,
        DECIMAL;

    }
}

