/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.basic.BasicPathSegment;

@Immutable
public class IdentifierPathSegment
extends BasicPathSegment {
    private static final long serialVersionUID = 1L;

    public IdentifierPathSegment(Name name) {
        super(name);
    }

    @Override
    public boolean isIdentifier() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path.Segment) {
            Path.Segment that = (Path.Segment)obj;
            if (!this.getName().equals(that.getName())) {
                return false;
            }
            return Math.abs(this.getIndex()) == Math.abs(that.getIndex());
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.hasIndex()) {
            return this.getName().toString() + "[" + this.getIndex() + "]";
        }
        return this.getName().toString();
    }

    @Override
    public String getString(TextEncoder encoder) {
        if (encoder == null) {
            encoder = Path.DEFAULT_ENCODER;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getName().getString(encoder)).append(']');
        return sb.toString();
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder, TextEncoder delimiterEncoder) {
        if (encoder == null) {
            encoder = Path.DEFAULT_ENCODER;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getName().getString(namespaceRegistry, encoder, delimiterEncoder)).append(']');
        return sb.toString();
    }
}

