/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.BinaryValueUnused;
import org.modeshape.jcr.cache.change.BinaryValueUsed;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.value.BinaryKey;

@ThreadSafe
public class BackupObserver
implements ChangeSetListener {
    private final Queue<NodeKey> changedNodes;
    private final Map<BinaryKey, Object> usedBinaryKeys = new ConcurrentHashMap<BinaryKey, Object>();
    private final Map<BinaryKey, Object> unusedBinaryKeys = new ConcurrentHashMap<BinaryKey, Object>();

    protected BackupObserver(Queue<NodeKey> changedNodes) {
        this.changedNodes = changedNodes;
    }

    @Override
    public void notify(ChangeSet changeSet) {
        if (changeSet == null) {
            return;
        }
        this.changedNodes.addAll(changeSet.changedNodes());
        for (Change change : changeSet) {
            BinaryKey key;
            if (change instanceof BinaryValueUnused) {
                BinaryValueUnused unused = (BinaryValueUnused)change;
                key = unused.getKey();
                if (this.usedBinaryKeys.containsKey(key)) {
                    this.usedBinaryKeys.remove(key);
                    break;
                }
                this.unusedBinaryKeys.put(key, null);
                continue;
            }
            if (!(change instanceof BinaryValueUsed)) continue;
            BinaryValueUsed used = (BinaryValueUsed)change;
            key = used.getKey();
            if (this.unusedBinaryKeys.containsKey(key)) {
                this.unusedBinaryKeys.remove(key);
                break;
            }
            this.usedBinaryKeys.put(key, null);
        }
    }

    public Iterable<BinaryKey> getUnusedBinaryKeys() {
        return this.unusedBinaryKeys.keySet();
    }

    public Iterable<BinaryKey> getUsedBinaryKeys() {
        return this.usedBinaryKeys.keySet();
    }
}

