/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.SessionEnvironment;
import org.modeshape.jcr.cache.document.DocumentCache;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.NodeCacheIterator;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.ValueFactories;

public abstract class AbstractSessionCache
implements SessionCache,
DocumentCache {
    protected final WorkspaceCache workspaceCache;
    private final NameFactory nameFactory;
    private final PathFactory pathFactory;
    private final Path rootPath;
    private final SessionEnvironment sessionContext;
    private ExecutionContext context;

    protected AbstractSessionCache(ExecutionContext context, WorkspaceCache workspaceCache, SessionEnvironment sessionContext) {
        this.context = context;
        this.workspaceCache = workspaceCache;
        ValueFactories factories = this.context.getValueFactories();
        this.nameFactory = factories.getNameFactory();
        this.pathFactory = factories.getPathFactory();
        this.rootPath = this.pathFactory.createRootPath();
        this.sessionContext = sessionContext;
    }

    @Override
    public final ExecutionContext getContext() {
        return this.context;
    }

    @Override
    public final WorkspaceCache workspaceCache() {
        return this.workspaceCache;
    }

    final DocumentTranslator translator() {
        return this.workspaceCache.translator();
    }

    final ExecutionContext context() {
        return this.context;
    }

    final NameFactory nameFactory() {
        return this.nameFactory;
    }

    final PathFactory pathFactory() {
        return this.pathFactory;
    }

    final Path rootPath() {
        return this.rootPath;
    }

    final SessionEnvironment sessionContext() {
        return this.sessionContext;
    }

    @Override
    public final void addContextData(String key, String value) {
        this.context = this.context.with(key, value);
    }

    @Override
    public NodeKey createNodeKey() {
        return this.getRootKey().withId(this.generateIdentifier());
    }

    @Override
    public NodeKey createNodeKeyWithIdentifier(String identifier) {
        return this.getRootKey().withId(identifier);
    }

    @Override
    public NodeKey createNodeKeyWithSource(String sourceName) {
        String sourceKey = NodeKey.keyForSourceName(sourceName);
        return this.getRootKey().withSourceKeyAndId(sourceKey, this.generateIdentifier());
    }

    @Override
    public NodeKey createNodeKey(String sourceName, String identifier) {
        String sourceKey = NodeKey.keyForSourceName(sourceName);
        if (identifier == null) {
            identifier = this.generateIdentifier();
        }
        return this.getRootKey().withSourceKeyAndId(sourceKey, identifier);
    }

    protected String generateIdentifier() {
        return UUID.randomUUID().toString();
    }

    @Override
    public NodeKey getRootKey() {
        return this.workspaceCache.getRootKey();
    }

    @Override
    public NodeCache getWorkspace() {
        return this.workspaceCache;
    }

    @Override
    public CachedNode getNode(NodeKey key) {
        return this.workspaceCache.getNode(key);
    }

    @Override
    public CachedNode getNode(ChildReference reference) {
        return this.getNode(reference.getKey());
    }

    @Override
    public Set<NodeKey> getNodeKeysAtAndBelow(NodeKey nodeKey) {
        CachedNode node = this.getNode(nodeKey);
        if (node == null) {
            return Collections.emptySet();
        }
        HashSet<NodeKey> result = new HashSet<NodeKey>();
        result.add(nodeKey);
        for (ChildReference reference : node.getChildReferences(this)) {
            NodeKey childKey = reference.getKey();
            result.addAll(this.getNodeKeysAtAndBelow(childKey));
        }
        return result;
    }

    @Override
    public abstract SessionNode mutable(NodeKey var1);

    @Override
    public Iterator<NodeKey> getAllNodeKeys() {
        return this.getAllNodeKeysAtAndBelow(this.getRootKey());
    }

    @Override
    public Iterator<NodeKey> getAllNodeKeysAtAndBelow(NodeKey startingKey) {
        return new NodeCacheIterator(this, startingKey);
    }

    @Immutable
    protected static final class BasicSaveContext
    implements SessionCache.SaveContext {
        private final DateTime now;
        private final String userId;

        protected BasicSaveContext(ExecutionContext context) {
            this.now = context.getValueFactories().getDateFactory().create();
            this.userId = context.getSecurityContext().getUserName();
        }

        @Override
        public DateTime getTime() {
            return this.now;
        }

        @Override
        public String getUserId() {
            return this.userId;
        }
    }
}

