/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.lucene.util.Version;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.impl.SimpleInitializer;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.ServiceProvider;

public abstract class LuceneSearchConfiguration
implements SearchConfiguration {
    protected static final String HIBERNATE_PROPERTY_PREFIX = "hibernate.search.";
    protected static final String DEFAULT_INDEX = "default.";
    private final Map<String, Class<?>> classes = new HashMap();
    private final Map<String, Class<?>> unmodifiableClasses;
    private final Properties properties = new Properties();
    private final InstanceInitializer initializer = SimpleInitializer.INSTANCE;

    protected LuceneSearchConfiguration(Class<?> ... annotatedAndBridgeClasses) {
        for (Class<?> annotatedAndBridgeClass : annotatedAndBridgeClasses) {
            this.classes.put(annotatedAndBridgeClass.getName(), annotatedAndBridgeClass);
        }
        this.unmodifiableClasses = Collections.unmodifiableMap(this.classes);
    }

    protected void setProperty(String name, String value) {
        if (value != null) {
            this.properties.setProperty(name, value);
        }
    }

    protected void setProperty(String name, String value, String defaultValue) {
        if (value != null) {
            this.properties.setProperty(name, value);
        } else if (defaultValue != null) {
            this.properties.setProperty(name, defaultValue);
        }
    }

    public Version getVersion() {
        Version version = Version.valueOf((String)this.properties.getProperty("hibernate.search.lucene_version"));
        return version != null ? version : Version.LUCENE_CURRENT;
    }

    public Iterator<Class<?>> getClassMappings() {
        return this.unmodifiableClasses.values().iterator();
    }

    public Class<?> getClassMapping(String name) {
        return this.classes.get(name);
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ReflectionManager getReflectionManager() {
        return null;
    }

    public SearchMapping getProgrammaticMapping() {
        return null;
    }

    public Map<Class<? extends ServiceProvider<?>>, Object> getProvidedServices() {
        return Collections.emptyMap();
    }

    public boolean isTransactionManagerExpected() {
        return false;
    }

    public InstanceInitializer getInstanceInitializer() {
        return this.initializer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<Object, Object>> iter = this.properties.entrySet().iterator();
        if (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            sb.append(entry.getKey() + " = " + entry.getValue());
            while (iter.hasNext()) {
                entry = iter.next();
                sb.append("\n");
                sb.append(entry.getKey() + " = " + entry.getValue());
            }
        }
        return sb.toString();
    }
}

