/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.util.ReflectionUtil;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.federation.FederationManager;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.LocalDocumentStore;
import org.modeshape.jcr.federation.spi.Connector;
import org.modeshape.jcr.federation.spi.ExtraPropertiesStore;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;

public class Connectors {
    private final JcrRepository.RunningState repository;
    private final Logger logger;
    private boolean initialized = false;
    private Map<String, Connector> sourceKeyToConnectorMap = new HashMap<String, Connector>();
    private Map<String, List<Projection>> preconfiguredProjections = new HashMap<String, List<Projection>>();
    private Map<String, Projection> projections;
    private Set<String> removedProjections = new HashSet<String>();

    protected Connectors(JcrRepository.RunningState repository, Collection<RepositoryConfiguration.Component> components, Map<String, List<RepositoryConfiguration.Federation.ProjectionConfiguration>> preconfiguredProjections) {
        this.repository = repository;
        this.logger = Logger.getLogger(this.getClass());
        this.registerConnectors(components);
        this.loadPreconfiguredProjections(preconfiguredProjections);
    }

    private void loadPreconfiguredProjections(Map<String, List<RepositoryConfiguration.Federation.ProjectionConfiguration>> preconfiguredProjections) {
        for (String sourceName : preconfiguredProjections.keySet()) {
            for (RepositoryConfiguration.Federation.ProjectionConfiguration projectionCfg : preconfiguredProjections.get(sourceName)) {
                String workspaceName = projectionCfg.getWorkspaceName();
                List<Projection> projections = this.preconfiguredProjections.get(workspaceName);
                if (projections == null) {
                    projections = new ArrayList<Projection>();
                    this.preconfiguredProjections.put(workspaceName, projections);
                }
                projections.add(new Projection(sourceName, projectionCfg.getAlias(), projectionCfg.getRepositoryPath(), projectionCfg.getExternalPath()));
            }
        }
    }

    private void registerConnectors(Collection<RepositoryConfiguration.Component> components) {
        for (RepositoryConfiguration.Component component : components) {
            Connector connector = this.instantiateConnector(component);
            if (connector == null) continue;
            this.registerConnector(connector);
        }
    }

    protected void initialize() throws RepositoryException {
        if (this.initialized || !this.hasConnectors()) {
            return;
        }
        this.initializeConnectors();
        this.loadStoredProjections();
        this.createPreconfiguredProjections();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPreconfiguredProjections() throws RepositoryException {
        for (String workspaceName : this.preconfiguredProjections.keySet()) {
            JcrSession session = this.repository.loginInternalSession(workspaceName);
            try {
                FederationManager federationManager = session.getWorkspace().getFederationManager();
                List<Projection> projections = this.preconfiguredProjections.get(workspaceName);
                for (Projection projection : projections) {
                    AbstractJcrNode node;
                    String repositoryPath = projection.getRepositoryPath();
                    String alias = projection.getAlias();
                    if (this.projectionExists(alias, (node = session.getNode(repositoryPath)).key().toString())) continue;
                    federationManager.createProjection(repositoryPath, projection.getSourceName(), projection.getExternalPath(), alias);
                }
            }
            finally {
                session.logout();
            }
        }
    }

    private boolean projectionExists(String alias, String projectedNodeKey) {
        for (Projection projection : this.projections.values()) {
            if (!projection.hasAlias(alias) || !projection.hasProjectedNodeKey(projectedNodeKey)) continue;
            return true;
        }
        return false;
    }

    private void loadStoredProjections() {
        assert (!this.initialized);
        SessionCache systemSession = this.repository.createSystemSession(this.repository.context(), false);
        CachedNode systemNode = this.getSystemNode(systemSession);
        ChildReference federationNodeRef = systemNode.getChildReferences(systemSession).getChild(ModeShapeLexicon.FEDERATION);
        this.projections = federationNodeRef != null ? this.storedProjections(systemSession, federationNodeRef, Collections.<String>emptySet()) : new HashMap<String, Projection>();
    }

    private Map<String, Projection> storedProjections(SessionCache systemSession, ChildReference federationNodeRef, Set<String> projectionsToRemove) {
        CachedNode federationNode = systemSession.getNode(federationNodeRef.getKey());
        ChildReferences federationChildRefs = federationNode.getChildReferences(systemSession);
        int projectionsCount = federationChildRefs.getChildCount(ModeShapeLexicon.PROJECTION);
        HashMap<String, Projection> projections = new HashMap<String, Projection>(projectionsCount);
        for (int i = 1; i <= projectionsCount; ++i) {
            ChildReference projectionRef = federationChildRefs.getChild(ModeShapeLexicon.PROJECTION, i);
            NodeKey projectionRefKey = projectionRef.getKey();
            CachedNode projection = systemSession.getNode(projectionRefKey);
            String externalNodeKey = projection.getProperty(ModeShapeLexicon.EXTERNAL_NODE_KEY, systemSession).getFirstValue().toString();
            assert (externalNodeKey != null);
            if (projectionsToRemove.contains(externalNodeKey)) {
                systemSession.destroy(projectionRefKey);
                continue;
            }
            String projectedNodeKey = projection.getProperty(ModeShapeLexicon.PROJECTED_NODE_KEY, systemSession).getFirstValue().toString();
            assert (projectedNodeKey != null);
            String alias = projection.getProperty(ModeShapeLexicon.PROJECTION_ALIAS, systemSession).getFirstValue().toString();
            assert (alias != null);
            projections.put(externalNodeKey, new Projection(externalNodeKey, projectedNodeKey, alias));
        }
        return projections;
    }

    private CachedNode getSystemNode(SessionCache systemSession) {
        CachedNode systemRoot = systemSession.getNode(systemSession.getRootKey());
        ChildReference systemNodeRef = systemRoot.getChildReferences(systemSession).getChild(JcrLexicon.SYSTEM);
        assert (systemNodeRef != null);
        return systemSession.getNode(systemNodeRef.getKey());
    }

    private void initializeConnectors() {
        Session session = null;
        try {
            session = this.repository.loginInternalSession();
            NamespaceRegistry registry = session.getWorkspace().getNamespaceRegistry();
            javax.jcr.nodetype.NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
            if (!(nodeTypeManager instanceof NodeTypeManager)) {
                throw new IllegalStateException("Invalid node type manager (expected modeshape NodeTypeManager): " + nodeTypeManager.getClass().getName());
            }
            Iterator<Map.Entry<String, Connector>> connectorsIterator = this.sourceKeyToConnectorMap.entrySet().iterator();
            while (connectorsIterator.hasNext()) {
                Connector connector = connectorsIterator.next().getValue();
                try {
                    this.initializeConnector(connector, registry, (NodeTypeManager)nodeTypeManager);
                }
                catch (Throwable t) {
                    this.logger.error(t, (I18nResource)JcrI18n.unableToInitializeConnector, new Object[]{connector, this.repository.name(), t.getMessage()});
                    connectorsIterator.remove();
                }
            }
        }
        catch (RepositoryException e) {
            throw new SystemFailureException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public void addProjection(String externalNodeKey, String projectedNodeKey, String alias) {
        this.projections.put(externalNodeKey, new Projection(externalNodeKey, projectedNodeKey, alias));
    }

    public String getProjectedNodeKey(String externalNodeKey) {
        Projection projection = this.projections.get(externalNodeKey);
        return projection != null ? projection.getProjectedNodeKey() : null;
    }

    public void externalNodeRemoved(String externalNodeKey) {
        Projection removedProjection = this.projections.remove(externalNodeKey);
        if (removedProjection != null) {
            this.removedProjections.add(externalNodeKey);
        }
    }

    public void internalNodeRemoved(String internalNodeKey) {
        ArrayList<String> externalNodeKeysToRemove = new ArrayList<String>();
        for (Projection projection : this.projections.values()) {
            if (!internalNodeKey.equalsIgnoreCase(projection.getProjectedNodeKey())) continue;
            String externalNodeKey = projection.getExternalNodeKey();
            externalNodeKeysToRemove.add(externalNodeKey);
            this.removedProjections.add(externalNodeKey);
        }
        for (String externalNodeKeyToRemove : externalNodeKeysToRemove) {
            this.projections.remove(externalNodeKeyToRemove);
        }
    }

    public void addConnector(RepositoryConfiguration.Component component) throws RepositoryException {
        Connector connector = this.instantiateConnector(component);
        if (this.initialized) {
            Session session = null;
            try {
                session = this.repository.loginInternalSession();
                NamespaceRegistry registry = session.getWorkspace().getNamespaceRegistry();
                javax.jcr.nodetype.NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
                if (!(nodeTypeManager instanceof NodeTypeManager)) {
                    throw new IllegalStateException("Invalid node type manager (expected modeshape NodeTypeManager): " + nodeTypeManager.getClass().getName());
                }
                this.initializeConnector(connector, registry, (NodeTypeManager)nodeTypeManager);
            }
            catch (IOException e) {
                String msg = JcrI18n.unableToInitializeConnector.text(new Object[]{component, this.repository.name(), e.getMessage()});
                throw new RepositoryException(msg, (Throwable)e);
            }
            catch (RuntimeException e) {
                String msg = JcrI18n.unableToInitializeConnector.text(new Object[]{component, this.repository.name(), e.getMessage()});
                throw new RepositoryException(msg, (Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
        this.registerConnector(connector);
    }

    public boolean removeConnector(String connectorName) {
        String key = NodeKey.keyForSourceName(connectorName);
        Connector existing = this.sourceKeyToConnectorMap.remove(key);
        if (existing == null) {
            return false;
        }
        existing.shutdown();
        return true;
    }

    protected Connector instantiateConnector(RepositoryConfiguration.Component component) {
        try {
            Connector connector = (Connector)component.createInstance(this.getClass().getClassLoader());
            ReflectionUtil.setValue((Object)connector, (String)"repositoryName", (Object)this.repository.name());
            ReflectionUtil.setValue((Object)connector, (String)"logger", (Object)Logger.getLogger(connector.getClass()));
            return connector;
        }
        catch (Throwable t) {
            if (t.getCause() != null) {
                t = t.getCause();
            }
            this.logger.error(t, (I18nResource)JcrI18n.unableToInitializeConnector, new Object[]{component, this.repository.name(), t.getMessage()});
            return null;
        }
    }

    protected void initializeConnector(Connector connector, NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws IOException, RepositoryException {
        ReflectionUtil.setValue((Object)connector, (String)"context", (Object)this.repository.context());
        ReflectionUtil.setValue((Object)connector, (String)"translator", (Object)this.getDocumentTranslator());
        ReflectionUtil.setValue((Object)connector, (String)"mimeTypeDetector", (Object)this.repository.mimeTypeDetector());
        ReflectionUtil.setValue((Object)connector, (String)"transactionManager", (Object)this.repository.txnManager());
        LocalDocumentStore store = this.repository.documentStore().localStore();
        String name = connector.getSourceName();
        String sourceKey = NodeKey.keyForSourceName(name);
        DocumentTranslator translator = this.getDocumentTranslator();
        LocalDocumentStoreExtraProperties defaultExtraPropertiesStore = new LocalDocumentStoreExtraProperties(store, sourceKey, translator);
        ReflectionUtil.setValue((Object)connector, (String)"extraPropertiesStore", (Object)defaultExtraPropertiesStore);
        connector.initialize(registry, nodeTypeManager);
        Method postInitialize = ReflectionUtil.findMethod(Connector.class, (String)"postInitialize");
        ReflectionUtil.invokeAccessibly((Object)connector, (Method)postInitialize, (Object[])new Object[0]);
    }

    protected void registerConnector(Connector connector) {
        String key = NodeKey.keyForSourceName(connector.getSourceName());
        Connector existing = this.sourceKeyToConnectorMap.put(key, connector);
        if (existing != null) {
            existing.shutdown();
        }
    }

    protected void shutdown() {
        if (!this.initialized || !this.hasConnectors()) {
            return;
        }
        this.storeProjections();
        this.shutdownConnectors();
        this.projections.clear();
        this.removedProjections.clear();
    }

    private void shutdownConnectors() {
        for (String sourceName : this.sourceKeyToConnectorMap.keySet()) {
            this.sourceKeyToConnectorMap.get(sourceName).shutdown();
        }
        this.sourceKeyToConnectorMap.clear();
        this.sourceKeyToConnectorMap = null;
    }

    private void storeProjections() {
        NodeKey systemNodeKey;
        if (this.projections.isEmpty()) {
            return;
        }
        PropertyFactory propertyFactory = this.repository.context().getPropertyFactory();
        SessionCache systemSession = this.repository.createSystemSession(this.repository.context(), false);
        MutableCachedNode systemNode = systemSession.mutable(systemNodeKey = this.getSystemNode(systemSession).getKey());
        ChildReference federationNodeRef = systemNode.getChildReferences(systemSession).getChild(ModeShapeLexicon.FEDERATION);
        if (federationNodeRef == null) {
            try {
                Property primaryType = propertyFactory.create(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.FEDERATION);
                systemNode.createChild(systemSession, systemNodeKey.withId("mode:federation"), ModeShapeLexicon.FEDERATION, primaryType, new Property[0]);
                systemSession.save();
                federationNodeRef = systemNode.getChildReferences(systemSession).getChild(ModeShapeLexicon.FEDERATION);
            }
            catch (Exception e) {
                this.logger.debug("Cannot create federation node", new Object[]{e});
                return;
            }
        }
        Map<String, Projection> existingStoredProjections = this.storedProjections(systemSession, federationNodeRef, this.removedProjections);
        for (String storedExternalNodeKey : existingStoredProjections.keySet()) {
            this.projections.remove(storedExternalNodeKey);
        }
        NodeKey federationNodeKey = federationNodeRef.getKey();
        MutableCachedNode federationNode = systemSession.mutable(federationNodeKey);
        for (String externalNodeKey : this.projections.keySet()) {
            Property primaryType = propertyFactory.create(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.PROJECTION);
            Property externalNodeKeyProp = propertyFactory.create(ModeShapeLexicon.EXTERNAL_NODE_KEY, externalNodeKey);
            Projection projection = this.projections.get(externalNodeKey);
            Property projectedNodeKeyProp = propertyFactory.create(ModeShapeLexicon.PROJECTED_NODE_KEY, projection.getProjectedNodeKey());
            Property alias = propertyFactory.create(ModeShapeLexicon.PROJECTION_ALIAS, projection.getAlias());
            federationNode.createChild(systemSession, federationNodeKey.withRandomId(), ModeShapeLexicon.PROJECTION, primaryType, externalNodeKeyProp, projectedNodeKeyProp, alias);
        }
        systemSession.save();
    }

    public Connector getConnectorForSourceKey(String sourceKey) {
        return this.sourceKeyToConnectorMap.get(sourceKey);
    }

    public Connector getConnectorForSourceName(String sourceName) {
        assert (sourceName != null);
        return this.sourceKeyToConnectorMap.get(NodeKey.keyForSourceName(sourceName));
    }

    public DocumentTranslator getDocumentTranslator() {
        return this.repository.repositoryCache().getDocumentTranslator();
    }

    public boolean hasConnectors() {
        return !this.sourceKeyToConnectorMap.isEmpty();
    }

    protected static class LocalDocumentStoreExtraProperties
    implements ExtraPropertiesStore {
        private final LocalDocumentStore localStore;
        private final String sourceKey;
        private final DocumentTranslator translator;

        protected LocalDocumentStoreExtraProperties(LocalDocumentStore localStore, String sourceKey, DocumentTranslator translator) {
            this.localStore = localStore;
            this.sourceKey = sourceKey;
            this.translator = translator;
            assert (this.localStore != null);
            assert (this.sourceKey != null);
            assert (this.translator != null);
        }

        protected String keyFor(String id) {
            return this.sourceKey + ":" + id;
        }

        @Override
        public Map<Name, Property> getProperties(String id) {
            String key = this.keyFor(id);
            SchematicEntry entry = this.localStore.get(key);
            if (entry == null) {
                return NO_PROPERTIES;
            }
            Document doc = entry.getContentAsDocument();
            HashMap<Name, Property> props = new HashMap<Name, Property>();
            this.translator.getProperties(doc, props);
            return props;
        }

        @Override
        public boolean removeProperties(String id) {
            String key = this.keyFor(id);
            return this.localStore.remove(key);
        }

        @Override
        public void storeProperties(String id, Map<Name, Property> properties) {
            String key = this.keyFor(id);
            EditableDocument doc = Schematic.newDocument();
            for (Map.Entry<Name, Property> entry : properties.entrySet()) {
                Property property = entry.getValue();
                if (property == null) continue;
                this.translator.setProperty(doc, property, null);
            }
            this.localStore.storeDocument(key, (Document)doc);
        }

        @Override
        public void updateProperties(String id, Map<Name, Property> properties) {
            String key = this.keyFor(id);
            SchematicEntry entry = this.localStore.get(key);
            EditableDocument doc = null;
            doc = entry != null ? entry.editDocumentContent() : Schematic.newDocument();
            for (Map.Entry<Name, Property> propertyEntry : properties.entrySet()) {
                Property property = propertyEntry.getValue();
                if (property != null) {
                    this.translator.setProperty(doc, property, null);
                    continue;
                }
                this.translator.removeProperty(doc, propertyEntry.getKey(), null);
            }
            this.localStore.storeDocument(key, (Document)doc);
        }
    }

    protected class Projection {
        private final String externalNodeKey;
        private final String projectedNodeKey;
        private final String alias;
        private final String repositoryPath;
        private final String externalPath;
        private final String sourceName;

        protected Projection(String externalNodeKey, String projectedNodeKey, String alias) {
            this.externalNodeKey = externalNodeKey;
            this.alias = alias;
            this.projectedNodeKey = projectedNodeKey;
            this.repositoryPath = null;
            this.externalPath = null;
            this.sourceName = null;
        }

        protected Projection(String sourceName, String alias, String repositoryPath, String externalPath) {
            this.alias = alias;
            this.repositoryPath = repositoryPath;
            this.externalPath = externalPath;
            this.sourceName = sourceName;
            this.projectedNodeKey = null;
            this.externalNodeKey = null;
        }

        protected boolean hasAlias(String alias) {
            return this.alias.equalsIgnoreCase(alias);
        }

        protected boolean hasProjectedNodeKey(String projectedNodeKey) {
            return this.projectedNodeKey.equals(projectedNodeKey);
        }

        protected String getProjectedNodeKey() {
            return this.projectedNodeKey;
        }

        protected String getAlias() {
            return this.alias;
        }

        protected String getExternalPath() {
            return this.externalPath;
        }

        protected String getRepositoryPath() {
            return this.repositoryPath;
        }

        protected String getSourceName() {
            return this.sourceName;
        }

        protected String getExternalNodeKey() {
            return this.externalNodeKey;
        }
    }
}

